/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import jline.console.completer.Completer;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.command.ColouredConsoleSender;
import org.bukkit.craftbukkit.v1_21_R1.command.ConsoleCommandCompleter;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public abstract class PlayerList {
    public static final File USERBANLIST_FILE = new File("banned-players.json");
    public static final File IPBANLIST_FILE = new File("banned-ips.json");
    public static final File OPLIST_FILE = new File("ops.json");
    public static final File WHITELIST_FILE = new File("whitelist.json");
    public static final IChatBaseComponent CHAT_FILTERED_FULL = IChatBaseComponent.translatable("chat.filtered_full");
    public static final IChatBaseComponent DUPLICATE_LOGIN_DISCONNECT_MESSAGE = IChatBaseComponent.translatable("multiplayer.disconnect.duplicate_login");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SEND_PLAYER_INFO_INTERVAL = 600;
    private static final SimpleDateFormat BAN_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer server;
    public final List<EntityPlayer> players = new CopyOnWriteArrayList<EntityPlayer>();
    private final Map<UUID, EntityPlayer> playersByUUID = Maps.newHashMap();
    private final GameProfileBanList bans;
    private final IpBanList ipBans;
    private final OpList ops;
    private final WhiteList whitelist;
    public final WorldNBTStorage playerIo;
    private boolean doWhiteList;
    private final LayeredRegistryAccess<RegistryLayer> registries;
    public int maxPlayers;
    private int viewDistance;
    private int simulationDistance;
    private boolean allowCommandsForAllPlayers;
    private static final boolean ALLOW_LOGOUTIVATOR = false;
    private int sendAllPlayerInfoIn;
    private CraftServer cserver;
    private final Map<String, EntityPlayer> playersByName = new HashMap<String, EntityPlayer>();

    public PlayerList(MinecraftServer minecraftserver, LayeredRegistryAccess<RegistryLayer> layeredregistryaccess, WorldNBTStorage worldnbtstorage, int i2) {
        this.cserver = minecraftserver.server = new CraftServer((DedicatedServer)minecraftserver, this);
        minecraftserver.console = ColouredConsoleSender.getInstance();
        minecraftserver.reader.addCompleter((Completer)new ConsoleCommandCompleter(minecraftserver.server));
        this.bans = new GameProfileBanList(USERBANLIST_FILE);
        this.ipBans = new IpBanList(IPBANLIST_FILE);
        this.ops = new OpList(OPLIST_FILE);
        this.whitelist = new WhiteList(WHITELIST_FILE);
        this.server = minecraftserver;
        this.registries = layeredregistryaccess;
        this.maxPlayers = i2;
        this.playerIo = worldnbtstorage;
    }

    public void placeNewPlayer(NetworkManager networkmanager, EntityPlayer entityplayer, CommonListenerCookie commonlistenercookie) {
        WorldServer worldserver1;
        ResourceKey<net.minecraft.world.level.World> resourcekey;
        WorldServer worldserver;
        NBTTagCompound nbttagcompound2;
        String s2;
        Optional<Object> optional;
        GameProfile gameprofile = entityplayer.getGameProfile();
        UserCache usercache = this.server.getProfileCache();
        if (usercache != null) {
            optional = usercache.get(gameprofile.getId());
            s2 = optional.map(GameProfile::getName).orElse(gameprofile.getName());
            usercache.add(gameprofile);
        } else {
            s2 = gameprofile.getName();
        }
        optional = this.load(entityplayer);
        if (optional.isPresent() && (nbttagcompound2 = (NBTTagCompound)optional.get()).contains("bukkit")) {
            NBTTagCompound bukkit = nbttagcompound2.getCompound("bukkit");
            String string = s2 = bukkit.contains("lastKnownName", 8) ? bukkit.getString("lastKnownName") : s2;
        }
        if ((worldserver = this.server.getLevel(resourcekey = optional.flatMap(nbttagcompound -> {
            DataResult<ResourceKey<net.minecraft.world.level.World>> dataresult = DimensionManager.parseLegacy(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.get("Dimension")));
            Logger logger = LOGGER;
            Objects.requireNonNull(logger);
            return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
        }).orElse(entityplayer.serverLevel().dimension()))) == null) {
            LOGGER.warn("Unknown respawn dimension {}, defaulting to overworld", resourcekey);
            worldserver1 = this.server.overworld();
        } else {
            worldserver1 = worldserver;
        }
        entityplayer.setServerLevel(worldserver1);
        String s1 = networkmanager.getLoggableAddress(this.server.logIPs());
        CraftPlayer spawnPlayer = entityplayer.getBukkitEntity();
        PlayerSpawnLocationEvent ev = new PlayerSpawnLocationEvent((Player)spawnPlayer, spawnPlayer.getLocation());
        this.cserver.getPluginManager().callEvent((Event)ev);
        Location loc = ev.getSpawnLocation();
        worldserver1 = ((CraftWorld)loc.getWorld()).getHandle();
        entityplayer.spawnIn(worldserver1);
        entityplayer.gameMode.setLevel((WorldServer)entityplayer.level());
        entityplayer.absMoveTo(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        WorldData worlddata = worldserver1.getLevelData();
        entityplayer.loadGameTypes(optional.orElse(null));
        PlayerConnection playerconnection = new PlayerConnection(this.server, networkmanager, entityplayer, commonlistenercookie);
        networkmanager.setupInboundProtocol(GameProtocols.SERVERBOUND_TEMPLATE.bind(RegistryFriendlyByteBuf.decorator(this.server.registryAccess())), playerconnection);
        GameRules gamerules = worldserver1.getGameRules();
        boolean flag = gamerules.getBoolean(GameRules.RULE_DO_IMMEDIATE_RESPAWN);
        boolean flag1 = gamerules.getBoolean(GameRules.RULE_REDUCEDDEBUGINFO);
        boolean flag2 = gamerules.getBoolean(GameRules.RULE_LIMITED_CRAFTING);
        playerconnection.send(new PacketPlayOutLogin(entityplayer.getId(), worlddata.isHardcore(), this.server.levelKeys(), this.getMaxPlayers(), worldserver1.spigotConfig.viewDistance, worldserver1.spigotConfig.simulationDistance, flag1, !flag, flag2, entityplayer.createCommonSpawnInfo(worldserver1), this.server.enforceSecureProfile()));
        entityplayer.getBukkitEntity().sendSupportedChannels();
        playerconnection.send(new PacketPlayOutServerDifficulty(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
        playerconnection.send(new PacketPlayOutAbilities(entityplayer.getAbilities()));
        playerconnection.send(new PacketPlayOutHeldItemSlot(entityplayer.getInventory().selected));
        playerconnection.send(new PacketPlayOutRecipeUpdate(this.server.getRecipeManager().getOrderedRecipes()));
        this.sendPlayerPermissionLevel(entityplayer);
        entityplayer.getStats().markAllDirty();
        entityplayer.getRecipeBook().sendInitialRecipeBook(entityplayer);
        this.updateEntireScoreboard(worldserver1.getScoreboard(), entityplayer);
        this.server.invalidateStatus();
        IChatMutableComponent ichatmutablecomponent = entityplayer.getGameProfile().getName().equalsIgnoreCase(s2) ? IChatBaseComponent.translatable("multiplayer.player.joined", entityplayer.getDisplayName()) : IChatBaseComponent.translatable("multiplayer.player.joined.renamed", entityplayer.getDisplayName(), s2);
        ichatmutablecomponent.withStyle(EnumChatFormat.YELLOW);
        String joinMessage = CraftChatMessage.fromComponent(ichatmutablecomponent);
        playerconnection.teleport(entityplayer.getX(), entityplayer.getY(), entityplayer.getZ(), entityplayer.getYRot(), entityplayer.getXRot());
        ServerPing serverping = this.server.getStatus();
        if (serverping != null && !commonlistenercookie.transferred()) {
            entityplayer.sendServerStatus(serverping);
        }
        this.players.add(entityplayer);
        this.playersByName.put(entityplayer.getScoreboardName().toLowerCase(Locale.ROOT), entityplayer);
        this.playersByUUID.put(entityplayer.getUUID(), entityplayer);
        CraftPlayer bukkitPlayer = entityplayer.getBukkitEntity();
        entityplayer.containerMenu.transferTo(entityplayer.containerMenu, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)bukkitPlayer, joinMessage);
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!entityplayer.connection.isAcceptingMessages()) {
            return;
        }
        joinMessage = playerJoinEvent.getJoinMessage();
        if (joinMessage != null && joinMessage.length() > 0) {
            for (IChatBaseComponent line : CraftChatMessage.fromString(joinMessage)) {
                this.server.getPlayerList().broadcastSystemMessage(line, false);
            }
        }
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(entityplayer));
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            EntityPlayer entityplayer1 = this.players.get(i2);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                entityplayer1.connection.send(packet);
            }
            if (!bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
            entityplayer.connection.send(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(entityplayer1)));
        }
        entityplayer.sentListPacket = true;
        entityplayer.refreshEntityData(entityplayer);
        this.sendLevelInfo(entityplayer, worldserver1);
        if (entityplayer.level() == worldserver1 && !worldserver1.players().contains(entityplayer)) {
            worldserver1.addNewPlayer(entityplayer);
            this.server.getCustomBossEvents().onPlayerConnect(entityplayer);
        }
        worldserver1 = entityplayer.serverLevel();
        this.sendActivePlayerEffects(entityplayer);
        if (optional.isPresent() && ((NBTTagCompound)optional.get()).contains("RootVehicle", 10)) {
            NBTTagCompound nbttagcompound3 = ((NBTTagCompound)optional.get()).getCompound("RootVehicle");
            WorldServer finalWorldServer = worldserver1;
            Entity entity = EntityTypes.loadEntityRecursive(nbttagcompound3.getCompound("Entity"), worldserver1, entity1 -> !finalWorldServer.addWithUUID((Entity)entity1) ? null : entity1);
            if (entity != null) {
                UUID uuid = nbttagcompound3.hasUUID("Attach") ? nbttagcompound3.getUUID("Attach") : null;
                if (entity.getUUID().equals(uuid)) {
                    entityplayer.startRiding(entity, true);
                } else {
                    for (Entity entity12 : entity.getIndirectPassengers()) {
                        if (!entity12.getUUID().equals(uuid)) continue;
                        entityplayer.startRiding(entity12, true);
                        break;
                    }
                }
                if (!entityplayer.isPassenger()) {
                    LOGGER.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (Entity entity12 : entity.getIndirectPassengers()) {
                        entity12.discard(null);
                    }
                }
            }
        }
        entityplayer.initInventoryMenu();
        LOGGER.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{entityplayer.getName().getString(), s1, entityplayer.getId(), worldserver1.serverLevelData.getLevelName(), entityplayer.getX(), entityplayer.getY(), entityplayer.getZ()});
    }

    public void updateEntireScoreboard(ScoreboardServer scoreboardserver, EntityPlayer entityplayer) {
        HashSet set = Sets.newHashSet();
        for (ScoreboardTeam scoreboardteam : scoreboardserver.getPlayerTeams()) {
            entityplayer.connection.send(PacketPlayOutScoreboardTeam.createAddOrModifyPacket(scoreboardteam, true));
        }
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            ScoreboardObjective scoreboardobjective = scoreboardserver.getDisplayObjective(displayslot);
            if (scoreboardobjective == null || set.contains(scoreboardobjective)) continue;
            List<Packet<?>> list = scoreboardserver.getStartTrackingPackets(scoreboardobjective);
            for (Packet<?> packet : list) {
                entityplayer.connection.send(packet);
            }
            set.add(scoreboardobjective);
        }
    }

    public void addWorldborderListener(WorldServer worldserver) {
        if (this.playerIo != null) {
            return;
        }
        worldserver.getWorldBorder().addListener(new IWorldBorderListener(){

            @Override
            public void onBorderSizeSet(WorldBorder worldborder, double d0) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSizeLerping(WorldBorder worldborder, double d0, double d1, long i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderCenterSet(WorldBorder worldborder, double d0, double d1) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderCenterPacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSetWarningTime(WorldBorder worldborder, int i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSetWarningBlocks(WorldBorder worldborder, int i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(worldborder), worldborder.world);
            }

            @Override
            public void onBorderSetDamagePerBlock(WorldBorder worldborder, double d0) {
            }

            @Override
            public void onBorderSetDamageSafeZOne(WorldBorder worldborder, double d0) {
            }
        });
    }

    public Optional<NBTTagCompound> load(EntityPlayer entityplayer) {
        Optional<NBTTagCompound> optional;
        NBTTagCompound nbttagcompound = this.server.getWorldData().getLoadedPlayerTag();
        if (this.server.isSingleplayerOwner(entityplayer.getGameProfile()) && nbttagcompound != null) {
            optional = Optional.of(nbttagcompound);
            entityplayer.load(nbttagcompound);
            LOGGER.debug("loading single player");
        } else {
            optional = this.playerIo.load(entityplayer);
        }
        return optional;
    }

    protected void save(EntityPlayer entityplayer) {
        AdvancementDataPlayer advancementdataplayer;
        if (!entityplayer.getBukkitEntity().isPersistent()) {
            return;
        }
        this.playerIo.save(entityplayer);
        ServerStatisticManager serverstatisticmanager = entityplayer.getStats();
        if (serverstatisticmanager != null) {
            serverstatisticmanager.save();
        }
        if ((advancementdataplayer = entityplayer.getAdvancements()) != null) {
            advancementdataplayer.save();
        }
    }

    public String remove(EntityPlayer entityplayer) {
        Entity entity;
        WorldServer worldserver = entityplayer.serverLevel();
        entityplayer.awardStat(StatisticList.LEAVE_GAME);
        if (entityplayer.containerMenu != entityplayer.inventoryMenu) {
            entityplayer.closeContainer();
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)entityplayer.getBukkitEntity(), (String)(entityplayer.kickLeaveMessage != null ? entityplayer.kickLeaveMessage : "\u00a7e" + entityplayer.getScoreboardName() + " left the game"));
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        entityplayer.getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        entityplayer.doTick();
        this.save(entityplayer);
        if (entityplayer.isPassenger() && (entity = entityplayer.getRootVehicle()).hasExactlyOnePlayerPassenger()) {
            LOGGER.debug("Removing player mount");
            entityplayer.stopRiding();
            entity.getPassengersAndSelf().forEach(entity1 -> entity1.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER, EntityRemoveEvent.Cause.PLAYER_QUIT));
        }
        entityplayer.unRide();
        worldserver.removePlayerImmediately(entityplayer, Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        entityplayer.getAdvancements().stopListening();
        this.players.remove(entityplayer);
        this.playersByName.remove(entityplayer.getScoreboardName().toLowerCase(Locale.ROOT));
        this.server.getCustomBossEvents().onPlayerDisconnect(entityplayer);
        UUID uuid = entityplayer.getUUID();
        EntityPlayer entityplayer1 = this.playersByUUID.get(uuid);
        if (entityplayer1 == entityplayer) {
            this.playersByUUID.remove(uuid);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(entityplayer.getUUID()));
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            EntityPlayer entityplayer2 = this.players.get(i2);
            if (entityplayer2.getBukkitEntity().canSee(entityplayer.getBukkitEntity())) {
                entityplayer2.connection.send(packet);
                continue;
            }
            entityplayer2.getBukkitEntity().onEntityRemove(entityplayer);
        }
        this.cserver.getScoreboardManager().removePlayer(entityplayer.getBukkitEntity());
        return playerQuitEvent.getQuitMessage();
    }

    public EntityPlayer canPlayerLogin(LoginListener loginlistener, GameProfile gameprofile) {
        UUID uuid = gameprofile.getId();
        ArrayList list = Lists.newArrayList();
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            EntityPlayer entityplayer = this.players.get(i2);
            if (!entityplayer.getUUID().equals(uuid)) continue;
            list.add(entityplayer);
        }
        for (EntityPlayer entityplayer : list) {
            this.save(entityplayer);
            entityplayer.connection.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.duplicate_login"));
        }
        SocketAddress socketaddress = loginlistener.connection.getRemoteAddress();
        EntityPlayer entity = new EntityPlayer(this.server, this.server.getLevel(net.minecraft.world.level.World.OVERWORLD), gameprofile, ClientInformation.createDefault());
        entity.transferCookieConnection = loginlistener;
        CraftPlayer player = entity.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((Player)player, loginlistener.connection.hostname, ((InetSocketAddress)socketaddress).getAddress(), ((InetSocketAddress)loginlistener.connection.channel.remoteAddress()).getAddress());
        if (this.bans.isBanned(gameprofile)) {
            GameProfileBanEntry gameprofilebanentry = (GameProfileBanEntry)this.bans.get(gameprofile);
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.translatable("multiplayer.disconnect.banned.reason", gameprofilebanentry.getReason());
            if (gameprofilebanentry.getExpires() != null) {
                ichatmutablecomponent.append(IChatBaseComponent.translatable("multiplayer.disconnect.banned.expiration", BAN_DATE_FORMAT.format(gameprofilebanentry.getExpires())));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent));
        } else if (!this.isWhiteListed(gameprofile)) {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.translatable("multiplayer.disconnect.not_whitelisted");
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, SpigotConfig.whitelistMessage);
        } else if (this.ipBans.isBanned(socketaddress)) {
            IpBanEntry ipbanentry = this.ipBans.get(socketaddress);
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.translatable("multiplayer.disconnect.banned_ip.reason", ipbanentry.getReason());
            if (ipbanentry.getExpires() != null) {
                ichatmutablecomponent.append(IChatBaseComponent.translatable("multiplayer.disconnect.banned_ip.expiration", BAN_DATE_FORMAT.format(ipbanentry.getExpires())));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent));
        } else if (this.players.size() >= this.maxPlayers && !this.canBypassPlayerLimit(gameprofile)) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, SpigotConfig.serverFullMessage);
        }
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            loginlistener.disconnect(event.getKickMessage());
            return null;
        }
        return entity;
    }

    public EntityPlayer getPlayerForLogin(GameProfile gameprofile, ClientInformation clientinformation, EntityPlayer player) {
        player.updateOptions(clientinformation);
        return player;
    }

    public boolean disconnectAllPlayersWithProfile(GameProfile gameprofile, EntityPlayer player) {
        return player == null;
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, flag, entity_removalreason, reason, null);
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason, Location location) {
        Object blockposition;
        IBlockData iblockdata;
        DimensionTransition dimensiontransition;
        entityplayer.stopRiding();
        this.players.remove(entityplayer);
        this.playersByName.remove(entityplayer.getScoreboardName().toLowerCase(Locale.ROOT));
        entityplayer.serverLevel().removePlayerImmediately(entityplayer, entity_removalreason);
        EntityPlayer entityplayer1 = entityplayer;
        net.minecraft.world.level.World fromWorld = entityplayer.level();
        entityplayer.wonGame = false;
        entityplayer1.connection = entityplayer.connection;
        entityplayer1.restoreFrom(entityplayer, flag);
        entityplayer1.setId(entityplayer.getId());
        entityplayer1.setMainArm(entityplayer.getMainArm());
        for (String s2 : entityplayer.getTags()) {
            entityplayer1.addTag(s2);
        }
        if (location == null) {
            dimensiontransition = entityplayer.findRespawnPositionAndUseSpawnBlock(flag, DimensionTransition.DO_NOTHING, reason);
            if (!flag) {
                entityplayer.reset();
            }
        } else {
            dimensiontransition = new DimensionTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), Vec3D.ZERO, location.getYaw(), location.getPitch(), DimensionTransition.DO_NOTHING);
        }
        if (dimensiontransition == null) {
            return entityplayer;
        }
        WorldServer worldserver = dimensiontransition.newLevel();
        entityplayer1.spawnIn(worldserver);
        entityplayer1.unsetRemoved();
        entityplayer1.setShiftKeyDown(false);
        Vec3D vec3d = dimensiontransition.pos();
        entityplayer1.forceSetPositionRotation(vec3d.x, vec3d.y, vec3d.z, dimensiontransition.yRot(), dimensiontransition.xRot());
        if (dimensiontransition.missingRespawnBlock()) {
            entityplayer1.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
            entityplayer1.setRespawnPosition(null, null, 0.0f, false, false, PlayerSpawnChangeEvent.Cause.RESET);
        }
        boolean i2 = flag;
        WorldServer worldserver1 = entityplayer1.serverLevel();
        WorldData worlddata = worldserver1.getLevelData();
        entityplayer1.connection.send(new PacketPlayOutRespawn(entityplayer1.createCommonSpawnInfo(worldserver1), (byte)(i2 ? 1 : 0)));
        entityplayer1.connection.send(new PacketPlayOutViewDistance(worldserver1.spigotConfig.viewDistance));
        entityplayer1.connection.send(new ClientboundSetSimulationDistancePacket(worldserver1.spigotConfig.simulationDistance));
        entityplayer1.connection.teleport(CraftLocation.toBukkit(entityplayer1.position(), (World)worldserver1.getWorld(), entityplayer1.getYRot(), entityplayer1.getXRot()));
        entityplayer1.connection.send(new PacketPlayOutSpawnPosition(worldserver.getSharedSpawnPos(), worldserver.getSharedSpawnAngle()));
        entityplayer1.connection.send(new PacketPlayOutServerDifficulty(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
        entityplayer1.connection.send(new PacketPlayOutExperience(entityplayer1.experienceProgress, entityplayer1.totalExperience, entityplayer1.experienceLevel));
        this.sendActivePlayerEffects(entityplayer1);
        this.sendLevelInfo(entityplayer1, worldserver);
        this.sendPlayerPermissionLevel(entityplayer1);
        if (!entityplayer.connection.isDisconnected()) {
            worldserver.addRespawnedPlayer(entityplayer1);
            this.players.add(entityplayer1);
            this.playersByName.put(entityplayer1.getScoreboardName().toLowerCase(Locale.ROOT), entityplayer1);
            this.playersByUUID.put(entityplayer1.getUUID(), entityplayer1);
        }
        entityplayer1.setHealth(entityplayer1.getHealth());
        if (!flag && (iblockdata = worldserver.getBlockState((BlockPosition)(blockposition = BlockPosition.containing(dimensiontransition.pos())))).is(Blocks.RESPAWN_ANCHOR)) {
            entityplayer1.connection.send(new PacketPlayOutNamedSoundEffect(SoundEffects.RESPAWN_ANCHOR_DEPLETE, SoundCategory.BLOCKS, ((BaseBlockPosition)blockposition).getX(), ((BaseBlockPosition)blockposition).getY(), ((BaseBlockPosition)blockposition).getZ(), 1.0f, 1.0f, worldserver.getRandom().nextLong()));
        }
        this.sendAllPlayerInfo(entityplayer);
        entityplayer.onUpdateAbilities();
        for (MobEffect mobEffect : entityplayer.getActiveEffects()) {
            entityplayer.connection.send(new PacketPlayOutEntityEffect(entityplayer.getId(), mobEffect, false));
        }
        entityplayer.triggerDimensionChangeTriggers(worldserver);
        if (fromWorld != worldserver) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)entityplayer.getBukkitEntity(), (World)fromWorld.getWorld());
            this.server.server.getPluginManager().callEvent((Event)event);
        }
        if (entityplayer.connection.isDisconnected()) {
            this.save(entityplayer);
        }
        return entityplayer1;
    }

    public void sendActivePlayerEffects(EntityPlayer entityplayer) {
        this.sendActiveEffects(entityplayer, entityplayer.connection);
    }

    public void sendActiveEffects(EntityLiving entityliving, PlayerConnection playerconnection) {
        for (MobEffect mobeffect : entityliving.getActiveEffects()) {
            playerconnection.send(new PacketPlayOutEntityEffect(entityliving.getId(), mobeffect, false));
        }
    }

    public void sendPlayerPermissionLevel(EntityPlayer entityplayer) {
        GameProfile gameprofile = entityplayer.getGameProfile();
        int i2 = this.server.getProfilePermissions(gameprofile);
        this.sendPlayerPermissionLevel(entityplayer, i2);
    }

    public void tick() {
        if (++this.sendAllPlayerInfoIn > 600) {
            for (int i2 = 0; i2 < this.players.size(); ++i2) {
                final EntityPlayer target = this.players.get(i2);
                target.connection.send(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.UPDATE_LATENCY), this.players.stream().filter(new Predicate<EntityPlayer>(){

                    @Override
                    public boolean test(EntityPlayer input) {
                        return target.getBukkitEntity().canSee(input.getBukkitEntity());
                    }
                }).collect(Collectors.toList())));
            }
            this.sendAllPlayerInfoIn = 0;
        }
    }

    public void broadcastAll(Packet<?> packet) {
        for (EntityPlayer entityplayer : this.players) {
            entityplayer.connection.send(packet);
        }
    }

    public void broadcastAll(Packet packet, EntityHuman entityhuman) {
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            EntityPlayer entityplayer = this.players.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            this.players.get((int)i2).connection.send(packet);
        }
    }

    public void broadcastAll(Packet packet, net.minecraft.world.level.World world) {
        for (int i2 = 0; i2 < world.players().size(); ++i2) {
            ((EntityPlayer)world.players().get((int)i2)).connection.send(packet);
        }
    }

    public void broadcastAll(Packet<?> packet, ResourceKey<net.minecraft.world.level.World> resourcekey) {
        for (EntityPlayer entityplayer : this.players) {
            if (entityplayer.level().dimension() != resourcekey) continue;
            entityplayer.connection.send(packet);
        }
    }

    public void broadcastSystemToTeam(EntityHuman entityhuman, IChatBaseComponent ichatbasecomponent) {
        ScoreboardTeam scoreboardteam = entityhuman.getTeam();
        if (scoreboardteam != null) {
            Collection<String> collection = scoreboardteam.getPlayers();
            for (String s2 : collection) {
                EntityPlayer entityplayer = this.getPlayerByName(s2);
                if (entityplayer == null || entityplayer == entityhuman) continue;
                entityplayer.sendSystemMessage(ichatbasecomponent);
            }
        }
    }

    public void broadcastSystemToAllExceptTeam(EntityHuman entityhuman, IChatBaseComponent ichatbasecomponent) {
        ScoreboardTeam scoreboardteam = entityhuman.getTeam();
        if (scoreboardteam == null) {
            this.broadcastSystemMessage(ichatbasecomponent, false);
        } else {
            for (int i2 = 0; i2 < this.players.size(); ++i2) {
                EntityPlayer entityplayer = this.players.get(i2);
                if (entityplayer.getTeam() == scoreboardteam) continue;
                entityplayer.sendSystemMessage(ichatbasecomponent);
            }
        }
    }

    public String[] getPlayerNamesArray() {
        String[] astring = new String[this.players.size()];
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            astring[i2] = this.players.get(i2).getGameProfile().getName();
        }
        return astring;
    }

    public GameProfileBanList getBans() {
        return this.bans;
    }

    public IpBanList getIpBans() {
        return this.ipBans;
    }

    public void op(GameProfile gameprofile) {
        this.ops.add(new OpListEntry(gameprofile, this.server.getOperatorUserPermissionLevel(), this.ops.canBypassPlayerLimit(gameprofile)));
        EntityPlayer entityplayer = this.getPlayer(gameprofile.getId());
        if (entityplayer != null) {
            this.sendPlayerPermissionLevel(entityplayer);
        }
    }

    public void deop(GameProfile gameprofile) {
        this.ops.remove(gameprofile);
        EntityPlayer entityplayer = this.getPlayer(gameprofile.getId());
        if (entityplayer != null) {
            this.sendPlayerPermissionLevel(entityplayer);
        }
    }

    private void sendPlayerPermissionLevel(EntityPlayer entityplayer, int i2) {
        if (entityplayer.connection != null) {
            byte b0 = i2 <= 0 ? (byte)24 : (i2 >= 4 ? (byte)28 : (byte)((byte)(24 + i2)));
            entityplayer.connection.send(new PacketPlayOutEntityStatus(entityplayer, b0));
        }
        entityplayer.getBukkitEntity().recalculatePermissions();
        this.server.getCommands().sendCommands(entityplayer);
    }

    public boolean isWhiteListed(GameProfile gameprofile) {
        return !this.doWhiteList || this.ops.contains(gameprofile) || this.whitelist.contains(gameprofile);
    }

    public boolean isOp(GameProfile gameprofile) {
        return this.ops.contains(gameprofile) || this.server.isSingleplayerOwner(gameprofile) && this.server.getWorldData().isAllowCommands() || this.allowCommandsForAllPlayers;
    }

    @Nullable
    public EntityPlayer getPlayerByName(String s2) {
        return this.playersByName.get(s2.toLowerCase(Locale.ROOT));
    }

    public void broadcast(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, double d3, ResourceKey<net.minecraft.world.level.World> resourcekey, Packet<?> packet) {
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            double d6;
            double d5;
            double d4;
            EntityPlayer entityplayer = this.players.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || entityplayer == entityhuman || entityplayer.level().dimension() != resourcekey || !((d4 = d0 - entityplayer.getX()) * d4 + (d5 = d1 - entityplayer.getY()) * d5 + (d6 = d2 - entityplayer.getZ()) * d6 < d3 * d3)) continue;
            entityplayer.connection.send(packet);
        }
    }

    public void saveAll() {
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            this.save(this.players.get(i2));
        }
    }

    public WhiteList getWhiteList() {
        return this.whitelist;
    }

    public String[] getWhiteListNames() {
        return this.whitelist.getUserList();
    }

    public OpList getOps() {
        return this.ops;
    }

    public String[] getOpNames() {
        return this.ops.getUserList();
    }

    public void reloadWhiteList() {
    }

    public void sendLevelInfo(EntityPlayer entityplayer, WorldServer worldserver) {
        WorldBorder worldborder = entityplayer.level().getWorldBorder();
        entityplayer.connection.send(new ClientboundInitializeBorderPacket(worldborder));
        entityplayer.connection.send(new PacketPlayOutUpdateTime(worldserver.getGameTime(), worldserver.getDayTime(), worldserver.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
        entityplayer.connection.send(new PacketPlayOutSpawnPosition(worldserver.getSharedSpawnPos(), worldserver.getSharedSpawnAngle()));
        if (worldserver.isRaining()) {
            entityplayer.setPlayerWeather(WeatherType.DOWNFALL, false);
            entityplayer.updateWeather(-worldserver.rainLevel, worldserver.rainLevel, -worldserver.thunderLevel, worldserver.thunderLevel);
        }
        entityplayer.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.LEVEL_CHUNKS_LOAD_START, 0.0f));
        this.server.tickRateManager().updateJoiningPlayer(entityplayer);
    }

    public void sendAllPlayerInfo(EntityPlayer entityplayer) {
        entityplayer.inventoryMenu.sendAllDataToRemote();
        entityplayer.getBukkitEntity().updateScaledHealth();
        entityplayer.refreshEntityData(entityplayer);
        entityplayer.connection.send(new PacketPlayOutHeldItemSlot(entityplayer.getInventory().selected));
        int i2 = entityplayer.level().getGameRules().getBoolean(GameRules.RULE_REDUCEDDEBUGINFO) ? 22 : 23;
        entityplayer.connection.send(new PacketPlayOutEntityStatus(entityplayer, (byte)i2));
        float immediateRespawn = entityplayer.level().getGameRules().getBoolean(GameRules.RULE_DO_IMMEDIATE_RESPAWN) ? 1.0f : 0.0f;
        entityplayer.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.IMMEDIATE_RESPAWN, immediateRespawn));
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public boolean isUsingWhitelist() {
        return this.doWhiteList;
    }

    public void setUsingWhiteList(boolean flag) {
        this.doWhiteList = flag;
    }

    public List<EntityPlayer> getPlayersWithAddress(String s2) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.players) {
            if (!entityplayer.getIpAddress().equals(s2)) continue;
            list.add(entityplayer);
        }
        return list;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    @Nullable
    public NBTTagCompound getSingleplayerData() {
        return null;
    }

    public void setAllowCommandsForAllPlayers(boolean flag) {
        this.allowCommandsForAllPlayers = flag;
    }

    public void removeAll() {
        for (EntityPlayer player : this.players) {
            player.connection.disconnect(CraftChatMessage.fromStringOrEmpty(this.server.server.getShutdownMessage()));
        }
    }

    public void broadcastMessage(IChatBaseComponent[] iChatBaseComponents) {
        for (IChatBaseComponent component : iChatBaseComponents) {
            this.broadcastSystemMessage(component, false);
        }
    }

    public void broadcastSystemMessage(IChatBaseComponent ichatbasecomponent, boolean flag) {
        this.broadcastSystemMessage(ichatbasecomponent, entityplayer -> ichatbasecomponent, flag);
    }

    public void broadcastSystemMessage(IChatBaseComponent ichatbasecomponent, Function<EntityPlayer, IChatBaseComponent> function, boolean flag) {
        this.server.sendSystemMessage(ichatbasecomponent);
        for (EntityPlayer entityplayer : this.players) {
            IChatBaseComponent ichatbasecomponent1 = function.apply(entityplayer);
            if (ichatbasecomponent1 == null) continue;
            entityplayer.sendSystemMessage(ichatbasecomponent1, flag);
        }
    }

    public void broadcastChatMessage(PlayerChatMessage playerchatmessage, CommandListenerWrapper commandlistenerwrapper, ChatMessageType.a chatmessagetype_a) {
        Objects.requireNonNull(commandlistenerwrapper);
        this.broadcastChatMessage(playerchatmessage, commandlistenerwrapper::shouldFilterMessageTo, commandlistenerwrapper.getPlayer(), chatmessagetype_a);
    }

    public void broadcastChatMessage(PlayerChatMessage playerchatmessage, EntityPlayer entityplayer, ChatMessageType.a chatmessagetype_a) {
        Objects.requireNonNull(entityplayer);
        this.broadcastChatMessage(playerchatmessage, entityplayer::shouldFilterMessageTo, entityplayer, chatmessagetype_a);
    }

    private void broadcastChatMessage(PlayerChatMessage playerchatmessage, Predicate<EntityPlayer> predicate, @Nullable EntityPlayer entityplayer, ChatMessageType.a chatmessagetype_a) {
        boolean flag = this.verifyChatTrusted(playerchatmessage);
        this.server.logChatMessage(playerchatmessage.decoratedContent(), chatmessagetype_a, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.create(playerchatmessage);
        boolean flag1 = false;
        for (EntityPlayer entityplayer1 : this.players) {
            boolean flag2 = predicate.test(entityplayer1);
            entityplayer1.sendChatMessage(outgoingchatmessage, flag2, chatmessagetype_a);
            flag1 |= flag2 && playerchatmessage.isFullyFiltered();
        }
        if (flag1 && entityplayer != null) {
            entityplayer.sendSystemMessage(CHAT_FILTERED_FULL);
        }
    }

    private boolean verifyChatTrusted(PlayerChatMessage playerchatmessage) {
        return playerchatmessage.hasSignature() && !playerchatmessage.hasExpiredServer(Instant.now());
    }

    public ServerStatisticManager getPlayerStats(EntityPlayer entityhuman) {
        ServerStatisticManager serverstatisticmanager = entityhuman.getStats();
        return serverstatisticmanager == null ? this.getPlayerStats(entityhuman.getUUID(), entityhuman.getDisplayName().getString()) : serverstatisticmanager;
    }

    public ServerStatisticManager getPlayerStats(UUID uuid, String displayName) {
        ServerStatisticManager serverstatisticmanager;
        EntityPlayer entityhuman = this.getPlayer(uuid);
        ServerStatisticManager serverStatisticManager = serverstatisticmanager = entityhuman == null ? null : entityhuman.getStats();
        if (serverstatisticmanager == null) {
            File file2;
            Path path;
            File file = this.server.getWorldPath(SavedFile.PLAYER_STATS_DIR).toFile();
            File file1 = new File(file, String.valueOf(uuid) + ".json");
            if (!file1.exists() && FileUtils.isPathNormalized(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtils.isPathPortable(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new ServerStatisticManager(this.server, file1);
        }
        return serverstatisticmanager;
    }

    public AdvancementDataPlayer getPlayerAdvancements(EntityPlayer entityplayer) {
        UUID uuid = entityplayer.getUUID();
        AdvancementDataPlayer advancementdataplayer = entityplayer.getAdvancements();
        if (advancementdataplayer == null) {
            Path path = this.server.getWorldPath(SavedFile.PLAYER_ADVANCEMENTS_DIR).resolve(String.valueOf(uuid) + ".json");
            advancementdataplayer = new AdvancementDataPlayer(this.server.getFixerUpper(), this, this.server.getAdvancements(), path, entityplayer);
        }
        advancementdataplayer.setPlayer(entityplayer);
        return advancementdataplayer;
    }

    public void setViewDistance(int i2) {
        this.viewDistance = i2;
        this.broadcastAll(new PacketPlayOutViewDistance(i2));
        for (WorldServer worldserver : this.server.getAllLevels()) {
            if (worldserver == null) continue;
            worldserver.getChunkSource().setViewDistance(i2);
        }
    }

    public void setSimulationDistance(int i2) {
        this.simulationDistance = i2;
        this.broadcastAll(new ClientboundSetSimulationDistancePacket(i2));
        for (WorldServer worldserver : this.server.getAllLevels()) {
            if (worldserver == null) continue;
            worldserver.getChunkSource().setSimulationDistance(i2);
        }
    }

    public List<EntityPlayer> getPlayers() {
        return this.players;
    }

    @Nullable
    public EntityPlayer getPlayer(UUID uuid) {
        return this.playersByUUID.get(uuid);
    }

    public boolean canBypassPlayerLimit(GameProfile gameprofile) {
        return false;
    }

    public void reloadResources() {
        for (EntityPlayer player : this.players) {
            player.getAdvancements().reload(this.server.getAdvancements());
            player.getAdvancements().flushDirty(player);
        }
        this.broadcastAll(new ClientboundUpdateTagsPacket(TagNetworkSerialization.serializeTagsToNetwork(this.registries)));
        PacketPlayOutRecipeUpdate packetplayoutrecipeupdate = new PacketPlayOutRecipeUpdate(this.server.getRecipeManager().getOrderedRecipes());
        for (EntityPlayer entityplayer : this.players) {
            entityplayer.connection.send(packetplayoutrecipeupdate);
            entityplayer.getRecipeBook().sendInitialRecipeBook(entityplayer);
        }
    }

    public boolean isAllowCommandsForAllPlayers() {
        return this.allowCommandsForAllPlayers;
    }
}

