/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import java.util.Iterator;
import java.util.List;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;

public class SleepStatus {
    private int activePlayers;
    private int sleepingPlayers;

    public boolean areEnoughSleeping(int i2) {
        return this.sleepingPlayers >= this.sleepersNeeded(i2);
    }

    public boolean areEnoughDeepSleeping(int i2, List<EntityPlayer> list) {
        int j2 = (int)list.stream().filter(eh -> eh.isSleepingLongEnough() || eh.fauxSleeping).count();
        boolean anyDeepSleep = list.stream().anyMatch(EntityHuman::isSleepingLongEnough);
        return anyDeepSleep && j2 >= this.sleepersNeeded(i2);
    }

    public int sleepersNeeded(int i2) {
        return Math.max(1, MathHelper.ceil((float)(this.activePlayers * i2) / 100.0f));
    }

    public void removeAllSleepers() {
        this.sleepingPlayers = 0;
    }

    public int amountSleeping() {
        return this.sleepingPlayers;
    }

    public boolean update(List<EntityPlayer> list) {
        int i2 = this.activePlayers;
        int j2 = this.sleepingPlayers;
        this.activePlayers = 0;
        this.sleepingPlayers = 0;
        Iterator<EntityPlayer> iterator = list.iterator();
        boolean anySleep = false;
        while (iterator.hasNext()) {
            EntityPlayer entityplayer = iterator.next();
            if (entityplayer.isSpectator()) continue;
            ++this.activePlayers;
            if (entityplayer.isSleeping() || entityplayer.fauxSleeping) {
                ++this.sleepingPlayers;
            }
            if (!entityplayer.isSleeping()) continue;
            anySleep = true;
        }
        return !(!anySleep || j2 <= 0 && this.sleepingPlayers <= 0 || i2 == this.activePlayers && j2 == this.sleepingPlayers);
    }
}

