/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon;

import java.net.SocketAddress;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R1.command.CraftRemoteConsoleCommandSender;

public class RemoteControlCommandListener
implements ICommandListener {
    private static final String RCON = "Rcon";
    private static final IChatBaseComponent RCON_COMPONENT = IChatBaseComponent.literal("Rcon");
    private final StringBuffer buffer = new StringBuffer();
    private final MinecraftServer server;
    public final SocketAddress socketAddress;
    private final CraftRemoteConsoleCommandSender remoteConsole = new CraftRemoteConsoleCommandSender(this);

    public RemoteControlCommandListener(MinecraftServer minecraftserver, SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
        this.server = minecraftserver;
    }

    public void prepareForCommand() {
        this.buffer.setLength(0);
    }

    public String getCommandResponse() {
        return this.buffer.toString();
    }

    public CommandListenerWrapper createCommandSourceStack() {
        WorldServer worldserver = this.server.overworld();
        return new CommandListenerWrapper(this, Vec3D.atLowerCornerOf(worldserver.getSharedSpawnPos()), Vec2F.ZERO, worldserver, 4, RCON, RCON_COMPONENT, this.server, null);
    }

    public void sendMessage(String message) {
        this.buffer.append(message);
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.remoteConsole;
    }

    @Override
    public void sendSystemMessage(IChatBaseComponent ichatbasecomponent) {
        this.buffer.append(ichatbasecomponent.getString());
    }

    @Override
    public boolean acceptsSuccess() {
        return true;
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public boolean shouldInformAdmins() {
        return this.server.shouldRconBroadcast();
    }
}

