/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.mojang.logging.LogUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.rcon.RemoteControlCommandListener;
import net.minecraft.server.rcon.StatusChallengeUtils;
import net.minecraft.server.rcon.thread.RemoteConnectionThread;
import org.slf4j.Logger;

public class RemoteControlSession
extends RemoteConnectionThread {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SERVERDATA_AUTH = 3;
    private static final int SERVERDATA_EXECCOMMAND = 2;
    private static final int SERVERDATA_RESPONSE_VALUE = 0;
    private static final int SERVERDATA_AUTH_RESPONSE = 2;
    private static final int SERVERDATA_AUTH_FAILURE = -1;
    private boolean authed;
    private final Socket client;
    private final byte[] buf = new byte[1460];
    private final String rconPassword;
    private final DedicatedServer serverInterface;
    private final RemoteControlCommandListener rconConsoleSource;

    RemoteControlSession(IMinecraftServer iminecraftserver, String s2, Socket socket) {
        super("RCON Client " + String.valueOf(socket.getInetAddress()));
        this.serverInterface = (DedicatedServer)iminecraftserver;
        this.client = socket;
        try {
            this.client.setSoTimeout(0);
        }
        catch (Exception exception) {
            this.running = false;
        }
        this.rconPassword = s2;
        this.rconConsoleSource = new RemoteControlCommandListener(this.serverInterface, socket.getRemoteSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block15: while (true) {
                if (!this.running) {
                    return;
                }
                BufferedInputStream bufferedinputstream = new BufferedInputStream(this.client.getInputStream());
                int i2 = bufferedinputstream.read(this.buf, 0, 1460);
                if (10 > i2) {
                    return;
                }
                int j2 = 0;
                int k2 = StatusChallengeUtils.intFromByteArray(this.buf, 0, i2);
                if (k2 != i2 - 4) continue;
                int l2 = StatusChallengeUtils.intFromByteArray(this.buf, j2 += 4, i2);
                int i1 = StatusChallengeUtils.intFromByteArray(this.buf, j2 += 4);
                j2 += 4;
                switch (i1) {
                    case 2: {
                        if (this.authed) {
                            String s2 = StatusChallengeUtils.stringFromByteArray(this.buf, j2, i2);
                            try {
                                this.sendCmdResponse(l2, this.serverInterface.runCommand(this.rconConsoleSource, s2));
                            }
                            catch (Exception exception) {
                                this.sendCmdResponse(l2, "Error executing: " + s2 + " (" + exception.getMessage() + ")");
                            }
                            continue block15;
                        }
                        this.sendAuthFailure();
                        continue block15;
                    }
                    case 3: {
                        String s1 = StatusChallengeUtils.stringFromByteArray(this.buf, j2, i2);
                        int j1 = j2 + s1.length();
                        if (!s1.isEmpty() && s1.equals(this.rconPassword)) {
                            this.authed = true;
                            this.send(l2, 2, "");
                            continue block15;
                        }
                        this.authed = false;
                        this.sendAuthFailure();
                        continue block15;
                    }
                }
                this.sendCmdResponse(l2, String.format(Locale.ROOT, "Unknown request %s", Integer.toHexString(i1)));
                continue;
                break;
            }
        }
        catch (IOException ioexception) {
            return;
        }
        catch (Exception exception1) {
            LOGGER.error("Exception whilst parsing RCON input", (Throwable)exception1);
            return;
        }
        finally {
            this.closeSocket();
            LOGGER.info("Thread {} shutting down", (Object)this.name);
            this.running = false;
        }
    }

    private void send(int i2, int j2, String s2) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(1248);
        DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
        byte[] abyte = s2.getBytes(StandardCharsets.UTF_8);
        dataoutputstream.writeInt(Integer.reverseBytes(abyte.length + 10));
        dataoutputstream.writeInt(Integer.reverseBytes(i2));
        dataoutputstream.writeInt(Integer.reverseBytes(j2));
        dataoutputstream.write(abyte);
        dataoutputstream.write(0);
        dataoutputstream.write(0);
        this.client.getOutputStream().write(bytearrayoutputstream.toByteArray());
    }

    private void sendAuthFailure() throws IOException {
        this.send(-1, 2, "");
    }

    private void sendCmdResponse(int i2, String s2) throws IOException {
        int k2;
        int j2 = s2.length();
        do {
            k2 = 4096 <= j2 ? 4096 : j2;
            this.send(i2, 0, s2.substring(0, k2));
        } while (0 != (j2 = (s2 = s2.substring(k2)).length()));
    }

    @Override
    public void stop() {
        this.running = false;
        this.closeSocket();
        super.stop();
    }

    private void closeSocket() {
        try {
            this.client.close();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to close socket", (Throwable)ioexception);
        }
    }
}

