/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutRecipes;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.slf4j.Logger;

public class RecipeBookServer
extends RecipeBook {
    public static final String RECIPE_BOOK_TAG = "recipeBook";
    private static final Logger LOGGER = LogUtils.getLogger();

    public int addRecipes(Collection<RecipeHolder<?>> collection, EntityPlayer entityplayer) {
        ArrayList list = Lists.newArrayList();
        int i2 = 0;
        for (RecipeHolder<?> recipeholder : collection) {
            MinecraftKey minecraftkey = recipeholder.id();
            if (this.known.contains(minecraftkey) || recipeholder.value().isSpecial() || !CraftEventFactory.handlePlayerRecipeListUpdateEvent(entityplayer, minecraftkey)) continue;
            this.add(minecraftkey);
            this.addHighlight(minecraftkey);
            list.add(minecraftkey);
            CriterionTriggers.RECIPE_UNLOCKED.trigger(entityplayer, recipeholder);
            ++i2;
        }
        if (list.size() > 0) {
            this.sendRecipes(PacketPlayOutRecipes.Action.ADD, entityplayer, list);
        }
        return i2;
    }

    public int removeRecipes(Collection<RecipeHolder<?>> collection, EntityPlayer entityplayer) {
        ArrayList list = Lists.newArrayList();
        int i2 = 0;
        for (RecipeHolder<?> recipeholder : collection) {
            MinecraftKey minecraftkey = recipeholder.id();
            if (!this.known.contains(minecraftkey)) continue;
            this.remove(minecraftkey);
            list.add(minecraftkey);
            ++i2;
        }
        this.sendRecipes(PacketPlayOutRecipes.Action.REMOVE, entityplayer, list);
        return i2;
    }

    private void sendRecipes(PacketPlayOutRecipes.Action packetplayoutrecipes_action, EntityPlayer entityplayer, List<MinecraftKey> list) {
        if (entityplayer.connection == null) {
            return;
        }
        entityplayer.connection.send(new PacketPlayOutRecipes(packetplayoutrecipes_action, list, Collections.emptyList(), this.getBookSettings()));
    }

    public NBTTagCompound toNbt() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.getBookSettings().write(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (MinecraftKey minecraftkey : this.known) {
            nbttaglist.add(NBTTagString.valueOf(minecraftkey.toString()));
        }
        nbttagcompound.put("recipes", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (MinecraftKey minecraftkey1 : this.highlight) {
            nbttaglist1.add(NBTTagString.valueOf(minecraftkey1.toString()));
        }
        nbttagcompound.put("toBeDisplayed", nbttaglist1);
        return nbttagcompound;
    }

    public void fromNbt(NBTTagCompound nbttagcompound, CraftingManager craftingmanager) {
        this.setBookSettings(RecipeBookSettings.read(nbttagcompound));
        NBTTagList nbttaglist = nbttagcompound.getList("recipes", 8);
        this.loadRecipes(nbttaglist, this::add, craftingmanager);
        NBTTagList nbttaglist1 = nbttagcompound.getList("toBeDisplayed", 8);
        this.loadRecipes(nbttaglist1, this::addHighlight, craftingmanager);
    }

    private void loadRecipes(NBTTagList nbttaglist, Consumer<RecipeHolder<?>> consumer, CraftingManager craftingmanager) {
        for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
            String s2 = nbttaglist.getString(i2);
            try {
                MinecraftKey minecraftkey = MinecraftKey.parse(s2);
                Optional<RecipeHolder<?>> optional = craftingmanager.byKey(minecraftkey);
                if (optional.isEmpty()) {
                    LOGGER.error("Tried to load unrecognized recipe: {} removed now.", (Object)minecraftkey);
                    continue;
                }
                consumer.accept(optional.get());
                continue;
            }
            catch (ResourceKeyInvalidException resourcekeyinvalidexception) {
                LOGGER.error("Tried to load improperly formatted recipe: {} removed now.", (Object)s2);
            }
        }
    }

    public void sendInitialRecipeBook(EntityPlayer entityplayer) {
        entityplayer.connection.send(new PacketPlayOutRecipes(PacketPlayOutRecipes.Action.INIT, this.known, this.highlight, this.getBookSettings()));
    }
}

