/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutStatistic;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticManager;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatisticManager
extends StatisticManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MinecraftServer server;
    private final File file;
    private final Set<Statistic<?>> dirty = Sets.newHashSet();

    public ServerStatisticManager(MinecraftServer minecraftserver, File file) {
        this.server = minecraftserver;
        this.file = file;
        for (Map.Entry<MinecraftKey, Integer> entry : SpigotConfig.forcedStats.entrySet()) {
            Statistic<MinecraftKey> wrapper = StatisticList.CUSTOM.get(entry.getKey());
            this.stats.put(wrapper, entry.getValue().intValue());
        }
        if (file.isFile()) {
            try {
                this.parseLocal(minecraftserver.getFixerUpper(), FileUtils.readFileToString((File)file));
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't read statistics file {}", (Object)file, (Object)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                LOGGER.error("Couldn't parse statistics file {}", (Object)file, (Object)jsonparseexception);
            }
        }
    }

    public void save() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.file, (String)this.toJson());
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save stats", (Throwable)ioexception);
        }
    }

    @Override
    public void setValue(EntityHuman entityhuman, Statistic<?> statistic, int i2) {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        super.setValue(entityhuman, statistic, i2);
        this.dirty.add(statistic);
    }

    private Set<Statistic<?>> getDirty() {
        HashSet set = Sets.newHashSet(this.dirty);
        this.dirty.clear();
        return set;
    }

    public void parseLocal(DataFixer datafixer, String s2) {
        block11: {
            try {
                try (JsonReader jsonreader = new JsonReader((Reader)new StringReader(s2));){
                    jsonreader.setLenient(false);
                    JsonElement jsonelement = Streams.parse((JsonReader)jsonreader);
                    if (!jsonelement.isJsonNull()) {
                        NBTTagCompound nbttagcompound = ServerStatisticManager.fromJson(jsonelement.getAsJsonObject());
                        if (!(nbttagcompound = DataFixTypes.STATS.updateToCurrentVersion(datafixer, nbttagcompound, GameProfileSerializer.getDataVersion(nbttagcompound, 1343))).contains("stats", 10)) {
                            break block11;
                        }
                        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("stats");
                        Iterator<String> iterator = nbttagcompound1.getAllKeys().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                break block11;
                            }
                            String s1 = iterator.next();
                            if (!nbttagcompound1.contains(s1, 10)) continue;
                            SystemUtils.ifElse(BuiltInRegistries.STAT_TYPE.getOptional(MinecraftKey.parse(s1)), statisticwrapper -> {
                                NBTTagCompound nbttagcompound2 = nbttagcompound1.getCompound(s1);
                                for (String s2 : nbttagcompound2.getAllKeys()) {
                                    if (nbttagcompound2.contains(s2, 99)) {
                                        SystemUtils.ifElse(this.getStat((StatisticWrapper)statisticwrapper, s2), statistic -> this.stats.put(statistic, nbttagcompound2.getInt(s2)), () -> LOGGER.warn("Invalid statistic in {}: Don't know what {} is", (Object)this.file, (Object)s2));
                                        continue;
                                    }
                                    LOGGER.warn("Invalid statistic value in {}: Don't know what {} is for key {}", new Object[]{this.file, nbttagcompound2.get(s2), s2});
                                }
                            }, () -> LOGGER.warn("Invalid statistic type in {}: Don't know what {} is", (Object)this.file, (Object)s1));
                        }
                    }
                    LOGGER.error("Unable to parse Stat data from {}", (Object)this.file);
                }
                return;
            }
            catch (JsonParseException | IOException jsonparseexception) {
                LOGGER.error("Unable to parse Stat data from {}", (Object)this.file, (Object)jsonparseexception);
            }
        }
    }

    private <T> Optional<Statistic<T>> getStat(StatisticWrapper<T> statisticwrapper, String s2) {
        Optional<MinecraftKey> optional = Optional.ofNullable(MinecraftKey.tryParse(s2));
        IRegistry<T> iregistry = statisticwrapper.getRegistry();
        return optional.flatMap(iregistry::getOptional).map(statisticwrapper::get);
    }

    private static NBTTagCompound fromJson(JsonObject jsonobject) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        for (Map.Entry entry : jsonobject.entrySet()) {
            JsonPrimitive jsonprimitive;
            JsonElement jsonelement = (JsonElement)entry.getValue();
            if (jsonelement.isJsonObject()) {
                nbttagcompound.put((String)entry.getKey(), ServerStatisticManager.fromJson(jsonelement.getAsJsonObject()));
                continue;
            }
            if (!jsonelement.isJsonPrimitive() || !(jsonprimitive = jsonelement.getAsJsonPrimitive()).isNumber()) continue;
            nbttagcompound.putInt((String)entry.getKey(), jsonprimitive.getAsInt());
        }
        return nbttagcompound;
    }

    protected String toJson() {
        HashMap map = Maps.newHashMap();
        for (Object2IntMap.Entry it_unimi_dsi_fastutil_objects_object2intmap_entry : this.stats.object2IntEntrySet()) {
            Statistic statistic = (Statistic)it_unimi_dsi_fastutil_objects_object2intmap_entry.getKey();
            map.computeIfAbsent(statistic.getType(), statisticwrapper -> new JsonObject()).addProperty(ServerStatisticManager.getKey(statistic).toString(), (Number)it_unimi_dsi_fastutil_objects_object2intmap_entry.getIntValue());
        }
        JsonObject jsonobject = new JsonObject();
        for (Map.Entry entry : map.entrySet()) {
            jsonobject.add(BuiltInRegistries.STAT_TYPE.getKey((StatisticWrapper)entry.getKey()).toString(), (JsonElement)entry.getValue());
        }
        JsonObject jsonobject1 = new JsonObject();
        jsonobject1.add("stats", (JsonElement)jsonobject);
        jsonobject1.addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        return jsonobject1.toString();
    }

    private static <T> MinecraftKey getKey(Statistic<T> statistic) {
        return statistic.getType().getRegistry().getKey(statistic.getValue());
    }

    public void markAllDirty() {
        this.dirty.addAll((Collection<Statistic<?>>)this.stats.keySet());
    }

    public void sendStats(EntityPlayer entityplayer) {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (Statistic<?> statistic : this.getDirty()) {
            object2intmap.put(statistic, this.getValue(statistic));
        }
        entityplayer.connection.send(new PacketPlayOutStatistic((Object2IntMap<Statistic<?>>)object2intmap));
    }
}

