/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.Cancellable;

public class StatisticManager {
    protected final Object2IntMap<Statistic<?>> stats = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());

    public StatisticManager() {
        this.stats.defaultReturnValue(0);
    }

    public void increment(EntityHuman entityhuman, Statistic<?> statistic, int i2) {
        int j2 = (int)Math.min((long)this.getValue(statistic) + (long)i2, Integer.MAX_VALUE);
        Cancellable cancellable = CraftEventFactory.handleStatisticsIncrease(entityhuman, statistic, this.getValue(statistic), j2);
        if (cancellable != null && cancellable.isCancelled()) {
            return;
        }
        this.setValue(entityhuman, statistic, j2);
    }

    public void setValue(EntityHuman entityhuman, Statistic<?> statistic, int i2) {
        this.stats.put(statistic, i2);
    }

    public <T> int getValue(StatisticWrapper<T> statisticwrapper, T t0) {
        return statisticwrapper.contains(t0) ? this.getValue(statisticwrapper.get(t0)) : 0;
    }

    public int getValue(Statistic<?> statistic) {
        return this.stats.getInt(statistic);
    }
}

