/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.util.DependencySorter;
import org.slf4j.Logger;

public class TagDataPack<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final Function<MinecraftKey, Optional<? extends T>> idToValue;
    private final String directory;

    public TagDataPack(Function<MinecraftKey, Optional<? extends T>> var0, String var1) {
        this.idToValue = var0;
        this.directory = var1;
    }

    public Map<MinecraftKey, List<a>> load(IResourceManager var02) {
        HashMap var1 = Maps.newHashMap();
        FileToIdConverter var22 = FileToIdConverter.json(this.directory);
        for (Map.Entry<MinecraftKey, List<IResource>> var4 : var22.listMatchingResourceStacks(var02).entrySet()) {
            MinecraftKey var5 = var4.getKey();
            MinecraftKey var6 = var22.fileToId(var5);
            for (IResource var8 : var4.getValue()) {
                try {
                    BufferedReader var9 = var8.openAsReader();
                    try {
                        JsonElement var10 = JsonParser.parseReader((Reader)var9);
                        List var11 = var1.computeIfAbsent(var6, var0 -> new ArrayList());
                        TagFile var12 = (TagFile)TagFile.CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)var10)).getOrThrow();
                        if (var12.replace()) {
                            var11.clear();
                        }
                        String var13 = var8.sourcePackId();
                        var12.entries().forEach(var2 -> var11.add(new a((TagEntry)var2, var13)));
                    }
                    finally {
                        if (var9 == null) continue;
                        ((Reader)var9).close();
                    }
                }
                catch (Exception var9) {
                    LOGGER.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{var6, var5, var8.sourcePackId(), var9});
                }
            }
        }
        return var1;
    }

    private Either<Collection<a>, Collection<T>> build(TagEntry.a<T> var0, List<a> var1) {
        ImmutableSet.Builder var2 = ImmutableSet.builder();
        ArrayList<a> var3 = new ArrayList<a>();
        for (a var5 : var1) {
            if (var5.entry().build(var0, arg_0 -> ((ImmutableSet.Builder)var2).add(arg_0))) continue;
            var3.add(var5);
        }
        return var3.isEmpty() ? Either.right((Object)var2.build()) : Either.left(var3);
    }

    public Map<MinecraftKey, Collection<T>> build(Map<MinecraftKey, List<a>> var0) {
        final HashMap var12 = Maps.newHashMap();
        TagEntry.a var23 = new TagEntry.a<T>(){

            @Override
            @Nullable
            public T element(MinecraftKey var0) {
                return TagDataPack.this.idToValue.apply(var0).orElse(null);
            }

            @Override
            @Nullable
            public Collection<T> tag(MinecraftKey var0) {
                return (Collection)var12.get(var0);
            }
        };
        DependencySorter<MinecraftKey, b> var32 = new DependencySorter<MinecraftKey, b>();
        var0.forEach((var1, var2) -> var32.addEntry((MinecraftKey)var1, new b((List<a>)var2)));
        var32.orderByDependencies((var22, var3) -> this.build(var23, var3.entries).ifLeft(var1 -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", var22, (Object)var1.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight(var2 -> var12.put(var22, var2)));
        return var12;
    }

    public Map<MinecraftKey, Collection<T>> loadAndBuild(IResourceManager var0) {
        return this.build(this.load(var0));
    }

    public static final class a
    extends Record {
        final TagEntry entry;
        private final String source;

        public a(TagEntry var0, String var1) {
            this.entry = var0;
            this.source = var1;
        }

        @Override
        public String toString() {
            return String.valueOf(this.entry) + " (from " + this.source + ")";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "entry;source", "entry", "source"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "entry;source", "entry", "source"}, this, var0);
        }

        public TagEntry entry() {
            return this.entry;
        }

        public String source() {
            return this.source;
        }
    }

    static final class b
    extends Record
    implements DependencySorter.a<MinecraftKey> {
        final List<a> entries;

        b(List<a> var0) {
            this.entries = var0;
        }

        @Override
        public void visitRequiredDependencies(Consumer<MinecraftKey> var0) {
            this.entries.forEach(var1 -> var1.entry.visitRequiredDependencies(var0));
        }

        @Override
        public void visitOptionalDependencies(Consumer<MinecraftKey> var0) {
            this.entries.forEach(var1 -> var1.entry.visitOptionalDependencies(var0));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "entries", "entries"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "entries", "entries"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "entries", "entries"}, this, var0);
        }

        public List<a> entries() {
            return this.entries;
        }
    }
}

