/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockStainedGlass;
import net.minecraft.world.level.block.BlockStainedGlassPane;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SpawnUtil {
    public static <T extends EntityInsentient> Optional<T> trySpawnMob(EntityTypes<T> entitytypes, EnumMobSpawn enummobspawn, WorldServer worldserver, BlockPosition blockposition, int i2, int j2, int k2, a spawnutil_a) {
        return SpawnUtil.trySpawnMob(entitytypes, enummobspawn, worldserver, blockposition, i2, j2, k2, spawnutil_a, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public static <T extends EntityInsentient> Optional<T> trySpawnMob(EntityTypes<T> entitytypes, EnumMobSpawn enummobspawn, WorldServer worldserver, BlockPosition blockposition, int i2, int j2, int k2, a spawnutil_a, CreatureSpawnEvent.SpawnReason reason) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.mutable();
        for (int l2 = 0; l2 < i2; ++l2) {
            EntityInsentient t0;
            int i1 = MathHelper.randomBetweenInclusive(worldserver.random, -j2, j2);
            int j1 = MathHelper.randomBetweenInclusive(worldserver.random, -j2, j2);
            blockposition_mutableblockposition.setWithOffset(blockposition, i1, k2, j1);
            if (!worldserver.getWorldBorder().isWithinBounds(blockposition_mutableblockposition) || !SpawnUtil.moveToPossibleSpawnPosition(worldserver, k2, blockposition_mutableblockposition, spawnutil_a) || (t0 = (EntityInsentient)entitytypes.create(worldserver, null, blockposition_mutableblockposition, enummobspawn, false, false)) == null) continue;
            if (t0.checkSpawnRules(worldserver, enummobspawn) && t0.checkSpawnObstruction(worldserver)) {
                worldserver.addFreshEntityWithPassengers(t0, reason);
                return Optional.of(t0);
            }
            t0.discard(null);
        }
        return Optional.empty();
    }

    private static boolean moveToPossibleSpawnPosition(WorldServer worldserver, int i2, BlockPosition.MutableBlockPosition blockposition_mutableblockposition, a spawnutil_a) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition().set(blockposition_mutableblockposition);
        IBlockData iblockdata = worldserver.getBlockState(blockposition_mutableblockposition1);
        for (int j2 = i2; j2 >= -i2; --j2) {
            blockposition_mutableblockposition.move(EnumDirection.DOWN);
            blockposition_mutableblockposition1.setWithOffset((BaseBlockPosition)blockposition_mutableblockposition, EnumDirection.UP);
            IBlockData iblockdata1 = worldserver.getBlockState(blockposition_mutableblockposition);
            if (spawnutil_a.canSpawnOn(worldserver, blockposition_mutableblockposition, iblockdata1, blockposition_mutableblockposition1, iblockdata)) {
                blockposition_mutableblockposition.move(EnumDirection.UP);
                return true;
            }
            iblockdata = iblockdata1;
        }
        return false;
    }

    public static interface a {
        @Deprecated
        public static final a LEGACY_IRON_GOLEM = (worldserver, blockposition, iblockdata, blockposition1, iblockdata1) -> !(iblockdata.is(Blocks.COBWEB) || iblockdata.is(Blocks.CACTUS) || iblockdata.is(Blocks.GLASS_PANE) || iblockdata.getBlock() instanceof BlockStainedGlassPane || iblockdata.getBlock() instanceof BlockStainedGlass || iblockdata.getBlock() instanceof BlockLeaves || iblockdata.is(Blocks.CONDUIT) || iblockdata.is(Blocks.ICE) || iblockdata.is(Blocks.TNT) || iblockdata.is(Blocks.GLOWSTONE) || iblockdata.is(Blocks.BEACON) || iblockdata.is(Blocks.SEA_LANTERN) || iblockdata.is(Blocks.FROSTED_ICE) || iblockdata.is(Blocks.TINTED_GLASS) || iblockdata.is(Blocks.GLASS)) ? (iblockdata1.isAir() || iblockdata1.liquid()) && (iblockdata.isSolid() || iblockdata.is(Blocks.POWDER_SNOW)) : false;
        public static final a ON_TOP_OF_COLLIDER = (worldserver, blockposition, iblockdata, blockposition1, iblockdata1) -> iblockdata1.getCollisionShape(worldserver, blockposition1).isEmpty() && Block.isFaceFull(iblockdata.getCollisionShape(worldserver, blockposition), EnumDirection.UP);

        public boolean canSpawnOn(WorldServer var1, BlockPosition var2, IBlockData var3, BlockPosition var4, IBlockData var5);
    }
}

