/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Map;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class BannerEntityCustomNameToOverrideComponentFix
extends DataFix {
    public BannerEntityCustomNameToOverrideComponentFix(Schema var0) {
        super(var0, false);
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.BLOCK_ENTITY);
        TaggedChoice.TaggedChoiceType var1 = this.getInputSchema().findChoiceType(DataConverterTypes.BLOCK_ENTITY);
        OpticFinder var22 = var0.findField("components");
        return this.fixTypeEverywhereTyped("Banner entity custom_name to item_name component fix", var0, var2 -> {
            Object var3 = ((Pair)var2.get(var1.finder())).getFirst();
            return var3.equals("minecraft:banner") ? this.fix((Typed<?>)var2, (OpticFinder<?>)var22) : var2;
        });
    }

    private Typed<?> fix(Typed<?> var02, OpticFinder<?> var12) {
        Dynamic var2 = (Dynamic)var02.getOptional(DSL.remainderFinder()).orElseThrow();
        OptionalDynamic var3 = var2.get("CustomName");
        boolean var4 = var3.asString().result().flatMap(ComponentDataFixUtils::extractTranslationString).filter(var0 -> var0.equals("block.minecraft.ominous_banner")).isPresent();
        if (var4) {
            Typed var5 = var02.getOrCreateTyped(var12).update(DSL.remainderFinder(), var1 -> var1.set("minecraft:item_name", (Dynamic)var3.result().get()).set("minecraft:hide_additional_tooltip", var1.createMap(Map.of())));
            return var02.set(var12, var5).set(DSL.remainderFinder(), (Object)var2.remove("CustomName"));
        }
        return var02;
    }
}

