/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class FixProjectileStoredItem
extends DataFix {
    private static final String EMPTY_POTION = "minecraft:empty";

    public FixProjectileStoredItem(Schema var0) {
        super(var0, true);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.ENTITY);
        Type var1 = this.getOutputSchema().getType(DataConverterTypes.ENTITY);
        return this.fixTypeEverywhereTyped("Fix AbstractArrow item type", var0, var1, ExtraDataFixUtils.chainAllFilters(this.fixChoice("minecraft:trident", FixProjectileStoredItem::castUnchecked), this.fixChoice("minecraft:arrow", FixProjectileStoredItem::fixArrow), this.fixChoice("minecraft:spectral_arrow", FixProjectileStoredItem::fixSpectralArrow)));
    }

    private Function<Typed<?>, Typed<?>> fixChoice(String var0, a<?> var1) {
        Type var2 = this.getInputSchema().getChoiceType(DataConverterTypes.ENTITY, var0);
        Type var3 = this.getOutputSchema().getChoiceType(DataConverterTypes.ENTITY, var0);
        return FixProjectileStoredItem.fixChoiceCap(var0, var1, var2, var3);
    }

    private static <T> Function<Typed<?>, Typed<?>> fixChoiceCap(String var0, a<?> var1, Type<?> var2, Type<T> var32) {
        OpticFinder var4 = DSL.namedChoice((String)var0, var2);
        a<?> var5 = var1;
        return var3 -> var3.updateTyped(var4, var32, var2 -> var5.fix((Typed<?>)var2, var32));
    }

    private static <T> Typed<T> fixArrow(Typed<?> var02, Type<T> var1) {
        return SystemUtils.writeAndReadTypedOrThrow(var02, var1, var0 -> var0.set("item", FixProjectileStoredItem.createItemStack(var0, FixProjectileStoredItem.getArrowType(var0))));
    }

    private static String getArrowType(Dynamic<?> var0) {
        return var0.get("Potion").asString(EMPTY_POTION).equals(EMPTY_POTION) ? "minecraft:arrow" : "minecraft:tipped_arrow";
    }

    private static <T> Typed<T> fixSpectralArrow(Typed<?> var02, Type<T> var1) {
        return SystemUtils.writeAndReadTypedOrThrow(var02, var1, var0 -> var0.set("item", FixProjectileStoredItem.createItemStack(var0, "minecraft:spectral_arrow")));
    }

    private static Dynamic<?> createItemStack(Dynamic<?> var0, String var1) {
        return var0.createMap((Map)ImmutableMap.of((Object)var0.createString("id"), (Object)var0.createString(var1), (Object)var0.createString("Count"), (Object)var0.createInt(1)));
    }

    private static <T> Typed<T> castUnchecked(Typed<?> var0, Type<T> var1) {
        return new Typed(var1, var0.getOps(), var0.getValue());
    }

    static interface a<F> {
        public Typed<F> fix(Typed<?> var1, Type<F> var2);
    }
}

