/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.RewriteResult;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.View;
import com.mojang.datafixers.functions.PointFreeRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.BitSet;
import net.minecraft.SystemUtils;

public abstract class NamedEntityWriteReadFix
extends DataFix {
    private final String name;
    private final String entityName;
    private final DSL.TypeReference type;

    public NamedEntityWriteReadFix(Schema var0, boolean var1, String var2, DSL.TypeReference var3, String var4) {
        super(var0, var1);
        this.name = var2;
        this.type = var3;
        this.entityName = var4;
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(this.type);
        Type var1 = this.getInputSchema().getChoiceType(this.type, this.entityName);
        Type var2 = this.getOutputSchema().getType(this.type);
        Type var3 = this.getOutputSchema().getChoiceType(this.type, this.entityName);
        OpticFinder var4 = DSL.namedChoice((String)this.entityName, (Type)var1);
        Type var5 = var1.all(NamedEntityWriteReadFix.typePatcher(var0, var2), true, false).view().newType();
        return this.fix(var0, var2, var4, var3, var5);
    }

    private <S, T, A, B> TypeRewriteRule fix(Type<S> var0, Type<T> var1, OpticFinder<A> var2, Type<B> var3, Type<?> var42) {
        return this.fixTypeEverywhere(this.name, var0, var1, var4 -> var5 -> {
            Typed var6 = new Typed(var0, var4, var5);
            return var6.update(var2, var3, var3 -> {
                Type<?> var42 = new Typed(var42, var4, var3);
                return SystemUtils.writeAndReadTypedOrThrow(var42, var3, this::fix).getValue();
            }).getValue();
        });
    }

    private static <A, B> TypeRewriteRule typePatcher(Type<A> var0, Type<B> var1) {
        RewriteResult var2 = RewriteResult.create((View)View.create((String)"Patcher", var0, var1, var02 -> var0 -> {
            throw new UnsupportedOperationException();
        }), (BitSet)new BitSet());
        return TypeRewriteRule.everywhere((TypeRewriteRule)TypeRewriteRule.ifSame(var0, (RewriteResult)var2), (PointFreeRule)PointFreeRule.nop(), (boolean)true, (boolean)true);
    }

    protected abstract <T> Dynamic<T> fix(Dynamic<T> var1);
}

