/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import com.mojang.logging.LogUtils;
import java.net.SocketAddress;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JfrProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.slf4j.Logger;

public interface JvmProfiler {
    public static final JvmProfiler INSTANCE = Runtime.class.getModule().getLayer().findModule("jdk.jfr").isPresent() ? JfrProfiler.getInstance() : new a();

    public boolean start(Environment var1);

    public Path stop();

    public boolean isRunning();

    public boolean isAvailable();

    public void onServerTick(float var1);

    public void onPacketReceived(EnumProtocol var1, PacketType<?> var2, SocketAddress var3, int var4);

    public void onPacketSent(EnumProtocol var1, PacketType<?> var2, SocketAddress var3, int var4);

    public void onRegionFileRead(RegionStorageInfo var1, ChunkCoordIntPair var2, RegionFileCompression var3, int var4);

    public void onRegionFileWrite(RegionStorageInfo var1, ChunkCoordIntPair var2, RegionFileCompression var3, int var4);

    @Nullable
    public ProfiledDuration onWorldLoadedStarted();

    @Nullable
    public ProfiledDuration onChunkGenerate(ChunkCoordIntPair var1, ResourceKey<World> var2, String var3);

    public static class a
    implements JvmProfiler {
        private static final Logger LOGGER = LogUtils.getLogger();
        static final ProfiledDuration noOpCommit = () -> {};

        @Override
        public boolean start(Environment var0) {
            LOGGER.warn("Attempted to start Flight Recorder, but it's not supported on this JVM");
            return false;
        }

        @Override
        public Path stop() {
            throw new IllegalStateException("Attempted to stop Flight Recorder, but it's not supported on this JVM");
        }

        @Override
        public boolean isRunning() {
            return false;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void onPacketReceived(EnumProtocol var0, PacketType<?> var1, SocketAddress var2, int var3) {
        }

        @Override
        public void onPacketSent(EnumProtocol var0, PacketType<?> var1, SocketAddress var2, int var3) {
        }

        @Override
        public void onRegionFileRead(RegionStorageInfo var0, ChunkCoordIntPair var1, RegionFileCompression var2, int var3) {
        }

        @Override
        public void onRegionFileWrite(RegionStorageInfo var0, ChunkCoordIntPair var1, RegionFileCompression var2, int var3) {
        }

        @Override
        public void onServerTick(float var0) {
        }

        @Override
        public ProfiledDuration onWorldLoadedStarted() {
            return noOpCommit;
        }

        @Override
        @Nullable
        public ProfiledDuration onChunkGenerate(ChunkCoordIntPair var0, ResourceKey<World> var1, String var2) {
            return null;
        }
    }
}

