/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import it.unimi.dsi.fastutil.objects.Reference2FloatMaps;
import it.unimi.dsi.fastutil.objects.Reference2FloatOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RecreatingChunkStorage;
import net.minecraft.world.level.chunk.storage.RecreatingSimpleRegionStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.slf4j.Logger;

public class WorldUpgrader {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).build();
    private static final String NEW_DIRECTORY_PREFIX = "new_";
    static final IChatMutableComponent STATUS_UPGRADING_POI = IChatBaseComponent.translatable("optimizeWorld.stage.upgrading.poi");
    static final IChatMutableComponent STATUS_FINISHED_POI = IChatBaseComponent.translatable("optimizeWorld.stage.finished.poi");
    static final IChatMutableComponent STATUS_UPGRADING_ENTITIES = IChatBaseComponent.translatable("optimizeWorld.stage.upgrading.entities");
    static final IChatMutableComponent STATUS_FINISHED_ENTITIES = IChatBaseComponent.translatable("optimizeWorld.stage.finished.entities");
    static final IChatMutableComponent STATUS_UPGRADING_CHUNKS = IChatBaseComponent.translatable("optimizeWorld.stage.upgrading.chunks");
    static final IChatMutableComponent STATUS_FINISHED_CHUNKS = IChatBaseComponent.translatable("optimizeWorld.stage.finished.chunks");
    final IRegistry<WorldDimension> dimensions;
    final Set<ResourceKey<World>> levels;
    final boolean eraseCache;
    final boolean recreateRegionFiles;
    final Convertable.ConversionSession levelStorage;
    private final Thread thread;
    final DataFixer dataFixer;
    volatile boolean running = true;
    private volatile boolean finished;
    volatile float progress;
    volatile int totalChunks;
    volatile int totalFiles;
    volatile int converted;
    volatile int skipped;
    final Reference2FloatMap<ResourceKey<World>> progressMap = Reference2FloatMaps.synchronize((Reference2FloatMap)new Reference2FloatOpenHashMap());
    volatile IChatBaseComponent status = IChatBaseComponent.translatable("optimizeWorld.stage.counting");
    static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    final WorldPersistentData overworldDataStorage;

    public WorldUpgrader(Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, IRegistryCustom iregistrycustom, boolean flag, boolean flag1) {
        this.dimensions = iregistrycustom.registryOrThrow(Registries.LEVEL_STEM);
        this.levels = Stream.of(convertable_conversionsession.dimensionType).map(Registries::levelStemToLevel).collect(Collectors.toUnmodifiableSet());
        this.eraseCache = flag;
        this.dataFixer = datafixer;
        this.levelStorage = convertable_conversionsession;
        this.overworldDataStorage = new WorldPersistentData(this.levelStorage.getDimensionPath(World.OVERWORLD).resolve("data").toFile(), datafixer, iregistrycustom);
        this.recreateRegionFiles = flag1;
        this.thread = THREAD_FACTORY.newThread(this::work);
        this.thread.setUncaughtExceptionHandler((thread, throwable) -> {
            LOGGER.error("Error upgrading world", throwable);
            this.status = IChatBaseComponent.translatable("optimizeWorld.stage.failed");
            this.finished = true;
        });
        this.thread.start();
    }

    public void cancel() {
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void work() {
        long i2 = SystemUtils.getMillis();
        LOGGER.info("Upgrading entities");
        new d(this, this).upgrade();
        LOGGER.info("Upgrading POIs");
        new f(this, this).upgrade();
        LOGGER.info("Upgrading blocks");
        new b().upgrade();
        this.overworldDataStorage.save();
        i2 = SystemUtils.getMillis() - i2;
        LOGGER.info("World optimizaton finished after {} seconds", (Object)(i2 / 1000L));
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Set<ResourceKey<World>> levels() {
        return this.levels;
    }

    public float dimensionProgress(ResourceKey<World> resourcekey) {
        return this.progressMap.getFloat(resourcekey);
    }

    public float getProgress() {
        return this.progress;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public int getConverted() {
        return this.converted;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public IChatBaseComponent getStatus() {
        return this.status;
    }

    static Path resolveRecreateDirectory(Path path) {
        return path.resolveSibling(NEW_DIRECTORY_PREFIX + path.getFileName().toString());
    }

    private class d
    extends g {
        d(WorldUpgrader worldUpgrader, WorldUpgrader worldupgrader) {
            super(DataFixTypes.ENTITY_CHUNK, "entities", STATUS_UPGRADING_ENTITIES, STATUS_FINISHED_ENTITIES);
        }

        @Override
        protected NBTTagCompound upgradeTag(SimpleRegionStorage simpleregionstorage, NBTTagCompound nbttagcompound) {
            return simpleregionstorage.upgradeChunkTag(nbttagcompound, -1);
        }
    }

    private class f
    extends g {
        f(WorldUpgrader worldUpgrader, WorldUpgrader worldupgrader) {
            super(DataFixTypes.POI_CHUNK, "poi", STATUS_UPGRADING_POI, STATUS_FINISHED_POI);
        }

        @Override
        protected NBTTagCompound upgradeTag(SimpleRegionStorage simpleregionstorage, NBTTagCompound nbttagcompound) {
            return simpleregionstorage.upgradeChunkTag(nbttagcompound, 1945);
        }
    }

    private class b
    extends a<IChunkLoader> {
        b() {
            super(DataFixTypes.CHUNK, "chunk", "region", STATUS_UPGRADING_CHUNKS, STATUS_FINISHED_CHUNKS);
        }

        @Override
        protected boolean tryProcessOnePosition(IChunkLoader ichunkloader, ChunkCoordIntPair chunkcoordintpair, ResourceKey<World> resourcekey) {
            NBTTagCompound nbttagcompound = ichunkloader.read(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound != null) {
                boolean flag;
                int i2 = IChunkLoader.getVersion(nbttagcompound);
                ChunkGenerator chunkgenerator = WorldUpgrader.this.dimensions.getOrThrow(Registries.levelToLevelStem(resourcekey)).generator();
                NBTTagCompound nbttagcompound1 = ichunkloader.upgradeChunkTag(Registries.levelToLevelStem(resourcekey), () -> WorldUpgrader.this.overworldDataStorage, nbttagcompound, chunkgenerator.getTypeNameForDataFixer(), chunkcoordintpair, null);
                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(nbttagcompound1.getInt("xPos"), nbttagcompound1.getInt("zPos"));
                if (!chunkcoordintpair1.equals(chunkcoordintpair)) {
                    LOGGER.warn("Chunk {} has invalid position {}", (Object)chunkcoordintpair, (Object)chunkcoordintpair1);
                }
                boolean bl = flag = i2 < SharedConstants.getCurrentVersion().getDataVersion().getVersion();
                if (WorldUpgrader.this.eraseCache) {
                    flag = flag || nbttagcompound1.contains("Heightmaps");
                    nbttagcompound1.remove("Heightmaps");
                    flag = flag || nbttagcompound1.contains("isLightOn");
                    nbttagcompound1.remove("isLightOn");
                    NBTTagList nbttaglist = nbttagcompound1.getList("sections", 10);
                    for (int j2 = 0; j2 < nbttaglist.size(); ++j2) {
                        NBTTagCompound nbttagcompound2 = nbttaglist.getCompound(j2);
                        flag = flag || nbttagcompound2.contains("BlockLight");
                        nbttagcompound2.remove("BlockLight");
                        flag = flag || nbttagcompound2.contains("SkyLight");
                        nbttagcompound2.remove("SkyLight");
                    }
                }
                if (flag || WorldUpgrader.this.recreateRegionFiles) {
                    if (this.previousWriteFuture != null) {
                        this.previousWriteFuture.join();
                    }
                    this.previousWriteFuture = ichunkloader.write(chunkcoordintpair, nbttagcompound1);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected IChunkLoader createStorage(RegionStorageInfo regionstorageinfo, Path path) {
            return WorldUpgrader.this.recreateRegionFiles ? new RecreatingChunkStorage(regionstorageinfo.withTypeSuffix("source"), path, regionstorageinfo.withTypeSuffix("target"), WorldUpgrader.resolveRecreateDirectory(path), WorldUpgrader.this.dataFixer, true) : new IChunkLoader(regionstorageinfo, path, WorldUpgrader.this.dataFixer, true);
        }
    }

    record c<T>(ResourceKey<World> dimensionKey, T storage, ListIterator<e> files) {
    }

    record e(RegionFile file, List<ChunkCoordIntPair> chunksToUpgrade) {
    }

    private abstract class a<T extends AutoCloseable> {
        private final IChatMutableComponent upgradingStatus;
        private final IChatMutableComponent finishedStatus;
        private final String type;
        private final String folderName;
        @Nullable
        protected CompletableFuture<Void> previousWriteFuture;
        protected final DataFixTypes dataFixType;

        a(DataFixTypes datafixtypes, String s2, String s1, IChatMutableComponent ichatmutablecomponent, IChatMutableComponent ichatmutablecomponent1) {
            this.dataFixType = datafixtypes;
            this.type = s2;
            this.folderName = s1;
            this.upgradingStatus = ichatmutablecomponent;
            this.finishedStatus = ichatmutablecomponent1;
        }

        public void upgrade() {
            WorldUpgrader.this.totalFiles = 0;
            WorldUpgrader.this.totalChunks = 0;
            WorldUpgrader.this.converted = 0;
            WorldUpgrader.this.skipped = 0;
            List<c<T>> list = this.getDimensionsToUpgrade();
            if (WorldUpgrader.this.totalChunks != 0) {
                float f2 = WorldUpgrader.this.totalFiles;
                WorldUpgrader.this.status = this.upgradingStatus;
                while (WorldUpgrader.this.running) {
                    boolean flag = false;
                    float f1 = 0.0f;
                    for (c<T> worldupgrader_c : list) {
                        ResourceKey<World> resourcekey = worldupgrader_c.dimensionKey;
                        ListIterator<e> listiterator = worldupgrader_c.files;
                        AutoCloseable t0 = (AutoCloseable)worldupgrader_c.storage;
                        if (listiterator.hasNext()) {
                            e worldupgrader_e = listiterator.next();
                            boolean flag1 = true;
                            for (ChunkCoordIntPair chunkcoordintpair : worldupgrader_e.chunksToUpgrade) {
                                flag1 = flag1 && this.processOnePosition(resourcekey, t0, chunkcoordintpair);
                                flag = true;
                            }
                            if (WorldUpgrader.this.recreateRegionFiles) {
                                if (flag1) {
                                    this.onFileFinished(worldupgrader_e.file);
                                } else {
                                    LOGGER.error("Failed to convert region file {}", (Object)worldupgrader_e.file.getPath());
                                }
                            }
                        }
                        float f22 = (float)listiterator.nextIndex() / f2;
                        WorldUpgrader.this.progressMap.put(resourcekey, f22);
                        f1 += f22;
                    }
                    WorldUpgrader.this.progress = f1;
                    if (flag) continue;
                    break;
                }
                WorldUpgrader.this.status = this.finishedStatus;
                for (c<T> worldupgrader_c1 : list) {
                    try {
                        ((AutoCloseable)worldupgrader_c1.storage).close();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error upgrading chunk", (Throwable)exception);
                    }
                }
            }
        }

        private List<c<T>> getDimensionsToUpgrade() {
            ArrayList list = Lists.newArrayList();
            for (ResourceKey<World> resourcekey : WorldUpgrader.this.levels) {
                RegionStorageInfo regionstorageinfo = new RegionStorageInfo(WorldUpgrader.this.levelStorage.getLevelId(), resourcekey, this.type);
                Path path = WorldUpgrader.this.levelStorage.getDimensionPath(resourcekey).resolve(this.folderName);
                T t0 = this.createStorage(regionstorageinfo, path);
                ListIterator<e> listiterator = this.getFilesToProcess(regionstorageinfo, path);
                list.add(new c<T>(resourcekey, t0, listiterator));
            }
            return list;
        }

        protected abstract T createStorage(RegionStorageInfo var1, Path var2);

        private ListIterator<e> getFilesToProcess(RegionStorageInfo regionstorageinfo, Path path) {
            List<e> list = a.getAllChunkPositions(regionstorageinfo, path);
            WorldUpgrader.this.totalFiles += list.size();
            WorldUpgrader.this.totalChunks += list.stream().mapToInt(worldupgrader_e -> worldupgrader_e.chunksToUpgrade.size()).sum();
            return list.listIterator();
        }

        private static List<e> getAllChunkPositions(RegionStorageInfo regionstorageinfo, Path path) {
            File[] afile = path.toFile().listFiles((file, s2) -> s2.endsWith(".mca"));
            if (afile == null) {
                return List.of();
            }
            ArrayList list = Lists.newArrayList();
            File[] afile1 = afile;
            int i2 = afile.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                File file2 = afile1[j2];
                Matcher matcher = REGEX.matcher(file2.getName());
                if (!matcher.matches()) continue;
                int k2 = Integer.parseInt(matcher.group(1)) << 5;
                int l2 = Integer.parseInt(matcher.group(2)) << 5;
                ArrayList list1 = Lists.newArrayList();
                try (RegionFile regionfile = new RegionFile(regionstorageinfo, file2.toPath(), path, true);){
                    for (int i1 = 0; i1 < 32; ++i1) {
                        for (int j1 = 0; j1 < 32; ++j1) {
                            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i1 + k2, j1 + l2);
                            if (!regionfile.doesChunkExist(chunkcoordintpair)) continue;
                            list1.add(chunkcoordintpair);
                        }
                    }
                    if (list1.isEmpty()) continue;
                    list.add(new e(regionfile, list1));
                    continue;
                }
                catch (Throwable throwable2) {
                    LOGGER.error("Failed to read chunks from region file {}", (Object)file2.toPath(), (Object)throwable2);
                }
            }
            return list;
        }

        private boolean processOnePosition(ResourceKey<World> resourcekey, T t0, ChunkCoordIntPair chunkcoordintpair) {
            boolean flag = false;
            try {
                flag = this.tryProcessOnePosition(t0, chunkcoordintpair, resourcekey);
            }
            catch (CompletionException | ReportedException reportedexception) {
                Throwable throwable = reportedexception.getCause();
                if (!(throwable instanceof IOException)) {
                    throw reportedexception;
                }
                LOGGER.error("Error upgrading chunk {}", (Object)chunkcoordintpair, (Object)throwable);
            }
            if (flag) {
                ++WorldUpgrader.this.converted;
            } else {
                ++WorldUpgrader.this.skipped;
            }
            return flag;
        }

        protected abstract boolean tryProcessOnePosition(T var1, ChunkCoordIntPair var2, ResourceKey<World> var3);

        private void onFileFinished(RegionFile regionfile) {
            if (WorldUpgrader.this.recreateRegionFiles) {
                if (this.previousWriteFuture != null) {
                    this.previousWriteFuture.join();
                }
                Path path = regionfile.getPath();
                Path path1 = path.getParent();
                Path path2 = WorldUpgrader.resolveRecreateDirectory(path1).resolve(path.getFileName().toString());
                try {
                    if (path2.toFile().exists()) {
                        Files.delete(path);
                        Files.move(path2, path, new CopyOption[0]);
                    } else {
                        LOGGER.error("Failed to replace an old region file. New file {} does not exist.", (Object)path2);
                    }
                }
                catch (IOException ioexception) {
                    LOGGER.error("Failed to replace an old region file", (Throwable)ioexception);
                }
            }
        }
    }

    private abstract class g
    extends a<SimpleRegionStorage> {
        g(DataFixTypes datafixtypes, String s2, IChatMutableComponent ichatmutablecomponent, IChatMutableComponent ichatmutablecomponent1) {
            super(datafixtypes, s2, s2, ichatmutablecomponent, ichatmutablecomponent1);
        }

        @Override
        protected SimpleRegionStorage createStorage(RegionStorageInfo regionstorageinfo, Path path) {
            return WorldUpgrader.this.recreateRegionFiles ? new RecreatingSimpleRegionStorage(regionstorageinfo.withTypeSuffix("source"), path, regionstorageinfo.withTypeSuffix("target"), WorldUpgrader.resolveRecreateDirectory(path), WorldUpgrader.this.dataFixer, true, this.dataFixType) : new SimpleRegionStorage(regionstorageinfo, path, WorldUpgrader.this.dataFixer, true, this.dataFixType);
        }

        @Override
        protected boolean tryProcessOnePosition(SimpleRegionStorage simpleregionstorage, ChunkCoordIntPair chunkcoordintpair, ResourceKey<World> resourcekey) {
            NBTTagCompound nbttagcompound = simpleregionstorage.read(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound != null) {
                boolean flag;
                int i2 = IChunkLoader.getVersion(nbttagcompound);
                NBTTagCompound nbttagcompound1 = this.upgradeTag(simpleregionstorage, nbttagcompound);
                boolean bl = flag = i2 < SharedConstants.getCurrentVersion().getDataVersion().getVersion();
                if (flag || WorldUpgrader.this.recreateRegionFiles) {
                    if (this.previousWriteFuture != null) {
                        this.previousWriteFuture.join();
                    }
                    this.previousWriteFuture = simpleregionstorage.write(chunkcoordintpair, nbttagcompound1);
                    return true;
                }
            }
            return false;
        }

        protected abstract NBTTagCompound upgradeTag(SimpleRegionStorage var1, NBTTagCompound var2);
    }
}

