/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.serialization.Codec;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;

public record ChestLock(String key) {
    public static final ChestLock NO_LOCK = new ChestLock("");
    public static final Codec<ChestLock> CODEC = Codec.STRING.xmap(ChestLock::new, ChestLock::key);
    public static final String TAG_LOCK = "Lock";

    public boolean unlocksWith(ItemStack itemstack) {
        if (this.key.isEmpty()) {
            return true;
        }
        IChatBaseComponent ichatbasecomponent = itemstack.get(DataComponents.CUSTOM_NAME);
        if (this.key.isEmpty()) {
            return true;
        }
        if (ichatbasecomponent != null) {
            if (this.key.indexOf(167) == -1) {
                return this.key.equals(ichatbasecomponent.getString());
            }
            return this.key.equals(CraftChatMessage.fromComponent(ichatbasecomponent));
        }
        return false;
    }

    public void addToTag(NBTTagCompound nbttagcompound) {
        if (!this.key.isEmpty()) {
            nbttagcompound.putString(TAG_LOCK, this.key);
        }
    }

    public static ChestLock fromTag(NBTTagCompound nbttagcompound) {
        return nbttagcompound.contains(TAG_LOCK, 8) ? new ChestLock(nbttagcompound.getString(TAG_LOCK)) : NO_LOCK;
    }
}

