/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;

public class ContainerUtil {
    public static final String TAG_ITEMS = "Items";

    public static ItemStack removeItem(List<ItemStack> var0, int var1, int var2) {
        if (var1 < 0 || var1 >= var0.size() || var0.get(var1).isEmpty() || var2 <= 0) {
            return ItemStack.EMPTY;
        }
        return var0.get(var1).split(var2);
    }

    public static ItemStack takeItem(List<ItemStack> var0, int var1) {
        if (var1 < 0 || var1 >= var0.size()) {
            return ItemStack.EMPTY;
        }
        return var0.set(var1, ItemStack.EMPTY);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound var0, NonNullList<ItemStack> var1, HolderLookup.a var2) {
        return ContainerUtil.saveAllItems(var0, var1, true, var2);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound var0, NonNullList<ItemStack> var1, boolean var2, HolderLookup.a var3) {
        NBTTagList var4 = new NBTTagList();
        for (int var5 = 0; var5 < var1.size(); ++var5) {
            ItemStack var6 = var1.get(var5);
            if (var6.isEmpty()) continue;
            NBTTagCompound var7 = new NBTTagCompound();
            var7.putByte("Slot", (byte)var5);
            var4.add(var6.save(var3, var7));
        }
        if (!var4.isEmpty() || var2) {
            var0.put(TAG_ITEMS, var4);
        }
        return var0;
    }

    public static void loadAllItems(NBTTagCompound var0, NonNullList<ItemStack> var1, HolderLookup.a var2) {
        NBTTagList var3 = var0.getList(TAG_ITEMS, 10);
        for (int var4 = 0; var4 < var3.size(); ++var4) {
            NBTTagCompound var5 = var3.getCompound(var4);
            int var6 = var5.getByte("Slot") & 0xFF;
            if (var6 < 0 || var6 >= var1.size()) continue;
            var1.set(var6, ItemStack.parse(var2, var5).orElse(ItemStack.EMPTY));
        }
    }

    public static int clearOrCountMatchingItems(IInventory var0, Predicate<ItemStack> var1, int var2, boolean var3) {
        int var4 = 0;
        for (int var5 = 0; var5 < var0.getContainerSize(); ++var5) {
            ItemStack var6 = var0.getItem(var5);
            int var7 = ContainerUtil.clearOrCountMatchingItems(var6, var1, var2 - var4, var3);
            if (var7 > 0 && !var3 && var6.isEmpty()) {
                var0.setItem(var5, ItemStack.EMPTY);
            }
            var4 += var7;
        }
        return var4;
    }

    public static int clearOrCountMatchingItems(ItemStack var0, Predicate<ItemStack> var1, int var2, boolean var3) {
        if (var0.isEmpty() || !var1.test(var0)) {
            return 0;
        }
        if (var3) {
            return var0.getCount();
        }
        int var4 = var2 < 0 ? var0.getCount() : Math.min(var2, var0.getCount());
        var0.shrink(var4);
        return var4;
    }
}

