/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public interface IInventory
extends Clearable {
    public static final float DEFAULT_DISTANCE_BUFFER = 4.0f;
    public static final int MAX_STACK = 99;

    public int getContainerSize();

    public boolean isEmpty();

    public ItemStack getItem(int var1);

    public ItemStack removeItem(int var1, int var2);

    public ItemStack removeItemNoUpdate(int var1);

    public void setItem(int var1, ItemStack var2);

    public int getMaxStackSize();

    default public int getMaxStackSize(ItemStack itemstack) {
        return Math.min(this.getMaxStackSize(), itemstack.getMaxStackSize());
    }

    public void setChanged();

    public boolean stillValid(EntityHuman var1);

    default public void startOpen(EntityHuman entityhuman) {
    }

    default public void stopOpen(EntityHuman entityhuman) {
    }

    default public boolean canPlaceItem(int i2, ItemStack itemstack) {
        return true;
    }

    default public boolean canTakeItem(IInventory iinventory, int i2, ItemStack itemstack) {
        return true;
    }

    default public int countItem(Item item) {
        int i2 = 0;
        for (int j2 = 0; j2 < this.getContainerSize(); ++j2) {
            ItemStack itemstack = this.getItem(j2);
            if (!itemstack.getItem().equals(item)) continue;
            i2 += itemstack.getCount();
        }
        return i2;
    }

    default public boolean hasAnyOf(Set<Item> set) {
        return this.hasAnyMatching(itemstack -> !itemstack.isEmpty() && set.contains(itemstack.getItem()));
    }

    default public boolean hasAnyMatching(Predicate<ItemStack> predicate) {
        for (int i2 = 0; i2 < this.getContainerSize(); ++i2) {
            ItemStack itemstack = this.getItem(i2);
            if (!predicate.test(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean stillValidBlockEntity(TileEntity tileentity, EntityHuman entityhuman) {
        return IInventory.stillValidBlockEntity(tileentity, entityhuman, 4.0f);
    }

    public static boolean stillValidBlockEntity(TileEntity tileentity, EntityHuman entityhuman, float f2) {
        World world = tileentity.getLevel();
        BlockPosition blockposition = tileentity.getBlockPos();
        return world == null ? false : (world.getBlockEntity(blockposition) != tileentity ? false : entityhuman.canInteractWithBlock(blockposition, f2));
    }

    public List<ItemStack> getContents();

    public void onOpen(CraftHumanEntity var1);

    public void onClose(CraftHumanEntity var1);

    public List<HumanEntity> getViewers();

    public InventoryHolder getOwner();

    public void setMaxStackSize(int var1);

    public Location getLocation();
}

