/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class InventoryLargeChest
implements IInventory {
    public final IInventory container1;
    public final IInventory container2;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    @Override
    public List<ItemStack> getContents() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(this.getContainerSize());
        for (int i2 = 0; i2 < this.getContainerSize(); ++i2) {
            result.add(this.getItem(i2));
        }
        return result;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.container1.onOpen(who);
        this.container2.onOpen(who);
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.container1.onClose(who);
        this.container2.onClose(who);
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return null;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.container1.setMaxStackSize(size);
        this.container2.setMaxStackSize(size);
    }

    @Override
    public Location getLocation() {
        return this.container1.getLocation();
    }

    public InventoryLargeChest(IInventory iinventory, IInventory iinventory1) {
        this.container1 = iinventory;
        this.container2 = iinventory1;
    }

    @Override
    public int getContainerSize() {
        return this.container1.getContainerSize() + this.container2.getContainerSize();
    }

    @Override
    public boolean isEmpty() {
        return this.container1.isEmpty() && this.container2.isEmpty();
    }

    public boolean contains(IInventory iinventory) {
        return this.container1 == iinventory || this.container2 == iinventory;
    }

    @Override
    public ItemStack getItem(int i2) {
        return i2 >= this.container1.getContainerSize() ? this.container2.getItem(i2 - this.container1.getContainerSize()) : this.container1.getItem(i2);
    }

    @Override
    public ItemStack removeItem(int i2, int j2) {
        return i2 >= this.container1.getContainerSize() ? this.container2.removeItem(i2 - this.container1.getContainerSize(), j2) : this.container1.removeItem(i2, j2);
    }

    @Override
    public ItemStack removeItemNoUpdate(int i2) {
        return i2 >= this.container1.getContainerSize() ? this.container2.removeItemNoUpdate(i2 - this.container1.getContainerSize()) : this.container1.removeItemNoUpdate(i2);
    }

    @Override
    public void setItem(int i2, ItemStack itemstack) {
        if (i2 >= this.container1.getContainerSize()) {
            this.container2.setItem(i2 - this.container1.getContainerSize(), itemstack);
        } else {
            this.container1.setItem(i2, itemstack);
        }
    }

    @Override
    public int getMaxStackSize() {
        return Math.min(this.container1.getMaxStackSize(), this.container2.getMaxStackSize());
    }

    @Override
    public void setChanged() {
        this.container1.setChanged();
        this.container2.setChanged();
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return this.container1.stillValid(entityhuman) && this.container2.stillValid(entityhuman);
    }

    @Override
    public void startOpen(EntityHuman entityhuman) {
        this.container1.startOpen(entityhuman);
        this.container2.startOpen(entityhuman);
    }

    @Override
    public void stopOpen(EntityHuman entityhuman) {
        this.container1.stopOpen(entityhuman);
        this.container2.stopOpen(entityhuman);
    }

    @Override
    public boolean canPlaceItem(int i2, ItemStack itemstack) {
        return i2 >= this.container1.getContainerSize() ? this.container2.canPlaceItem(i2 - this.container1.getContainerSize(), itemstack) : this.container1.canPlaceItem(i2, itemstack);
    }

    @Override
    public void clearContent() {
        this.container1.clearContent();
        this.container2.clearContent();
    }
}

