/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class InventorySubcontainer
implements IInventory,
AutoRecipeOutput {
    private final int size;
    public final NonNullList<ItemStack> items;
    @Nullable
    private List<IInventoryListener> listeners;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    protected InventoryHolder bukkitOwner;

    @Override
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int i2) {
        this.maxStack = i2;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.bukkitOwner;
    }

    @Override
    public Location getLocation() {
        return null;
    }

    public InventorySubcontainer(InventorySubcontainer original) {
        this(original.size);
        for (int slot = 0; slot < original.size; ++slot) {
            this.items.set(slot, original.items.get(slot).copy());
        }
    }

    public InventorySubcontainer(int i2) {
        this(i2, null);
    }

    public InventorySubcontainer(int i2, InventoryHolder owner) {
        this.bukkitOwner = owner;
        this.size = i2;
        this.items = NonNullList.withSize(i2, ItemStack.EMPTY);
    }

    public InventorySubcontainer(ItemStack ... aitemstack) {
        this.size = aitemstack.length;
        this.items = NonNullList.of(ItemStack.EMPTY, aitemstack);
    }

    public void addListener(IInventoryListener iinventorylistener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(iinventorylistener);
    }

    public void removeListener(IInventoryListener iinventorylistener) {
        if (this.listeners != null) {
            this.listeners.remove(iinventorylistener);
        }
    }

    @Override
    public ItemStack getItem(int i2) {
        return i2 >= 0 && i2 < this.items.size() ? this.items.get(i2) : ItemStack.EMPTY;
    }

    public List<ItemStack> removeAllItems() {
        List<ItemStack> list = this.items.stream().filter(itemstack -> !itemstack.isEmpty()).collect(Collectors.toList());
        this.clearContent();
        return list;
    }

    @Override
    public ItemStack removeItem(int i2, int j2) {
        ItemStack itemstack = ContainerUtil.removeItem(this.items, i2, j2);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemType(Item item, int i2) {
        ItemStack itemstack = new ItemStack(item, 0);
        for (int j2 = this.size - 1; j2 >= 0; --j2) {
            ItemStack itemstack1 = this.getItem(j2);
            if (!itemstack1.getItem().equals(item)) continue;
            int k2 = i2 - itemstack.getCount();
            ItemStack itemstack2 = itemstack1.split(k2);
            itemstack.grow(itemstack2.getCount());
            if (itemstack.getCount() == i2) break;
        }
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack addItem(ItemStack itemstack) {
        if (itemstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack1 = itemstack.copy();
        this.moveItemToOccupiedSlotsWithSameType(itemstack1);
        if (itemstack1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.moveItemToEmptySlots(itemstack1);
        return itemstack1.isEmpty() ? ItemStack.EMPTY : itemstack1;
    }

    public boolean canAddItem(ItemStack itemstack) {
        boolean flag = false;
        for (ItemStack itemstack1 : this.items) {
            if (!itemstack1.isEmpty() && (!ItemStack.isSameItemSameComponents(itemstack1, itemstack) || itemstack1.getCount() >= itemstack1.getMaxStackSize())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public ItemStack removeItemNoUpdate(int i2) {
        ItemStack itemstack = this.items.get(i2);
        if (itemstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.items.set(i2, ItemStack.EMPTY);
        return itemstack;
    }

    @Override
    public void setItem(int i2, ItemStack itemstack) {
        this.items.set(i2, itemstack);
        itemstack.limitSize(this.getMaxStackSize(itemstack));
        this.setChanged();
    }

    @Override
    public int getContainerSize() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        ItemStack itemstack;
        Iterator iterator = this.items.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).isEmpty());
        return false;
    }

    @Override
    public void setChanged() {
        if (this.listeners != null) {
            for (IInventoryListener iinventorylistener : this.listeners) {
                iinventorylistener.containerChanged(this);
            }
        }
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return true;
    }

    @Override
    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    @Override
    public void fillStackedContents(AutoRecipeStackManager autorecipestackmanager) {
        for (ItemStack itemstack : this.items) {
            autorecipestackmanager.accountStack(itemstack);
        }
    }

    public String toString() {
        return this.items.stream().filter(itemstack -> !itemstack.isEmpty()).collect(Collectors.toList()).toString();
    }

    private void moveItemToEmptySlots(ItemStack itemstack) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            ItemStack itemstack1 = this.getItem(i2);
            if (!itemstack1.isEmpty()) continue;
            this.setItem(i2, itemstack.copyAndClear());
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(ItemStack itemstack) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            ItemStack itemstack1 = this.getItem(i2);
            if (!ItemStack.isSameItemSameComponents(itemstack1, itemstack)) continue;
            this.moveItemsBetweenStacks(itemstack, itemstack1);
            if (!itemstack.isEmpty()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(ItemStack itemstack, ItemStack itemstack1) {
        int i2 = this.getMaxStackSize(itemstack1);
        int j2 = Math.min(itemstack.getCount(), i2 - itemstack1.getCount());
        if (j2 > 0) {
            itemstack1.grow(j2);
            itemstack.shrink(j2);
            this.setChanged();
        }
    }

    public void fromTag(NBTTagList nbttaglist, HolderLookup.a holderlookup_a) {
        this.clearContent();
        for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
            ItemStack.parse(holderlookup_a, nbttaglist.getCompound(i2)).ifPresent(this::addItem);
        }
    }

    public NBTTagList createTag(HolderLookup.a holderlookup_a) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i2 = 0; i2 < this.getContainerSize(); ++i2) {
            ItemStack itemstack = this.getItem(i2);
            if (itemstack.isEmpty()) continue;
            nbttaglist.add(itemstack.save(holderlookup_a));
        }
        return nbttaglist;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }
}

