/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import javax.annotation.Nullable;
import net.minecraft.world.effect.InstantMobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.event.entity.EntityRegainHealthEvent;

class HealOrHarmMobEffect
extends InstantMobEffect {
    private final boolean isHarm;

    public HealOrHarmMobEffect(MobEffectInfo mobeffectinfo, int i2, boolean flag) {
        super(mobeffectinfo, i2);
        this.isHarm = flag;
    }

    @Override
    public boolean applyEffectTick(EntityLiving entityliving, int i2) {
        if (this.isHarm == entityliving.isInvertedHealAndHarm()) {
            entityliving.heal(Math.max(4 << i2, 0), EntityRegainHealthEvent.RegainReason.MAGIC);
        } else {
            entityliving.hurt(entityliving.damageSources().magic(), 6 << i2);
        }
        return true;
    }

    @Override
    public void applyInstantenousEffect(@Nullable Entity entity, @Nullable Entity entity1, EntityLiving entityliving, int i2, double d0) {
        if (this.isHarm == entityliving.isInvertedHealAndHarm()) {
            int j2 = (int)(d0 * (double)(4 << i2) + 0.5);
            entityliving.heal(j2, EntityRegainHealthEvent.RegainReason.MAGIC);
        } else {
            int j3 = (int)(d0 * (double)(6 << i2) + 0.5);
            if (entity == null) {
                entityliving.hurt(entityliving.damageSources().magic(), j3);
            } else {
                entityliving.hurt(entityliving.damageSources().indirectMagic(entity, entity1), j3);
            }
        }
    }
}

