/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import java.util.function.ToIntFunction;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.joml.Vector3f;

class InfestedMobEffect
extends MobEffectList {
    private final float chanceToSpawn;
    private final ToIntFunction<RandomSource> spawnedCount;

    protected InfestedMobEffect(MobEffectInfo mobeffectinfo, int i2, float f2, ToIntFunction<RandomSource> tointfunction) {
        super(mobeffectinfo, i2, Particles.INFESTED);
        this.chanceToSpawn = f2;
        this.spawnedCount = tointfunction;
    }

    @Override
    public void onMobHurt(EntityLiving entityliving, int i2, DamageSource damagesource, float f2) {
        if (entityliving.getRandom().nextFloat() <= this.chanceToSpawn) {
            int j2 = this.spawnedCount.applyAsInt(entityliving.getRandom());
            for (int k2 = 0; k2 < j2; ++k2) {
                this.spawnSilverfish(entityliving.level(), entityliving, entityliving.getX(), entityliving.getY() + (double)entityliving.getBbHeight() / 2.0, entityliving.getZ());
            }
        }
    }

    private void spawnSilverfish(World world, EntityLiving entityliving, double d0, double d1, double d2) {
        EntitySilverfish entitysilverfish = EntityTypes.SILVERFISH.create(world);
        if (entitysilverfish != null) {
            RandomSource randomsource = entityliving.getRandom();
            float f2 = 1.5707964f;
            float f1 = MathHelper.randomBetween(randomsource, -1.5707964f, 1.5707964f);
            Vector3f vector3f = entityliving.getLookAngle().toVector3f().mul(0.3f).mul(1.0f, 1.5f, 1.0f).rotateY(f1);
            entitysilverfish.moveTo(d0, d1, d2, world.getRandom().nextFloat() * 360.0f, 0.0f);
            entitysilverfish.setDeltaMovement(new Vec3D(vector3f));
            if (!world.addFreshEntity(entitysilverfish, CreatureSpawnEvent.SpawnReason.POTION_EFFECT)) {
                return;
            }
            entitysilverfish.playSound(SoundEffects.SILVERFISH_HURT);
        }
    }
}

