/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.function.ToIntFunction;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.CreatureSpawnEvent;

class OozingMobEffect
extends MobEffectList {
    private static final int RADIUS_TO_CHECK_SLIMES = 2;
    public static final int SLIME_SIZE = 2;
    private final ToIntFunction<RandomSource> spawnedCount;

    protected OozingMobEffect(MobEffectInfo mobeffectinfo, int i2, ToIntFunction<RandomSource> tointfunction) {
        super(mobeffectinfo, i2, Particles.ITEM_SLIME);
        this.spawnedCount = tointfunction;
    }

    @VisibleForTesting
    protected static int numberOfSlimesToSpawn(int i2, a oozingmobeffect_a, int j2) {
        return i2 < 1 ? j2 : MathHelper.clamp(0, i2 - oozingmobeffect_a.count(i2), j2);
    }

    @Override
    public void onMobRemoved(EntityLiving entityliving, int i2, Entity.RemovalReason entity_removalreason) {
        if (entity_removalreason == Entity.RemovalReason.KILLED) {
            int j2 = this.spawnedCount.applyAsInt(entityliving.getRandom());
            World world = entityliving.level();
            int k2 = world.getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
            int l2 = OozingMobEffect.numberOfSlimesToSpawn(k2, a.closeTo(entityliving), j2);
            for (int i1 = 0; i1 < l2; ++i1) {
                this.spawnSlimeOffspring(entityliving.level(), entityliving.getX(), entityliving.getY() + 0.5, entityliving.getZ());
            }
        }
    }

    private void spawnSlimeOffspring(World world, double d0, double d1, double d2) {
        EntitySlime entityslime = EntityTypes.SLIME.create(world);
        if (entityslime != null) {
            entityslime.setSize(2, true);
            entityslime.moveTo(d0, d1, d2, world.getRandom().nextFloat() * 360.0f, 0.0f);
            world.addFreshEntity(entityslime, CreatureSpawnEvent.SpawnReason.POTION_EFFECT);
        }
    }

    @FunctionalInterface
    protected static interface a {
        public int count(int var1);

        public static a closeTo(EntityLiving entityliving) {
            return i2 -> {
                ArrayList list = new ArrayList();
                entityliving.level().getEntities(EntityTypes.SLIME, entityliving.getBoundingBox().inflate(2.0), entityslime -> entityslime != entityliving, list, i2);
                return list.size();
            };
        }
    }
}

