/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.CustomTimingsHandler;

public abstract class Entity
implements SyncedDataHolder,
INamableTileEntity,
EntityAccess,
ICommandListener,
ScoreHolder {
    private static final int CURRENT_LEVEL = 2;
    private CraftEntity bukkitEntity;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String ID_TAG = "id";
    public static final String PASSENGERS_TAG = "Passengers";
    private static final AtomicInteger ENTITY_COUNTER = new AtomicInteger();
    public static final int CONTENTS_SLOT_INDEX = 0;
    public static final int BOARDING_COOLDOWN = 60;
    public static final int TOTAL_AIR_SUPPLY = 300;
    public static final int MAX_ENTITY_TAG_COUNT = 1024;
    public static final float DELTA_AFFECTED_BY_BLOCKS_BELOW_0_2 = 0.2f;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_0_5 = 0.500001;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_1_0 = 0.999999;
    public static final int BASE_TICKS_REQUIRED_TO_FREEZE = 140;
    public static final int FREEZE_HURT_FREQUENCY = 40;
    public static final int BASE_SAFE_FALL_DISTANCE = 3;
    private static final AxisAlignedBB INITIAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double WATER_FLOW_SCALE = 0.014;
    private static final double LAVA_FAST_FLOW_SCALE = 0.007;
    private static final double LAVA_SLOW_FLOW_SCALE = 0.0023333333333333335;
    public static final String UUID_TAG = "UUID";
    private static double viewScale = 1.0;
    private final EntityTypes<?> type;
    private int id;
    public boolean blocksBuilding;
    public ImmutableList<Entity> passengers;
    protected int boardingCooldown;
    @Nullable
    private Entity vehicle;
    private net.minecraft.world.level.World level;
    public double xo;
    public double yo;
    public double zo;
    private Vec3D position;
    private BlockPosition blockPosition;
    private ChunkCoordIntPair chunkPosition;
    private Vec3D deltaMovement;
    private float yRot;
    private float xRot;
    public float yRotO;
    public float xRotO;
    private AxisAlignedBB bb;
    public boolean onGround;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean verticalCollisionBelow;
    public boolean minorHorizontalCollision;
    public boolean hurtMarked;
    protected Vec3D stuckSpeedMultiplier;
    @Nullable
    private RemovalReason removalReason;
    public static final float DEFAULT_BB_WIDTH = 0.6f;
    public static final float DEFAULT_BB_HEIGHT = 1.8f;
    public float walkDistO;
    public float walkDist;
    public float moveDist;
    public float flyDist;
    public float fallDistance;
    private float nextStep = 1.0f;
    public double xOld;
    public double yOld;
    public double zOld;
    public boolean noPhysics;
    public final RandomSource random;
    public int tickCount;
    private int remainingFireTicks;
    public boolean wasTouchingWater;
    protected Object2DoubleMap<TagKey<FluidType>> fluidHeight;
    protected boolean wasEyeInWater;
    private final Set<TagKey<FluidType>> fluidOnEyes;
    public int invulnerableTime;
    protected boolean firstTick = true;
    protected final DataWatcher entityData;
    protected static final DataWatcherObject<Byte> DATA_SHARED_FLAGS_ID = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BYTE);
    protected static final int FLAG_ONFIRE = 0;
    private static final int FLAG_SHIFT_KEY_DOWN = 1;
    private static final int FLAG_SPRINTING = 3;
    private static final int FLAG_SWIMMING = 4;
    private static final int FLAG_INVISIBLE = 5;
    protected static final int FLAG_GLOWING = 6;
    protected static final int FLAG_FALL_FLYING = 7;
    private static final DataWatcherObject<Integer> DATA_AIR_SUPPLY_ID = DataWatcher.defineId(Entity.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> DATA_CUSTOM_NAME = DataWatcher.defineId(Entity.class, DataWatcherRegistry.OPTIONAL_COMPONENT);
    private static final DataWatcherObject<Boolean> DATA_CUSTOM_NAME_VISIBLE = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_SILENT = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_NO_GRAVITY = DataWatcher.defineId(Entity.class, DataWatcherRegistry.BOOLEAN);
    protected static final DataWatcherObject<EntityPose> DATA_POSE = DataWatcher.defineId(Entity.class, DataWatcherRegistry.POSE);
    private static final DataWatcherObject<Integer> DATA_TICKS_FROZEN = DataWatcher.defineId(Entity.class, DataWatcherRegistry.INT);
    private EntityInLevelCallback levelCallback;
    private final VecDeltaCodec packetPositionCodec;
    public boolean noCulling;
    public boolean hasImpulse;
    @Nullable
    public PortalProcessor portalProcess;
    public int portalCooldown;
    private boolean invulnerable;
    protected UUID uuid;
    protected String stringUUID;
    private boolean hasGlowingTag;
    private final Set<String> tags;
    private final double[] pistonDeltas;
    private long pistonDeltasGameTime;
    private EntitySize dimensions;
    private float eyeHeight;
    public boolean isInPowderSnow;
    public boolean wasInPowderSnow;
    public boolean wasOnFire;
    public Optional<BlockPosition> mainSupportingBlockPos;
    private boolean onGroundNoBlocks = false;
    private float crystalSoundIntensity;
    private int lastCrystalSoundPlayTick;
    public boolean hasVisualFire;
    @Nullable
    private IBlockData inBlockState = null;
    public boolean forceDrops;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPosition lastLavaContact;
    public boolean pluginRemoved = false;
    public CustomTimingsHandler tickTimer = SpigotTimings.getEntityTimings(this);
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;

    static boolean isLevelAtLeast(NBTTagCompound tag, int level) {
        return tag.contains("Bukkit.updateLevel") && tag.getInt("Bukkit.updateLevel") >= level;
    }

    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = CraftEntity.getEntity(this.level.getCraftServer(), this);
        }
        return this.bukkitEntity;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.getBukkitEntity();
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public float getBukkitYaw() {
        return this.yRot;
    }

    public boolean isChunkLoaded() {
        return this.level.hasChunk((int)Math.floor(this.getX()) >> 4, (int)Math.floor(this.getZ()) >> 4);
    }

    public Entity(EntityTypes<?> entitytypes, net.minecraft.world.level.World world) {
        this.id = ENTITY_COUNTER.incrementAndGet();
        this.passengers = ImmutableList.of();
        this.deltaMovement = Vec3D.ZERO;
        this.bb = INITIAL_AABB;
        this.stuckSpeedMultiplier = Vec3D.ZERO;
        this.random = RandomSource.create();
        this.remainingFireTicks = -this.getFireImmuneTicks();
        this.fluidHeight = new Object2DoubleArrayMap(2);
        this.fluidOnEyes = new HashSet<TagKey<FluidType>>();
        this.levelCallback = EntityInLevelCallback.NULL;
        this.packetPositionCodec = new VecDeltaCodec();
        this.uuid = MathHelper.createInsecureUUID(this.random);
        this.stringUUID = this.uuid.toString();
        this.tags = Sets.newHashSet();
        this.pistonDeltas = new double[]{0.0, 0.0, 0.0};
        this.mainSupportingBlockPos = Optional.empty();
        this.type = entitytypes;
        this.level = world;
        this.dimensions = entitytypes.getDimensions();
        this.position = Vec3D.ZERO;
        this.blockPosition = BlockPosition.ZERO;
        this.chunkPosition = ChunkCoordIntPair.ZERO;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        DataWatcher.a datawatcher_a = new DataWatcher.a(this);
        datawatcher_a.define(DATA_SHARED_FLAGS_ID, (byte)0);
        datawatcher_a.define(DATA_AIR_SUPPLY_ID, this.getMaxAirSupply());
        datawatcher_a.define(DATA_CUSTOM_NAME_VISIBLE, false);
        datawatcher_a.define(DATA_CUSTOM_NAME, Optional.empty());
        datawatcher_a.define(DATA_SILENT, false);
        datawatcher_a.define(DATA_NO_GRAVITY, false);
        datawatcher_a.define(DATA_POSE, EntityPose.STANDING);
        datawatcher_a.define(DATA_TICKS_FROZEN, 0);
        this.defineSynchedData(datawatcher_a);
        this.entityData = datawatcher_a.build();
        this.setPos(0.0, 0.0, 0.0);
        this.eyeHeight = this.dimensions.eyeHeight();
    }

    public boolean isColliding(BlockPosition blockposition, IBlockData iblockdata) {
        VoxelShape voxelshape = iblockdata.getCollisionShape(this.level(), blockposition, VoxelShapeCollision.of(this));
        VoxelShape voxelshape1 = voxelshape.move(blockposition.getX(), blockposition.getY(), blockposition.getZ());
        return VoxelShapes.joinIsNotEmpty(voxelshape1, VoxelShapes.create(this.getBoundingBox()), OperatorBoolean.AND);
    }

    public int getTeamColor() {
        ScoreboardTeam scoreboardteam = this.getTeam();
        return scoreboardteam != null && scoreboardteam.getColor().getColor() != null ? scoreboardteam.getColor().getColor() : 0xFFFFFF;
    }

    public boolean isSpectator() {
        return false;
    }

    public final void unRide() {
        if (this.isVehicle()) {
            this.ejectPassengers();
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
    }

    public void syncPacketPositionCodec(double d0, double d1, double d2) {
        this.packetPositionCodec.setBase(new Vec3D(d0, d1, d2));
    }

    public VecDeltaCodec getPositionCodec() {
        return this.packetPositionCodec;
    }

    public EntityTypes<?> getType() {
        return this.type;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int i2) {
        this.id = i2;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean addTag(String s2) {
        return this.tags.size() >= 1024 ? false : this.tags.add(s2);
    }

    public boolean removeTag(String s2) {
        return this.tags.remove(s2);
    }

    public void kill() {
        this.remove(RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    public final void discard() {
        this.discard(null);
    }

    public final void discard(EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.DISCARDED, cause);
    }

    protected abstract void defineSynchedData(DataWatcher.a var1);

    public DataWatcher getEntityData() {
        return this.entityData;
    }

    public void refreshEntityData(EntityPlayer to) {
        List<DataWatcher.c<?>> list = this.getEntityData().getNonDefaultValues();
        if (list != null) {
            to.connection.send(new PacketPlayOutEntityMetadata(this.getId(), list));
        }
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).id == this.id : false;
    }

    public int hashCode() {
        return this.id;
    }

    public void remove(RemovalReason entity_removalreason) {
        this.setRemoved(entity_removalreason, null);
    }

    public void remove(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.setRemoved(entity_removalreason, cause);
    }

    public void onClientRemoval() {
    }

    public void setPose(EntityPose entitypose) {
        if (entitypose == this.getPose()) {
            return;
        }
        this.level.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[entitypose.ordinal()]));
        this.entityData.set(DATA_POSE, entitypose);
    }

    public EntityPose getPose() {
        return this.entityData.get(DATA_POSE);
    }

    public boolean hasPose(EntityPose entitypose) {
        return this.getPose() == entitypose;
    }

    public boolean closerThan(Entity entity, double d0) {
        return this.position().closerThan(entity.position(), d0);
    }

    public boolean closerThan(Entity entity, double d0, double d1) {
        double d2 = entity.getX() - this.getX();
        double d3 = entity.getY() - this.getY();
        double d4 = entity.getZ() - this.getZ();
        return MathHelper.lengthSquared(d2, d4) < MathHelper.square(d0) && MathHelper.square(d3) < MathHelper.square(d1);
    }

    protected void setRot(float f2, float f1) {
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.level.getCraftServer().getLogger().warning(this.getScoreboardName() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        if (f1 == Float.POSITIVE_INFINITY || f1 == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.level.getCraftServer().getLogger().warning(this.getScoreboardName() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            f1 = 0.0f;
        }
        this.setYRot(f2 % 360.0f);
        this.setXRot(f1 % 360.0f);
    }

    public final void setPos(Vec3D vec3d) {
        this.setPos(vec3d.x(), vec3d.y(), vec3d.z());
    }

    public void setPos(double d0, double d1, double d2) {
        this.setPosRaw(d0, d1, d2);
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected AxisAlignedBB makeBoundingBox() {
        return this.dimensions.makeBoundingBox(this.position);
    }

    protected void reapplyPosition() {
        this.setPos(this.position.x, this.position.y, this.position.z);
    }

    public void turn(double d0, double d1) {
        float f2 = (float)d1 * 0.15f;
        float f1 = (float)d0 * 0.15f;
        this.setXRot(this.getXRot() + f2);
        this.setYRot(this.getYRot() + f1);
        this.setXRot(MathHelper.clamp(this.getXRot(), -90.0f, 90.0f));
        this.xRotO += f2;
        this.yRotO += f1;
        this.xRotO = MathHelper.clamp(this.xRotO, -90.0f, 90.0f);
        if (this.vehicle != null) {
            this.vehicle.onPassengerTurned(this);
        }
    }

    public void tick() {
        this.baseTick();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer)) {
            this.handlePortal();
        }
    }

    public void baseTick() {
        this.level().getProfiler().push("entityBaseTick");
        this.inBlockState = null;
        if (this.isPassenger() && this.getVehicle().isRemoved()) {
            this.stopRiding();
        }
        if (this.boardingCooldown > 0) {
            --this.boardingCooldown;
        }
        this.walkDistO = this.walkDist;
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        if (this instanceof EntityPlayer) {
            this.handlePortal();
        }
        if (this.canSpawnSprintParticle()) {
            this.spawnSprintParticle();
        }
        this.wasInPowderSnow = this.isInPowderSnow;
        this.isInPowderSnow = false;
        this.updateInWaterStateAndDoFluidPushing();
        this.updateFluidOnEyes();
        this.updateSwimming();
        if (this.level().isClientSide) {
            this.clearFire();
        } else if (this.remainingFireTicks > 0) {
            if (this.fireImmune()) {
                this.setRemainingFireTicks(this.remainingFireTicks - 4);
                if (this.remainingFireTicks < 0) {
                    this.clearFire();
                }
            } else {
                if (this.remainingFireTicks % 20 == 0 && !this.isInLava()) {
                    this.hurt(this.damageSources().onFire(), 1.0f);
                }
                this.setRemainingFireTicks(this.remainingFireTicks - 1);
            }
            if (this.getTicksFrozen() > 0) {
                this.setTicksFrozen(0);
                this.level().levelEvent(null, 1009, this.blockPosition, 1);
            }
        }
        if (this.isInLava()) {
            this.lavaHurt();
            this.fallDistance *= 0.5f;
        } else {
            this.lastLavaContact = null;
        }
        this.checkBelowWorld();
        if (!this.level().isClientSide) {
            this.setSharedFlagOnFire(this.remainingFireTicks > 0);
        }
        this.firstTick = false;
        if (!this.level().isClientSide && this instanceof Leashable) {
            Leashable.tickLeash((Entity)((Object)((Leashable)((Object)this))));
        }
        this.level().getProfiler().pop();
    }

    public void setSharedFlagOnFire(boolean flag) {
        this.setSharedFlag(0, flag || this.hasVisualFire);
    }

    public void checkBelowWorld() {
        if (this.getY() < (double)(this.level().getMinBuildHeight() - 64)) {
            this.onBelowWorld();
        }
    }

    public void setPortalCooldown() {
        this.portalCooldown = this.getDimensionChangingDelay();
    }

    public void setPortalCooldown(int i2) {
        this.portalCooldown = i2;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public boolean isOnPortalCooldown() {
        return this.portalCooldown > 0;
    }

    protected void processPortalCooldown() {
        if (this.isOnPortalCooldown()) {
            --this.portalCooldown;
        }
    }

    public void lavaHurt() {
        if (!this.fireImmune()) {
            if (this instanceof EntityLiving && this.remainingFireTicks <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.level, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.level.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.igniteForSeconds(combustEvent.getDuration(), false);
                }
            } else {
                this.igniteForSeconds(15.0f, false);
            }
            if (this.hurt(this.damageSources().lava().directBlock(this.level, this.lastLavaContact), 4.0f)) {
                this.playSound(SoundEffects.GENERIC_BURN, 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
            }
        }
    }

    public final void igniteForSeconds(float f2) {
        this.igniteForSeconds(f2, true);
    }

    public final void igniteForSeconds(float f2, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), f2);
            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            f2 = event.getDuration();
        }
        this.igniteForTicks(MathHelper.floor(f2 * 20.0f));
    }

    public void igniteForTicks(int i2) {
        if (this.remainingFireTicks < i2) {
            this.setRemainingFireTicks(i2);
        }
    }

    public void setRemainingFireTicks(int i2) {
        this.remainingFireTicks = i2;
    }

    public int getRemainingFireTicks() {
        return this.remainingFireTicks;
    }

    public void clearFire() {
        this.setRemainingFireTicks(0);
    }

    protected void onBelowWorld() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean isFree(double d0, double d1, double d2) {
        return this.isFree(this.getBoundingBox().move(d0, d1, d2));
    }

    private boolean isFree(AxisAlignedBB axisalignedbb) {
        return this.level().noCollision(this, axisalignedbb) && !this.level().containsAnyLiquid(axisalignedbb);
    }

    public void setOnGround(boolean flag) {
        this.onGround = flag;
        this.checkSupportingBlock(flag, null);
    }

    public void setOnGroundWithMovement(boolean flag, Vec3D vec3d) {
        this.onGround = flag;
        this.checkSupportingBlock(flag, vec3d);
    }

    public boolean isSupportedBy(BlockPosition blockposition) {
        return this.mainSupportingBlockPos.isPresent() && this.mainSupportingBlockPos.get().equals(blockposition);
    }

    protected void checkSupportingBlock(boolean flag, @Nullable Vec3D vec3d) {
        if (flag) {
            AxisAlignedBB axisalignedbb = this.getBoundingBox();
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.minX, axisalignedbb.minY - 1.0E-6, axisalignedbb.minZ, axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
            Optional<BlockPosition> optional = this.level.findSupportingBlock(this, axisalignedbb1);
            if (!optional.isPresent() && !this.onGroundNoBlocks) {
                if (vec3d != null) {
                    AxisAlignedBB axisalignedbb2 = axisalignedbb1.move(-vec3d.x, 0.0, -vec3d.z);
                    optional = this.level.findSupportingBlock(this, axisalignedbb2);
                    this.mainSupportingBlockPos = optional;
                }
            } else {
                this.mainSupportingBlockPos = optional;
            }
            this.onGroundNoBlocks = optional.isEmpty();
        } else {
            this.onGroundNoBlocks = false;
            if (this.mainSupportingBlockPos.isPresent()) {
                this.mainSupportingBlockPos = Optional.empty();
            }
        }
    }

    public boolean onGround() {
        return this.onGround;
    }

    public void move(EnumMoveType enummovetype, Vec3D vec3d) {
        SpigotTimings.entityMoveTimer.startTiming();
        if (this.noPhysics) {
            this.setPos(this.getX() + vec3d.x, this.getY() + vec3d.y, this.getZ() + vec3d.z);
        } else {
            Vec3D vec3d1;
            double d0;
            this.wasOnFire = this.isOnFire();
            if (enummovetype == EnumMoveType.PISTON && (vec3d = this.limitPistonMovement(vec3d)).equals(Vec3D.ZERO)) {
                return;
            }
            this.level().getProfiler().push("move");
            if (this.stuckSpeedMultiplier.lengthSqr() > 1.0E-7) {
                vec3d = vec3d.multiply(this.stuckSpeedMultiplier);
                this.stuckSpeedMultiplier = Vec3D.ZERO;
                this.setDeltaMovement(Vec3D.ZERO);
            }
            if ((d0 = (vec3d1 = this.collide(vec3d = this.maybeBackOffFromEdge(vec3d, enummovetype))).lengthSqr()) > 1.0E-7) {
                MovingObjectPositionBlock movingobjectpositionblock;
                if (this.fallDistance != 0.0f && d0 >= 1.0 && (movingobjectpositionblock = this.level().clip(new RayTrace(this.position(), this.position().add(vec3d1), RayTrace.BlockCollisionOption.FALLDAMAGE_RESETTING, RayTrace.FluidCollisionOption.WATER, this))).getType() != MovingObjectPosition.EnumMovingObjectType.MISS) {
                    this.resetFallDistance();
                }
                this.setPos(this.getX() + vec3d1.x, this.getY() + vec3d1.y, this.getZ() + vec3d1.z);
            }
            this.level().getProfiler().pop();
            this.level().getProfiler().push("rest");
            boolean flag = !MathHelper.equal(vec3d.x, vec3d1.x);
            boolean flag1 = !MathHelper.equal(vec3d.z, vec3d1.z);
            this.horizontalCollision = flag || flag1;
            this.verticalCollision = vec3d.y != vec3d1.y;
            this.verticalCollisionBelow = this.verticalCollision && vec3d.y < 0.0;
            this.minorHorizontalCollision = this.horizontalCollision ? this.isHorizontalCollisionMinor(vec3d1) : false;
            this.setOnGroundWithMovement(this.verticalCollisionBelow, vec3d1);
            BlockPosition blockposition = this.getOnPosLegacy();
            IBlockData iblockdata = this.level().getBlockState(blockposition);
            this.checkFallDamage(vec3d1.y, this.onGround(), iblockdata, blockposition);
            if (this.isRemoved()) {
                this.level().getProfiler().pop();
            } else {
                MovementEmission entity_movementemission;
                if (this.horizontalCollision) {
                    Vec3D vec3d2 = this.getDeltaMovement();
                    this.setDeltaMovement(flag ? 0.0 : vec3d2.x, vec3d2.y, flag1 ? 0.0 : vec3d2.z);
                }
                Block block = iblockdata.getBlock();
                if (vec3d.y != vec3d1.y) {
                    block.updateEntityAfterFallOn(this.level(), this);
                }
                if (this.horizontalCollision && this.getBukkitEntity() instanceof Vehicle) {
                    Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                    org.bukkit.block.Block bl = this.level.getWorld().getBlockAt(MathHelper.floor(this.getX()), MathHelper.floor(this.getY()), MathHelper.floor(this.getZ()));
                    if (vec3d.x > vec3d1.x) {
                        bl = bl.getRelative(BlockFace.EAST);
                    } else if (vec3d.x < vec3d1.x) {
                        bl = bl.getRelative(BlockFace.WEST);
                    } else if (vec3d.z > vec3d1.z) {
                        bl = bl.getRelative(BlockFace.SOUTH);
                    } else if (vec3d.z < vec3d1.z) {
                        bl = bl.getRelative(BlockFace.NORTH);
                    }
                    if (!bl.getType().isAir()) {
                        VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl);
                        this.level.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                }
                if (this.onGround()) {
                    block.stepOn(this.level(), blockposition, iblockdata, this);
                }
                if ((entity_movementemission = this.getMovementEmission()).emitsAnything() && !this.isPassenger()) {
                    double d1 = vec3d1.x;
                    double d2 = vec3d1.y;
                    double d3 = vec3d1.z;
                    this.flyDist += (float)(vec3d1.length() * 0.6);
                    BlockPosition blockposition1 = this.getOnPos();
                    IBlockData iblockdata1 = this.level().getBlockState(blockposition1);
                    boolean flag2 = this.isStateClimbable(iblockdata1);
                    if (!flag2) {
                        d2 = 0.0;
                    }
                    this.walkDist += (float)vec3d1.horizontalDistance() * 0.6f;
                    this.moveDist += (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3) * 0.6f;
                    if (this.moveDist > this.nextStep && !iblockdata1.isAir()) {
                        boolean flag3 = blockposition1.equals(blockposition);
                        boolean flag4 = this.vibrationAndSoundEffectsFromBlock(blockposition, iblockdata, entity_movementemission.emitsSounds(), flag3, vec3d);
                        if (!flag3) {
                            flag4 |= this.vibrationAndSoundEffectsFromBlock(blockposition1, iblockdata1, false, entity_movementemission.emitsEvents(), vec3d);
                        }
                        if (flag4) {
                            this.nextStep = this.nextStep();
                        } else if (this.isInWater()) {
                            this.nextStep = this.nextStep();
                            if (entity_movementemission.emitsSounds()) {
                                this.waterSwimSound();
                            }
                            if (entity_movementemission.emitsEvents()) {
                                this.gameEvent(GameEvent.SWIM);
                            }
                        }
                    } else if (iblockdata1.isAir()) {
                        this.processFlappingMovement();
                    }
                }
                this.tryCheckInsideBlocks();
                float f2 = this.getBlockSpeedFactor();
                this.setDeltaMovement(this.getDeltaMovement().multiply(f2, 1.0, f2));
                if (this.level().getBlockStatesIfLoaded(this.getBoundingBox().deflate(1.0E-6)).noneMatch(iblockdata2 -> iblockdata2.is(TagsBlock.FIRE) || iblockdata2.is(Blocks.LAVA))) {
                    if (this.remainingFireTicks <= 0) {
                        this.setRemainingFireTicks(-this.getFireImmuneTicks());
                    }
                    if (this.wasOnFire && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
                        this.playEntityOnFireExtinguishedSound();
                    }
                }
                if (this.isOnFire() && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
                    this.setRemainingFireTicks(-this.getFireImmuneTicks());
                }
                this.level().getProfiler().pop();
            }
        }
        SpigotTimings.entityMoveTimer.stopTiming();
    }

    private boolean isStateClimbable(IBlockData iblockdata) {
        return iblockdata.is(TagsBlock.CLIMBABLE) || iblockdata.is(Blocks.POWDER_SNOW);
    }

    private boolean vibrationAndSoundEffectsFromBlock(BlockPosition blockposition, IBlockData iblockdata, boolean flag, boolean flag1, Vec3D vec3d) {
        if (iblockdata.isAir()) {
            return false;
        }
        boolean flag2 = this.isStateClimbable(iblockdata);
        if ((this.onGround() || flag2 || this.isCrouching() && vec3d.y == 0.0 || this.isOnRails()) && !this.isSwimming()) {
            if (flag) {
                this.walkingStepSound(blockposition, iblockdata);
            }
            if (flag1) {
                this.level().gameEvent(GameEvent.STEP, this.position(), GameEvent.a.of(this, iblockdata));
            }
            return true;
        }
        return false;
    }

    protected boolean isHorizontalCollisionMinor(Vec3D vec3d) {
        return false;
    }

    protected void tryCheckInsideBlocks() {
        try {
            this.checkInsideBlocks();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Checking entity block collision");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Entity being checked for collision");
            this.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected void playEntityOnFireExtinguishedSound() {
        this.playSound(SoundEffects.GENERIC_EXTINGUISH_FIRE, 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    public void extinguishFire() {
        if (!this.level().isClientSide && this.wasOnFire) {
            this.playEntityOnFireExtinguishedSound();
        }
        this.clearFire();
    }

    protected void processFlappingMovement() {
        if (this.isFlapping()) {
            this.onFlap();
            if (this.getMovementEmission().emitsEvents()) {
                this.gameEvent(GameEvent.FLAP);
            }
        }
    }

    @Deprecated
    public BlockPosition getOnPosLegacy() {
        return this.getOnPos(0.2f);
    }

    public BlockPosition getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.500001f);
    }

    public BlockPosition getOnPos() {
        return this.getOnPos(1.0E-5f);
    }

    protected BlockPosition getOnPos(float f2) {
        if (this.mainSupportingBlockPos.isPresent()) {
            BlockPosition blockposition = this.mainSupportingBlockPos.get();
            if (f2 <= 1.0E-5f) {
                return blockposition;
            }
            IBlockData iblockdata = this.level().getBlockState(blockposition);
            return ((double)f2 > 0.5 || !iblockdata.is(TagsBlock.FENCES)) && !iblockdata.is(TagsBlock.WALLS) && !(iblockdata.getBlock() instanceof BlockFenceGate) ? blockposition.atY(MathHelper.floor(this.position.y - (double)f2)) : blockposition;
        }
        int i2 = MathHelper.floor(this.position.x);
        int j2 = MathHelper.floor(this.position.y - (double)f2);
        int k2 = MathHelper.floor(this.position.z);
        return new BlockPosition(i2, j2, k2);
    }

    protected float getBlockJumpFactor() {
        float f2 = this.level().getBlockState(this.blockPosition()).getBlock().getJumpFactor();
        float f1 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getJumpFactor();
        return (double)f2 == 1.0 ? f1 : f2;
    }

    protected float getBlockSpeedFactor() {
        IBlockData iblockdata = this.level().getBlockState(this.blockPosition());
        float f2 = iblockdata.getBlock().getSpeedFactor();
        return !iblockdata.is(Blocks.WATER) && !iblockdata.is(Blocks.BUBBLE_COLUMN) ? ((double)f2 == 1.0 ? this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getSpeedFactor() : f2) : f2;
    }

    protected Vec3D maybeBackOffFromEdge(Vec3D vec3d, EnumMoveType enummovetype) {
        return vec3d;
    }

    protected Vec3D limitPistonMovement(Vec3D vec3d) {
        if (vec3d.lengthSqr() <= 1.0E-7) {
            return vec3d;
        }
        long i2 = this.level().getGameTime();
        if (i2 != this.pistonDeltasGameTime) {
            Arrays.fill(this.pistonDeltas, 0.0);
            this.pistonDeltasGameTime = i2;
        }
        if (vec3d.x != 0.0) {
            double d0 = this.applyPistonMovementRestriction(EnumDirection.EnumAxis.X, vec3d.x);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.ZERO : new Vec3D(d0, 0.0, 0.0);
        }
        if (vec3d.y != 0.0) {
            double d0 = this.applyPistonMovementRestriction(EnumDirection.EnumAxis.Y, vec3d.y);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.ZERO : new Vec3D(0.0, d0, 0.0);
        }
        if (vec3d.z != 0.0) {
            double d0 = this.applyPistonMovementRestriction(EnumDirection.EnumAxis.Z, vec3d.z);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.ZERO : new Vec3D(0.0, 0.0, d0);
        }
        return Vec3D.ZERO;
    }

    private double applyPistonMovementRestriction(EnumDirection.EnumAxis enumdirection_enumaxis, double d0) {
        int i2 = enumdirection_enumaxis.ordinal();
        double d1 = MathHelper.clamp(d0 + this.pistonDeltas[i2], -0.51, 0.51);
        d0 = d1 - this.pistonDeltas[i2];
        this.pistonDeltas[i2] = d1;
        return d0;
    }

    private Vec3D collide(Vec3D vec3d) {
        boolean flag3;
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        List<VoxelShape> list = this.level().getEntityCollisions(this, axisalignedbb.expandTowards(vec3d));
        Vec3D vec3d1 = vec3d.lengthSqr() == 0.0 ? vec3d : Entity.collideBoundingBox(this, vec3d, axisalignedbb, this.level(), list);
        boolean flag = vec3d.x != vec3d1.x;
        boolean flag1 = vec3d.y != vec3d1.y;
        boolean flag2 = vec3d.z != vec3d1.z;
        boolean bl = flag3 = flag1 && vec3d.y < 0.0;
        if (this.maxUpStep() > 0.0f && (flag3 || this.onGround()) && (flag || flag2)) {
            float[] afloat;
            AxisAlignedBB axisalignedbb1 = flag3 ? axisalignedbb.move(0.0, vec3d1.y, 0.0) : axisalignedbb;
            AxisAlignedBB axisalignedbb2 = axisalignedbb1.expandTowards(vec3d.x, this.maxUpStep(), vec3d.z);
            if (!flag3) {
                axisalignedbb2 = axisalignedbb2.expandTowards(0.0, -1.0E-5f, 0.0);
            }
            List<VoxelShape> list1 = Entity.collectColliders(this, this.level, list, axisalignedbb2);
            float f2 = (float)vec3d1.y;
            float[] afloat1 = afloat = Entity.collectCandidateStepUpHeights(axisalignedbb1, list1, this.maxUpStep(), f2);
            int i2 = afloat.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                float f1 = afloat1[j2];
                Vec3D vec3d2 = Entity.collideWithShapes(new Vec3D(vec3d.x, f1, vec3d.z), axisalignedbb1, list1);
                if (!(vec3d2.horizontalDistanceSqr() > vec3d1.horizontalDistanceSqr())) continue;
                double d0 = axisalignedbb.minY - axisalignedbb1.minY;
                return vec3d2.add(0.0, -d0, 0.0);
            }
        }
        return vec3d1;
    }

    private static float[] collectCandidateStepUpHeights(AxisAlignedBB axisalignedbb, List<VoxelShape> list, float f2, float f1) {
        FloatArraySet floatarrayset = new FloatArraySet(4);
        block0: for (VoxelShape voxelshape : list) {
            DoubleList doublelist = voxelshape.getCoords(EnumDirection.EnumAxis.Y);
            DoubleListIterator doublelistiterator = doublelist.iterator();
            while (doublelistiterator.hasNext()) {
                double d0 = doublelistiterator.next();
                float f22 = (float)(d0 - axisalignedbb.minY);
                if (!(f22 >= 0.0f) || f22 == f1) continue;
                if (f22 > f2) continue block0;
                floatarrayset.add(f22);
            }
        }
        float[] afloat = floatarrayset.toFloatArray();
        FloatArrays.unstableSort((float[])afloat);
        return afloat;
    }

    public static Vec3D collideBoundingBox(@Nullable Entity entity, Vec3D vec3d, AxisAlignedBB axisalignedbb, net.minecraft.world.level.World world, List<VoxelShape> list) {
        List<VoxelShape> list1 = Entity.collectColliders(entity, world, list, axisalignedbb.expandTowards(vec3d));
        return Entity.collideWithShapes(vec3d, axisalignedbb, list1);
    }

    private static List<VoxelShape> collectColliders(@Nullable Entity entity, net.minecraft.world.level.World world, List<VoxelShape> list, AxisAlignedBB axisalignedbb) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(list.size() + 1));
        if (!list.isEmpty()) {
            builder.addAll(list);
        }
        WorldBorder worldborder = world.getWorldBorder();
        boolean bl = flag = entity != null && worldborder.isInsideCloseToBorder(entity, axisalignedbb);
        if (flag) {
            builder.add((Object)worldborder.getCollisionShape());
        }
        builder.addAll(world.getBlockCollisions(entity, axisalignedbb));
        return builder.build();
    }

    private static Vec3D collideWithShapes(Vec3D vec3d, AxisAlignedBB axisalignedbb, List<VoxelShape> list) {
        boolean flag;
        if (list.isEmpty()) {
            return vec3d;
        }
        double d0 = vec3d.x;
        double d1 = vec3d.y;
        double d2 = vec3d.z;
        if (d1 != 0.0 && (d1 = VoxelShapes.collide(EnumDirection.EnumAxis.Y, axisalignedbb, list, d1)) != 0.0) {
            axisalignedbb = axisalignedbb.move(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.collide(EnumDirection.EnumAxis.Z, axisalignedbb, list, d2)) != 0.0) {
            axisalignedbb = axisalignedbb.move(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.collide(EnumDirection.EnumAxis.X, axisalignedbb, list, d0);
            if (!flag && d0 != 0.0) {
                axisalignedbb = axisalignedbb.move(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.collide(EnumDirection.EnumAxis.Z, axisalignedbb, list, d2);
        }
        return new Vec3D(d0, d1, d2);
    }

    protected float nextStep() {
        return (int)this.moveDist + 1;
    }

    protected SoundEffect getSwimSound() {
        return SoundEffects.GENERIC_SWIM;
    }

    protected SoundEffect getSwimSplashSound() {
        return SoundEffects.GENERIC_SPLASH;
    }

    protected SoundEffect getSwimHighSpeedSplashSound() {
        return SoundEffects.GENERIC_SPLASH;
    }

    public SoundEffect getSwimSound0() {
        return this.getSwimSound();
    }

    public SoundEffect getSwimSplashSound0() {
        return this.getSwimSplashSound();
    }

    public SoundEffect getSwimHighSpeedSplashSound0() {
        return this.getSwimHighSpeedSplashSound();
    }

    protected void checkInsideBlocks() {
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        BlockPosition blockposition = BlockPosition.containing(axisalignedbb.minX + 1.0E-7, axisalignedbb.minY + 1.0E-7, axisalignedbb.minZ + 1.0E-7);
        BlockPosition blockposition1 = BlockPosition.containing(axisalignedbb.maxX - 1.0E-7, axisalignedbb.maxY - 1.0E-7, axisalignedbb.maxZ - 1.0E-7);
        if (this.level().hasChunksAt(blockposition, blockposition1)) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int i2 = blockposition.getX(); i2 <= blockposition1.getX(); ++i2) {
                for (int j2 = blockposition.getY(); j2 <= blockposition1.getY(); ++j2) {
                    for (int k2 = blockposition.getZ(); k2 <= blockposition1.getZ(); ++k2) {
                        if (!this.isAlive()) {
                            return;
                        }
                        blockposition_mutableblockposition.set(i2, j2, k2);
                        IBlockData iblockdata = this.level().getBlockState(blockposition_mutableblockposition);
                        try {
                            iblockdata.entityInside(this.level(), blockposition_mutableblockposition, this);
                            this.onInsideBlock(iblockdata);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.forThrowable(throwable, "Colliding entity with block");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Block being collided with");
                            CrashReportSystemDetails.populateBlockDetails(crashreportsystemdetails, this.level(), blockposition_mutableblockposition, iblockdata);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected void onInsideBlock(IBlockData iblockdata) {
    }

    public BlockPosition adjustSpawnLocation(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition blockposition1 = worldserver.getSharedSpawnPos();
        Vec3D vec3d = blockposition1.getCenter();
        int i2 = worldserver.getChunkAt(blockposition1).getHeight(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, blockposition1.getX(), blockposition1.getZ()) + 1;
        return BlockPosition.containing(vec3d.x, i2, vec3d.z);
    }

    public void gameEvent(Holder<GameEvent> holder, @Nullable Entity entity) {
        this.level().gameEvent(entity, holder, this.position);
    }

    public void gameEvent(Holder<GameEvent> holder) {
        this.gameEvent(holder, this);
    }

    private void walkingStepSound(BlockPosition blockposition, IBlockData iblockdata) {
        this.playStepSound(blockposition, iblockdata);
        if (this.shouldPlayAmethystStepSound(iblockdata)) {
            this.playAmethystStepSound();
        }
    }

    protected void waterSwimSound() {
        Entity entity = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float f2 = entity == this ? 0.35f : 0.4f;
        Vec3D vec3d = entity.getDeltaMovement();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.x * vec3d.x * (double)0.2f + vec3d.y * vec3d.y + vec3d.z * vec3d.z * (double)0.2f) * f2);
        this.playSwimSound(f1);
    }

    protected BlockPosition getPrimaryStepSoundBlockPos(BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.above();
        IBlockData iblockdata = this.level().getBlockState(blockposition1);
        return !iblockdata.is(TagsBlock.INSIDE_STEP_SOUND_BLOCKS) && !iblockdata.is(TagsBlock.COMBINATION_STEP_SOUND_BLOCKS) ? blockposition : blockposition1;
    }

    protected void playCombinationStepSounds(IBlockData iblockdata, IBlockData iblockdata1) {
        SoundEffectType soundeffecttype = iblockdata.getSoundType();
        this.playSound(soundeffecttype.getStepSound(), soundeffecttype.getVolume() * 0.15f, soundeffecttype.getPitch());
        this.playMuffledStepSound(iblockdata1);
    }

    protected void playMuffledStepSound(IBlockData iblockdata) {
        SoundEffectType soundeffecttype = iblockdata.getSoundType();
        this.playSound(soundeffecttype.getStepSound(), soundeffecttype.getVolume() * 0.05f, soundeffecttype.getPitch() * 0.8f);
    }

    protected void playStepSound(BlockPosition blockposition, IBlockData iblockdata) {
        SoundEffectType soundeffecttype = iblockdata.getSoundType();
        this.playSound(soundeffecttype.getStepSound(), soundeffecttype.getVolume() * 0.15f, soundeffecttype.getPitch());
    }

    private boolean shouldPlayAmethystStepSound(IBlockData iblockdata) {
        return iblockdata.is(TagsBlock.CRYSTAL_SOUND_BLOCKS) && this.tickCount >= this.lastCrystalSoundPlayTick + 20;
    }

    private void playAmethystStepSound() {
        this.crystalSoundIntensity *= (float)Math.pow(0.997, this.tickCount - this.lastCrystalSoundPlayTick);
        this.crystalSoundIntensity = Math.min(1.0f, this.crystalSoundIntensity + 0.07f);
        float f2 = 0.5f + this.crystalSoundIntensity * this.random.nextFloat() * 1.2f;
        float f1 = 0.1f + this.crystalSoundIntensity * 1.2f;
        this.playSound(SoundEffects.AMETHYST_BLOCK_CHIME, f1, f2);
        this.lastCrystalSoundPlayTick = this.tickCount;
    }

    protected void playSwimSound(float f2) {
        this.playSound(this.getSwimSound(), f2, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    protected void onFlap() {
    }

    protected boolean isFlapping() {
        return false;
    }

    public void playSound(SoundEffect soundeffect, float f2, float f1) {
        if (!this.isSilent()) {
            this.level().playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), soundeffect, this.getSoundSource(), f2, f1);
        }
    }

    public void playSound(SoundEffect soundeffect) {
        if (!this.isSilent()) {
            this.playSound(soundeffect, 1.0f, 1.0f);
        }
    }

    public boolean isSilent() {
        return this.entityData.get(DATA_SILENT);
    }

    public void setSilent(boolean flag) {
        this.entityData.set(DATA_SILENT, flag);
    }

    public boolean isNoGravity() {
        return this.entityData.get(DATA_NO_GRAVITY);
    }

    public void setNoGravity(boolean flag) {
        this.entityData.set(DATA_NO_GRAVITY, flag);
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public final double getGravity() {
        return this.isNoGravity() ? 0.0 : this.getDefaultGravity();
    }

    protected void applyGravity() {
        double d0 = this.getGravity();
        if (d0 != 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -d0, 0.0));
        }
    }

    protected MovementEmission getMovementEmission() {
        return MovementEmission.ALL;
    }

    public boolean dampensVibrations() {
        return false;
    }

    protected void checkFallDamage(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (flag) {
            if (this.fallDistance > 0.0f) {
                iblockdata.getBlock().fallOn(this.level(), iblockdata, blockposition, this, this.fallDistance);
                this.level().gameEvent(GameEvent.HIT_GROUND, this.position, GameEvent.a.of(this, this.mainSupportingBlockPos.map(blockposition1 -> this.level().getBlockState((BlockPosition)blockposition1)).orElse(iblockdata)));
            }
            this.resetFallDistance();
        } else if (d0 < 0.0) {
            this.fallDistance -= (float)d0;
        }
    }

    public boolean fireImmune() {
        return this.getType().fireImmune();
    }

    public boolean causeFallDamage(float f2, float f1, DamageSource damagesource) {
        if (this.type.is(TagsEntity.FALL_DAMAGE_IMMUNE)) {
            return false;
        }
        if (this.isVehicle()) {
            for (Entity entity : this.getPassengers()) {
                entity.causeFallDamage(f2, f1, damagesource);
            }
        }
        return false;
    }

    public boolean isInWater() {
        return this.wasTouchingWater;
    }

    private boolean isInRain() {
        BlockPosition blockposition = this.blockPosition();
        return this.level().isRainingAt(blockposition) || this.level().isRainingAt(BlockPosition.containing(blockposition.getX(), this.getBoundingBox().maxY, blockposition.getZ()));
    }

    private boolean isInBubbleColumn() {
        return this.getInBlockState().is(Blocks.BUBBLE_COLUMN);
    }

    public boolean isInWaterOrRain() {
        return this.isInWater() || this.isInRain();
    }

    public boolean isInWaterRainOrBubble() {
        return this.isInWater() || this.isInRain() || this.isInBubbleColumn();
    }

    public boolean isInWaterOrBubble() {
        return this.isInWater() || this.isInBubbleColumn();
    }

    public boolean isInLiquid() {
        return this.isInWaterOrBubble() || this.isInLava();
    }

    public boolean isUnderWater() {
        return this.wasEyeInWater && this.isInWater();
    }

    public void updateSwimming() {
        if (this.isSwimming()) {
            this.setSwimming(this.isSprinting() && this.isInWater() && !this.isPassenger());
        } else {
            this.setSwimming(this.isSprinting() && this.isUnderWater() && !this.isPassenger() && this.level().getFluidState(this.blockPosition).is(TagsFluid.WATER));
        }
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        this.fluidHeight.clear();
        this.updateInWaterStateAndDoWaterCurrentPushing();
        double d0 = this.level().dimensionType().ultraWarm() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.updateFluidHeightAndDoFluidPushing(TagsFluid.LAVA, d0);
        return this.isInWater() || flag;
    }

    void updateInWaterStateAndDoWaterCurrentPushing() {
        EntityBoat entityboat;
        Entity entity = this.getVehicle();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).isUnderWater()) {
            this.wasTouchingWater = false;
            return;
        }
        if (this.updateFluidHeightAndDoFluidPushing(TagsFluid.WATER, 0.014)) {
            if (!this.wasTouchingWater && !this.firstTick) {
                this.doWaterSplashEffect();
            }
            this.resetFallDistance();
            this.wasTouchingWater = true;
            this.clearFire();
        } else {
            this.wasTouchingWater = false;
        }
    }

    private void updateFluidOnEyes() {
        EntityBoat entityboat;
        this.wasEyeInWater = this.isEyeInFluid(TagsFluid.WATER);
        this.fluidOnEyes.clear();
        double d0 = this.getEyeY();
        Entity entity = this.getVehicle();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).isUnderWater() && entityboat.getBoundingBox().maxY >= d0 && entityboat.getBoundingBox().minY <= d0) {
            return;
        }
        BlockPosition blockposition = BlockPosition.containing(this.getX(), d0, this.getZ());
        Fluid fluid = this.level().getFluidState(blockposition);
        double d1 = (float)blockposition.getY() + fluid.getHeight(this.level(), blockposition);
        if (d1 > d0) {
            Stream<TagKey<FluidType>> stream = fluid.getTags();
            Set<TagKey<FluidType>> set = this.fluidOnEyes;
            Objects.requireNonNull(this.fluidOnEyes);
            stream.forEach(set::add);
        }
    }

    protected void doWaterSplashEffect() {
        double d1;
        double d0;
        Entity entity = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float f2 = entity == this ? 0.2f : 0.9f;
        Vec3D vec3d = entity.getDeltaMovement();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.x * vec3d.x * (double)0.2f + vec3d.y * vec3d.y + vec3d.z * vec3d.z * (double)0.2f) * f2);
        if (f1 < 0.25f) {
            this.playSound(this.getSwimSplashSound(), f1, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        } else {
            this.playSound(this.getSwimHighSpeedSplashSound(), f1, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
        float f22 = MathHelper.floor(this.getY());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.dimensions.width() * 20.0f) {
            d0 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            d1 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(Particles.BUBBLE, this.getX() + d0, f22 + 1.0f, this.getZ() + d1, vec3d.x, vec3d.y - this.random.nextDouble() * (double)0.2f, vec3d.z);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < 1.0f + this.dimensions.width() * 20.0f) {
            d0 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            d1 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(Particles.SPLASH, this.getX() + d0, f22 + 1.0f, this.getZ() + d1, vec3d.x, vec3d.y, vec3d.z);
            ++i2;
        }
        this.gameEvent(GameEvent.SPLASH);
    }

    @Deprecated
    protected IBlockData getBlockStateOnLegacy() {
        return this.level().getBlockState(this.getOnPosLegacy());
    }

    public IBlockData getBlockStateOn() {
        return this.level().getBlockState(this.getOnPos());
    }

    public boolean canSpawnSprintParticle() {
        return this.isSprinting() && !this.isInWater() && !this.isSpectator() && !this.isCrouching() && !this.isInLava() && this.isAlive();
    }

    protected void spawnSprintParticle() {
        BlockPosition blockposition = this.getOnPosLegacy();
        IBlockData iblockdata = this.level().getBlockState(blockposition);
        if (iblockdata.getRenderShape() != EnumRenderType.INVISIBLE) {
            Vec3D vec3d = this.getDeltaMovement();
            BlockPosition blockposition1 = this.blockPosition();
            double d0 = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            double d1 = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            if (blockposition1.getX() != blockposition.getX()) {
                d0 = MathHelper.clamp(d0, (double)blockposition.getX(), (double)blockposition.getX() + 1.0);
            }
            if (blockposition1.getZ() != blockposition.getZ()) {
                d1 = MathHelper.clamp(d1, (double)blockposition.getZ(), (double)blockposition.getZ() + 1.0);
            }
            this.level().addParticle(new ParticleParamBlock(Particles.BLOCK, iblockdata), d0, this.getY() + 0.1, d1, vec3d.x * -4.0, 1.5, vec3d.z * -4.0);
        }
    }

    public boolean isEyeInFluid(TagKey<FluidType> tagkey) {
        return this.fluidOnEyes.contains(tagkey);
    }

    public boolean isInLava() {
        return !this.firstTick && this.fluidHeight.getDouble(TagsFluid.LAVA) > 0.0;
    }

    public void moveRelative(float f2, Vec3D vec3d) {
        Vec3D vec3d1 = Entity.getInputVector(vec3d, f2, this.getYRot());
        this.setDeltaMovement(this.getDeltaMovement().add(vec3d1));
    }

    private static Vec3D getInputVector(Vec3D vec3d, float f2, float f1) {
        double d0 = vec3d.lengthSqr();
        if (d0 < 1.0E-7) {
            return Vec3D.ZERO;
        }
        Vec3D vec3d1 = (d0 > 1.0 ? vec3d.normalize() : vec3d).scale(f2);
        float f22 = MathHelper.sin(f1 * ((float)Math.PI / 180));
        float f3 = MathHelper.cos(f1 * ((float)Math.PI / 180));
        return new Vec3D(vec3d1.x * (double)f3 - vec3d1.z * (double)f22, vec3d1.y, vec3d1.z * (double)f3 + vec3d1.x * (double)f22);
    }

    @Deprecated
    public float getLightLevelDependentMagicValue() {
        return this.level().hasChunkAt(this.getBlockX(), this.getBlockZ()) ? this.level().getLightLevelDependentMagicValue(BlockPosition.containing(this.getX(), this.getEyeY(), this.getZ())) : 0.0f;
    }

    public void absMoveTo(double d0, double d1, double d2, float f2, float f1) {
        this.absMoveTo(d0, d1, d2);
        this.absRotateTo(f2, f1);
    }

    public void absRotateTo(float f2, float f1) {
        this.setYRot(f2 % 360.0f);
        this.setXRot(MathHelper.clamp(f1, -90.0f, 90.0f) % 360.0f);
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void absMoveTo(double d0, double d1, double d2) {
        double d3 = MathHelper.clamp(d0, -3.0E7, 3.0E7);
        double d4 = MathHelper.clamp(d2, -3.0E7, 3.0E7);
        this.xo = d3;
        this.yo = d1;
        this.zo = d4;
        this.setPos(d3, d1, d4);
        if (this.valid) {
            this.level.getChunk((int)Math.floor(this.getX()) >> 4, (int)Math.floor(this.getZ()) >> 4);
        }
    }

    public void moveTo(Vec3D vec3d) {
        this.moveTo(vec3d.x, vec3d.y, vec3d.z);
    }

    public void moveTo(double d0, double d1, double d2) {
        this.moveTo(d0, d1, d2, this.getYRot(), this.getXRot());
    }

    public void moveTo(BlockPosition blockposition, float f2, float f1) {
        this.moveTo(blockposition.getBottomCenter(), f2, f1);
    }

    public void moveTo(Vec3D vec3d, float f2, float f1) {
        this.moveTo(vec3d.x, vec3d.y, vec3d.z, f2, f1);
    }

    public void moveTo(double d0, double d1, double d2, float f2, float f1) {
        this.setPosRaw(d0, d1, d2);
        this.setYRot(f2);
        this.setXRot(f1);
        this.setOldPosAndRot();
        this.reapplyPosition();
    }

    public final void setOldPosAndRot() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        this.xo = d0;
        this.yo = d1;
        this.zo = d2;
        this.xOld = d0;
        this.yOld = d1;
        this.zOld = d2;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public float distanceTo(Entity entity) {
        float f2 = (float)(this.getX() - entity.getX());
        float f1 = (float)(this.getY() - entity.getY());
        float f22 = (float)(this.getZ() - entity.getZ());
        return MathHelper.sqrt(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double distanceToSqr(double d0, double d1, double d2) {
        double d3 = this.getX() - d0;
        double d4 = this.getY() - d1;
        double d5 = this.getZ() - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double distanceToSqr(Entity entity) {
        return this.distanceToSqr(entity.position());
    }

    public double distanceToSqr(Vec3D vec3d) {
        double d0 = this.getX() - vec3d.x;
        double d1 = this.getY() - vec3d.y;
        double d2 = this.getZ() - vec3d.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void playerTouch(EntityHuman entityhuman) {
    }

    public void push(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!this.isPassengerOfSameVehicle(entity) && !entity.noPhysics && !this.noPhysics && (d2 = MathHelper.absMax(d0 = entity.getX() - this.getX(), d1 = entity.getZ() - this.getZ())) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.isVehicle() && this.isPushable()) {
                this.push(-d0, 0.0, -d1);
            }
            if (!entity.isVehicle() && entity.isPushable()) {
                entity.push(d0, 0.0, d1);
            }
        }
    }

    public void push(Vec3D vec3d) {
        this.push(vec3d.x, vec3d.y, vec3d.z);
    }

    public void push(double d0, double d1, double d2) {
        this.setDeltaMovement(this.getDeltaMovement().add(d0, d1, d2));
        this.hasImpulse = true;
    }

    protected void markHurt() {
        this.hurtMarked = true;
    }

    public boolean hurt(DamageSource damagesource, float f2) {
        if (this.isInvulnerableTo(damagesource)) {
            return false;
        }
        this.markHurt();
        return false;
    }

    public final Vec3D getViewVector(float f2) {
        return this.calculateViewVector(this.getViewXRot(f2), this.getViewYRot(f2));
    }

    public EnumDirection getNearestViewDirection() {
        return EnumDirection.getNearest(this.getViewVector(1.0f));
    }

    public float getViewXRot(float f2) {
        return f2 == 1.0f ? this.getXRot() : MathHelper.lerp(f2, this.xRotO, this.getXRot());
    }

    public float getViewYRot(float f2) {
        return f2 == 1.0f ? this.getYRot() : MathHelper.lerp(f2, this.yRotO, this.getYRot());
    }

    public final Vec3D calculateViewVector(float f2, float f1) {
        float f22 = f2 * ((float)Math.PI / 180);
        float f3 = -f1 * ((float)Math.PI / 180);
        float f4 = MathHelper.cos(f3);
        float f5 = MathHelper.sin(f3);
        float f6 = MathHelper.cos(f22);
        float f7 = MathHelper.sin(f22);
        return new Vec3D(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3D getUpVector(float f2) {
        return this.calculateUpVector(this.getViewXRot(f2), this.getViewYRot(f2));
    }

    protected final Vec3D calculateUpVector(float f2, float f1) {
        return this.calculateViewVector(f2 - 90.0f, f1);
    }

    public final Vec3D getEyePosition() {
        return new Vec3D(this.getX(), this.getEyeY(), this.getZ());
    }

    public final Vec3D getEyePosition(float f2) {
        double d0 = MathHelper.lerp((double)f2, this.xo, this.getX());
        double d1 = MathHelper.lerp((double)f2, this.yo, this.getY()) + (double)this.getEyeHeight();
        double d2 = MathHelper.lerp((double)f2, this.zo, this.getZ());
        return new Vec3D(d0, d1, d2);
    }

    public Vec3D getLightProbePosition(float f2) {
        return this.getEyePosition(f2);
    }

    public final Vec3D getPosition(float f2) {
        double d0 = MathHelper.lerp((double)f2, this.xo, this.getX());
        double d1 = MathHelper.lerp((double)f2, this.yo, this.getY());
        double d2 = MathHelper.lerp((double)f2, this.zo, this.getZ());
        return new Vec3D(d0, d1, d2);
    }

    public MovingObjectPosition pick(double d0, float f2, boolean flag) {
        Vec3D vec3d = this.getEyePosition(f2);
        Vec3D vec3d1 = this.getViewVector(f2);
        Vec3D vec3d2 = vec3d.add(vec3d1.x * d0, vec3d1.y * d0, vec3d1.z * d0);
        return this.level().clip(new RayTrace(vec3d, vec3d2, RayTrace.BlockCollisionOption.OUTLINE, flag ? RayTrace.FluidCollisionOption.ANY : RayTrace.FluidCollisionOption.NONE, this));
    }

    public boolean canBeHitByProjectile() {
        return this.isAlive() && this.isPickable();
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.isPushable();
    }

    public void awardKillScore(Entity entity, int i2, DamageSource damagesource) {
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.ENTITY_KILLED_PLAYER.trigger((EntityPlayer)entity, this, damagesource);
        }
    }

    public boolean shouldRender(double d0, double d1, double d2) {
        double d3 = this.getX() - d0;
        double d4 = this.getY() - d1;
        double d5 = this.getZ() - d2;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.shouldRenderAtSqrDistance(d6);
    }

    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = this.getBoundingBox().getSize();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return d0 < (d1 *= 64.0 * viewScale) * d1;
    }

    public boolean saveAsPassenger(NBTTagCompound nbttagcompound) {
        return this.saveAsPassenger(nbttagcompound, true);
    }

    public boolean saveAsPassenger(NBTTagCompound nbttagcompound, boolean includeAll) {
        if (this.removalReason != null && !this.removalReason.shouldSave()) {
            return false;
        }
        String s2 = this.getEncodeId();
        if (!this.persist || s2 == null) {
            return false;
        }
        nbttagcompound.putString(ID_TAG, s2);
        this.saveWithoutId(nbttagcompound, includeAll);
        return true;
    }

    public boolean save(NBTTagCompound nbttagcompound) {
        return this.isPassenger() ? false : this.saveAsPassenger(nbttagcompound);
    }

    public NBTTagCompound saveWithoutId(NBTTagCompound nbttagcompound) {
        return this.saveWithoutId(nbttagcompound, true);
    }

    public NBTTagCompound saveWithoutId(NBTTagCompound nbttagcompound, boolean includeAll) {
        try {
            NBTTagList nbttaglist;
            int i2;
            if (includeAll) {
                if (this.vehicle != null) {
                    nbttagcompound.put("Pos", this.newDoubleList(this.vehicle.getX(), this.getY(), this.vehicle.getZ()));
                } else {
                    nbttagcompound.put("Pos", this.newDoubleList(this.getX(), this.getY(), this.getZ()));
                }
            }
            Vec3D vec3d = this.getDeltaMovement();
            nbttagcompound.put("Motion", this.newDoubleList(vec3d.x, vec3d.y, vec3d.z));
            if (Float.isNaN(this.yRot)) {
                this.yRot = 0.0f;
            }
            if (Float.isNaN(this.xRot)) {
                this.xRot = 0.0f;
            }
            nbttagcompound.put("Rotation", this.newFloatList(this.getYRot(), this.getXRot()));
            nbttagcompound.putFloat("FallDistance", this.fallDistance);
            nbttagcompound.putShort("Fire", (short)this.remainingFireTicks);
            nbttagcompound.putShort("Air", (short)this.getAirSupply());
            nbttagcompound.putBoolean("OnGround", this.onGround());
            nbttagcompound.putBoolean("Invulnerable", this.invulnerable);
            nbttagcompound.putInt("PortalCooldown", this.portalCooldown);
            if (includeAll) {
                nbttagcompound.putUUID(UUID_TAG, this.getUUID());
                nbttagcompound.putLong("WorldUUIDLeast", ((WorldServer)this.level).getWorld().getUID().getLeastSignificantBits());
                nbttagcompound.putLong("WorldUUIDMost", ((WorldServer)this.level).getWorld().getUID().getMostSignificantBits());
            }
            nbttagcompound.putInt("Bukkit.updateLevel", 2);
            if (!this.persist) {
                nbttagcompound.putBoolean("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                nbttagcompound.putBoolean("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                nbttagcompound.putBoolean("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                nbttagcompound.putInt("Bukkit.MaxAirSupply", this.getMaxAirSupply());
            }
            nbttagcompound.putInt("Spigot.ticksLived", this.tickCount);
            IChatBaseComponent ichatbasecomponent = this.getCustomName();
            if (ichatbasecomponent != null) {
                nbttagcompound.putString("CustomName", IChatBaseComponent.ChatSerializer.toJson(ichatbasecomponent, this.registryAccess()));
            }
            if (this.isCustomNameVisible()) {
                nbttagcompound.putBoolean("CustomNameVisible", this.isCustomNameVisible());
            }
            if (this.isSilent()) {
                nbttagcompound.putBoolean("Silent", this.isSilent());
            }
            if (this.isNoGravity()) {
                nbttagcompound.putBoolean("NoGravity", this.isNoGravity());
            }
            if (this.hasGlowingTag) {
                nbttagcompound.putBoolean("Glowing", true);
            }
            if ((i2 = this.getTicksFrozen()) > 0) {
                nbttagcompound.putInt("TicksFrozen", this.getTicksFrozen());
            }
            if (this.hasVisualFire) {
                nbttagcompound.putBoolean("HasVisualFire", this.hasVisualFire);
            }
            if (!this.tags.isEmpty()) {
                nbttaglist = new NBTTagList();
                for (String s2 : this.tags) {
                    nbttaglist.add(NBTTagString.valueOf(s2));
                }
                nbttagcompound.put("Tags", nbttaglist);
            }
            this.addAdditionalSaveData(nbttagcompound, includeAll);
            if (this.isVehicle()) {
                nbttaglist = new NBTTagList();
                for (Entity entity : this.getPassengers()) {
                    NBTTagCompound nbttagcompound1;
                    if (!entity.saveAsPassenger(nbttagcompound1 = new NBTTagCompound(), includeAll)) continue;
                    nbttaglist.add(nbttagcompound1);
                }
                if (!nbttaglist.isEmpty()) {
                    nbttagcompound.put(PASSENGERS_TAG, nbttaglist);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(nbttagcompound);
            }
            return nbttagcompound;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Saving entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Entity being saved");
            this.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(NBTTagCompound nbttagcompound) {
        try {
            NBTTagList nbttaglist = nbttagcompound.getList("Pos", 6);
            NBTTagList nbttaglist1 = nbttagcompound.getList("Motion", 6);
            NBTTagList nbttaglist2 = nbttagcompound.getList("Rotation", 5);
            double d0 = nbttaglist1.getDouble(0);
            double d1 = nbttaglist1.getDouble(1);
            double d2 = nbttaglist1.getDouble(2);
            this.setDeltaMovement(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
            double d3 = 3.0000512E7;
            this.setPosRaw(MathHelper.clamp(nbttaglist.getDouble(0), -3.0000512E7, 3.0000512E7), MathHelper.clamp(nbttaglist.getDouble(1), -2.0E7, 2.0E7), MathHelper.clamp(nbttaglist.getDouble(2), -3.0000512E7, 3.0000512E7));
            this.setYRot(nbttaglist2.getFloat(0));
            this.setXRot(nbttaglist2.getFloat(1));
            this.setOldPosAndRot();
            this.setYHeadRot(this.getYRot());
            this.setYBodyRot(this.getYRot());
            this.fallDistance = nbttagcompound.getFloat("FallDistance");
            this.remainingFireTicks = nbttagcompound.getShort("Fire");
            if (nbttagcompound.contains("Air")) {
                this.setAirSupply(nbttagcompound.getShort("Air"));
            }
            this.onGround = nbttagcompound.getBoolean("OnGround");
            this.invulnerable = nbttagcompound.getBoolean("Invulnerable");
            this.portalCooldown = nbttagcompound.getInt("PortalCooldown");
            if (nbttagcompound.hasUUID(UUID_TAG)) {
                this.uuid = nbttagcompound.getUUID(UUID_TAG);
                this.stringUUID = this.uuid.toString();
            }
            if (!Double.isFinite(this.getX()) || !Double.isFinite(this.getY()) || !Double.isFinite(this.getZ())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.getYRot()) || !Double.isFinite(this.getXRot())) throw new IllegalStateException("Entity has invalid rotation");
            this.reapplyPosition();
            this.setRot(this.getYRot(), this.getXRot());
            if (nbttagcompound.contains("CustomName", 8)) {
                String s2 = nbttagcompound.getString("CustomName");
                try {
                    this.setCustomName(IChatBaseComponent.ChatSerializer.fromJson(s2, (HolderLookup.a)this.registryAccess()));
                }
                catch (Exception exception) {
                    LOGGER.warn("Failed to parse entity custom name {}", (Object)s2, (Object)exception);
                }
            }
            this.setCustomNameVisible(nbttagcompound.getBoolean("CustomNameVisible"));
            this.setSilent(nbttagcompound.getBoolean("Silent"));
            this.setNoGravity(nbttagcompound.getBoolean("NoGravity"));
            this.setGlowingTag(nbttagcompound.getBoolean("Glowing"));
            this.setTicksFrozen(nbttagcompound.getInt("TicksFrozen"));
            this.hasVisualFire = nbttagcompound.getBoolean("HasVisualFire");
            if (nbttagcompound.contains("Tags", 9)) {
                this.tags.clear();
                NBTTagList nbttaglist3 = nbttagcompound.getList("Tags", 8);
                int i2 = Math.min(nbttaglist3.size(), 1024);
                for (int j2 = 0; j2 < i2; ++j2) {
                    this.tags.add(nbttaglist3.getString(j2));
                }
            }
            this.readAdditionalSaveData(nbttagcompound);
            if (this.repositionEntityAfterLoad()) {
                this.reapplyPosition();
            }
            if (this instanceof EntityLiving) {
                this.tickCount = nbttagcompound.getInt("Spigot.ticksLived");
            }
            this.persist = !nbttagcompound.contains("Bukkit.persist") || nbttagcompound.getBoolean("Bukkit.persist");
            boolean bl = this.visibleByDefault = !nbttagcompound.contains("Bukkit.visibleByDefault") || nbttagcompound.getBoolean("Bukkit.visibleByDefault");
            if (nbttagcompound.contains("Bukkit.MaxAirSupply")) {
                this.maxAirTicks = nbttagcompound.getInt("Bukkit.MaxAirSupply");
            }
            if (this instanceof EntityPlayer) {
                Server server = Bukkit.getServer();
                World bworld = null;
                String worldName = nbttagcompound.getString("world");
                if (nbttagcompound.contains("WorldUUIDMost") && nbttagcompound.contains("WorldUUIDLeast")) {
                    UUID uid = new UUID(nbttagcompound.getLong("WorldUUIDMost"), nbttagcompound.getLong("WorldUUIDLeast"));
                    bworld = server.getWorld(uid);
                } else {
                    bworld = server.getWorld(worldName);
                }
                if (bworld == null) {
                    bworld = ((CraftServer)server).getServer().getLevel(net.minecraft.world.level.World.OVERWORLD).getWorld();
                }
                ((EntityPlayer)this).setLevel(bworld == null ? null : ((CraftWorld)bworld).getHandle());
            }
            this.getBukkitEntity().readBukkitValues(nbttagcompound);
            if (!nbttagcompound.contains("Bukkit.invisible")) return;
            boolean bukkitInvisible = nbttagcompound.getBoolean("Bukkit.invisible");
            this.setInvisible(bukkitInvisible);
            this.persistentInvisibility = bukkitInvisible;
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Loading entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Entity being loaded");
            this.fillCrashReportCategory(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean repositionEntityAfterLoad() {
        return true;
    }

    @Nullable
    public final String getEncodeId() {
        EntityTypes<?> entitytypes = this.getType();
        MinecraftKey minecraftkey = EntityTypes.getKey(entitytypes);
        return entitytypes.canSerialize() && minecraftkey != null ? minecraftkey.toString() : null;
    }

    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        this.addAdditionalSaveData(nbttagcompound);
    }

    protected abstract void readAdditionalSaveData(NBTTagCompound var1);

    protected abstract void addAdditionalSaveData(NBTTagCompound var1);

    protected NBTTagList newDoubleList(double ... adouble) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble1 = adouble;
        int i2 = adouble.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            double d0 = adouble1[j2];
            nbttaglist.add(NBTTagDouble.valueOf(d0));
        }
        return nbttaglist;
    }

    protected NBTTagList newFloatList(float ... afloat) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] afloat1 = afloat;
        int i2 = afloat.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            float f2 = afloat1[j2];
            nbttaglist.add(NBTTagFloat.valueOf(f2));
        }
        return nbttaglist;
    }

    @Nullable
    public EntityItem spawnAtLocation(IMaterial imaterial) {
        return this.spawnAtLocation(imaterial, 0);
    }

    @Nullable
    public EntityItem spawnAtLocation(IMaterial imaterial, int i2) {
        return this.spawnAtLocation(new ItemStack(imaterial), (float)i2);
    }

    @Nullable
    public EntityItem spawnAtLocation(ItemStack itemstack) {
        return this.spawnAtLocation(itemstack, 0.0f);
    }

    @Nullable
    public EntityItem spawnAtLocation(ItemStack itemstack, float f2) {
        if (itemstack.isEmpty()) {
            return null;
        }
        if (this.level().isClientSide) {
            return null;
        }
        if (this instanceof EntityLiving && !((EntityLiving)this).forceDrops) {
            ((EntityLiving)this).drops.add(CraftItemStack.asBukkitCopy(itemstack));
            return null;
        }
        EntityItem entityitem = new EntityItem(this.level(), this.getX(), this.getY() + (double)f2, this.getZ(), itemstack);
        entityitem.setDefaultPickUpDelay();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        this.level().addFreshEntity(entityitem);
        return entityitem;
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public boolean isInWall() {
        if (this.noPhysics) {
            return false;
        }
        float f2 = this.dimensions.width() * 0.8f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.ofSize(this.getEyePosition(), f2, 1.0E-6, f2);
        return BlockPosition.betweenClosedStream(axisalignedbb).anyMatch(blockposition -> {
            IBlockData iblockdata = this.level().getBlockState((BlockPosition)blockposition);
            return !iblockdata.isAir() && iblockdata.isSuffocating(this.level(), (BlockPosition)blockposition) && VoxelShapes.joinIsNotEmpty(iblockdata.getCollisionShape(this.level(), (BlockPosition)blockposition).move(blockposition.getX(), blockposition.getY(), blockposition.getZ()), VoxelShapes.create(axisalignedbb), OperatorBoolean.AND);
        });
    }

    public EnumInteractionResult interact(EntityHuman entityhuman, EnumHand enumhand) {
        Entity entity;
        if (this.isAlive() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.getLeashHolder() == entityhuman) {
                if (!this.level().isClientSide()) {
                    if (CraftEventFactory.callPlayerUnleashEntityEvent(this, entityhuman, enumhand).isCancelled()) {
                        ((EntityPlayer)entityhuman).connection.send(new PacketPlayOutAttachEntity(this, leashable.getLeashHolder()));
                        return EnumInteractionResult.PASS;
                    }
                    leashable.dropLeash(true, !entityhuman.hasInfiniteMaterials());
                    this.gameEvent(GameEvent.ENTITY_INTERACT, entityhuman);
                }
                return EnumInteractionResult.sidedSuccess(this.level().isClientSide);
            }
            ItemStack itemstack = entityhuman.getItemInHand(enumhand);
            if (itemstack.is(Items.LEAD) && leashable.canHaveALeashAttachedToIt()) {
                if (!this.level().isClientSide()) {
                    if (CraftEventFactory.callPlayerLeashEntityEvent(this, entityhuman, entityhuman, enumhand).isCancelled()) {
                        ((EntityPlayer)entityhuman).resendItemInHands();
                        ((EntityPlayer)entityhuman).connection.send(new PacketPlayOutAttachEntity(this, leashable.getLeashHolder()));
                        return EnumInteractionResult.PASS;
                    }
                    leashable.setLeashedTo(entityhuman, true);
                }
                itemstack.shrink(1);
                return EnumInteractionResult.sidedSuccess(this.level().isClientSide);
            }
        }
        return EnumInteractionResult.PASS;
    }

    public boolean canCollideWith(Entity entity) {
        return entity.canBeCollidedWith() && !this.isPassengerOfSameVehicle(entity);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void rideTick() {
        this.setDeltaMovement(Vec3D.ZERO);
        this.tick();
        if (this.isPassenger()) {
            this.getVehicle().positionRider(this);
        }
    }

    public final void positionRider(Entity entity) {
        if (this.hasPassenger(entity)) {
            this.positionRider(entity, Entity::setPos);
        }
    }

    protected void positionRider(Entity entity, MoveFunction entity_movefunction) {
        Vec3D vec3d = this.getPassengerRidingPosition(entity);
        Vec3D vec3d1 = entity.getVehicleAttachmentPoint(this);
        entity_movefunction.accept(entity, vec3d.x - vec3d1.x, vec3d.y - vec3d1.y, vec3d.z - vec3d1.z);
    }

    public void onPassengerTurned(Entity entity) {
    }

    public Vec3D getVehicleAttachmentPoint(Entity entity) {
        return this.getAttachments().get(EntityAttachment.VEHICLE, 0, this.yRot);
    }

    public Vec3D getPassengerRidingPosition(Entity entity) {
        return this.position().add(this.getPassengerAttachmentPoint(entity, this.dimensions, 1.0f));
    }

    protected Vec3D getPassengerAttachmentPoint(Entity entity, EntitySize entitysize, float f2) {
        return Entity.getDefaultPassengerAttachmentPoint(this, entity, entitysize.attachments());
    }

    protected static Vec3D getDefaultPassengerAttachmentPoint(Entity entity, Entity entity1, EntityAttachments entityattachments) {
        int i2 = entity.getPassengers().indexOf(entity1);
        return entityattachments.getClamped(EntityAttachment.PASSENGER, i2, entity.yRot);
    }

    public boolean startRiding(Entity entity) {
        return this.startRiding(entity, false);
    }

    public boolean showVehicleHealth() {
        return this instanceof EntityLiving;
    }

    public boolean startRiding(Entity entity, boolean flag) {
        EntityMountEvent event;
        if (entity == this.vehicle) {
            return false;
        }
        if (!entity.couldAcceptPassenger()) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.vehicle != null) {
            if (entity1.vehicle == this) {
                return false;
            }
            entity1 = entity1.vehicle;
        }
        if (!(flag || this.canRide(entity) && entity.canAddPassenger(this))) {
            return false;
        }
        if (entity.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof LivingEntity) {
            event = new VehicleEnterEvent((Vehicle)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
        }
        event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
        this.setPose(EntityPose.STANDING);
        this.vehicle = entity;
        this.vehicle.addPassenger(this);
        entity.getIndirectPassengersStream().filter(entity2 -> entity2 instanceof EntityPlayer).forEach(entity2 -> CriterionTriggers.START_RIDING_TRIGGER.trigger((EntityPlayer)entity2));
        return true;
    }

    protected boolean canRide(Entity entity) {
        return !this.isShiftKeyDown() && this.boardingCooldown <= 0;
    }

    public void ejectPassengers() {
        for (int i2 = this.passengers.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.passengers.get(i2)).stopRiding();
        }
    }

    public void removeVehicle() {
        if (this.vehicle != null) {
            Entity entity = this.vehicle;
            this.vehicle = null;
            if (!entity.removePassenger(this)) {
                this.vehicle = entity;
            }
        }
    }

    public void stopRiding() {
        this.removeVehicle();
    }

    protected void addPassenger(Entity entity) {
        if (entity.getVehicle() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.passengers.isEmpty()) {
            this.passengers = ImmutableList.of((Object)entity);
        } else {
            ArrayList list = Lists.newArrayList(this.passengers);
            if (!this.level().isClientSide && entity instanceof EntityHuman && !(this.getFirstPassenger() instanceof EntityHuman)) {
                list.add(0, entity);
            } else {
                list.add(entity);
            }
            this.passengers = ImmutableList.copyOf((Collection)list);
        }
        this.gameEvent(GameEvent.ENTITY_MOUNT, entity);
    }

    protected boolean removePassenger(Entity entity) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.getVehicle() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.passengers = this.passengers.size() == 1 && this.passengers.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.passengers.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.boardingCooldown = 60;
        this.gameEvent(GameEvent.ENTITY_DISMOUNT, entity);
        return true;
    }

    protected boolean canAddPassenger(Entity entity) {
        return this.passengers.isEmpty();
    }

    protected boolean couldAcceptPassenger() {
        return true;
    }

    public void lerpTo(double d0, double d1, double d2, float f2, float f1, int i2) {
        this.setPos(d0, d1, d2);
        this.setRot(f2, f1);
    }

    public double lerpTargetX() {
        return this.getX();
    }

    public double lerpTargetY() {
        return this.getY();
    }

    public double lerpTargetZ() {
        return this.getZ();
    }

    public float lerpTargetXRot() {
        return this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.getYRot();
    }

    public void lerpHeadTo(float f2, int i2) {
        this.setYHeadRot(f2);
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public Vec3D getLookAngle() {
        return this.calculateViewVector(this.getXRot(), this.getYRot());
    }

    public Vec3D getHandHoldingItemAngle(net.minecraft.world.item.Item item) {
        Entity entity = this;
        if (!(entity instanceof EntityHuman)) {
            return Vec3D.ZERO;
        }
        EntityHuman entityhuman = (EntityHuman)entity;
        boolean flag = entityhuman.getOffhandItem().is(item) && !entityhuman.getMainHandItem().is(item);
        EnumMainHand enummainhand = flag ? entityhuman.getMainArm().getOpposite() : entityhuman.getMainArm();
        return this.calculateViewVector(0.0f, this.getYRot() + (float)(enummainhand == EnumMainHand.RIGHT ? 80 : -80)).scale(0.5);
    }

    public Vec2F getRotationVector() {
        return new Vec2F(this.getXRot(), this.getYRot());
    }

    public Vec3D getForward() {
        return Vec3D.directionFromRotation(this.getRotationVector());
    }

    public void setAsInsidePortal(Portal portal, BlockPosition blockposition) {
        if (this.isOnPortalCooldown()) {
            this.setPortalCooldown();
        } else if (this.portalProcess != null && this.portalProcess.isSamePortal(portal)) {
            this.portalProcess.updateEntryPosition(blockposition.immutable());
            this.portalProcess.setAsInsidePortalThisTick(true);
        } else {
            this.portalProcess = new PortalProcessor(portal, blockposition.immutable());
        }
    }

    protected void handlePortal() {
        net.minecraft.world.level.World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.processPortalCooldown();
            if (this.portalProcess != null) {
                if (this.portalProcess.processPortalTeleportation(worldserver, this, this.canUsePortal(false))) {
                    worldserver.getProfiler().push("portal");
                    this.setPortalCooldown();
                    DimensionTransition dimensiontransition = this.portalProcess.getPortalDestination(worldserver, this);
                    if (dimensiontransition != null) {
                        WorldServer worldserver1 = dimensiontransition.newLevel();
                        if (this instanceof EntityPlayer || worldserver1 != null && (worldserver1.dimension() == worldserver.dimension() || this.canChangeDimensions(worldserver, worldserver1))) {
                            this.changeDimension(dimensiontransition);
                        }
                    }
                    worldserver.getProfiler().pop();
                } else if (this.portalProcess.hasExpired()) {
                    this.portalProcess = null;
                }
            }
        }
    }

    public int getDimensionChangingDelay() {
        Entity entity = this.getFirstPassenger();
        return entity instanceof EntityPlayer ? entity.getDimensionChangingDelay() : 300;
    }

    public void lerpMotion(double d0, double d1, double d2) {
        this.setDeltaMovement(d0, d1, d2);
    }

    public void handleDamageEvent(DamageSource damagesource) {
    }

    public void handleEntityEvent(byte b0) {
        switch (b0) {
            case 53: {
                BlockHoney.showSlideParticles(this);
            }
        }
    }

    public void animateHurt(float f2) {
    }

    public boolean isOnFire() {
        boolean flag = this.level() != null && this.level().isClientSide;
        return !this.fireImmune() && (this.remainingFireTicks > 0 || flag && this.getSharedFlag(0));
    }

    public boolean isPassenger() {
        return this.getVehicle() != null;
    }

    public boolean isVehicle() {
        return !this.passengers.isEmpty();
    }

    public boolean dismountsUnderwater() {
        return this.getType().is(TagsEntity.DISMOUNTS_UNDERWATER);
    }

    public boolean canControlVehicle() {
        return !this.getType().is(TagsEntity.NON_CONTROLLING_RIDER);
    }

    public void setShiftKeyDown(boolean flag) {
        this.setSharedFlag(1, flag);
    }

    public boolean isShiftKeyDown() {
        return this.getSharedFlag(1);
    }

    public boolean isSteppingCarefully() {
        return this.isShiftKeyDown();
    }

    public boolean isSuppressingBounce() {
        return this.isShiftKeyDown();
    }

    public boolean isDiscrete() {
        return this.isShiftKeyDown();
    }

    public boolean isDescending() {
        return this.isShiftKeyDown();
    }

    public boolean isCrouching() {
        return this.hasPose(EntityPose.CROUCHING);
    }

    public boolean isSprinting() {
        return this.getSharedFlag(3);
    }

    public void setSprinting(boolean flag) {
        this.setSharedFlag(3, flag);
    }

    public boolean isSwimming() {
        return this.getSharedFlag(4);
    }

    public boolean isVisuallySwimming() {
        return this.hasPose(EntityPose.SWIMMING);
    }

    public boolean isVisuallyCrawling() {
        return this.isVisuallySwimming() && !this.isInWater();
    }

    public void setSwimming(boolean flag) {
        if (this.valid && this.isSwimming() != flag && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, flag).isCancelled()) {
            return;
        }
        this.setSharedFlag(4, flag);
    }

    public final boolean hasGlowingTag() {
        return this.hasGlowingTag;
    }

    public final void setGlowingTag(boolean flag) {
        this.hasGlowingTag = flag;
        this.setSharedFlag(6, this.isCurrentlyGlowing());
    }

    public boolean isCurrentlyGlowing() {
        return this.level().isClientSide() ? this.getSharedFlag(6) : this.hasGlowingTag;
    }

    public boolean isInvisible() {
        return this.getSharedFlag(5);
    }

    public boolean isInvisibleTo(EntityHuman entityhuman) {
        if (entityhuman.isSpectator()) {
            return false;
        }
        ScoreboardTeam scoreboardteam = this.getTeam();
        return scoreboardteam != null && entityhuman != null && entityhuman.getTeam() == scoreboardteam && scoreboardteam.canSeeFriendlyInvisibles() ? false : this.isInvisible();
    }

    public boolean isOnRails() {
        return false;
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, WorldServer> biconsumer) {
    }

    @Nullable
    public ScoreboardTeam getTeam() {
        return this.level().getScoreboard().getPlayersTeam(this.getScoreboardName());
    }

    public boolean isAlliedTo(Entity entity) {
        return this.isAlliedTo(entity.getTeam());
    }

    public boolean isAlliedTo(ScoreboardTeamBase scoreboardteambase) {
        return this.getTeam() != null ? this.getTeam().isAlliedTo(scoreboardteambase) : false;
    }

    public void setInvisible(boolean flag) {
        if (!this.persistentInvisibility) {
            this.setSharedFlag(5, flag);
        }
    }

    public boolean getSharedFlag(int i2) {
        return (this.entityData.get(DATA_SHARED_FLAGS_ID) & 1 << i2) != 0;
    }

    public void setSharedFlag(int i2, boolean flag) {
        byte b0 = this.entityData.get(DATA_SHARED_FLAGS_ID);
        if (flag) {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(b0 | 1 << i2));
        } else {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)(b0 & ~(1 << i2)));
        }
    }

    public int getMaxAirSupply() {
        return this.maxAirTicks;
    }

    public int getAirSupply() {
        return this.entityData.get(DATA_AIR_SUPPLY_ID);
    }

    public void setAirSupply(int i2) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), i2);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.getAirSupply() != i2) {
            this.entityData.markDirty(DATA_AIR_SUPPLY_ID);
            return;
        }
        this.entityData.set(DATA_AIR_SUPPLY_ID, event.getAmount());
    }

    public int getTicksFrozen() {
        return this.entityData.get(DATA_TICKS_FROZEN);
    }

    public void setTicksFrozen(int i2) {
        this.entityData.set(DATA_TICKS_FROZEN, i2);
    }

    public float getPercentFrozen() {
        int i2 = this.getTicksRequiredToFreeze();
        return (float)Math.min(this.getTicksFrozen(), i2) / (float)i2;
    }

    public boolean isFullyFrozen() {
        return this.getTicksFrozen() >= this.getTicksRequiredToFreeze();
    }

    public int getTicksRequiredToFreeze() {
        return 140;
    }

    public void thunderHit(WorldServer worldserver, EntityLightning entitylightning) {
        this.setRemainingFireTicks(this.remainingFireTicks + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = entitylightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.remainingFireTicks == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8.0f);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.igniteForSeconds(entityCombustEvent.getDuration(), false);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.fireImmune()) {
            return;
        }
        if (!this.hurt(this.damageSources().lightningBolt().customEntityDamager(entitylightning), 5.0f)) {
            return;
        }
    }

    public void onAboveBubbleCol(boolean flag) {
        Vec3D vec3d = this.getDeltaMovement();
        double d0 = flag ? Math.max(-0.9, vec3d.y - 0.03) : Math.min(1.8, vec3d.y + 0.1);
        this.setDeltaMovement(vec3d.x, d0, vec3d.z);
    }

    public void onInsideBubbleColumn(boolean flag) {
        Vec3D vec3d = this.getDeltaMovement();
        double d0 = flag ? Math.max(-0.3, vec3d.y - 0.03) : Math.min(0.7, vec3d.y + 0.06);
        this.setDeltaMovement(vec3d.x, d0, vec3d.z);
        this.resetFallDistance();
    }

    public boolean killedEntity(WorldServer worldserver, EntityLiving entityliving) {
        return true;
    }

    public void checkSlowFallDistance() {
        if (this.getDeltaMovement().y() > -0.5 && this.fallDistance > 1.0f) {
            this.fallDistance = 1.0f;
        }
    }

    public void resetFallDistance() {
        this.fallDistance = 0.0f;
    }

    protected void moveTowardsClosestSpace(double d0, double d1, double d2) {
        BlockPosition blockposition = BlockPosition.containing(d0, d1, d2);
        Vec3D vec3d = new Vec3D(d0 - (double)blockposition.getX(), d1 - (double)blockposition.getY(), d2 - (double)blockposition.getZ());
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        EnumDirection enumdirection = EnumDirection.UP;
        double d3 = Double.MAX_VALUE;
        for (EnumDirection enumdirection1 : new EnumDirection[]{EnumDirection.NORTH, EnumDirection.SOUTH, EnumDirection.WEST, EnumDirection.EAST, EnumDirection.UP}) {
            double d5;
            blockposition_mutableblockposition.setWithOffset((BaseBlockPosition)blockposition, enumdirection1);
            if (this.level().getBlockState(blockposition_mutableblockposition).isCollisionShapeFullBlock(this.level(), blockposition_mutableblockposition)) continue;
            double d4 = vec3d.get(enumdirection1.getAxis());
            double d6 = d5 = enumdirection1.getAxisDirection() == EnumDirection.EnumAxisDirection.POSITIVE ? 1.0 - d4 : d4;
            if (!(d5 < d3)) continue;
            d3 = d5;
            enumdirection = enumdirection1;
        }
        float f2 = this.random.nextFloat() * 0.2f + 0.1f;
        float f1 = enumdirection.getAxisDirection().getStep();
        Vec3D vec3d1 = this.getDeltaMovement().scale(0.75);
        if (enumdirection.getAxis() == EnumDirection.EnumAxis.X) {
            this.setDeltaMovement(f1 * f2, vec3d1.y, vec3d1.z);
        } else if (enumdirection.getAxis() == EnumDirection.EnumAxis.Y) {
            this.setDeltaMovement(vec3d1.x, f1 * f2, vec3d1.z);
        } else if (enumdirection.getAxis() == EnumDirection.EnumAxis.Z) {
            this.setDeltaMovement(vec3d1.x, vec3d1.y, f1 * f2);
        }
    }

    public void makeStuckInBlock(IBlockData iblockdata, Vec3D vec3d) {
        this.resetFallDistance();
        this.stuckSpeedMultiplier = vec3d;
    }

    private static IChatBaseComponent removeAction(IChatBaseComponent ichatbasecomponent) {
        IChatMutableComponent ichatmutablecomponent = ichatbasecomponent.plainCopy().setStyle(ichatbasecomponent.getStyle().withClickEvent(null));
        for (IChatBaseComponent ichatbasecomponent1 : ichatbasecomponent.getSiblings()) {
            ichatmutablecomponent.append(Entity.removeAction(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public IChatBaseComponent getName() {
        IChatBaseComponent ichatbasecomponent = this.getCustomName();
        return ichatbasecomponent != null ? Entity.removeAction(ichatbasecomponent) : this.getTypeName();
    }

    protected IChatBaseComponent getTypeName() {
        return this.type.getDescription();
    }

    public boolean is(Entity entity) {
        return this == entity;
    }

    public float getYHeadRot() {
        return 0.0f;
    }

    public void setYHeadRot(float f2) {
    }

    public void setYBodyRot(float f2) {
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity entity) {
        return false;
    }

    public String toString() {
        String s2 = this.level() == null ? "~NULL~" : this.level().toString();
        return this.removalReason != null ? String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.getName().getString(), this.id, s2, this.getX(), this.getY(), this.getZ(), this.removalReason}) : String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.getName().getString(), this.id, s2, this.getX(), this.getY(), this.getZ());
    }

    public boolean isInvulnerableTo(DamageSource damagesource) {
        return this.isRemoved() || this.invulnerable && !damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !damagesource.isCreativePlayer() || damagesource.is(DamageTypeTags.IS_FIRE) && this.fireImmune() || damagesource.is(DamageTypeTags.IS_FALL) && this.getType().is(TagsEntity.FALL_DAMAGE_IMMUNE);
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean flag) {
        this.invulnerable = flag;
    }

    public void copyPosition(Entity entity) {
        this.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
    }

    public void restoreFrom(Entity entity) {
        NBTTagCompound nbttagcompound = entity.saveWithoutId(new NBTTagCompound());
        nbttagcompound.remove("Dimension");
        this.load(nbttagcompound);
        this.portalCooldown = entity.portalCooldown;
        this.portalProcess = entity.portalProcess;
    }

    @Nullable
    public Entity changeDimension(DimensionTransition dimensiontransition) {
        net.minecraft.world.level.World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!this.isRemoved()) {
                Entity entity2;
                Location to = new Location((World)dimensiontransition.newLevel().getWorld(), dimensiontransition.pos().x, dimensiontransition.pos().y, dimensiontransition.pos().z, dimensiontransition.yRot(), dimensiontransition.xRot());
                EntityTeleportEvent teleEvent = CraftEventFactory.callEntityTeleportEvent(this, to);
                if (teleEvent.isCancelled()) {
                    return null;
                }
                to = teleEvent.getTo();
                dimensiontransition = new DimensionTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), dimensiontransition.speed(), to.getYaw(), to.getPitch(), dimensiontransition.missingRespawnBlock(), dimensiontransition.postDimensionTransition(), dimensiontransition.cause());
                WorldServer worldserver1 = dimensiontransition.newLevel();
                List<Entity> list = this.getPassengers();
                this.unRide();
                ArrayList<Entity> list1 = new ArrayList<Entity>();
                for (Entity entity1 : list) {
                    Entity entity3 = entity1.changeDimension(dimensiontransition);
                    if (entity3 == null) continue;
                    list1.add(entity3);
                }
                worldserver.getProfiler().push("changeDimension");
                Entity entity = entity2 = worldserver1.dimension() == worldserver.dimension() ? this : this.getType().create(worldserver1);
                if (entity2 != null) {
                    if (this != entity2) {
                        entity2.restoreFrom(this);
                        this.removeAfterChangingDimensions();
                        this.getBukkitEntity().setHandle(entity2);
                        entity2.bukkitEntity = this.getBukkitEntity();
                    }
                    entity2.moveTo(dimensiontransition.pos().x, dimensiontransition.pos().y, dimensiontransition.pos().z, dimensiontransition.yRot(), entity2.getXRot());
                    entity2.setDeltaMovement(dimensiontransition.speed());
                    if (this != entity2 && this.inWorld) {
                        worldserver1.addDuringTeleport(entity2);
                    }
                    for (Entity entity3 : list1) {
                        entity3.startRiding(entity2, true);
                    }
                    worldserver.resetEmptyTime();
                    worldserver1.resetEmptyTime();
                    dimensiontransition.postDimensionTransition().onTransition(entity2);
                }
                worldserver.getProfiler().pop();
                return entity2;
            }
        }
        return null;
    }

    public void placePortalTicket(BlockPosition blockposition) {
        net.minecraft.world.level.World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.getChunkSource().addRegionTicket(TicketType.PORTAL, new ChunkCoordIntPair(blockposition), 3, blockposition);
        }
    }

    protected void removeAfterChangingDimensions() {
        this.setRemoved(RemovalReason.CHANGED_DIMENSION, null);
        Entity entity = this;
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            this.level().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            leashable.dropLeash(true, false);
        }
    }

    public Vec3D getRelativePortalPosition(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return BlockPortalShape.getRelativePosition(blockutil_rectangle, enumdirection_enumaxis, this.position(), this.getDimensions(this.getPose()));
    }

    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, true, creationRadius);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.isAlive()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public boolean canUsePortal(boolean flag) {
        return (flag || !this.isPassenger()) && this.isAlive();
    }

    public boolean canChangeDimensions(net.minecraft.world.level.World world, net.minecraft.world.level.World world1) {
        return true;
    }

    public float getBlockExplosionResistance(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, Fluid fluid, float f2) {
        return f2;
    }

    public boolean shouldBlockExplode(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, float f2) {
        return true;
    }

    public int getMaxFallDistance() {
        return 3;
    }

    public boolean isIgnoringBlockTriggers() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportSystemDetails crashreportsystemdetails) {
        crashreportsystemdetails.setDetail("Entity Type", () -> {
            String s2 = String.valueOf(EntityTypes.getKey(this.getType()));
            return s2 + " (" + this.getClass().getCanonicalName() + ")";
        });
        crashreportsystemdetails.setDetail("Entity ID", this.id);
        crashreportsystemdetails.setDetail("Entity Name", () -> this.getName().getString());
        crashreportsystemdetails.setDetail("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.getX(), this.getY(), this.getZ()));
        crashreportsystemdetails.setDetail("Entity's Block location", CrashReportSystemDetails.formatLocation((LevelHeightAccessor)this.level(), MathHelper.floor(this.getX()), MathHelper.floor(this.getY()), MathHelper.floor(this.getZ())));
        Vec3D vec3d = this.getDeltaMovement();
        crashreportsystemdetails.setDetail("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.x, vec3d.y, vec3d.z));
        crashreportsystemdetails.setDetail("Entity's Passengers", () -> this.getPassengers().toString());
        crashreportsystemdetails.setDetail("Entity's Vehicle", () -> String.valueOf(this.getVehicle()));
    }

    public boolean displayFireAnimation() {
        return this.isOnFire() && !this.isSpectator();
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
        this.stringUUID = this.uuid.toString();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public String getStringUUID() {
        return this.stringUUID;
    }

    @Override
    public String getScoreboardName() {
        return this.stringUUID;
    }

    public boolean isPushedByFluid() {
        return true;
    }

    public static double getViewScale() {
        return viewScale;
    }

    public static void setViewScale(double d0) {
        viewScale = d0;
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        return ScoreboardTeam.formatNameForTeam(this.getTeam(), this.getName()).withStyle(chatmodifier -> chatmodifier.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()));
    }

    public void setCustomName(@Nullable IChatBaseComponent ichatbasecomponent) {
        this.entityData.set(DATA_CUSTOM_NAME, Optional.ofNullable(ichatbasecomponent));
    }

    @Override
    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).orElse(null);
    }

    @Override
    public boolean hasCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).isPresent();
    }

    public void setCustomNameVisible(boolean flag) {
        this.entityData.set(DATA_CUSTOM_NAME_VISIBLE, flag);
    }

    public boolean isCustomNameVisible() {
        return this.entityData.get(DATA_CUSTOM_NAME_VISIBLE);
    }

    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleportTo(worldserver, d0, d1, d2, set, f2, f1);
    }

    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1) {
        float f22 = MathHelper.clamp(f1, -90.0f, 90.0f);
        if (worldserver == this.level()) {
            this.moveTo(d0, d1, d2, f2, f22);
            this.teleportPassengers();
            this.setYHeadRot(f2);
        } else {
            this.unRide();
            Object entity = this.getType().create(worldserver);
            if (entity == null) {
                return false;
            }
            ((Entity)entity).restoreFrom(this);
            ((Entity)entity).moveTo(d0, d1, d2, f2, f22);
            ((Entity)entity).setYHeadRot(f2);
            this.setRemoved(RemovalReason.CHANGED_DIMENSION, null);
            if (this.inWorld) {
                worldserver.addDuringTeleport((Entity)entity);
            }
        }
        return true;
    }

    public void dismountTo(double d0, double d1, double d2) {
        this.teleportTo(d0, d1, d2);
    }

    public void teleportTo(double d0, double d1, double d2) {
        if (this.level() instanceof WorldServer) {
            this.moveTo(d0, d1, d2, this.getYRot(), this.getXRot());
            this.teleportPassengers();
        }
    }

    private void teleportPassengers() {
        this.getSelfAndPassengers().forEach(entity -> {
            for (Entity entity1 : entity.passengers) {
                entity.positionRider(entity1, Entity::moveTo);
            }
        });
    }

    public void teleportRelative(double d0, double d1, double d2) {
        this.teleportTo(this.getX() + d0, this.getY() + d1, this.getZ() + d2);
    }

    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    @Override
    public void onSyncedDataUpdated(List<DataWatcher.c<?>> list) {
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        if (DATA_POSE.equals(datawatcherobject)) {
            this.refreshDimensions();
        }
    }

    @Deprecated
    protected void fixupDimensions() {
        EntitySize entitysize;
        EntityPose entitypose = this.getPose();
        this.dimensions = entitysize = this.getDimensions(entitypose);
        this.eyeHeight = entitysize.eyeHeight();
    }

    public void refreshDimensions() {
        boolean flag;
        EntitySize entitysize1;
        EntitySize entitysize = this.dimensions;
        EntityPose entitypose = this.getPose();
        this.dimensions = entitysize1 = this.getDimensions(entitypose);
        this.eyeHeight = entitysize1.eyeHeight();
        this.reapplyPosition();
        boolean bl = flag = (double)entitysize1.width() <= 4.0 && (double)entitysize1.height() <= 4.0;
        if (!(this.level.isClientSide || this.firstTick || this.noPhysics || !flag || !(entitysize1.width() > entitysize.width()) && !(entitysize1.height() > entitysize.height()) || this instanceof EntityHuman)) {
            this.fudgePositionAfterSizeChange(entitysize);
        }
    }

    public boolean fudgePositionAfterSizeChange(EntitySize entitysize) {
        VoxelShape voxelshape1;
        Optional<Vec3D> optional1;
        double d1;
        double d0;
        EntitySize entitysize1 = this.getDimensions(this.getPose());
        Vec3D vec3d = this.position().add(0.0, (double)entitysize.height() / 2.0, 0.0);
        VoxelShape voxelshape = VoxelShapes.create(AxisAlignedBB.ofSize(vec3d, d0 = (double)Math.max(0.0f, entitysize1.width() - entitysize.width()) + 1.0E-6, d1 = (double)Math.max(0.0f, entitysize1.height() - entitysize.height()) + 1.0E-6, d0));
        Optional<Vec3D> optional = this.level.findFreePosition(this, voxelshape, vec3d, entitysize1.width(), entitysize1.height(), entitysize1.width());
        if (optional.isPresent()) {
            this.setPos(optional.get().add(0.0, (double)(-entitysize1.height()) / 2.0, 0.0));
            return true;
        }
        if (entitysize1.width() > entitysize.width() && entitysize1.height() > entitysize.height() && (optional1 = this.level.findFreePosition(this, voxelshape1 = VoxelShapes.create(AxisAlignedBB.ofSize(vec3d, d0, 1.0E-6, d0)), vec3d, entitysize1.width(), entitysize.height(), entitysize1.width())).isPresent()) {
            this.setPos(optional1.get().add(0.0, (double)(-entitysize.height()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public EnumDirection getDirection() {
        return EnumDirection.fromYRot(this.getYRot());
    }

    public EnumDirection getMotionDirection() {
        return this.getDirection();
    }

    protected ChatHoverable createHoverEvent() {
        return new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_ENTITY, new ChatHoverable.b(this.getType(), this.getUUID(), this.getName()));
    }

    public boolean broadcastToPlayer(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public final AxisAlignedBB getBoundingBox() {
        return this.bb;
    }

    public AxisAlignedBB getBoundingBoxForCulling() {
        return this.getBoundingBox();
    }

    public final void setBoundingBox(AxisAlignedBB axisalignedbb) {
        double minX = axisalignedbb.minX;
        double minY = axisalignedbb.minY;
        double minZ = axisalignedbb.minZ;
        double maxX = axisalignedbb.maxX;
        double maxY = axisalignedbb.maxY;
        double maxZ = axisalignedbb.maxZ;
        double len = axisalignedbb.maxX - axisalignedbb.minX;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = axisalignedbb.maxY - axisalignedbb.minY) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = axisalignedbb.maxZ - axisalignedbb.minZ) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.bb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final float getEyeHeight(EntityPose entitypose) {
        return this.getDimensions(entitypose).eyeHeight();
    }

    public final float getEyeHeight() {
        return this.eyeHeight;
    }

    public Vec3D getLeashOffset(float f2) {
        return this.getLeashOffset();
    }

    protected Vec3D getLeashOffset() {
        return new Vec3D(0.0, this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public SlotAccess getSlot(int i2) {
        return SlotAccess.NULL;
    }

    @Override
    public void sendSystemMessage(IChatBaseComponent ichatbasecomponent) {
    }

    public net.minecraft.world.level.World getCommandSenderWorld() {
        return this.level();
    }

    @Nullable
    public MinecraftServer getServer() {
        return this.level().getServer();
    }

    public EnumInteractionResult interactAt(EntityHuman entityhuman, Vec3D vec3d, EnumHand enumhand) {
        return EnumInteractionResult.PASS;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return false;
    }

    public void startSeenByPlayer(EntityPlayer entityplayer) {
    }

    public void stopSeenByPlayer(EntityPlayer entityplayer) {
    }

    public float rotate(EnumBlockRotation enumblockrotation) {
        float f2 = MathHelper.wrapDegrees(this.getYRot());
        switch (enumblockrotation) {
            case CLOCKWISE_180: {
                return f2 + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f2 + 270.0f;
            }
            case CLOCKWISE_90: {
                return f2 + 90.0f;
            }
        }
        return f2;
    }

    public float mirror(EnumBlockMirror enumblockmirror) {
        float f2 = MathHelper.wrapDegrees(this.getYRot());
        switch (enumblockmirror) {
            case FRONT_BACK: {
                return -f2;
            }
            case LEFT_RIGHT: {
                return 180.0f - f2;
            }
        }
        return f2;
    }

    public boolean onlyOpCanSetNbt() {
        return false;
    }

    public ProjectileDeflection deflection(IProjectile iprojectile) {
        return this.getType().is(TagsEntity.DEFLECTS_PROJECTILES) ? ProjectileDeflection.REVERSE : ProjectileDeflection.NONE;
    }

    @Nullable
    public EntityLiving getControllingPassenger() {
        return null;
    }

    public final boolean hasControllingPassenger() {
        return this.getControllingPassenger() != null;
    }

    public final List<Entity> getPassengers() {
        return this.passengers;
    }

    @Nullable
    public Entity getFirstPassenger() {
        return this.passengers.isEmpty() ? null : (Entity)this.passengers.get(0);
    }

    public boolean hasPassenger(Entity entity) {
        return this.passengers.contains((Object)entity);
    }

    public boolean hasPassenger(Predicate<Entity> predicate) {
        Entity entity;
        UnmodifiableIterator unmodifiableiterator = this.passengers.iterator();
        do {
            if (unmodifiableiterator.hasNext()) continue;
            return false;
        } while (!predicate.test(entity = (Entity)unmodifiableiterator.next()));
        return true;
    }

    private Stream<Entity> getIndirectPassengersStream() {
        return this.passengers.stream().flatMap(Entity::getSelfAndPassengers);
    }

    public Stream<Entity> getSelfAndPassengers() {
        return Stream.concat(Stream.of(this), this.getIndirectPassengersStream());
    }

    public Stream<Entity> getPassengersAndSelf() {
        return Stream.concat(this.passengers.stream().flatMap(Entity::getPassengersAndSelf), Stream.of(this));
    }

    public Iterable<Entity> getIndirectPassengers() {
        return () -> this.getIndirectPassengersStream().iterator();
    }

    public int countPlayerPassengers() {
        return (int)this.getIndirectPassengersStream().filter(entity -> entity instanceof EntityHuman).count();
    }

    public boolean hasExactlyOnePlayerPassenger() {
        return this.countPlayerPassengers() == 1;
    }

    public Entity getRootVehicle() {
        Entity entity = this;
        while (entity.isPassenger()) {
            entity = entity.getVehicle();
        }
        return entity;
    }

    public boolean isPassengerOfSameVehicle(Entity entity) {
        return this.getRootVehicle() == entity.getRootVehicle();
    }

    public boolean hasIndirectPassenger(Entity entity) {
        if (!entity.isPassenger()) {
            return false;
        }
        Entity entity1 = entity.getVehicle();
        return entity1 == this ? true : this.hasIndirectPassenger(entity1);
    }

    public boolean isControlledByLocalInstance() {
        EntityLiving entityliving = this.getControllingPassenger();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            return entityhuman.isLocalPlayer();
        }
        return this.isEffectiveAi();
    }

    public boolean isEffectiveAi() {
        return !this.level().isClientSide;
    }

    protected static Vec3D getCollisionHorizontalEscapeVector(double d0, double d1, float f2) {
        double d2 = (d0 + d1 + (double)1.0E-5f) / 2.0;
        float f1 = -MathHelper.sin(f2 * ((float)Math.PI / 180));
        float f22 = MathHelper.cos(f2 * ((float)Math.PI / 180));
        float f3 = Math.max(Math.abs(f1), Math.abs(f22));
        return new Vec3D((double)f1 * d2 / (double)f3, 0.0, (double)f22 * d2 / (double)f3);
    }

    public Vec3D getDismountLocationForPassenger(EntityLiving entityliving) {
        return new Vec3D(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Nullable
    public Entity getVehicle() {
        return this.vehicle;
    }

    @Nullable
    public Entity getControlledVehicle() {
        return this.vehicle != null && this.vehicle.getControllingPassenger() == this ? this.vehicle : null;
    }

    public EnumPistonReaction getPistonPushReaction() {
        return EnumPistonReaction.NORMAL;
    }

    public SoundCategory getSoundSource() {
        return SoundCategory.NEUTRAL;
    }

    public int getFireImmuneTicks() {
        return 1;
    }

    public CommandListenerWrapper createCommandSourceStack() {
        return new CommandListenerWrapper(this, this.position(), this.getRotationVector(), this.level() instanceof WorldServer ? (WorldServer)this.level() : null, this.getPermissionLevel(), this.getName().getString(), this.getDisplayName(), this.level().getServer(), this);
    }

    protected int getPermissionLevel() {
        return 0;
    }

    public boolean hasPermissions(int i2) {
        return this.getPermissionLevel() >= i2;
    }

    @Override
    public boolean acceptsSuccess() {
        return this.level().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public boolean shouldInformAdmins() {
        return true;
    }

    public void lookAt(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        Vec3D vec3d1 = argumentanchor_anchor.apply(this);
        double d0 = vec3d.x - vec3d1.x;
        double d1 = vec3d.y - vec3d1.y;
        double d2 = vec3d.z - vec3d1.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.setXRot(MathHelper.wrapDegrees((float)(-(MathHelper.atan2(d1, d3) * 57.2957763671875))));
        this.setYRot(MathHelper.wrapDegrees((float)(MathHelper.atan2(d2, d0) * 57.2957763671875) - 90.0f));
        this.setYHeadRot(this.getYRot());
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    public float getPreciseBodyRotation(float f2) {
        return MathHelper.lerp(f2, this.yRotO, this.yRot);
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<FluidType> tagkey, double d0) {
        if (this.touchingUnloadedChunk()) {
            return false;
        }
        AxisAlignedBB axisalignedbb = this.getBoundingBox().deflate(0.001);
        int i2 = MathHelper.floor(axisalignedbb.minX);
        int j2 = MathHelper.ceil(axisalignedbb.maxX);
        int k2 = MathHelper.floor(axisalignedbb.minY);
        int l2 = MathHelper.ceil(axisalignedbb.maxY);
        int i1 = MathHelper.floor(axisalignedbb.minZ);
        int j1 = MathHelper.ceil(axisalignedbb.maxZ);
        double d1 = 0.0;
        boolean flag = this.isPushedByFluid();
        boolean flag1 = false;
        Vec3D vec3d = Vec3D.ZERO;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l1 = i2; l1 < j2; ++l1) {
            for (int i22 = k2; i22 < l2; ++i22) {
                for (int j22 = i1; j22 < j1; ++j22) {
                    double d2;
                    blockposition_mutableblockposition.set(l1, i22, j22);
                    Fluid fluid = this.level().getFluidState(blockposition_mutableblockposition);
                    if (!fluid.is(tagkey) || !((d2 = (double)((float)i22 + fluid.getHeight(this.level(), blockposition_mutableblockposition))) >= axisalignedbb.minY)) continue;
                    flag1 = true;
                    d1 = Math.max(d2 - axisalignedbb.minY, d1);
                    if (flag) {
                        Vec3D vec3d1 = fluid.getFlow(this.level(), blockposition_mutableblockposition);
                        if (d1 < 0.4) {
                            vec3d1 = vec3d1.scale(d1);
                        }
                        vec3d = vec3d.add(vec3d1);
                        ++k1;
                    }
                    if (tagkey != TagsFluid.LAVA) continue;
                    this.lastLavaContact = blockposition_mutableblockposition.immutable();
                }
            }
        }
        if (vec3d.length() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.scale(1.0 / (double)k1);
            }
            if (!(this instanceof EntityHuman)) {
                vec3d = vec3d.normalize();
            }
            Vec3D vec3d2 = this.getDeltaMovement();
            vec3d = vec3d.scale(d0);
            double d3 = 0.003;
            if (Math.abs(vec3d2.x) < 0.003 && Math.abs(vec3d2.z) < 0.003 && vec3d.length() < 0.0045000000000000005) {
                vec3d = vec3d.normalize().scale(0.0045000000000000005);
            }
            this.setDeltaMovement(this.getDeltaMovement().add(vec3d));
        }
        this.fluidHeight.put(tagkey, d1);
        return flag1;
    }

    public boolean touchingUnloadedChunk() {
        AxisAlignedBB axisalignedbb = this.getBoundingBox().inflate(1.0);
        int i2 = MathHelper.floor(axisalignedbb.minX);
        int j2 = MathHelper.ceil(axisalignedbb.maxX);
        int k2 = MathHelper.floor(axisalignedbb.minZ);
        int l2 = MathHelper.ceil(axisalignedbb.maxZ);
        return !this.level().hasChunksAt(i2, k2, j2, l2);
    }

    public double getFluidHeight(TagKey<FluidType> tagkey) {
        return this.fluidHeight.getDouble(tagkey);
    }

    public double getFluidJumpThreshold() {
        return (double)this.getEyeHeight() < 0.4 ? 0.0 : 0.4;
    }

    public final float getBbWidth() {
        return this.dimensions.width();
    }

    public final float getBbHeight() {
        return this.dimensions.height();
    }

    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity(this, entitytrackerentry);
    }

    public EntitySize getDimensions(EntityPose entitypose) {
        return this.type.getDimensions();
    }

    public final EntityAttachments getAttachments() {
        return this.dimensions.attachments();
    }

    public Vec3D position() {
        return this.position;
    }

    public Vec3D trackingPosition() {
        return this.position();
    }

    @Override
    public BlockPosition blockPosition() {
        return this.blockPosition;
    }

    public IBlockData getInBlockState() {
        if (this.inBlockState == null) {
            this.inBlockState = this.level().getBlockState(this.blockPosition());
        }
        return this.inBlockState;
    }

    public ChunkCoordIntPair chunkPosition() {
        return this.chunkPosition;
    }

    public Vec3D getDeltaMovement() {
        return this.deltaMovement;
    }

    public void setDeltaMovement(Vec3D vec3d) {
        this.deltaMovement = vec3d;
    }

    public void addDeltaMovement(Vec3D vec3d) {
        this.setDeltaMovement(this.getDeltaMovement().add(vec3d));
    }

    public void setDeltaMovement(double d0, double d1, double d2) {
        this.setDeltaMovement(new Vec3D(d0, d1, d2));
    }

    public final int getBlockX() {
        return this.blockPosition.getX();
    }

    public final double getX() {
        return this.position.x;
    }

    public double getX(double d0) {
        return this.position.x + (double)this.getBbWidth() * d0;
    }

    public double getRandomX(double d0) {
        return this.getX((2.0 * this.random.nextDouble() - 1.0) * d0);
    }

    public final int getBlockY() {
        return this.blockPosition.getY();
    }

    public final double getY() {
        return this.position.y;
    }

    public double getY(double d0) {
        return this.position.y + (double)this.getBbHeight() * d0;
    }

    public double getRandomY() {
        return this.getY(this.random.nextDouble());
    }

    public double getEyeY() {
        return this.position.y + (double)this.eyeHeight;
    }

    public final int getBlockZ() {
        return this.blockPosition.getZ();
    }

    public final double getZ() {
        return this.position.z;
    }

    public double getZ(double d0) {
        return this.position.z + (double)this.getBbWidth() * d0;
    }

    public double getRandomZ(double d0) {
        return this.getZ((2.0 * this.random.nextDouble() - 1.0) * d0);
    }

    public final void setPosRaw(double d0, double d1, double d2) {
        if (this.position.x != d0 || this.position.y != d1 || this.position.z != d2) {
            this.position = new Vec3D(d0, d1, d2);
            int i2 = MathHelper.floor(d0);
            int j2 = MathHelper.floor(d1);
            int k2 = MathHelper.floor(d2);
            if (i2 != this.blockPosition.getX() || j2 != this.blockPosition.getY() || k2 != this.blockPosition.getZ()) {
                this.blockPosition = new BlockPosition(i2, j2, k2);
                this.inBlockState = null;
                if (SectionPosition.blockToSectionCoord(i2) != this.chunkPosition.x || SectionPosition.blockToSectionCoord(k2) != this.chunkPosition.z) {
                    this.chunkPosition = new ChunkCoordIntPair(this.blockPosition);
                }
            }
            this.levelCallback.onMove();
        }
    }

    public void checkDespawn() {
    }

    public Vec3D getRopeHoldPosition(float f2) {
        return this.getPosition(f2).add(0.0, (double)this.eyeHeight * 0.7, 0.0);
    }

    public void recreateFromPacket(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        int i2 = packetplayoutspawnentity.getId();
        double d0 = packetplayoutspawnentity.getX();
        double d1 = packetplayoutspawnentity.getY();
        double d2 = packetplayoutspawnentity.getZ();
        this.syncPacketPositionCodec(d0, d1, d2);
        this.moveTo(d0, d1, d2);
        this.setXRot(packetplayoutspawnentity.getXRot());
        this.setYRot(packetplayoutspawnentity.getYRot());
        this.setId(i2);
        this.setUUID(packetplayoutspawnentity.getUUID());
    }

    @Nullable
    public ItemStack getPickResult() {
        return null;
    }

    public void setIsInPowderSnow(boolean flag) {
        this.isInPowderSnow = flag;
    }

    public boolean canFreeze() {
        return !this.getType().is(TagsEntity.FREEZE_IMMUNE_ENTITY_TYPES);
    }

    public boolean isFreezing() {
        return (this.isInPowderSnow || this.wasInPowderSnow) && this.canFreeze();
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getVisualRotationYInDegrees() {
        return this.getYRot();
    }

    public void setYRot(float f2) {
        if (!Float.isFinite(f2)) {
            SystemUtils.logAndPauseIfInIde("Invalid entity rotation: " + f2 + ", discarding.");
        } else {
            this.yRot = f2;
        }
    }

    public float getXRot() {
        return this.xRot;
    }

    public void setXRot(float f2) {
        if (!Float.isFinite(f2)) {
            SystemUtils.logAndPauseIfInIde("Invalid entity rotation: " + f2 + ", discarding.");
        } else {
            this.xRot = f2;
        }
    }

    public boolean canSprint() {
        return false;
    }

    public float maxUpStep() {
        return 0.0f;
    }

    public void onExplosionHit(@Nullable Entity entity) {
    }

    public final boolean isRemoved() {
        return this.removalReason != null;
    }

    @Nullable
    public RemovalReason getRemovalReason() {
        return this.removalReason;
    }

    @Override
    public final void setRemoved(RemovalReason entity_removalreason) {
        this.setRemoved(entity_removalreason, null);
    }

    @Override
    public final void setRemoved(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        if (this.removalReason == null) {
            this.removalReason = entity_removalreason;
        }
        if (this.removalReason.shouldDestroy()) {
            this.stopRiding();
        }
        this.getPassengers().forEach(Entity::stopRiding);
        this.levelCallback.onRemove(entity_removalreason);
    }

    public void unsetRemoved() {
        this.removalReason = null;
    }

    @Override
    public void setLevelCallback(EntityInLevelCallback entityinlevelcallback) {
        this.levelCallback = entityinlevelcallback;
    }

    @Override
    public boolean shouldBeSaved() {
        return this.removalReason != null && !this.removalReason.shouldSave() ? false : (this.isPassenger() ? false : !this.isVehicle() || !this.hasExactlyOnePlayerPassenger());
    }

    @Override
    public boolean isAlwaysTicking() {
        return false;
    }

    public boolean mayInteract(net.minecraft.world.level.World world, BlockPosition blockposition) {
        return true;
    }

    public net.minecraft.world.level.World level() {
        return this.level;
    }

    protected void setLevel(net.minecraft.world.level.World world) {
        this.level = world;
    }

    public DamageSources damageSources() {
        return this.level().damageSources();
    }

    public IRegistryCustom registryAccess() {
        return this.level().registryAccess();
    }

    protected void lerpPositionAndRotationStep(int i2, double d0, double d1, double d2, double d3, double d4) {
        double d5 = 1.0 / (double)i2;
        double d6 = MathHelper.lerp(d5, this.getX(), d0);
        double d7 = MathHelper.lerp(d5, this.getY(), d1);
        double d8 = MathHelper.lerp(d5, this.getZ(), d2);
        float f2 = (float)MathHelper.rotLerp(d5, (double)this.getYRot(), d3);
        float f1 = (float)MathHelper.lerp(d5, (double)this.getXRot(), d4);
        this.setPos(d6, d7, d8);
        this.setRot(f2, f1);
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public Vec3D getKnownMovement() {
        EntityLiving entityliving = this.getControllingPassenger();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            if (this.isAlive()) {
                return entityhuman.getKnownMovement();
            }
        }
        return this.getDeltaMovement();
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return null;
    }

    public static enum RemovalReason {
        KILLED(true, false),
        DISCARDED(true, false),
        UNLOADED_TO_CHUNK(false, true),
        UNLOADED_WITH_PLAYER(false, false),
        CHANGED_DIMENSION(false, false);

        private final boolean destroy;
        private final boolean save;

        private RemovalReason(boolean flag, boolean flag1) {
            this.destroy = flag;
            this.save = flag1;
        }

        public boolean shouldDestroy() {
            return this.destroy;
        }

        public boolean shouldSave() {
            return this.save;
        }
    }

    public static enum MovementEmission {
        NONE(false, false),
        SOUNDS(true, false),
        EVENTS(false, true),
        ALL(true, true);

        final boolean sounds;
        final boolean events;

        private MovementEmission(boolean flag, boolean flag1) {
            this.sounds = flag;
            this.events = flag1;
        }

        public boolean emitsAnything() {
            return this.events || this.sounds;
        }

        public boolean emitsEvents() {
            return this.events;
        }

        public boolean emitsSounds() {
            return this.sounds;
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }
}

