/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;

public abstract class EntityAgeable
extends EntityCreature {
    private static final DataWatcherObject<Boolean> DATA_BABY_ID = DataWatcher.defineId(EntityAgeable.class, DataWatcherRegistry.BOOLEAN);
    public static final int BABY_START_AGE = -24000;
    private static final int FORCED_AGE_PARTICLE_TICKS = 40;
    protected int age;
    protected int forcedAge;
    protected int forcedAgeTimer;
    public boolean ageLocked;

    protected EntityAgeable(EntityTypes<? extends EntityAgeable> entitytypes, World world) {
        super((EntityTypes<? extends EntityCreature>)entitytypes, world);
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.level().isClientSide || this.ageLocked) {
            this.refreshDimensions();
        } else {
            int i2 = this.getAge();
            if (i2 < 0) {
                this.setAge(++i2);
            } else if (i2 > 0) {
                this.setAge(--i2);
            }
        }
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        a entityageable_a;
        if (groupdataentity == null) {
            groupdataentity = new a(true);
        }
        if ((entityageable_a = (a)groupdataentity).isShouldSpawnBaby() && entityageable_a.getGroupSize() > 0 && worldaccess.getRandom().nextFloat() <= entityageable_a.getBabySpawnChance()) {
            this.setAge(-24000);
        }
        entityageable_a.increaseGroupSizeByOne();
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    @Nullable
    public abstract EntityAgeable getBreedOffspring(WorldServer var1, EntityAgeable var2);

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_BABY_ID, false);
    }

    public boolean canBreed() {
        return false;
    }

    public int getAge() {
        return this.level().isClientSide ? (this.entityData.get(DATA_BABY_ID).booleanValue() ? -1 : 1) : this.age;
    }

    public void ageUp(int i2, boolean flag) {
        int j2;
        int k2 = j2 = this.getAge();
        if ((j2 += i2 * 20) > 0) {
            j2 = 0;
        }
        int l2 = j2 - k2;
        this.setAge(j2);
        if (flag) {
            this.forcedAge += l2;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getAge() == 0) {
            this.setAge(this.forcedAge);
        }
    }

    public void ageUp(int i2) {
        this.ageUp(i2, false);
    }

    public void setAge(int i2) {
        int j2 = this.getAge();
        this.age = i2;
        if (j2 < 0 && i2 >= 0 || j2 >= 0 && i2 < 0) {
            this.entityData.set(DATA_BABY_ID, i2 < 0);
            this.ageBoundaryReached();
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putInt("Age", this.getAge());
        nbttagcompound.putInt("ForcedAge", this.forcedAge);
        nbttagcompound.putBoolean("AgeLocked", this.ageLocked);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.setAge(nbttagcompound.getInt("Age"));
        this.forcedAge = nbttagcompound.getInt("ForcedAge");
        this.ageLocked = nbttagcompound.getBoolean("AgeLocked");
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        if (DATA_BABY_ID.equals(datawatcherobject)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide || this.ageLocked) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.level().addParticle(Particles.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.isAlive()) {
            int i2 = this.getAge();
            if (i2 < 0) {
                this.setAge(++i2);
            } else if (i2 > 0) {
                this.setAge(--i2);
            }
        }
    }

    protected void ageBoundaryReached() {
        EntityBoat entityboat;
        Entity entity;
        if (!this.isBaby() && this.isPassenger() && (entity = this.getVehicle()) instanceof EntityBoat && !(entityboat = (EntityBoat)entity).hasEnoughSpaceFor(this)) {
            this.stopRiding();
        }
    }

    @Override
    public boolean isBaby() {
        return this.getAge() < 0;
    }

    @Override
    public void setBaby(boolean flag) {
        this.setAge(flag ? -24000 : 0);
    }

    public static int getSpeedUpSecondsWhenFeeding(int i2) {
        return (int)((float)(i2 / 20) * 0.1f);
    }

    public static class a
    implements GroupDataEntity {
        private int groupSize;
        private final boolean shouldSpawnBaby;
        private final float babySpawnChance;

        private a(boolean flag, float f2) {
            this.shouldSpawnBaby = flag;
            this.babySpawnChance = f2;
        }

        public a(boolean flag) {
            this(flag, 0.05f);
        }

        public a(float f2) {
            this(true, f2);
        }

        public int getGroupSize() {
            return this.groupSize;
        }

        public void increaseGroupSizeByOne() {
            ++this.groupSize;
        }

        public boolean isShouldSpawnBaby() {
            return this.shouldSpawnBaby;
        }

        public float getBabySpawnChance() {
            return this.babySpawnChance;
        }
    }
}

