/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ColorUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TIME_BETWEEN_APPLICATIONS = 5;
    private static final DataWatcherObject<Float> DATA_RADIUS = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Boolean> DATA_WAITING = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<ParticleParam> DATA_PARTICLE = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.PARTICLE);
    private static final float MAX_RADIUS = 32.0f;
    private static final float MINIMAL_RADIUS = 0.5f;
    private static final float DEFAULT_RADIUS = 3.0f;
    public static final float DEFAULT_WIDTH = 6.0f;
    public static final float HEIGHT = 0.5f;
    public PotionContents potionContents = PotionContents.EMPTY;
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    public int waitTime = 20;
    public int reapplicationDelay = 20;
    public int durationOnUse;
    public float radiusOnUse;
    public float radiusPerTick;
    @Nullable
    private EntityLiving owner;
    @Nullable
    private UUID ownerUUID;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> entitytypes, World world) {
        super(entitytypes, world);
        this.noPhysics = true;
    }

    public EntityAreaEffectCloud(World world, double d0, double d1, double d2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.AREA_EFFECT_CLOUD, world);
        this.setPos(d0, d1, d2);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        datawatcher_a.define(DATA_RADIUS, Float.valueOf(3.0f));
        datawatcher_a.define(DATA_WAITING, false);
        datawatcher_a.define(DATA_PARTICLE, ColorParticleOption.create(Particles.ENTITY_EFFECT, -1));
    }

    public void setRadius(float f2) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, Float.valueOf(MathHelper.clamp(f2, 0.0f, 32.0f)));
        }
    }

    @Override
    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public float getRadius() {
        return this.getEntityData().get(DATA_RADIUS).floatValue();
    }

    public void setPotionContents(PotionContents potioncontents) {
        this.potionContents = potioncontents;
        this.updateColor();
    }

    public void updateColor() {
        ParticleParam particleparam = this.entityData.get(DATA_PARTICLE);
        if (particleparam instanceof ColorParticleOption) {
            ColorParticleOption colorparticleoption = (ColorParticleOption)particleparam;
            int i2 = this.potionContents.equals(PotionContents.EMPTY) ? 0 : this.potionContents.getColor();
            this.entityData.set(DATA_PARTICLE, ColorParticleOption.create(colorparticleoption.getType(), ColorUtil.b.opaque(i2)));
        }
    }

    public void addEffect(MobEffect mobeffect) {
        this.setPotionContents(this.potionContents.withEffectAdded(mobeffect));
    }

    public ParticleParam getParticle() {
        return this.getEntityData().get(DATA_PARTICLE);
    }

    public void setParticle(ParticleParam particleparam) {
        this.getEntityData().set(DATA_PARTICLE, particleparam);
    }

    protected void setWaiting(boolean flag) {
        this.getEntityData().set(DATA_WAITING, flag);
    }

    public boolean isWaiting() {
        return this.getEntityData().get(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int i2) {
        this.duration = i2;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.tickCount >= this.waitTime + this.duration) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
    }

    @Override
    public void tick() {
        block22: {
            float f2;
            block23: {
                boolean flag1;
                boolean flag;
                block21: {
                    float f1;
                    int i2;
                    super.tick();
                    flag = this.isWaiting();
                    f2 = this.getRadius();
                    if (!this.level().isClientSide) break block21;
                    if (flag && this.random.nextBoolean()) {
                        return;
                    }
                    ParticleParam particleparam = this.getParticle();
                    if (flag) {
                        i2 = 2;
                        f1 = 0.2f;
                    } else {
                        i2 = MathHelper.ceil((float)Math.PI * f2 * f2);
                        f1 = f2;
                    }
                    for (int j2 = 0; j2 < i2; ++j2) {
                        float f22 = this.random.nextFloat() * ((float)Math.PI * 2);
                        float f3 = MathHelper.sqrt(this.random.nextFloat()) * f1;
                        double d0 = this.getX() + (double)(MathHelper.cos(f22) * f3);
                        double d1 = this.getY();
                        double d2 = this.getZ() + (double)(MathHelper.sin(f22) * f3);
                        if (particleparam.getType() == Particles.ENTITY_EFFECT) {
                            if (flag && this.random.nextBoolean()) {
                                this.level().addAlwaysVisibleParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, -1), d0, d1, d2, 0.0, 0.0, 0.0);
                                continue;
                            }
                            this.level().addAlwaysVisibleParticle(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                            continue;
                        }
                        if (flag) {
                            this.level().addAlwaysVisibleParticle(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                            continue;
                        }
                        this.level().addAlwaysVisibleParticle(particleparam, d0, d1, d2, (0.5 - this.random.nextDouble()) * 0.15, 0.01f, (0.5 - this.random.nextDouble()) * 0.15);
                    }
                    break block22;
                }
                if (this.tickCount >= this.waitTime + this.duration) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
                boolean bl = flag1 = this.tickCount < this.waitTime;
                if (flag != flag1) {
                    this.setWaiting(flag1);
                }
                if (flag1) {
                    return;
                }
                if (this.radiusPerTick != 0.0f) {
                    if ((f2 += this.radiusPerTick) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.setRadius(f2);
                }
                if (this.tickCount % 5 != 0) break block22;
                this.victims.entrySet().removeIf(entry -> this.tickCount >= (Integer)entry.getValue());
                if (this.potionContents.hasEffects()) break block23;
                this.victims.clear();
                break block22;
            }
            ArrayList list = Lists.newArrayList();
            if (this.potionContents.potion().isPresent()) {
                for (MobEffect mobeffect : this.potionContents.potion().get().value().getEffects()) {
                    list.add(new MobEffect(mobeffect.getEffect(), mobeffect.mapDuration(k2 -> k2 / 4), mobeffect.getAmplifier(), mobeffect.isAmbient(), mobeffect.isVisible()));
                }
            }
            list.addAll(this.potionContents.customEffects());
            List<EntityLiving> list1 = this.level().getEntitiesOfClass(EntityLiving.class, this.getBoundingBox());
            if (list1.isEmpty()) break block22;
            Iterator<EntityLiving> iterator1 = list1.iterator();
            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
            while (iterator1.hasNext()) {
                double d4;
                double d3;
                double d5;
                EntityLiving entityliving = iterator1.next();
                if (this.victims.containsKey(entityliving) || !entityliving.isAffectedByPotions()) continue;
                Stream stream = list.stream();
                Objects.requireNonNull(entityliving);
                if (stream.noneMatch(entityliving::canBeAffected) || !((d5 = (d3 = entityliving.getX() - this.getX()) * d3 + (d4 = entityliving.getZ() - this.getZ()) * d4) <= (double)(f2 * f2))) continue;
                entities.add((LivingEntity)entityliving.getBukkitEntity());
            }
            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
            if (!event.isCancelled()) {
                for (LivingEntity entity : event.getAffectedEntities()) {
                    if (!(entity instanceof CraftLivingEntity)) continue;
                    EntityLiving entityliving = ((CraftLivingEntity)entity).getHandle();
                    this.victims.put(entityliving, this.tickCount + this.reapplicationDelay);
                    for (MobEffect mobeffect1 : list) {
                        if (mobeffect1.getEffect().value().isInstantenous()) {
                            mobeffect1.getEffect().value().applyInstantenousEffect(this, this.getOwner(), entityliving, mobeffect1.getAmplifier(), 0.5);
                            continue;
                        }
                        entityliving.addEffect(new MobEffect(mobeffect1), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                    }
                    if (this.radiusOnUse != 0.0f) {
                        if ((f2 += this.radiusOnUse) < 0.5f) {
                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                            return;
                        }
                        this.setRadius(f2);
                    }
                    if (this.durationOnUse == 0) continue;
                    this.duration += this.durationOnUse;
                    if (this.duration > 0) continue;
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            }
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float f2) {
        this.radiusOnUse = f2;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float f2) {
        this.radiusPerTick = f2;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int i2) {
        this.durationOnUse = i2;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int i2) {
        this.waitTime = i2;
    }

    public void setOwner(@Nullable EntityLiving entityliving) {
        this.owner = entityliving;
        this.ownerUUID = entityliving == null ? null : entityliving.getUUID();
    }

    @Override
    @Nullable
    public EntityLiving getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof WorldServer && (entity = ((WorldServer)this.level()).getEntity(this.ownerUUID)) instanceof EntityLiving) {
            this.owner = (EntityLiving)entity;
        }
        return this.owner;
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        this.tickCount = nbttagcompound.getInt("Age");
        this.duration = nbttagcompound.getInt("Duration");
        this.waitTime = nbttagcompound.getInt("WaitTime");
        this.reapplicationDelay = nbttagcompound.getInt("ReapplicationDelay");
        this.durationOnUse = nbttagcompound.getInt("DurationOnUse");
        this.radiusOnUse = nbttagcompound.getFloat("RadiusOnUse");
        this.radiusPerTick = nbttagcompound.getFloat("RadiusPerTick");
        this.setRadius(nbttagcompound.getFloat("Radius"));
        if (nbttagcompound.hasUUID("Owner")) {
            this.ownerUUID = nbttagcompound.getUUID("Owner");
        }
        RegistryOps<NBTBase> registryops = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        if (nbttagcompound.contains("Particle", 10)) {
            Particles.CODEC.parse(registryops, (Object)nbttagcompound.get("Particle")).resultOrPartial(s2 -> LOGGER.warn("Failed to parse area effect cloud particle options: '{}'", s2)).ifPresent(this::setParticle);
        }
        if (nbttagcompound.contains("potion_contents")) {
            PotionContents.CODEC.parse(registryops, (Object)nbttagcompound.get("potion_contents")).resultOrPartial(s2 -> LOGGER.warn("Failed to parse area effect cloud potions: '{}'", s2)).ifPresent(this::setPotionContents);
        }
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        nbttagcompound.putInt("Age", this.tickCount);
        nbttagcompound.putInt("Duration", this.duration);
        nbttagcompound.putInt("WaitTime", this.waitTime);
        nbttagcompound.putInt("ReapplicationDelay", this.reapplicationDelay);
        nbttagcompound.putInt("DurationOnUse", this.durationOnUse);
        nbttagcompound.putFloat("RadiusOnUse", this.radiusOnUse);
        nbttagcompound.putFloat("RadiusPerTick", this.radiusPerTick);
        nbttagcompound.putFloat("Radius", this.getRadius());
        RegistryOps<NBTBase> registryops = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        nbttagcompound.put("Particle", (NBTBase)Particles.CODEC.encodeStart(registryops, (Object)this.getParticle()).getOrThrow());
        if (this.ownerUUID != null) {
            nbttagcompound.putUUID("Owner", this.ownerUUID);
        }
        if (!this.potionContents.equals(PotionContents.EMPTY)) {
            NBTBase nbtbase = (NBTBase)PotionContents.CODEC.encodeStart(registryops, (Object)this.potionContents).getOrThrow();
            nbttagcompound.put("potion_contents", nbtbase);
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        if (DATA_RADIUS.equals(datawatcherobject)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    public EnumPistonReaction getPistonPushReaction() {
        return EnumPistonReaction.IGNORE;
    }

    @Override
    public EntitySize getDimensions(EntityPose entitypose) {
        return EntitySize.scalable(this.getRadius() * 2.0f, 0.5f);
    }
}

