/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Iterator;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityCreature
extends EntityInsentient {
    protected static final float DEFAULT_WALK_TARGET_VALUE = 0.0f;

    protected EntityCreature(EntityTypes<? extends EntityCreature> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)entitytypes, world);
    }

    public float getWalkTargetValue(BlockPosition blockposition) {
        return this.getWalkTargetValue(blockposition, this.level());
    }

    public float getWalkTargetValue(BlockPosition blockposition, IWorldReader iworldreader) {
        return 0.0f;
    }

    @Override
    public boolean checkSpawnRules(GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn) {
        return this.getWalkTargetValue(this.blockPosition(), generatoraccess) >= 0.0f;
    }

    public boolean isPathFinding() {
        return !this.getNavigation().isDone();
    }

    public boolean isPanicking() {
        PathfinderGoalWrapped pathfindergoalwrapped;
        if (this.brain.hasMemoryValue(MemoryModuleType.IS_PANICKING)) {
            return this.brain.getMemory(MemoryModuleType.IS_PANICKING).isPresent();
        }
        Iterator<PathfinderGoalWrapped> iterator = this.goalSelector.getAvailableGoals().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(pathfindergoalwrapped = iterator.next()).isRunning() || !(pathfindergoalwrapped.getGoal() instanceof PathfinderGoalPanic));
        return true;
    }

    protected boolean shouldStayCloseToLeashHolder() {
        return true;
    }

    @Override
    public void closeRangeLeashBehaviour(Entity entity) {
        super.closeRangeLeashBehaviour(entity);
        if (this.shouldStayCloseToLeashHolder() && !this.isPanicking()) {
            this.goalSelector.enableControlFlag(PathfinderGoal.Type.MOVE);
            float f2 = 2.0f;
            float f1 = this.distanceTo(entity);
            Vec3D vec3d = new Vec3D(entity.getX() - this.getX(), entity.getY() - this.getY(), entity.getZ() - this.getZ()).normalize().scale(Math.max(f1 - 2.0f, 0.0f));
            this.getNavigation().moveTo(this.getX() + vec3d.x, this.getY() + vec3d.y, this.getZ() + vec3d.z, this.followLeashSpeed());
        }
    }

    @Override
    public boolean handleLeashAtDistance(Entity entity, float f2) {
        this.restrictTo(entity.blockPosition(), 5);
        return true;
    }

    protected double followLeashSpeed() {
        return 1.0;
    }
}

