/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerItemMendEvent;

public class EntityExperienceOrb
extends Entity {
    private static final int LIFETIME = 6000;
    private static final int ENTITY_SCAN_PERIOD = 20;
    private static final int MAX_FOLLOW_DIST = 8;
    private static final int ORB_GROUPS_PER_AREA = 40;
    private static final double ORB_MERGE_DISTANCE = 0.5;
    private int age;
    private int health = 5;
    public int value;
    private int count = 1;
    private EntityHuman followingPlayer;

    public EntityExperienceOrb(World world, double d0, double d1, double d2, int i2) {
        this((EntityTypes<? extends EntityExperienceOrb>)EntityTypes.EXPERIENCE_ORB, world);
        this.setPos(d0, d1, d2);
        this.setYRot((float)(this.random.nextDouble() * 360.0));
        this.setDeltaMovement((this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
        this.value = i2;
    }

    public EntityExperienceOrb(EntityTypes<? extends EntityExperienceOrb> entitytypes, World world) {
        super(entitytypes, world);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }

    @Override
    public void tick() {
        Vec3D vec3d;
        double d0;
        super.tick();
        EntityHuman prevTarget = this.followingPlayer;
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.isEyeInFluid(TagsFluid.WATER)) {
            this.setUnderwaterMovement();
        } else {
            this.applyGravity();
        }
        if (this.level().getFluidState(this.blockPosition()).is(TagsFluid.LAVA)) {
            this.setDeltaMovement((this.random.nextFloat() - this.random.nextFloat()) * 0.2f, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        if (this.tickCount % 20 == 1) {
            this.scanForEntities();
        }
        if (this.followingPlayer != null && (this.followingPlayer.isSpectator() || this.followingPlayer.isDeadOrDying())) {
            this.followingPlayer = null;
        }
        boolean cancelled = false;
        if (this.followingPlayer != prevTarget) {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(this, this.followingPlayer, this.followingPlayer != null ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            EntityLiving target = event.getTarget() == null ? null : ((CraftLivingEntity)event.getTarget()).getHandle();
            cancelled = event.isCancelled();
            if (cancelled) {
                this.followingPlayer = prevTarget;
            } else {
                EntityHuman entityHuman = this.followingPlayer = target instanceof EntityHuman ? (EntityHuman)target : null;
            }
        }
        if (this.followingPlayer != null && !cancelled && (d0 = (vec3d = new Vec3D(this.followingPlayer.getX() - this.getX(), this.followingPlayer.getY() + (double)this.followingPlayer.getEyeHeight() / 2.0 - this.getY(), this.followingPlayer.getZ() - this.getZ())).lengthSqr()) < 64.0) {
            double d1 = 1.0 - Math.sqrt(d0) / 8.0;
            this.setDeltaMovement(this.getDeltaMovement().add(vec3d.normalize().scale(d1 * d1 * 0.1)));
        }
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        float f2 = 0.98f;
        if (this.onGround()) {
            f2 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(f2, 0.98, f2));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        ++this.age;
        if (this.age >= 6000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public BlockPosition getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void scanForEntities() {
        if (this.followingPlayer == null || this.followingPlayer.distanceToSqr(this) > 64.0) {
            this.followingPlayer = this.level().getNearestPlayer(this, 8.0);
        }
        if (this.level() instanceof WorldServer) {
            List<EntityExperienceOrb> list = this.level().getEntities(EntityTypeTest.forClass(EntityExperienceOrb.class), this.getBoundingBox().inflate(0.5), this::canMerge);
            for (EntityExperienceOrb entityexperienceorb : list) {
                this.merge(entityexperienceorb);
            }
        }
    }

    public static void award(WorldServer worldserver, Vec3D vec3d, int i2) {
        while (i2 > 0) {
            int j2 = EntityExperienceOrb.getExperienceValue(i2);
            i2 -= j2;
            if (EntityExperienceOrb.tryMergeToExisting(worldserver, vec3d, j2)) continue;
            worldserver.addFreshEntity(new EntityExperienceOrb(worldserver, vec3d.x(), vec3d.y(), vec3d.z(), j2));
        }
    }

    private static boolean tryMergeToExisting(WorldServer worldserver, Vec3D vec3d, int i2) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.ofSize(vec3d, 1.0, 1.0, 1.0);
        int j2 = worldserver.getRandom().nextInt(40);
        List<EntityExperienceOrb> list = worldserver.getEntities(EntityTypeTest.forClass(EntityExperienceOrb.class), axisalignedbb, entityexperienceorb -> EntityExperienceOrb.canMerge(entityexperienceorb, j2, i2));
        if (!list.isEmpty()) {
            EntityExperienceOrb entityexperienceorb2 = list.get(0);
            ++entityexperienceorb2.count;
            entityexperienceorb2.age = 0;
            return true;
        }
        return false;
    }

    private boolean canMerge(EntityExperienceOrb entityexperienceorb) {
        return entityexperienceorb != this && EntityExperienceOrb.canMerge(entityexperienceorb, this.getId(), this.value);
    }

    private static boolean canMerge(EntityExperienceOrb entityexperienceorb, int i2, int j2) {
        return !entityexperienceorb.isRemoved() && (entityexperienceorb.getId() - i2) % 40 == 0 && entityexperienceorb.value == j2;
    }

    private void merge(EntityExperienceOrb entityexperienceorb) {
        this.count += entityexperienceorb.count;
        this.age = Math.min(this.age, entityexperienceorb.age);
        entityexperienceorb.discard(EntityRemoveEvent.Cause.MERGE);
    }

    private void setUnderwaterMovement() {
        Vec3D vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x * (double)0.99f, Math.min(vec3d.y + (double)5.0E-4f, (double)0.06f), vec3d.z * (double)0.99f);
    }

    @Override
    protected void doWaterSplashEffect() {
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        if (this.isInvulnerableTo(damagesource)) {
            return false;
        }
        if (this.level().isClientSide) {
            return true;
        }
        this.markHurt();
        this.health = (int)((float)this.health - f2);
        if (this.health <= 0) {
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        nbttagcompound.putShort("Health", (short)this.health);
        nbttagcompound.putShort("Age", (short)this.age);
        nbttagcompound.putShort("Value", (short)this.value);
        nbttagcompound.putInt("Count", this.count);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        this.health = nbttagcompound.getShort("Health");
        this.age = nbttagcompound.getShort("Age");
        this.value = nbttagcompound.getShort("Value");
        this.count = Math.max(nbttagcompound.getInt("Count"), 1);
    }

    @Override
    public void playerTouch(EntityHuman entityhuman) {
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityhuman;
            if (entityhuman.takeXpDelay == 0) {
                entityhuman.takeXpDelay = CraftEventFactory.callPlayerXpCooldownEvent(entityhuman, 2, PlayerExpCooldownChangeEvent.ChangeReason.PICKUP_ORB).getNewCooldown();
                entityhuman.take(this, 1);
                int i2 = this.repairPlayerItems(entityplayer, this.value);
                if (i2 > 0) {
                    entityhuman.giveExperiencePoints(CraftEventFactory.callPlayerExpChangeEvent(entityhuman, i2).getAmount());
                }
                --this.count;
                if (this.count == 0) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                }
            }
        }
    }

    private int repairPlayerItems(EntityPlayer entityplayer, int i2) {
        Optional<EnchantedItemInUse> optional = EnchantmentManager.getRandomItemWith(EnchantmentEffectComponents.REPAIR_WITH_XP, entityplayer, ItemStack::isDamaged);
        if (optional.isPresent()) {
            int l2;
            ItemStack itemstack = optional.get().itemStack();
            int j2 = EnchantmentManager.modifyDurabilityToRepairFromXp(entityplayer.serverLevel(), itemstack, i2);
            int k2 = Math.min(j2, itemstack.getDamageValue());
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(entityplayer, this, itemstack, optional.get().inSlot(), k2);
            k2 = event.getRepairAmount();
            if (event.isCancelled()) {
                return i2;
            }
            itemstack.setDamageValue(itemstack.getDamageValue() - k2);
            if (k2 > 0 && (l2 = i2 - k2 * i2 / j2) > 0) {
                this.value = l2;
                return this.repairPlayerItems(entityplayer, l2);
            }
            return 0;
        }
        return i2;
    }

    public int getValue() {
        return this.value;
    }

    public int getIcon() {
        return this.value >= 2477 ? 10 : (this.value >= 1237 ? 9 : (this.value >= 617 ? 8 : (this.value >= 307 ? 7 : (this.value >= 149 ? 6 : (this.value >= 73 ? 5 : (this.value >= 37 ? 4 : (this.value >= 17 ? 3 : (this.value >= 7 ? 2 : (this.value >= 3 ? 1 : 0)))))))));
    }

    public static int getExperienceValue(int i2) {
        if (i2 > 162670129) {
            return i2 - 100000;
        }
        if (i2 > 81335063) {
            return 81335063;
        }
        if (i2 > 40667527) {
            return 40667527;
        }
        if (i2 > 20333759) {
            return 20333759;
        }
        if (i2 > 10166857) {
            return 10166857;
        }
        if (i2 > 5083423) {
            return 5083423;
        }
        if (i2 > 2541701) {
            return 2541701;
        }
        if (i2 > 1270849) {
            return 1270849;
        }
        if (i2 > 635413) {
            return 635413;
        }
        if (i2 > 317701) {
            return 317701;
        }
        if (i2 > 158849) {
            return 158849;
        }
        if (i2 > 79423) {
            return 79423;
        }
        if (i2 > 39709) {
            return 39709;
        }
        if (i2 > 19853) {
            return 19853;
        }
        if (i2 > 9923) {
            return 9923;
        }
        if (i2 > 4957) {
            return 4957;
        }
        return i2 >= 2477 ? 2477 : (i2 >= 1237 ? 1237 : (i2 >= 617 ? 617 : (i2 >= 307 ? 307 : (i2 >= 149 ? 149 : (i2 >= 73 ? 73 : (i2 >= 37 ? 37 : (i2 >= 17 ? 17 : (i2 >= 7 ? 7 : (i2 >= 3 ? 3 : 1)))))))));
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntityExperienceOrb(this, entitytrackerentry);
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.AMBIENT;
    }
}

