/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> DATA_MOB_FLAGS_ID = DataWatcher.defineId(EntityInsentient.class, DataWatcherRegistry.BYTE);
    private static final int MOB_FLAG_NO_AI = 1;
    private static final int MOB_FLAG_LEFTHANDED = 2;
    private static final int MOB_FLAG_AGGRESSIVE = 4;
    protected static final int PICKUP_REACH = 1;
    private static final BaseBlockPosition ITEM_PICKUP_REACH = new BaseBlockPosition(1, 0, 1);
    public static final float MAX_WEARING_ARMOR_CHANCE = 0.15f;
    public static final float MAX_PICKUP_LOOT_CHANCE = 0.55f;
    public static final float MAX_ENCHANTED_ARMOR_CHANCE = 0.5f;
    public static final float MAX_ENCHANTED_WEAPON_CHANCE = 0.25f;
    public static final float DEFAULT_EQUIPMENT_DROP_CHANCE = 0.085f;
    public static final float PRESERVE_ITEM_DROP_CHANCE_THRESHOLD = 1.0f;
    public static final int PRESERVE_ITEM_DROP_CHANCE = 2;
    public static final int UPDATE_GOAL_SELECTOR_EVERY_N_TICKS = 2;
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    protected static final MinecraftKey RANDOM_SPAWN_BONUS_ID = MinecraftKey.withDefaultNamespace("random_spawn_bonus");
    public int ambientSoundTime;
    protected int xpReward;
    protected ControllerLook lookControl;
    protected ControllerMove moveControl;
    protected ControllerJump jumpControl;
    private final EntityAIBodyControl bodyRotationControl;
    protected NavigationAbstract navigation;
    public PathfinderGoalSelector goalSelector;
    public PathfinderGoalSelector targetSelector;
    @Nullable
    private EntityLiving target;
    private final EntitySenses sensing;
    private final NonNullList<ItemStack> handItems = NonNullList.withSize(2, ItemStack.EMPTY);
    public final float[] handDropChances = new float[2];
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize(4, ItemStack.EMPTY);
    public final float[] armorDropChances = new float[4];
    private ItemStack bodyArmorItem = ItemStack.EMPTY;
    protected float bodyArmorDropChance;
    private boolean canPickUpLoot;
    private boolean persistenceRequired;
    private final Map<PathType, Float> pathfindingMalus = Maps.newEnumMap(PathType.class);
    @Nullable
    public ResourceKey<LootTable> lootTable;
    public long lootTableSeed;
    @Nullable
    private Leashable.a leashData;
    private BlockPosition restrictCenter = BlockPosition.ZERO;
    private float restrictRadius = -1.0f;
    public boolean aware = true;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> entitytypes, World world) {
        super((EntityTypes<? extends EntityLiving>)entitytypes, world);
        this.goalSelector = new PathfinderGoalSelector(world.getProfilerSupplier());
        this.targetSelector = new PathfinderGoalSelector(world.getProfilerSupplier());
        this.lookControl = new ControllerLook(this);
        this.moveControl = new ControllerMove(this);
        this.jumpControl = new ControllerJump(this);
        this.bodyRotationControl = this.createBodyControl();
        this.navigation = this.createNavigation(world);
        this.sensing = new EntitySenses(this);
        Arrays.fill(this.armorDropChances, 0.085f);
        Arrays.fill(this.handDropChances, 0.085f);
        this.bodyArmorDropChance = 0.085f;
        if (world != null && !world.isClientSide) {
            this.registerGoals();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.persistenceRequired = persistenceRequired;
    }

    protected void registerGoals() {
    }

    public static AttributeProvider.Builder createMobAttributes() {
        return EntityLiving.createLivingAttributes().add(GenericAttributes.FOLLOW_RANGE, 16.0);
    }

    protected NavigationAbstract createNavigation(World world) {
        return new Navigation(this, world);
    }

    protected boolean shouldPassengersInheritMalus() {
        return false;
    }

    public float getPathfindingMalus(PathType pathtype) {
        EntityInsentient entityinsentient1;
        Entity entity = this.getControlledVehicle();
        EntityInsentient entityinsentient = entity instanceof EntityInsentient && (entityinsentient1 = (EntityInsentient)entity).shouldPassengersInheritMalus() ? entityinsentient1 : this;
        Float ofloat = entityinsentient.pathfindingMalus.get((Object)pathtype);
        return ofloat == null ? pathtype.getMalus() : ofloat.floatValue();
    }

    public void setPathfindingMalus(PathType pathtype, float f2) {
        this.pathfindingMalus.put(pathtype, Float.valueOf(f2));
    }

    public void onPathfindingStart() {
    }

    public void onPathfindingDone() {
    }

    protected EntityAIBodyControl createBodyControl() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook getLookControl() {
        return this.lookControl;
    }

    public ControllerMove getMoveControl() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.getMoveControl();
        }
        return this.moveControl;
    }

    public ControllerJump getJumpControl() {
        return this.jumpControl;
    }

    public NavigationAbstract getNavigation() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.getNavigation();
        }
        return this.navigation;
    }

    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (!this.isNoAi() && entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient1 = (EntityInsentient)entity;
            if (entity.canControlVehicle()) {
                EntityInsentient entityinsentient = entityinsentient1;
                return entityinsentient;
            }
        }
        EntityLiving entityinsentient = null;
        return entityinsentient;
    }

    public EntitySenses getSensing() {
        return this.sensing;
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        return this.target;
    }

    @Nullable
    protected final EntityLiving getTargetFromBrain() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public void setTarget(@Nullable EntityLiving entityliving) {
        this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.getTarget() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.getTarget() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.getTarget().isAlive() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.level().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.target = entityliving;
        return true;
    }

    @Override
    public boolean canAttackType(EntityTypes<?> entitytypes) {
        return entitytypes != EntityTypes.GHAST;
    }

    public boolean canFireProjectileWeapon(ItemProjectileWeapon itemprojectileweapon) {
        return false;
    }

    public void ate() {
        this.gameEvent(GameEvent.EAT);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_MOB_FLAGS_ID, (byte)0);
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    public void playAmbientSound() {
        this.makeSound(this.getAmbientSound());
    }

    @Override
    public void baseTick() {
        super.baseTick();
        this.level().getProfiler().push("mobBaseTick");
        if (this.isAlive() && this.random.nextInt(1000) < this.ambientSoundTime++) {
            this.resetAmbientSoundTime();
            this.playAmbientSound();
        }
        this.level().getProfiler().pop();
    }

    @Override
    protected void playHurtSound(DamageSource damagesource) {
        this.resetAmbientSoundTime();
        super.playHurtSound(damagesource);
    }

    private void resetAmbientSoundTime() {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
    }

    @Override
    protected int getBaseExperienceReward() {
        if (this.xpReward > 0) {
            int j2;
            int i2 = this.xpReward;
            for (j2 = 0; j2 < this.armorItems.size(); ++j2) {
                if (this.armorItems.get(j2).isEmpty() || !(this.armorDropChances[j2] <= 1.0f)) continue;
                i2 += 1 + this.random.nextInt(3);
            }
            for (j2 = 0; j2 < this.handItems.size(); ++j2) {
                if (this.handItems.get(j2).isEmpty() || !(this.handDropChances[j2] <= 1.0f)) continue;
                i2 += 1 + this.random.nextInt(3);
            }
            if (!this.bodyArmorItem.isEmpty() && this.bodyArmorDropChance <= 1.0f) {
                i2 += 1 + this.random.nextInt(3);
            }
            return i2;
        }
        return this.xpReward;
    }

    public void spawnAnim() {
        if (this.level().isClientSide) {
            for (int i2 = 0; i2 < 20; ++i2) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                double d3 = 10.0;
                this.level().addParticle(Particles.POOF, this.getX(1.0) - d0 * 10.0, this.getRandomY() - d1 * 10.0, this.getRandomZ(1.0) - d2 * 10.0, d0, d1, d2);
            }
        } else {
            this.level().broadcastEntityEvent(this, (byte)20);
        }
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 20) {
            this.spawnAnim();
        } else {
            super.handleEntityEvent(b0);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.tickCount % 5 == 0) {
            this.updateControlFlags();
        }
    }

    protected void updateControlFlags() {
        boolean flag = !(this.getControllingPassenger() instanceof EntityInsentient);
        boolean flag1 = !(this.getVehicle() instanceof EntityBoat);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.MOVE, flag);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.JUMP, flag && flag1);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.LOOK, flag);
    }

    @Override
    protected float tickHeadTurn(float f2, float f1) {
        this.bodyRotationControl.clientTick();
        return f1;
    }

    @Nullable
    protected SoundEffect getAmbientSound() {
        return null;
    }

    public SoundEffect getAmbientSound0() {
        return this.getAmbientSound();
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putBoolean("CanPickUpLoot", this.canPickUpLoot());
        nbttagcompound.putBoolean("PersistenceRequired", this.persistenceRequired);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemstack : this.armorItems) {
            if (!itemstack.isEmpty()) {
                nbttaglist.add(itemstack.save(this.registryAccess()));
                continue;
            }
            nbttaglist.add(new NBTTagCompound());
        }
        nbttagcompound.put("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (float f2 : this.armorDropChances) {
            nbttaglist1.add(NBTTagFloat.valueOf(f2));
        }
        nbttagcompound.put("ArmorDropChances", nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (ItemStack itemstack1 : this.handItems) {
            if (!itemstack1.isEmpty()) {
                nbttaglist2.add(itemstack1.save(this.registryAccess()));
                continue;
            }
            nbttaglist2.add(new NBTTagCompound());
        }
        nbttagcompound.put("HandItems", nbttaglist2);
        NBTTagList nbttaglist3 = new NBTTagList();
        for (float f1 : this.handDropChances) {
            nbttaglist3.add(NBTTagFloat.valueOf(f1));
        }
        nbttagcompound.put("HandDropChances", nbttaglist3);
        if (!this.bodyArmorItem.isEmpty()) {
            nbttagcompound.put("body_armor_item", this.bodyArmorItem.save(this.registryAccess()));
            nbttagcompound.putFloat("body_armor_drop_chance", this.bodyArmorDropChance);
        }
        this.writeLeashData(nbttagcompound, this.leashData);
        nbttagcompound.putBoolean("LeftHanded", this.isLeftHanded());
        if (this.lootTable != null) {
            nbttagcompound.putString("DeathLootTable", this.lootTable.location().toString());
            if (this.lootTableSeed != 0L) {
                nbttagcompound.putLong("DeathLootTableSeed", this.lootTableSeed);
            }
        }
        if (this.isNoAi()) {
            nbttagcompound.putBoolean("NoAI", this.isNoAi());
        }
        nbttagcompound.putBoolean("Bukkit.Aware", this.aware);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompound1;
        int i2;
        NBTTagList nbttaglist;
        boolean data;
        super.readAdditionalSaveData(nbttagcompound);
        if (nbttagcompound.contains("CanPickUpLoot", 1)) {
            data = nbttagcompound.getBoolean("CanPickUpLoot");
            if (EntityInsentient.isLevelAtLeast(nbttagcompound, 1) || data) {
                this.setCanPickUpLoot(data);
            }
        }
        data = nbttagcompound.getBoolean("PersistenceRequired");
        if (EntityInsentient.isLevelAtLeast(nbttagcompound, 1) || data) {
            this.persistenceRequired = data;
        }
        if (nbttagcompound.contains("ArmorItems", 9)) {
            nbttaglist = nbttagcompound.getList("ArmorItems", 10);
            for (i2 = 0; i2 < this.armorItems.size(); ++i2) {
                nbttagcompound1 = nbttaglist.getCompound(i2);
                this.armorItems.set(i2, ItemStack.parseOptional(this.registryAccess(), nbttagcompound1));
            }
        }
        if (nbttagcompound.contains("ArmorDropChances", 9)) {
            nbttaglist = nbttagcompound.getList("ArmorDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.armorDropChances[i2] = nbttaglist.getFloat(i2);
            }
        }
        if (nbttagcompound.contains("HandItems", 9)) {
            nbttaglist = nbttagcompound.getList("HandItems", 10);
            for (i2 = 0; i2 < this.handItems.size(); ++i2) {
                nbttagcompound1 = nbttaglist.getCompound(i2);
                this.handItems.set(i2, ItemStack.parseOptional(this.registryAccess(), nbttagcompound1));
            }
        }
        if (nbttagcompound.contains("HandDropChances", 9)) {
            nbttaglist = nbttagcompound.getList("HandDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.handDropChances[i2] = nbttaglist.getFloat(i2);
            }
        }
        if (nbttagcompound.contains("body_armor_item", 10)) {
            this.bodyArmorItem = ItemStack.parse(this.registryAccess(), nbttagcompound.getCompound("body_armor_item")).orElse(ItemStack.EMPTY);
            this.bodyArmorDropChance = nbttagcompound.getFloat("body_armor_drop_chance");
        } else {
            this.bodyArmorItem = ItemStack.EMPTY;
        }
        this.leashData = this.readLeashData(nbttagcompound);
        this.setLeftHanded(nbttagcompound.getBoolean("LeftHanded"));
        if (nbttagcompound.contains("DeathLootTable", 8)) {
            this.lootTable = ResourceKey.create(Registries.LOOT_TABLE, MinecraftKey.parse(nbttagcompound.getString("DeathLootTable")));
            this.lootTableSeed = nbttagcompound.getLong("DeathLootTableSeed");
        }
        this.setNoAi(nbttagcompound.getBoolean("NoAI"));
        if (nbttagcompound.contains("Bukkit.Aware")) {
            this.aware = nbttagcompound.getBoolean("Bukkit.Aware");
        }
    }

    @Override
    protected void dropFromLootTable(DamageSource damagesource, boolean flag) {
        super.dropFromLootTable(damagesource, flag);
        this.lootTable = null;
    }

    @Override
    public final ResourceKey<LootTable> getLootTable() {
        return this.lootTable == null ? this.getDefaultLootTable() : this.lootTable;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return super.getLootTable();
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setZza(float f2) {
        this.zza = f2;
    }

    public void setYya(float f2) {
        this.yya = f2;
    }

    public void setXxa(float f2) {
        this.xxa = f2;
    }

    @Override
    public void setSpeed(float f2) {
        super.setSpeed(f2);
        this.setZza(f2);
    }

    public void stopInPlace() {
        this.getNavigation().stop();
        this.setXxa(0.0f);
        this.setYya(0.0f);
        this.setSpeed(0.0f);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.level().getProfiler().push("looting");
        if (!this.level().isClientSide && this.canPickUpLoot() && this.isAlive() && !this.dead && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            BaseBlockPosition baseblockposition = this.getPickupReach();
            List<EntityItem> list = this.level().getEntitiesOfClass(EntityItem.class, this.getBoundingBox().inflate(baseblockposition.getX(), baseblockposition.getY(), baseblockposition.getZ()));
            for (EntityItem entityitem : list) {
                if (entityitem.isRemoved() || entityitem.getItem().isEmpty() || entityitem.hasPickUpDelay() || !this.wantsToPickUp(entityitem.getItem())) continue;
                this.pickUpItem(entityitem);
            }
        }
        this.level().getProfiler().pop();
    }

    protected BaseBlockPosition getPickupReach() {
        return ITEM_PICKUP_REACH;
    }

    protected void pickUpItem(EntityItem entityitem) {
        ItemStack itemstack = entityitem.getItem();
        ItemStack itemstack1 = this.equipItemIfPossible(itemstack.copy(), entityitem);
        if (!itemstack1.isEmpty()) {
            this.onItemPickup(entityitem);
            this.take(entityitem, itemstack1.getCount());
            itemstack.shrink(itemstack1.getCount());
            if (itemstack.isEmpty()) {
                entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack equipItemIfPossible(ItemStack itemstack) {
        return this.equipItemIfPossible(itemstack, null);
    }

    public ItemStack equipItemIfPossible(ItemStack itemstack, EntityItem entityitem) {
        boolean canPickup;
        EnumItemSlot enumitemslot = this.getEquipmentSlotForItem(itemstack);
        ItemStack itemstack1 = this.getItemBySlot(enumitemslot);
        boolean flag = this.canReplaceCurrentItem(itemstack, itemstack1);
        if (enumitemslot.isArmor() && !flag) {
            enumitemslot = EnumItemSlot.MAINHAND;
            itemstack1 = this.getItemBySlot(enumitemslot);
            flag = itemstack1.isEmpty();
        }
        boolean bl = canPickup = flag && this.canHoldItem(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.getEquipmentDropChance(enumitemslot);
            if (!itemstack1.isEmpty() && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.spawnAtLocation(itemstack1);
                this.forceDrops = false;
            }
            ItemStack itemstack2 = enumitemslot.limit(itemstack);
            this.setItemSlotAndDropWhenKilled(enumitemslot, itemstack2);
            return itemstack2;
        }
        return ItemStack.EMPTY;
    }

    protected void setItemSlotAndDropWhenKilled(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.setItemSlot(enumitemslot, itemstack);
        this.setGuaranteedDrop(enumitemslot);
        this.persistenceRequired = true;
    }

    public void setGuaranteedDrop(EnumItemSlot enumitemslot) {
        switch (enumitemslot.getType()) {
            case HAND: {
                this.handDropChances[enumitemslot.getIndex()] = 2.0f;
                break;
            }
            case HUMANOID_ARMOR: {
                this.armorDropChances[enumitemslot.getIndex()] = 2.0f;
                break;
            }
            case ANIMAL_ARMOR: {
                this.bodyArmorDropChance = 2.0f;
            }
        }
    }

    protected boolean canReplaceCurrentItem(ItemStack itemstack, ItemStack itemstack1) {
        if (itemstack1.isEmpty()) {
            return true;
        }
        if (itemstack.getItem() instanceof ItemSword) {
            double d1;
            if (!(itemstack1.getItem() instanceof ItemSword)) {
                return true;
            }
            double d0 = this.getApproximateAttackDamageWithItem(itemstack);
            return d0 != (d1 = this.getApproximateAttackDamageWithItem(itemstack1)) ? d0 > d1 : this.canReplaceEqualItem(itemstack, itemstack1);
        }
        if (itemstack.getItem() instanceof ItemBow && itemstack1.getItem() instanceof ItemBow) {
            return this.canReplaceEqualItem(itemstack, itemstack1);
        }
        if (itemstack.getItem() instanceof ItemCrossbow && itemstack1.getItem() instanceof ItemCrossbow) {
            return this.canReplaceEqualItem(itemstack, itemstack1);
        }
        Item item = itemstack.getItem();
        if (item instanceof ItemArmor) {
            ItemArmor itemarmor = (ItemArmor)item;
            if (EnchantmentManager.has(itemstack1, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
                return false;
            }
            if (!(itemstack1.getItem() instanceof ItemArmor)) {
                return true;
            }
            ItemArmor itemarmor1 = (ItemArmor)itemstack1.getItem();
            return itemarmor.getDefense() != itemarmor1.getDefense() ? itemarmor.getDefense() > itemarmor1.getDefense() : (itemarmor.getToughness() != itemarmor1.getToughness() ? itemarmor.getToughness() > itemarmor1.getToughness() : this.canReplaceEqualItem(itemstack, itemstack1));
        }
        if (itemstack.getItem() instanceof ItemTool) {
            if (itemstack1.getItem() instanceof ItemBlock) {
                return true;
            }
            if (itemstack1.getItem() instanceof ItemTool) {
                double d1;
                double d0 = this.getApproximateAttackDamageWithItem(itemstack);
                if (d0 != (d1 = this.getApproximateAttackDamageWithItem(itemstack1))) {
                    return d0 > d1;
                }
                return this.canReplaceEqualItem(itemstack, itemstack1);
            }
        }
        return false;
    }

    private double getApproximateAttackDamageWithItem(ItemStack itemstack) {
        ItemAttributeModifiers itemattributemodifiers = itemstack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        return itemattributemodifiers.compute(this.getAttributeBaseValue(GenericAttributes.ATTACK_DAMAGE), EnumItemSlot.MAINHAND);
    }

    public boolean canReplaceEqualItem(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.getDamageValue() < itemstack1.getDamageValue() ? true : EntityInsentient.hasAnyComponentExceptDamage(itemstack) && !EntityInsentient.hasAnyComponentExceptDamage(itemstack1);
    }

    private static boolean hasAnyComponentExceptDamage(ItemStack itemstack) {
        DataComponentMap datacomponentmap = itemstack.getComponents();
        int i2 = datacomponentmap.size();
        return i2 > 1 || i2 == 1 && !datacomponentmap.has(DataComponents.DAMAGE);
    }

    public boolean canHoldItem(ItemStack itemstack) {
        return true;
    }

    public boolean wantsToPickUp(ItemStack itemstack) {
        return this.canHoldItem(itemstack);
    }

    public boolean removeWhenFarAway(double d0) {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return this.isPassenger();
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == EnumDifficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.isPersistenceRequired() && !this.requiresCustomPersistence()) {
            EntityHuman entityhuman = this.level().getNearestPlayer(this, -1.0);
            if (entityhuman != null) {
                int i2;
                int j2;
                double d0 = entityhuman.distanceToSqr(this);
                if (d0 > (double)(j2 = (i2 = this.getType().getCategory().getDespawnDistance()) * i2) && this.removeWhenFarAway(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                int k2 = this.getType().getCategory().getNoDespawnDistance();
                int l2 = k2 * k2;
                if (this.noActionTime > 600 && this.random.nextInt(800) == 0 && d0 > (double)l2 && this.removeWhenFarAway(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                } else if (d0 < (double)l2) {
                    this.noActionTime = 0;
                }
            }
        } else {
            this.noActionTime = 0;
        }
    }

    @Override
    protected final void serverAiStep() {
        ++this.noActionTime;
        if (!this.aware) {
            return;
        }
        GameProfilerFiller gameprofilerfiller = this.level().getProfiler();
        gameprofilerfiller.push("sensing");
        this.sensing.tick();
        gameprofilerfiller.pop();
        int i2 = this.tickCount + this.getId();
        if (i2 % 2 != 0 && this.tickCount > 1) {
            gameprofilerfiller.push("targetSelector");
            this.targetSelector.tickRunningGoals(false);
            gameprofilerfiller.pop();
            gameprofilerfiller.push("goalSelector");
            this.goalSelector.tickRunningGoals(false);
            gameprofilerfiller.pop();
        } else {
            gameprofilerfiller.push("targetSelector");
            this.targetSelector.tick();
            gameprofilerfiller.pop();
            gameprofilerfiller.push("goalSelector");
            this.goalSelector.tick();
            gameprofilerfiller.pop();
        }
        gameprofilerfiller.push("navigation");
        this.navigation.tick();
        gameprofilerfiller.pop();
        gameprofilerfiller.push("mob tick");
        this.customServerAiStep();
        gameprofilerfiller.pop();
        gameprofilerfiller.push("controls");
        gameprofilerfiller.push("move");
        this.moveControl.tick();
        gameprofilerfiller.popPush("look");
        this.lookControl.tick();
        gameprofilerfiller.popPush("jump");
        this.jumpControl.tick();
        gameprofilerfiller.pop();
        gameprofilerfiller.pop();
        this.sendDebugPackets();
    }

    protected void sendDebugPackets() {
        PacketDebug.sendGoalSelector(this.level(), this, this.goalSelector);
    }

    protected void customServerAiStep() {
    }

    public int getMaxHeadXRot() {
        return 40;
    }

    public int getMaxHeadYRot() {
        return 75;
    }

    protected void clampHeadRotationToBody() {
        float f2 = this.getMaxHeadYRot();
        float f1 = this.getYHeadRot();
        float f22 = MathHelper.wrapDegrees(this.yBodyRot - f1);
        float f3 = MathHelper.clamp(MathHelper.wrapDegrees(this.yBodyRot - f1), -f2, f2);
        float f4 = f1 + f22 - f3;
        this.setYHeadRot(f4);
    }

    public int getHeadRotSpeed() {
        return 10;
    }

    public void lookAt(Entity entity, float f2, float f1) {
        double d2;
        double d0 = entity.getX() - this.getX();
        double d1 = entity.getZ() - this.getZ();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            d2 = entityliving.getEyeY() - this.getEyeY();
        } else {
            d2 = (entity.getBoundingBox().minY + entity.getBoundingBox().maxY) / 2.0 - this.getEyeY();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f22 = (float)(MathHelper.atan2(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(MathHelper.atan2(d2, d3) * 57.2957763671875));
        this.setXRot(this.rotlerp(this.getXRot(), f3, f1));
        this.setYRot(this.rotlerp(this.getYRot(), f22, f2));
    }

    private float rotlerp(float f2, float f1, float f22) {
        float f3 = MathHelper.wrapDegrees(f1 - f2);
        if (f3 > f22) {
            f3 = f22;
        }
        if (f3 < -f22) {
            f3 = -f22;
        }
        return f2 + f3;
    }

    public static boolean checkMobSpawnRules(EntityTypes<? extends EntityInsentient> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition blockposition1 = blockposition.below();
        return enummobspawn == EnumMobSpawn.SPAWNER || generatoraccess.getBlockState(blockposition1).isValidSpawn(generatoraccess, blockposition1, entitytypes);
    }

    public boolean checkSpawnRules(GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn) {
        return true;
    }

    public boolean checkSpawnObstruction(IWorldReader iworldreader) {
        return !iworldreader.containsAnyLiquid(this.getBoundingBox()) && iworldreader.isUnobstructed(this);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    public boolean isMaxGroupSizeReached(int i2) {
        return false;
    }

    @Override
    public int getMaxFallDistance() {
        if (this.getTarget() == null) {
            return this.getComfortableFallDistance(0.0f);
        }
        int i2 = (int)(this.getHealth() - this.getMaxHealth() * 0.33f);
        if ((i2 -= (3 - this.level().getDifficulty().getId()) * 4) < 0) {
            i2 = 0;
        }
        return this.getComfortableFallDistance(i2);
    }

    @Override
    public Iterable<ItemStack> getHandSlots() {
        return this.handItems;
    }

    @Override
    public Iterable<ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    public ItemStack getBodyArmorItem() {
        return this.bodyArmorItem;
    }

    @Override
    public boolean canUseSlot(EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.BODY;
    }

    public boolean isWearingBodyArmor() {
        return !this.getItemBySlot(EnumItemSlot.BODY).isEmpty();
    }

    public boolean isBodyArmorItem(ItemStack itemstack) {
        return false;
    }

    public void setBodyArmorItem(ItemStack itemstack) {
        this.setItemSlotAndDropWhenKilled(EnumItemSlot.BODY, itemstack);
    }

    @Override
    public Iterable<ItemStack> getArmorAndBodyArmorSlots() {
        return this.bodyArmorItem.isEmpty() ? this.armorItems : Iterables.concat(this.armorItems, List.of(this.bodyArmorItem));
    }

    @Override
    public ItemStack getItemBySlot(EnumItemSlot enumitemslot) {
        return switch (enumitemslot.getType()) {
            case EnumItemSlot.Function.HAND -> this.handItems.get(enumitemslot.getIndex());
            case EnumItemSlot.Function.HUMANOID_ARMOR -> this.armorItems.get(enumitemslot.getIndex());
            case EnumItemSlot.Function.ANIMAL_ARMOR -> this.bodyArmorItem;
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.verifyEquippedItem(itemstack);
        switch (enumitemslot.getType()) {
            case HAND: {
                this.onEquipItem(enumitemslot, this.handItems.set(enumitemslot.getIndex(), itemstack), itemstack);
                break;
            }
            case HUMANOID_ARMOR: {
                this.onEquipItem(enumitemslot, this.armorItems.set(enumitemslot.getIndex(), itemstack), itemstack);
                break;
            }
            case ANIMAL_ARMOR: {
                ItemStack itemstack1 = this.bodyArmorItem;
                this.bodyArmorItem = itemstack;
                this.onEquipItem(enumitemslot, itemstack1, itemstack);
            }
        }
    }

    @Override
    protected void dropCustomDeathLoot(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.dropCustomDeathLoot(worldserver, damagesource, flag);
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            ItemStack itemstack = this.getItemBySlot(enumitemslot);
            float f2 = this.getEquipmentDropChance(enumitemslot);
            if (f2 == 0.0f) continue;
            boolean flag1 = f2 > 1.0f;
            Entity entity = damagesource.getEntity();
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                World world = this.level();
                if (world instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world;
                    f2 = EnchantmentManager.processEquipmentDropChance(worldserver1, entityliving, damagesource, f2);
                }
            }
            if (itemstack.isEmpty() || EnchantmentManager.has(itemstack, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || !flag && !flag1 || !(this.random.nextFloat() < f2)) continue;
            if (!flag1 && itemstack.isDamageableItem()) {
                itemstack.setDamageValue(itemstack.getMaxDamage() - this.random.nextInt(1 + this.random.nextInt(Math.max(itemstack.getMaxDamage() - 3, 1))));
            }
            this.spawnAtLocation(itemstack);
            this.setItemSlot(enumitemslot, ItemStack.EMPTY);
        }
    }

    protected float getEquipmentDropChance(EnumItemSlot enumitemslot) {
        return switch (enumitemslot.getType()) {
            case EnumItemSlot.Function.HAND -> this.handDropChances[enumitemslot.getIndex()];
            case EnumItemSlot.Function.HUMANOID_ARMOR -> this.armorDropChances[enumitemslot.getIndex()];
            case EnumItemSlot.Function.ANIMAL_ARMOR -> this.bodyArmorDropChance;
            default -> throw new MatchException(null, null);
        };
    }

    public void dropPreservedEquipment() {
        this.dropPreservedEquipment(itemstack -> true);
    }

    public Set<EnumItemSlot> dropPreservedEquipment(Predicate<ItemStack> predicate) {
        HashSet<EnumItemSlot> set = new HashSet<EnumItemSlot>();
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            ItemStack itemstack = this.getItemBySlot(enumitemslot);
            if (itemstack.isEmpty()) continue;
            if (!predicate.test(itemstack)) {
                set.add(enumitemslot);
                continue;
            }
            double d0 = this.getEquipmentDropChance(enumitemslot);
            if (!(d0 > 1.0)) continue;
            this.setItemSlot(enumitemslot, ItemStack.EMPTY);
            this.spawnAtLocation(itemstack);
        }
        return set;
    }

    private LootParams createEquipmentParams(WorldServer worldserver) {
        return new LootParams.a(worldserver).withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.THIS_ENTITY, this).create(LootContextParameterSets.EQUIPMENT);
    }

    public void equip(EquipmentTable equipmenttable) {
        this.equip(equipmenttable.lootTable(), equipmenttable.slotDropChances());
    }

    public void equip(ResourceKey<LootTable> resourcekey, Map<EnumItemSlot, Float> map) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.equip(resourcekey, this.createEquipmentParams(worldserver), map);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (randomsource.nextFloat() < 0.15f * difficultydamagescaler.getSpecialMultiplier()) {
            float f2;
            int i2 = randomsource.nextInt(2);
            float f3 = f2 = this.level().getDifficulty() == EnumDifficulty.HARD ? 0.1f : 0.25f;
            if (randomsource.nextFloat() < 0.095f) {
                ++i2;
            }
            if (randomsource.nextFloat() < 0.095f) {
                ++i2;
            }
            if (randomsource.nextFloat() < 0.095f) {
                ++i2;
            }
            boolean flag = true;
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                Item item;
                if (enumitemslot.getType() != EnumItemSlot.Function.HUMANOID_ARMOR) continue;
                ItemStack itemstack = this.getItemBySlot(enumitemslot);
                if (!flag && randomsource.nextFloat() < f2) break;
                flag = false;
                if (!itemstack.isEmpty() || (item = EntityInsentient.getEquipmentForSlot(enumitemslot, i2)) == null) continue;
                this.setItemSlot(enumitemslot, new ItemStack(item));
            }
        }
    }

    @Nullable
    public static Item getEquipmentForSlot(EnumItemSlot enumitemslot, int i2) {
        switch (enumitemslot) {
            case HEAD: {
                if (i2 == 0) {
                    return Items.LEATHER_HELMET;
                }
                if (i2 == 1) {
                    return Items.GOLDEN_HELMET;
                }
                if (i2 == 2) {
                    return Items.CHAINMAIL_HELMET;
                }
                if (i2 == 3) {
                    return Items.IRON_HELMET;
                }
                if (i2 == 4) {
                    return Items.DIAMOND_HELMET;
                }
            }
            case CHEST: {
                if (i2 == 0) {
                    return Items.LEATHER_CHESTPLATE;
                }
                if (i2 == 1) {
                    return Items.GOLDEN_CHESTPLATE;
                }
                if (i2 == 2) {
                    return Items.CHAINMAIL_CHESTPLATE;
                }
                if (i2 == 3) {
                    return Items.IRON_CHESTPLATE;
                }
                if (i2 == 4) {
                    return Items.DIAMOND_CHESTPLATE;
                }
            }
            case LEGS: {
                if (i2 == 0) {
                    return Items.LEATHER_LEGGINGS;
                }
                if (i2 == 1) {
                    return Items.GOLDEN_LEGGINGS;
                }
                if (i2 == 2) {
                    return Items.CHAINMAIL_LEGGINGS;
                }
                if (i2 == 3) {
                    return Items.IRON_LEGGINGS;
                }
                if (i2 == 4) {
                    return Items.DIAMOND_LEGGINGS;
                }
            }
            case FEET: {
                if (i2 == 0) {
                    return Items.LEATHER_BOOTS;
                }
                if (i2 == 1) {
                    return Items.GOLDEN_BOOTS;
                }
                if (i2 == 2) {
                    return Items.CHAINMAIL_BOOTS;
                }
                if (i2 == 3) {
                    return Items.IRON_BOOTS;
                }
                if (i2 != 4) break;
                return Items.DIAMOND_BOOTS;
            }
        }
        return null;
    }

    protected void populateDefaultEquipmentEnchantments(WorldAccess worldaccess, RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        this.enchantSpawnedWeapon(worldaccess, randomsource, difficultydamagescaler);
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            if (enumitemslot.getType() != EnumItemSlot.Function.HUMANOID_ARMOR) continue;
            this.enchantSpawnedArmor(worldaccess, randomsource, enumitemslot, difficultydamagescaler);
        }
    }

    protected void enchantSpawnedWeapon(WorldAccess worldaccess, RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        this.enchantSpawnedEquipment(worldaccess, EnumItemSlot.MAINHAND, randomsource, 0.25f, difficultydamagescaler);
    }

    protected void enchantSpawnedArmor(WorldAccess worldaccess, RandomSource randomsource, EnumItemSlot enumitemslot, DifficultyDamageScaler difficultydamagescaler) {
        this.enchantSpawnedEquipment(worldaccess, enumitemslot, randomsource, 0.5f, difficultydamagescaler);
    }

    private void enchantSpawnedEquipment(WorldAccess worldaccess, EnumItemSlot enumitemslot, RandomSource randomsource, float f2, DifficultyDamageScaler difficultydamagescaler) {
        ItemStack itemstack = this.getItemBySlot(enumitemslot);
        if (!itemstack.isEmpty() && randomsource.nextFloat() < f2 * difficultydamagescaler.getSpecialMultiplier()) {
            EnchantmentManager.enchantItemFromProvider(itemstack, worldaccess.registryAccess(), VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, difficultydamagescaler, randomsource);
            this.setItemSlot(enumitemslot, itemstack);
        }
    }

    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.getRandom();
        AttributeModifiable attributemodifiable = Objects.requireNonNull(this.getAttribute(GenericAttributes.FOLLOW_RANGE));
        if (!attributemodifiable.hasModifier(RANDOM_SPAWN_BONUS_ID)) {
            attributemodifiable.addPermanentModifier(new AttributeModifier(RANDOM_SPAWN_BONUS_ID, randomsource.triangle(0.0, 0.11485000000000001), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        this.setLeftHanded(randomsource.nextFloat() < 0.05f);
        return groupdataentity;
    }

    public void setPersistenceRequired() {
        this.persistenceRequired = true;
    }

    @Override
    public void setDropChance(EnumItemSlot enumitemslot, float f2) {
        switch (enumitemslot.getType()) {
            case HAND: {
                this.handDropChances[enumitemslot.getIndex()] = f2;
                break;
            }
            case HUMANOID_ARMOR: {
                this.armorDropChances[enumitemslot.getIndex()] = f2;
                break;
            }
            case ANIMAL_ARMOR: {
                this.bodyArmorDropChance = f2;
            }
        }
    }

    public boolean canPickUpLoot() {
        return this.canPickUpLoot;
    }

    public void setCanPickUpLoot(boolean flag) {
        this.canPickUpLoot = flag;
    }

    @Override
    public boolean canTakeItem(ItemStack itemstack) {
        EnumItemSlot enumitemslot = this.getEquipmentSlotForItem(itemstack);
        return this.getItemBySlot(enumitemslot).isEmpty() && this.canPickUpLoot();
    }

    public boolean isPersistenceRequired() {
        return this.persistenceRequired;
    }

    @Override
    public final EnumInteractionResult interact(EntityHuman entityhuman, EnumHand enumhand) {
        if (!this.isAlive()) {
            return EnumInteractionResult.PASS;
        }
        EnumInteractionResult enuminteractionresult = this.checkAndHandleImportantInteractions(entityhuman, enumhand);
        if (enuminteractionresult.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, entityhuman);
            return enuminteractionresult;
        }
        EnumInteractionResult enuminteractionresult1 = super.interact(entityhuman, enumhand);
        if (enuminteractionresult1 != EnumInteractionResult.PASS) {
            return enuminteractionresult1;
        }
        enuminteractionresult = this.mobInteract(entityhuman, enumhand);
        if (enuminteractionresult.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, entityhuman);
            return enuminteractionresult;
        }
        return EnumInteractionResult.PASS;
    }

    private EnumInteractionResult checkAndHandleImportantInteractions(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (itemstack.is(Items.NAME_TAG) && (enuminteractionresult = itemstack.interactLivingEntity(entityhuman, this, enumhand)).consumesAction()) {
            return enuminteractionresult;
        }
        if (itemstack.getItem() instanceof ItemMonsterEgg) {
            if (this.level() instanceof WorldServer) {
                ItemMonsterEgg itemmonsteregg = (ItemMonsterEgg)itemstack.getItem();
                Optional<EntityInsentient> optional = itemmonsteregg.spawnOffspringFromSpawnEgg(entityhuman, this, this.getType(), (WorldServer)this.level(), this.position(), itemstack);
                optional.ifPresent(entityinsentient -> this.onOffspringSpawnedFromEgg(entityhuman, (EntityInsentient)entityinsentient));
                return optional.isPresent() ? EnumInteractionResult.SUCCESS : EnumInteractionResult.PASS;
            }
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.PASS;
    }

    protected void onOffspringSpawnedFromEgg(EntityHuman entityhuman, EntityInsentient entityinsentient) {
    }

    protected EnumInteractionResult mobInteract(EntityHuman entityhuman, EnumHand enumhand) {
        return EnumInteractionResult.PASS;
    }

    public boolean isWithinRestriction() {
        return this.isWithinRestriction(this.blockPosition());
    }

    public boolean isWithinRestriction(BlockPosition blockposition) {
        return this.restrictRadius == -1.0f ? true : this.restrictCenter.distSqr(blockposition) < (double)(this.restrictRadius * this.restrictRadius);
    }

    public void restrictTo(BlockPosition blockposition, int i2) {
        this.restrictCenter = blockposition;
        this.restrictRadius = i2;
    }

    public BlockPosition getRestrictCenter() {
        return this.restrictCenter;
    }

    public float getRestrictRadius() {
        return this.restrictRadius;
    }

    public void clearRestriction() {
        this.restrictRadius = -1.0f;
    }

    public boolean hasRestriction() {
        return this.restrictRadius != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, boolean flag) {
        return this.convertTo(entitytypes, flag, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, boolean flag, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.isRemoved()) {
            return null;
        }
        EntityInsentient t0 = (EntityInsentient)entitytypes.create(this.level());
        if (t0 == null) {
            return null;
        }
        t0.copyPosition(this);
        t0.setBaby(this.isBaby());
        t0.setNoAi(this.isNoAi());
        if (this.hasCustomName()) {
            t0.setCustomName(this.getCustomName());
            t0.setCustomNameVisible(this.isCustomNameVisible());
        }
        if (this.isPersistenceRequired()) {
            t0.setPersistenceRequired();
        }
        t0.setInvulnerable(this.isInvulnerable());
        if (flag) {
            t0.setCanPickUpLoot(this.canPickUpLoot());
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                ItemStack itemstack = this.getItemBySlot(enumitemslot);
                if (itemstack.isEmpty()) continue;
                t0.setItemSlot(enumitemslot, itemstack.copyAndClear());
                t0.setDropChance(enumitemslot, this.getEquipmentDropChance(enumitemslot));
            }
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, t0, transformReason).isCancelled()) {
            return null;
        }
        this.level().addFreshEntity(t0, spawnReason);
        if (this.isPassenger()) {
            Entity entity = this.getVehicle();
            this.stopRiding();
            t0.startRiding(entity, true);
        }
        this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        return (T)t0;
    }

    @Override
    @Nullable
    public Leashable.a getLeashData() {
        return this.leashData;
    }

    @Override
    public void setLeashData(@Nullable Leashable.a leashable_a) {
        this.leashData = leashable_a;
    }

    @Override
    public void dropLeash(boolean flag, boolean flag1) {
        Leashable.super.dropLeash(flag, flag1);
        if (this.getLeashData() == null) {
            this.clearRestriction();
        }
    }

    @Override
    public void leashTooFarBehaviour() {
        Leashable.super.leashTooFarBehaviour();
        this.goalSelector.disableControlFlag(PathfinderGoal.Type.MOVE);
    }

    @Override
    public boolean canBeLeashed() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean startRiding(Entity entity, boolean flag) {
        boolean flag1 = super.startRiding(entity, flag);
        if (flag1 && this.isLeashed()) {
            this.level().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            this.dropLeash(true, true);
        }
        return flag1;
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && !this.isNoAi();
    }

    public void setNoAi(boolean flag) {
        byte b0 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void setLeftHanded(boolean flag) {
        byte b0 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void setAggressive(boolean flag) {
        byte b0 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean isNoAi() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 1) != 0;
    }

    public boolean isLeftHanded() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 2) != 0;
    }

    public boolean isAggressive() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 4) != 0;
    }

    public void setBaby(boolean flag) {
    }

    @Override
    public EnumMainHand getMainArm() {
        return this.isLeftHanded() ? EnumMainHand.LEFT : EnumMainHand.RIGHT;
    }

    public boolean isWithinMeleeAttackRange(EntityLiving entityliving) {
        return this.getAttackBoundingBox().intersects(entityliving.getHitbox());
    }

    protected AxisAlignedBB getAttackBoundingBox() {
        AxisAlignedBB axisalignedbb;
        Entity entity = this.getVehicle();
        if (entity != null) {
            AxisAlignedBB axisalignedbb1 = entity.getBoundingBox();
            AxisAlignedBB axisalignedbb2 = this.getBoundingBox();
            axisalignedbb = new AxisAlignedBB(Math.min(axisalignedbb2.minX, axisalignedbb1.minX), axisalignedbb2.minY, Math.min(axisalignedbb2.minZ, axisalignedbb1.minZ), Math.max(axisalignedbb2.maxX, axisalignedbb1.maxX), axisalignedbb2.maxY, Math.max(axisalignedbb2.maxZ, axisalignedbb1.maxZ));
        } else {
            axisalignedbb = this.getBoundingBox();
        }
        return axisalignedbb.inflate(DEFAULT_ATTACK_REACH, 0.0, DEFAULT_ATTACK_REACH);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        boolean flag;
        float f2 = (float)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE);
        DamageSource damagesource = this.damageSources().mobAttack(this);
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f2 = EnchantmentManager.modifyDamage(worldserver, this.getWeaponItem(), entity, damagesource, f2);
        }
        if (flag = entity.hurt(damagesource, f2)) {
            World world1;
            float f1 = this.getKnockback(entity, damagesource);
            if (f1 > 0.0f && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                entityliving.knockback(f1 * 0.5f, MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)), -MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((world1 = this.level()) instanceof WorldServer) {
                WorldServer worldserver1 = (WorldServer)world1;
                EnchantmentManager.doPostAttackEffects(worldserver1, entity, damagesource);
            }
            this.setLastHurtMob(entity);
            this.playAttackSound();
        }
        return flag;
    }

    protected void playAttackSound() {
    }

    protected boolean isSunBurnTick() {
        if (this.level().isDay() && !this.level().isClientSide) {
            boolean flag;
            float f2 = this.getLightLevelDependentMagicValue();
            BlockPosition blockposition = BlockPosition.containing(this.getX(), this.getEyeY(), this.getZ());
            boolean bl = flag = this.isInWaterRainOrBubble() || this.isInPowderSnow || this.wasInPowderSnow;
            if (f2 > 0.5f && this.random.nextFloat() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.level().canSeeSky(blockposition)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void jumpInLiquid(TagKey<FluidType> tagkey) {
        if (this.getNavigation().canFloat()) {
            super.jumpInLiquid(tagkey);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void removeFreeWill() {
        this.removeAllGoals(pathfindergoal -> true);
        this.getBrain().removeAllBehaviors();
    }

    public void removeAllGoals(Predicate<PathfinderGoal> predicate) {
        this.goalSelector.removeAllGoals(predicate);
    }

    @Override
    protected void removeAfterChangingDimensions() {
        super.removeAfterChangingDimensions();
        this.getAllSlots().forEach(itemstack -> {
            if (!itemstack.isEmpty()) {
                itemstack.setCount(0);
            }
        });
    }

    @Override
    @Nullable
    public ItemStack getPickResult() {
        ItemMonsterEgg itemmonsteregg = ItemMonsterEgg.byId(this.getType());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }
}

