/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSuspiciousStew;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R1.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity
implements Attackable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_ACTIVE_EFFECTS = "active_effects";
    private static final MinecraftKey SPEED_MODIFIER_POWDER_SNOW_ID = MinecraftKey.withDefaultNamespace("powder_snow");
    private static final MinecraftKey SPRINTING_MODIFIER_ID = MinecraftKey.withDefaultNamespace("sprinting");
    private static final AttributeModifier SPEED_MODIFIER_SPRINTING = new AttributeModifier(SPRINTING_MODIFIER_ID, 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final int HAND_SLOTS = 2;
    public static final int ARMOR_SLOTS = 4;
    public static final int EQUIPMENT_SLOT_OFFSET = 98;
    public static final int ARMOR_SLOT_OFFSET = 100;
    public static final int BODY_ARMOR_OFFSET = 105;
    public static final int SWING_DURATION = 6;
    public static final int PLAYER_HURT_EXPERIENCE_TIME = 100;
    private static final int DAMAGE_SOURCE_TIMEOUT = 40;
    public static final double MIN_MOVEMENT_DISTANCE = 0.003;
    public static final double DEFAULT_BASE_GRAVITY = 0.08;
    public static final int DEATH_DURATION = 20;
    private static final int TICKS_PER_ELYTRA_FREE_FALL_EVENT = 10;
    private static final int FREE_FALL_EVENTS_PER_ELYTRA_BREAK = 2;
    public static final int USE_ITEM_INTERVAL = 4;
    public static final float BASE_JUMP_POWER = 0.42f;
    private static final double MAX_LINE_OF_SIGHT_TEST_RANGE = 128.0;
    protected static final int LIVING_ENTITY_FLAG_IS_USING = 1;
    protected static final int LIVING_ENTITY_FLAG_OFF_HAND = 2;
    public static final int LIVING_ENTITY_FLAG_SPIN_ATTACK = 4;
    protected static final DataWatcherObject<Byte> DATA_LIVING_ENTITY_FLAGS = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.BYTE);
    public static final DataWatcherObject<Float> DATA_HEALTH_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<List<ParticleParam>> DATA_EFFECT_PARTICLES = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.PARTICLES);
    private static final DataWatcherObject<Boolean> DATA_EFFECT_AMBIENCE_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.BOOLEAN);
    public static final DataWatcherObject<Integer> DATA_ARROW_COUNT_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_STINGER_COUNT_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Optional<BlockPosition>> SLEEPING_POS_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.OPTIONAL_BLOCK_POS);
    private static final int PARTICLE_FREQUENCY_WHEN_INVISIBLE = 15;
    protected static final EntitySize SLEEPING_DIMENSIONS = EntitySize.fixed(0.2f, 0.2f).withEyeHeight(0.2f);
    public static final float EXTRA_RENDER_CULLING_SIZE_WITH_BIG_HAT = 0.5f;
    public static final float DEFAULT_BABY_SCALE = 0.5f;
    private static final float ITEM_USE_EFFECT_START_FRACTION = 0.21875f;
    public static final String ATTRIBUTES_FIELD = "attributes";
    private final AttributeMapBase attributes;
    public CombatTracker combatTracker = new CombatTracker(this);
    public final Map<Holder<MobEffectList>, MobEffect> activeEffects = Maps.newHashMap();
    private final NonNullList<ItemStack> lastHandItemStacks;
    private final NonNullList<ItemStack> lastArmorItemStacks;
    private ItemStack lastBodyItemStack;
    public boolean swinging;
    private boolean discardFriction = false;
    public EnumHand swingingArm;
    public int swingTime;
    public int removeArrowTime;
    public int removeStingerTime;
    public int hurtTime;
    public int hurtDuration;
    public int deathTime;
    public float oAttackAnim;
    public float attackAnim;
    protected int attackStrengthTicker;
    public final WalkAnimationState walkAnimation;
    public int invulnerableDuration = 20;
    public final float timeOffs;
    public final float rotA;
    public float yBodyRot;
    public float yBodyRotO;
    public float yHeadRot;
    public float yHeadRotO;
    @Nullable
    public EntityHuman lastHurtByPlayer;
    protected int lastHurtByPlayerTime;
    protected boolean dead;
    protected int noActionTime;
    protected float oRun;
    protected float run;
    protected float animStep;
    protected float animStepO;
    protected float rotOffs;
    protected int deathScore;
    public float lastHurt;
    protected boolean jumping;
    public float xxa;
    public float yya;
    public float zza;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    protected double lerpYHeadRot;
    protected int lerpHeadSteps;
    public boolean effectsDirty = true;
    @Nullable
    public EntityLiving lastHurtByMob;
    public int lastHurtByMobTimestamp;
    @Nullable
    private EntityLiving lastHurtMob;
    private int lastHurtMobTimestamp;
    private float speed;
    private int noJumpDelay;
    private float absorptionAmount;
    protected ItemStack useItem;
    public int useItemRemaining;
    protected int fallFlyTicks;
    private BlockPosition lastPos;
    private Optional<BlockPosition> lastClimbablePos;
    @Nullable
    private DamageSource lastDamageSource;
    private long lastDamageStamp;
    protected int autoSpinAttackTicks;
    protected float autoSpinAttackDmg;
    @Nullable
    protected ItemStack autoSpinAttackItemStack;
    private float swimAmount;
    private float swimAmountO;
    protected BehaviorController<?> brain;
    protected boolean skipDropExperience;
    private final Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>> activeLocationDependentEnchantments;
    protected float appliedScale = 1.0f;
    public int expToDrop;
    public ArrayList<org.bukkit.inventory.ItemStack> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();

    @Override
    public float getBukkitYaw() {
        return this.getYHeadRot();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.noActionTime;
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> entitytypes, net.minecraft.world.level.World world) {
        super(entitytypes, world);
        this.lastHandItemStacks = NonNullList.withSize(2, ItemStack.EMPTY);
        this.lastArmorItemStacks = NonNullList.withSize(4, ItemStack.EMPTY);
        this.lastBodyItemStack = ItemStack.EMPTY;
        this.walkAnimation = new WalkAnimationState();
        this.useItem = ItemStack.EMPTY;
        this.lastClimbablePos = Optional.empty();
        this.activeLocationDependentEnchantments = new Reference2ObjectArrayMap();
        this.attributes = new AttributeMapBase(AttributeDefaults.getSupplier(entitytypes));
        this.craftAttributes = new CraftAttributeMap(this.attributes);
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf((float)this.getAttribute(GenericAttributes.MAX_HEALTH).getValue()));
        this.blocksBuilding = true;
        this.rotA = (float)((Math.random() + 1.0) * (double)0.01f);
        this.reapplyPosition();
        this.timeOffs = (float)Math.random() * 12398.0f;
        this.setYRot((float)(Math.random() * 6.2831854820251465));
        this.yHeadRot = this.getYRot();
        DynamicOpsNBT dynamicopsnbt = DynamicOpsNBT.INSTANCE;
        this.brain = this.makeBrain(new Dynamic((DynamicOps)dynamicopsnbt, (Object)((NBTBase)dynamicopsnbt.createMap((Map)ImmutableMap.of((Object)dynamicopsnbt.createString("memories"), (Object)((NBTBase)dynamicopsnbt.emptyMap()))))));
    }

    public BehaviorController<?> getBrain() {
        return this.brain;
    }

    protected BehaviorController.b<?> brainProvider() {
        return BehaviorController.provider(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> makeBrain(Dynamic<?> dynamic) {
        return this.brainProvider().makeBrain(dynamic);
    }

    @Override
    public void kill() {
        this.hurt(this.damageSources().genericKill(), Float.MAX_VALUE);
    }

    public boolean canAttackType(EntityTypes<?> entitytypes) {
        return true;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        datawatcher_a.define(DATA_LIVING_ENTITY_FLAGS, (byte)0);
        datawatcher_a.define(DATA_EFFECT_PARTICLES, List.of());
        datawatcher_a.define(DATA_EFFECT_AMBIENCE_ID, false);
        datawatcher_a.define(DATA_ARROW_COUNT_ID, 0);
        datawatcher_a.define(DATA_STINGER_COUNT_ID, 0);
        datawatcher_a.define(DATA_HEALTH_ID, Float.valueOf(1.0f));
        datawatcher_a.define(SLEEPING_POS_ID, Optional.empty());
    }

    public static AttributeProvider.Builder createLivingAttributes() {
        return AttributeProvider.builder().add(GenericAttributes.MAX_HEALTH).add(GenericAttributes.KNOCKBACK_RESISTANCE).add(GenericAttributes.MOVEMENT_SPEED).add(GenericAttributes.ARMOR).add(GenericAttributes.ARMOR_TOUGHNESS).add(GenericAttributes.MAX_ABSORPTION).add(GenericAttributes.STEP_HEIGHT).add(GenericAttributes.SCALE).add(GenericAttributes.GRAVITY).add(GenericAttributes.SAFE_FALL_DISTANCE).add(GenericAttributes.FALL_DAMAGE_MULTIPLIER).add(GenericAttributes.JUMP_STRENGTH).add(GenericAttributes.OXYGEN_BONUS).add(GenericAttributes.BURNING_TIME).add(GenericAttributes.EXPLOSION_KNOCKBACK_RESISTANCE).add(GenericAttributes.WATER_MOVEMENT_EFFICIENCY).add(GenericAttributes.MOVEMENT_EFFICIENCY).add(GenericAttributes.ATTACK_KNOCKBACK);
    }

    @Override
    protected void checkFallDamage(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        net.minecraft.world.level.World world;
        if (!this.isInWater()) {
            this.updateInWaterStateAndDoWaterCurrentPushing();
        }
        if ((world = this.level()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (flag && this.fallDistance > 0.0f) {
                this.onChangedBlock(worldserver, blockposition);
                double d1 = this.getAttributeValue(GenericAttributes.SAFE_FALL_DISTANCE);
                if ((double)this.fallDistance > d1 && !iblockdata.isAir()) {
                    double d2 = this.getX();
                    double d3 = this.getY();
                    double d4 = this.getZ();
                    BlockPosition blockposition1 = this.blockPosition();
                    if (blockposition.getX() != blockposition1.getX() || blockposition.getZ() != blockposition1.getZ()) {
                        double d5 = d2 - (double)blockposition.getX() - 0.5;
                        double d6 = d4 - (double)blockposition.getZ() - 0.5;
                        double d7 = Math.max(Math.abs(d5), Math.abs(d6));
                        d2 = (double)blockposition.getX() + 0.5 + d5 / d7 * 0.5;
                        d4 = (double)blockposition.getZ() + 0.5 + d6 / d7 * 0.5;
                    }
                    float f2 = MathHelper.ceil((double)this.fallDistance - d1);
                    double d8 = Math.min((double)(0.2f + f2 / 15.0f), 2.5);
                    int i2 = (int)(150.0 * d8);
                    if (this instanceof EntityPlayer) {
                        ((WorldServer)this.level()).sendParticles((EntityPlayer)this, new ParticleParamBlock(Particles.BLOCK, iblockdata), d2, d3, d4, i2, 0.0, 0.0, 0.0, (double)0.15f, false);
                    } else {
                        ((WorldServer)this.level()).sendParticles(new ParticleParamBlock(Particles.BLOCK, iblockdata), d2, d3, d4, i2, 0.0, 0.0, 0.0, 0.15f);
                    }
                }
            }
        }
        super.checkFallDamage(d0, flag, iblockdata, blockposition);
        if (flag) {
            this.lastClimbablePos = Optional.empty();
        }
    }

    public final boolean canBreatheUnderwater() {
        return this.getType().is(TagsEntity.CAN_BREATHE_UNDER_WATER);
    }

    public float getSwimAmount(float f2) {
        return MathHelper.lerp(f2, this.swimAmountO, this.swimAmount);
    }

    public boolean hasLandedInLiquid() {
        return this.getDeltaMovement().y() < (double)1.0E-5f && this.isInLiquid();
    }

    @Override
    public void baseTick() {
        net.minecraft.world.level.World world;
        this.oAttackAnim = this.attackAnim;
        if (this.firstTick) {
            this.getSleepingPos().ifPresent(this::setPosToBed);
        }
        if ((world = this.level()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            EnchantmentManager.tickEffects(worldserver, this);
        }
        super.baseTick();
        this.level().getProfiler().push("livingEntityBaseTick");
        if (this.fireImmune() || this.level().isClientSide) {
            this.clearFire();
        }
        if (this.isAlive()) {
            boolean flag = this instanceof EntityHuman;
            if (!this.level().isClientSide) {
                double d1;
                double d0;
                if (this.isInWall()) {
                    this.hurt(this.damageSources().inWall(), 1.0f);
                } else if (flag && !this.level().getWorldBorder().isWithinBounds(this.getBoundingBox()) && (d0 = this.level().getWorldBorder().getDistanceToBorder(this) + this.level().getWorldBorder().getDamageSafeZone()) < 0.0 && (d1 = this.level().getWorldBorder().getDamagePerBlock()) > 0.0) {
                    this.hurt(this.damageSources().outOfBorder(), Math.max(1, MathHelper.floor(-d0 * d1)));
                }
            }
            if (this.isEyeInFluid(TagsFluid.WATER) && !this.level().getBlockState(BlockPosition.containing(this.getX(), this.getEyeY(), this.getZ())).is(Blocks.BUBBLE_COLUMN)) {
                boolean flag1;
                boolean bl = flag1 = !this.canBreatheUnderwater() && !MobEffectUtil.hasWaterBreathing(this) && (!flag || !((EntityHuman)this).getAbilities().invulnerable);
                if (flag1) {
                    this.setAirSupply(this.decreaseAirSupply(this.getAirSupply()));
                    if (this.getAirSupply() == -20) {
                        this.setAirSupply(0);
                        Vec3D vec3d = this.getDeltaMovement();
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d2 = this.random.nextDouble() - this.random.nextDouble();
                            double d3 = this.random.nextDouble() - this.random.nextDouble();
                            double d4 = this.random.nextDouble() - this.random.nextDouble();
                            this.level().addParticle(Particles.BUBBLE, this.getX() + d2, this.getY() + d3, this.getZ() + d4, vec3d.x, vec3d.y, vec3d.z);
                        }
                        this.hurt(this.damageSources().drown(), 2.0f);
                    }
                }
                if (!this.level().isClientSide && this.isPassenger() && this.getVehicle() != null && this.getVehicle().dismountsUnderwater()) {
                    this.stopRiding();
                }
            } else if (this.getAirSupply() < this.getMaxAirSupply()) {
                this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
            }
            net.minecraft.world.level.World world1 = this.level();
            if (world1 instanceof WorldServer) {
                WorldServer worldserver1 = (WorldServer)world1;
                BlockPosition blockposition = this.blockPosition();
                if (!com.google.common.base.Objects.equal((Object)this.lastPos, (Object)blockposition)) {
                    this.lastPos = blockposition;
                    this.onChangedBlock(worldserver1, blockposition);
                }
            }
        }
        if (this.isAlive() && (this.isInWaterRainOrBubble() || this.isInPowderSnow)) {
            this.extinguishFire();
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.invulnerableTime > 0 && !(this instanceof EntityPlayer)) {
            --this.invulnerableTime;
        }
        if (this.isDeadOrDying() && this.level().shouldTickDeath(this)) {
            this.tickDeath();
        }
        if (this.lastHurtByPlayerTime > 0) {
            --this.lastHurtByPlayerTime;
        } else {
            this.lastHurtByPlayer = null;
        }
        if (this.lastHurtMob != null && !this.lastHurtMob.isAlive()) {
            this.lastHurtMob = null;
        }
        if (this.lastHurtByMob != null) {
            if (!this.lastHurtByMob.isAlive()) {
                this.setLastHurtByMob(null);
            } else if (this.tickCount - this.lastHurtByMobTimestamp > 100) {
                this.setLastHurtByMob(null);
            }
        }
        this.tickEffects();
        this.animStepO = this.animStep;
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.level().getProfiler().pop();
    }

    @Override
    protected float getBlockSpeedFactor() {
        return MathHelper.lerp((float)this.getAttributeValue(GenericAttributes.MOVEMENT_EFFICIENCY), super.getBlockSpeedFactor(), 1.0f);
    }

    protected void removeFrost() {
        AttributeModifiable attributemodifiable = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
        if (attributemodifiable != null && attributemodifiable.getModifier(SPEED_MODIFIER_POWDER_SNOW_ID) != null) {
            attributemodifiable.removeModifier(SPEED_MODIFIER_POWDER_SNOW_ID);
        }
    }

    protected void tryAddFrost() {
        int i2;
        if (!this.getBlockStateOnLegacy().isAir() && (i2 = this.getTicksFrozen()) > 0) {
            AttributeModifiable attributemodifiable = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
            if (attributemodifiable == null) {
                return;
            }
            float f2 = -0.05f * this.getPercentFrozen();
            attributemodifiable.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_POWDER_SNOW_ID, f2, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    protected void onChangedBlock(WorldServer worldserver, BlockPosition blockposition) {
        EnchantmentManager.runLocationChangedEffects(worldserver, this);
    }

    public boolean isBaby() {
        return false;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.5f : 1.0f;
    }

    public float getScale() {
        AttributeMapBase attributemapbase = this.getAttributes();
        return attributemapbase == null ? 1.0f : this.sanitizeScale((float)attributemapbase.getValue(GenericAttributes.SCALE));
    }

    protected float sanitizeScale(float f2) {
        return f2;
    }

    protected boolean isAffectedByFluids() {
        return true;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent(this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean shouldDropExperience() {
        return !this.isBaby();
    }

    protected boolean shouldDropLoot() {
        return !this.isBaby();
    }

    protected int decreaseAirSupply(int i2) {
        AttributeModifiable attributemodifiable = this.getAttribute(GenericAttributes.OXYGEN_BONUS);
        double d0 = attributemodifiable != null ? attributemodifiable.getValue() : 0.0;
        return d0 > 0.0 && this.random.nextDouble() >= 1.0 / (d0 + 1.0) ? i2 : i2 - 1;
    }

    protected int increaseAirSupply(int i2) {
        return Math.min(i2 + 4, this.getMaxAirSupply());
    }

    public final int getExperienceReward(WorldServer worldserver, @Nullable Entity entity) {
        return EnchantmentManager.processMobExperience(worldserver, entity, this, this.getBaseExperienceReward());
    }

    protected int getBaseExperienceReward() {
        return 0;
    }

    protected boolean isAlwaysExperienceDropper() {
        return false;
    }

    @Nullable
    public EntityLiving getLastHurtByMob() {
        return this.lastHurtByMob;
    }

    @Override
    public EntityLiving getLastAttacker() {
        return this.getLastHurtByMob();
    }

    public int getLastHurtByMobTimestamp() {
        return this.lastHurtByMobTimestamp;
    }

    public void setLastHurtByPlayer(@Nullable EntityHuman entityhuman) {
        this.lastHurtByPlayer = entityhuman;
        this.lastHurtByPlayerTime = this.tickCount;
    }

    public void setLastHurtByMob(@Nullable EntityLiving entityliving) {
        this.lastHurtByMob = entityliving;
        this.lastHurtByMobTimestamp = this.tickCount;
    }

    @Nullable
    public EntityLiving getLastHurtMob() {
        return this.lastHurtMob;
    }

    public int getLastHurtMobTimestamp() {
        return this.lastHurtMobTimestamp;
    }

    public void setLastHurtMob(Entity entity) {
        this.lastHurtMob = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        this.lastHurtMobTimestamp = this.tickCount;
    }

    public int getNoActionTime() {
        return this.noActionTime;
    }

    public void setNoActionTime(int i2) {
        this.noActionTime = i2;
    }

    public boolean shouldDiscardFriction() {
        return this.discardFriction;
    }

    public void setDiscardFriction(boolean flag) {
        this.discardFriction = flag;
    }

    protected boolean doesEmitEquipEvent(EnumItemSlot enumitemslot) {
        return true;
    }

    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1) {
        this.onEquipItem(enumitemslot, itemstack, itemstack1, false);
    }

    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        boolean flag;
        boolean bl = flag = itemstack1.isEmpty() && itemstack.isEmpty();
        if (!(flag || ItemStack.isSameItemSameComponents(itemstack, itemstack1) || this.firstTick)) {
            Equipable equipable = Equipable.get(itemstack1);
            if (!this.level().isClientSide() && !this.isSpectator()) {
                if (!this.isSilent() && equipable != null && equipable.getEquipmentSlot() == enumitemslot && !silent) {
                    this.level().playSeededSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), equipable.getEquipSound(), this.getSoundSource(), 1.0f, 1.0f, this.random.nextLong());
                }
                if (this.doesEmitEquipEvent(enumitemslot)) {
                    this.gameEvent(equipable != null ? GameEvent.EQUIP : GameEvent.UNEQUIP);
                }
            }
        }
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        if (entity_removalreason == Entity.RemovalReason.KILLED || entity_removalreason == Entity.RemovalReason.DISCARDED) {
            this.triggerOnDeathMobEffects(entity_removalreason);
        }
        super.remove(entity_removalreason, cause);
        this.brain.clearMemories();
    }

    protected void triggerOnDeathMobEffects(Entity.RemovalReason entity_removalreason) {
        for (MobEffect mobeffect : this.getActiveEffects()) {
            mobeffect.onMobRemoved(this, entity_removalreason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.activeEffects.clear();
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        nbttagcompound.putFloat("Health", this.getHealth());
        nbttagcompound.putShort("HurtTime", (short)this.hurtTime);
        nbttagcompound.putInt("HurtByTimestamp", this.lastHurtByMobTimestamp);
        nbttagcompound.putShort("DeathTime", (short)this.deathTime);
        nbttagcompound.putFloat("AbsorptionAmount", this.getAbsorptionAmount());
        nbttagcompound.put(ATTRIBUTES_FIELD, this.getAttributes().save());
        if (!this.activeEffects.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (MobEffect mobeffect : this.activeEffects.values()) {
                nbttaglist.add(mobeffect.save());
            }
            nbttagcompound.put(TAG_ACTIVE_EFFECTS, nbttaglist);
        }
        nbttagcompound.putBoolean("FallFlying", this.isFallFlying());
        this.getSleepingPos().ifPresent(blockposition -> {
            nbttagcompound.putInt("SleepingX", blockposition.getX());
            nbttagcompound.putInt("SleepingY", blockposition.getY());
            nbttagcompound.putInt("SleepingZ", blockposition.getZ());
        });
        DataResult<NBTBase> dataresult = this.brain.serializeStart(DynamicOpsNBT.INSTANCE);
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.put("Brain", (NBTBase)nbtbase));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        this.internalSetAbsorptionAmount(nbttagcompound.getFloat("AbsorptionAmount"));
        if (nbttagcompound.contains(ATTRIBUTES_FIELD, 9) && this.level() != null && !this.level().isClientSide) {
            this.getAttributes().load(nbttagcompound.getList(ATTRIBUTES_FIELD, 10));
        }
        if (nbttagcompound.contains(TAG_ACTIVE_EFFECTS, 9)) {
            NBTTagList nbttaglist = nbttagcompound.getList(TAG_ACTIVE_EFFECTS, 10);
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                NBTTagCompound nbttagcompound1 = nbttaglist.getCompound(i2);
                MobEffect mobeffect = MobEffect.load(nbttagcompound1);
                if (mobeffect == null) continue;
                this.activeEffects.put(mobeffect.getEffect(), mobeffect);
            }
        }
        if (nbttagcompound.contains("Bukkit.MaxHealth")) {
            NBTBase nbtbase = nbttagcompound.get("Bukkit.MaxHealth");
            if (nbtbase.getId() == 5) {
                this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(((NBTTagFloat)nbtbase).getAsDouble());
            } else if (nbtbase.getId() == 3) {
                this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(((NBTTagInt)nbtbase).getAsDouble());
            }
        }
        if (nbttagcompound.contains("Health", 99)) {
            this.setHealth(nbttagcompound.getFloat("Health"));
        }
        this.hurtTime = nbttagcompound.getShort("HurtTime");
        this.deathTime = nbttagcompound.getShort("DeathTime");
        this.lastHurtByMobTimestamp = nbttagcompound.getInt("HurtByTimestamp");
        if (nbttagcompound.contains("Team", 8)) {
            boolean flag;
            String s2 = nbttagcompound.getString("Team");
            Scoreboard scoreboard = this.level().getScoreboard();
            ScoreboardTeam scoreboardteam = scoreboard.getPlayerTeam(s2);
            boolean bl = flag = scoreboardteam != null && scoreboard.addPlayerToTeam(this.getStringUUID(), scoreboardteam);
            if (!flag) {
                LOGGER.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s2);
            }
        }
        if (nbttagcompound.getBoolean("FallFlying")) {
            this.setSharedFlag(7, true);
        }
        if (nbttagcompound.contains("SleepingX", 99) && nbttagcompound.contains("SleepingY", 99) && nbttagcompound.contains("SleepingZ", 99)) {
            BlockPosition blockposition = new BlockPosition(nbttagcompound.getInt("SleepingX"), nbttagcompound.getInt("SleepingY"), nbttagcompound.getInt("SleepingZ"));
            this.setSleepingPos(blockposition);
            this.entityData.set(DATA_POSE, EntityPose.SLEEPING);
            if (!this.firstTick) {
                this.setPosToBed(blockposition);
            }
        }
        if (nbttagcompound.contains("Brain", 10)) {
            this.brain = this.makeBrain(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.get("Brain")));
        }
    }

    protected void tickEffects() {
        List<ParticleParam> list;
        Iterator<Holder<MobEffectList>> iterator = this.activeEffects.keySet().iterator();
        this.isTickingEffects = true;
        try {
            while (iterator.hasNext()) {
                Holder<MobEffectList> holder = iterator.next();
                MobEffect mobeffect = this.activeEffects.get(holder);
                if (!mobeffect.tick(this, () -> this.onEffectUpdated(mobeffect, true, null))) {
                    EntityPotionEffectEvent event;
                    if (this.level().isClientSide || (event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION)).isCancelled()) continue;
                    iterator.remove();
                    this.onEffectRemoved(mobeffect);
                    continue;
                }
                if (mobeffect.getDuration() % 600 != 0) continue;
                this.onEffectUpdated(mobeffect, false, null);
            }
        }
        catch (ConcurrentModificationException holder) {
            // empty catch block
        }
        this.isTickingEffects = false;
        for (ProcessableEffect e2 : this.effectsToProcess) {
            if (e2.effect != null) {
                this.addEffect(e2.effect, e2.cause);
                continue;
            }
            this.removeEffect(e2.type, e2.cause);
        }
        this.effectsToProcess.clear();
        if (this.effectsDirty) {
            if (!this.level().isClientSide) {
                this.updateInvisibilityStatus();
                this.updateGlowingStatus();
            }
            this.effectsDirty = false;
        }
        if (!(list = this.entityData.get(DATA_EFFECT_PARTICLES)).isEmpty()) {
            int j2;
            boolean flag = this.entityData.get(DATA_EFFECT_AMBIENCE_ID);
            int i2 = this.isInvisible() ? 15 : 4;
            int n2 = j2 = flag ? 5 : 1;
            if (this.random.nextInt(i2 * j2) == 0) {
                this.level().addParticle(SystemUtils.getRandom(list, this.random), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 1.0, 1.0, 1.0);
            }
        }
    }

    protected void updateInvisibilityStatus() {
        if (this.activeEffects.isEmpty()) {
            this.removeEffectParticles();
            this.setInvisible(false);
        } else {
            this.setInvisible(this.hasEffect(MobEffects.INVISIBILITY));
            this.updateSynchronizedMobEffectParticles();
        }
    }

    private void updateSynchronizedMobEffectParticles() {
        List<ParticleParam> list = this.activeEffects.values().stream().filter(MobEffect::isVisible).map(MobEffect::getParticleOptions).toList();
        this.entityData.set(DATA_EFFECT_PARTICLES, list);
        this.entityData.set(DATA_EFFECT_AMBIENCE_ID, EntityLiving.areAllEffectsAmbient(this.activeEffects.values()));
    }

    private void updateGlowingStatus() {
        boolean flag = this.isCurrentlyGlowing();
        if (this.getSharedFlag(6) != flag) {
            this.setSharedFlag(6, flag);
        }
    }

    public double getVisibilityPercent(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.isDiscrete()) {
            d0 *= 0.8;
        }
        if (this.isInvisible()) {
            float f2 = this.getArmorCoverPercentage();
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            d0 *= 0.7 * (double)f2;
        }
        if (entity != null) {
            ItemStack itemstack = this.getItemBySlot(EnumItemSlot.HEAD);
            EntityTypes<?> entitytypes = entity.getType();
            if (entitytypes == EntityTypes.SKELETON && itemstack.is(Items.SKELETON_SKULL) || entitytypes == EntityTypes.ZOMBIE && itemstack.is(Items.ZOMBIE_HEAD) || entitytypes == EntityTypes.PIGLIN && itemstack.is(Items.PIGLIN_HEAD) || entitytypes == EntityTypes.PIGLIN_BRUTE && itemstack.is(Items.PIGLIN_HEAD) || entitytypes == EntityTypes.CREEPER && itemstack.is(Items.CREEPER_HEAD)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean canAttack(EntityLiving entityliving) {
        return entityliving instanceof EntityHuman && this.level().getDifficulty() == EnumDifficulty.PEACEFUL ? false : entityliving.canBeSeenAsEnemy();
    }

    public boolean canAttack(EntityLiving entityliving, PathfinderTargetCondition pathfindertargetcondition) {
        return pathfindertargetcondition.test(this, entityliving);
    }

    public boolean canBeSeenAsEnemy() {
        return !this.isInvulnerable() && this.canBeSeenByAnyone();
    }

    public boolean canBeSeenByAnyone() {
        return !this.isSpectator() && this.isAlive();
    }

    public static boolean areAllEffectsAmbient(Collection<MobEffect> collection) {
        MobEffect mobeffect;
        Iterator<MobEffect> iterator = collection.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(mobeffect = iterator.next()).isVisible() || mobeffect.isAmbient());
        return false;
    }

    protected void removeEffectParticles() {
        this.entityData.set(DATA_EFFECT_PARTICLES, List.of());
    }

    public boolean removeAllEffects() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.level().isClientSide) {
            return false;
        }
        Iterator<MobEffect> iterator = this.activeEffects.values().iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (!event.isCancelled()) {
                this.onEffectRemoved(effect);
                iterator.remove();
            }
            flag = true;
        }
        return flag;
    }

    public Collection<MobEffect> getActiveEffects() {
        return this.activeEffects.values();
    }

    public Map<Holder<MobEffectList>, MobEffect> getActiveEffectsMap() {
        return this.activeEffects;
    }

    public boolean hasEffect(Holder<MobEffectList> holder) {
        return this.activeEffects.containsKey(holder);
    }

    @Nullable
    public MobEffect getEffect(Holder<MobEffectList> holder) {
        return this.activeEffects.get(holder);
    }

    public final boolean addEffect(MobEffect mobeffect) {
        return this.addEffect(mobeffect, (Entity)null);
    }

    public boolean addEffect(MobEffect mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity) {
        return this.addEffect(mobeffect, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        EntityPotionEffectEvent event;
        AsyncCatcher.catchOp("effect add");
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.canBeAffected(mobeffect)) {
            return false;
        }
        MobEffect mobeffect1 = this.activeEffects.get(mobeffect.getEffect());
        boolean flag = false;
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffect(mobeffect1).update(mobeffect);
        }
        if ((event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override)).isCancelled()) {
            return false;
        }
        if (mobeffect1 == null) {
            this.activeEffects.put(mobeffect.getEffect(), mobeffect);
            this.onEffectAdded(mobeffect, entity);
            flag = true;
            mobeffect.onEffectAdded(this);
        } else if (event.isOverride()) {
            mobeffect1.update(mobeffect);
            this.onEffectUpdated(mobeffect1, true, entity);
            flag = true;
        }
        mobeffect.onEffectStarted(this);
        return flag;
    }

    public boolean canBeAffected(MobEffect mobeffect) {
        return this.getType().is(TagsEntity.IMMUNE_TO_INFESTED) ? !mobeffect.is(MobEffects.INFESTED) : (this.getType().is(TagsEntity.IMMUNE_TO_OOZING) ? !mobeffect.is(MobEffects.OOZING) : (!this.getType().is(TagsEntity.IGNORES_POISON_AND_REGEN) ? true : !mobeffect.is(MobEffects.REGENERATION) && !mobeffect.is(MobEffects.POISON)));
    }

    public void forceAddEffect(MobEffect mobeffect, @Nullable Entity entity) {
        if (this.canBeAffected(mobeffect)) {
            MobEffect mobeffect1 = this.activeEffects.put(mobeffect.getEffect(), mobeffect);
            if (mobeffect1 == null) {
                this.onEffectAdded(mobeffect, entity);
            } else {
                mobeffect.copyBlendState(mobeffect1);
                this.onEffectUpdated(mobeffect, true, entity);
            }
        }
    }

    public boolean isInvertedHealAndHarm() {
        return this.getType().is(TagsEntity.INVERTED_HEALING_AND_HARM);
    }

    @Nullable
    public MobEffect removeEffectNoUpdate(Holder<MobEffectList> holder) {
        return this.removeEffectNoUpdate(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public MobEffect removeEffectNoUpdate(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(holder, cause));
            return null;
        }
        MobEffect effect = this.activeEffects.get(holder);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.activeEffects.remove(holder);
    }

    public boolean removeEffect(Holder<MobEffectList> holder) {
        return this.removeEffect(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobeffect = this.removeEffectNoUpdate(holder, cause);
        if (mobeffect != null) {
            this.onEffectRemoved(mobeffect);
            return true;
        }
        return false;
    }

    protected void onEffectAdded(MobEffect mobeffect, @Nullable Entity entity) {
        this.effectsDirty = true;
        if (!this.level().isClientSide) {
            mobeffect.getEffect().value().addAttributeModifiers(this.getAttributes(), mobeffect.getAmplifier());
            this.sendEffectToPassengers(mobeffect);
        }
    }

    public void sendEffectToPassengers(MobEffect mobeffect) {
        for (Entity entity : this.getPassengers()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.connection.send(new PacketPlayOutEntityEffect(this.getId(), mobeffect, false));
        }
    }

    protected void onEffectUpdated(MobEffect mobeffect, boolean flag, @Nullable Entity entity) {
        this.effectsDirty = true;
        if (flag && !this.level().isClientSide) {
            MobEffectList mobeffectlist = mobeffect.getEffect().value();
            mobeffectlist.removeAttributeModifiers(this.getAttributes());
            mobeffectlist.addAttributeModifiers(this.getAttributes(), mobeffect.getAmplifier());
            this.refreshDirtyAttributes();
        }
        if (!this.level().isClientSide) {
            this.sendEffectToPassengers(mobeffect);
        }
    }

    protected void onEffectRemoved(MobEffect mobeffect) {
        this.effectsDirty = true;
        if (!this.level().isClientSide) {
            mobeffect.getEffect().value().removeAttributeModifiers(this.getAttributes());
            this.refreshDirtyAttributes();
            for (Entity entity : this.getPassengers()) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.connection.send(new PacketPlayOutRemoveEntityEffect(this.getId(), mobeffect.getEffect()));
            }
        }
    }

    private void refreshDirtyAttributes() {
        Set<AttributeModifiable> set = this.getAttributes().getAttributesToUpdate();
        for (AttributeModifiable attributemodifiable : set) {
            this.onAttributeUpdated(attributemodifiable.getAttribute());
        }
        set.clear();
    }

    private void onAttributeUpdated(Holder<AttributeBase> holder) {
        if (holder.is(GenericAttributes.MAX_HEALTH)) {
            float f2 = this.getMaxHealth();
            if (this.getHealth() > f2) {
                this.setHealth(f2);
            }
        } else if (holder.is(GenericAttributes.MAX_ABSORPTION)) {
            float f3 = this.getMaxAbsorption();
            if (this.getAbsorptionAmount() > f3) {
                this.setAbsorptionAmount(f3);
            }
        }
    }

    public void heal(float f2) {
        this.heal(f2, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason) {
        float f1 = this.getHealth();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f2, regainReason);
            if (this.valid) {
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.setHealth((float)((double)this.getHealth() + event.getAmount()));
            }
        }
    }

    public float getHealth() {
        if (this instanceof EntityPlayer) {
            return (float)((EntityPlayer)this).getBukkitEntity().getHealth();
        }
        return this.entityData.get(DATA_HEALTH_ID).floatValue();
    }

    public void setHealth(float f2) {
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (f2 < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)f2 > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(f2);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf(MathHelper.clamp(f2, 0.0f, this.getMaxHealth())));
    }

    public boolean isDeadOrDying() {
        return this.getHealth() <= 0.0f;
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        boolean flag2;
        if (this.isInvulnerableTo(damagesource)) {
            return false;
        }
        if (this.level().isClientSide) {
            return false;
        }
        if (this.isRemoved() || this.dead || this.getHealth() <= 0.0f) {
            return false;
        }
        if (damagesource.is(DamageTypeTags.IS_FIRE) && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.isSleeping() && !this.level().isClientSide) {
            this.stopSleeping();
        }
        this.noActionTime = 0;
        float f1 = f2;
        boolean flag = f2 > 0.0f && this.isDamageSourceBlocked(damagesource);
        float f22 = 0.0f;
        EntityDamageEvent event = this.handleEntityDamage(damagesource, f2);
        f2 = 0.0f;
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
        this.walkAnimation.setSpeed(1.5f);
        boolean flag1 = true;
        if ((float)this.invulnerableTime > (float)this.invulnerableDuration / 2.0f && !damagesource.is(DamageTypeTags.BYPASSES_COOLDOWN)) {
            if (f2 <= this.lastHurt) {
                return false;
            }
            if (!this.actuallyHurt(damagesource, (float)event.getFinalDamage() - this.lastHurt, event)) {
                return false;
            }
            this.lastHurt = f2;
            flag1 = false;
        } else {
            if (!this.actuallyHurt(damagesource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            this.lastHurt = f2;
            this.invulnerableTime = this.invulnerableDuration;
            this.hurtTime = this.hurtDuration = 10;
        }
        Entity entity1 = damagesource.getEntity();
        if (entity1 != null) {
            EntityWolf entitywolf;
            if (entity1 instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity1;
                if (!(damagesource.is(DamageTypeTags.NO_ANGER) || damagesource.is(DamageTypes.WIND_CHARGE) && this.getType().is(TagsEntity.NO_ANGER_FROM_WIND_CHARGE))) {
                    this.setLastHurtByMob(entityliving1);
                }
            }
            if (entity1 instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entity1;
                this.lastHurtByPlayerTime = 100;
                this.lastHurtByPlayer = entityhuman;
            } else if (entity1 instanceof EntityWolf && (entitywolf = (EntityWolf)entity1).isTame()) {
                EntityHuman entityhuman1;
                this.lastHurtByPlayerTime = 100;
                EntityLiving entityliving2 = entitywolf.getOwner();
                this.lastHurtByPlayer = entityliving2 instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entityliving2) : null;
            }
        }
        if (flag1) {
            if (flag) {
                this.level().broadcastEntityEvent(this, (byte)29);
            } else {
                this.level().broadcastDamageEvent(this, damagesource);
            }
            if (!damagesource.is(DamageTypeTags.NO_IMPACT) && !flag) {
                this.markHurt();
            }
            if (!damagesource.is(DamageTypeTags.NO_KNOCKBACK)) {
                double d0 = 0.0;
                double d1 = 0.0;
                Entity entity2 = damagesource.getDirectEntity();
                if (entity2 instanceof IProjectile) {
                    IProjectile iprojectile = (IProjectile)entity2;
                    DoubleDoubleImmutablePair doubledoubleimmutablepair = iprojectile.calculateHorizontalHurtKnockbackDirection(this, damagesource);
                    d0 = -doubledoubleimmutablepair.leftDouble();
                    d1 = -doubledoubleimmutablepair.rightDouble();
                } else if (damagesource.getSourcePosition() != null) {
                    d0 = damagesource.getSourcePosition().x() - this.getX();
                    d1 = damagesource.getSourcePosition().z() - this.getZ();
                }
                this.knockback(0.4f, d0, d1, entity1, entity1 == null ? EntityKnockbackEvent.KnockbackCause.DAMAGE : EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                if (!flag) {
                    this.indicateDamage(d0, d1);
                }
            }
        }
        if (this.isDeadOrDying()) {
            if (!this.checkTotemDeathProtection(damagesource)) {
                if (flag1) {
                    this.makeSound(this.getDeathSound());
                }
                this.die(damagesource);
            }
        } else if (flag1) {
            this.playHurtSound(damagesource);
        }
        boolean bl = flag2 = !flag;
        if (flag2) {
            this.lastDamageSource = damagesource;
            this.lastDamageStamp = this.level().getGameTime();
            for (MobEffect mobeffect : this.getActiveEffects()) {
                mobeffect.onMobHurt(this, damagesource, f2);
            }
        }
        if (this instanceof EntityPlayer) {
            CriterionTriggers.ENTITY_HURT_PLAYER.trigger((EntityPlayer)this, damagesource, f1, f2, flag);
            if (f22 > 0.0f && f22 < 3.4028235E37f) {
                ((EntityPlayer)this).awardStat(StatisticList.DAMAGE_BLOCKED_BY_SHIELD, Math.round(f22 * 10.0f));
            }
        }
        if (entity1 instanceof EntityPlayer) {
            CriterionTriggers.PLAYER_HURT_ENTITY.trigger((EntityPlayer)entity1, this, damagesource, f1, f2, flag);
        }
        return flag2;
    }

    protected void blockUsingShield(EntityLiving entityliving) {
        entityliving.blockedByShield(this);
    }

    protected void blockedByShield(EntityLiving entityliving) {
        entityliving.knockback(0.5, entityliving.getX() - this.getX(), entityliving.getZ() - this.getZ(), null, EntityKnockbackEvent.KnockbackCause.SHIELD_BLOCK);
    }

    private boolean checkTotemDeathProtection(DamageSource damagesource) {
        if (damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        ItemStack itemstack = null;
        EnumHand[] aenumhand = EnumHand.values();
        int i2 = aenumhand.length;
        EnumHand hand = null;
        ItemStack itemstack1 = ItemStack.EMPTY;
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumHand enumhand = aenumhand[j2];
            itemstack1 = this.getItemInHand(enumhand);
            if (!itemstack1.is(Items.TOTEM_OF_UNDYING)) continue;
            hand = enumhand;
            itemstack = itemstack1.copy();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemstack == null);
        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.isEmpty()) {
                itemstack1.shrink(1);
            }
            if (itemstack != null && this instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)this;
                entityplayer.awardStat(StatisticList.ITEM_USED.get(Items.TOTEM_OF_UNDYING));
                CriterionTriggers.USED_TOTEM.trigger(entityplayer, itemstack);
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
            this.setHealth(1.0f);
            this.removeAllEffects(EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.REGENERATION, 900, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.ABSORPTION, 100, 1), EntityPotionEffectEvent.Cause.TOTEM);
            this.addEffect(new MobEffect(MobEffects.FIRE_RESISTANCE, 800, 0), EntityPotionEffectEvent.Cause.TOTEM);
            this.level().broadcastEntityEvent(this, (byte)35);
        }
        return !event.isCancelled();
    }

    @Nullable
    public DamageSource getLastDamageSource() {
        if (this.level().getGameTime() - this.lastDamageStamp > 40L) {
            this.lastDamageSource = null;
        }
        return this.lastDamageSource;
    }

    protected void playHurtSound(DamageSource damagesource) {
        this.makeSound(this.getHurtSound(damagesource));
    }

    public void makeSound(@Nullable SoundEffect soundeffect) {
        if (soundeffect != null) {
            this.playSound(soundeffect, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public boolean isDamageSourceBlocked(DamageSource damagesource) {
        Vec3D vec3d;
        EntityArrow entityarrow;
        Entity entity = damagesource.getDirectEntity();
        boolean flag = false;
        if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).getPierceLevel() > 0) {
            flag = true;
        }
        if (!damagesource.is(DamageTypeTags.BYPASSES_SHIELD) && this.isBlocking() && !flag && (vec3d = damagesource.getSourcePosition()) != null) {
            Vec3D vec3d1 = this.calculateViewVector(0.0f, this.getYHeadRot());
            Vec3D vec3d2 = vec3d.vectorTo(this.position());
            vec3d2 = new Vec3D(vec3d2.x, 0.0, vec3d2.z).normalize();
            return vec3d2.dot(vec3d1) < 0.0;
        }
        return false;
    }

    private void breakItem(ItemStack itemstack) {
        if (!itemstack.isEmpty()) {
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), itemstack.getBreakingSound(), this.getSoundSource(), 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f, false);
            }
            this.spawnItemParticles(itemstack, 5);
        }
    }

    public void die(DamageSource damagesource) {
        if (!this.isRemoved() && !this.dead) {
            Entity entity = damagesource.getEntity();
            EntityLiving entityliving = this.getKillCredit();
            if (this.deathScore >= 0 && entityliving != null) {
                entityliving.awardKillScore(this, this.deathScore, damagesource);
            }
            if (this.isSleeping()) {
                this.stopSleeping();
            }
            if (!this.level().isClientSide && this.hasCustomName() && SpigotConfig.logNamedDeaths) {
                LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.getCombatTracker().getDeathMessage().getString());
            }
            this.dead = true;
            this.getCombatTracker().recheckStatus();
            net.minecraft.world.level.World world = this.level();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (entity == null || entity.killedEntity(worldserver, this)) {
                    this.gameEvent(GameEvent.ENTITY_DIE);
                    this.dropAllDeathLoot(worldserver, damagesource);
                    this.createWitherRose(entityliving);
                }
                this.level().broadcastEntityEvent(this, (byte)3);
            }
            this.setPose(EntityPose.DYING);
        }
    }

    protected void createWitherRose(@Nullable EntityLiving entityliving) {
        if (!this.level().isClientSide) {
            boolean flag = false;
            if (entityliving instanceof EntityWither) {
                if (this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    BlockPosition blockposition = this.blockPosition();
                    IBlockData iblockdata = Blocks.WITHER_ROSE.defaultBlockState();
                    if (this.level().getBlockState(blockposition).isAir() && iblockdata.canSurvive(this.level(), blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.level(), blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    EntityItem entityitem = new EntityItem(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack(Items.WITHER_ROSE));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.level().addFreshEntity(entityitem);
                }
            }
        }
    }

    protected void dropAllDeathLoot(WorldServer worldserver, DamageSource damagesource) {
        boolean flag = this.lastHurtByPlayerTime > 0;
        this.dropEquipment();
        if (this.shouldDropLoot() && worldserver.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.dropFromLootTable(damagesource, flag);
            this.dropCustomDeathLoot(worldserver, damagesource, flag);
        }
        CraftEventFactory.callEntityDeathEvent(this, damagesource, this.drops);
        this.drops = new ArrayList();
        this.dropExperience(damagesource.getEntity());
    }

    protected void dropEquipment() {
    }

    public int getExpReward(@Nullable Entity entity) {
        net.minecraft.world.level.World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!this.wasExperienceConsumed() && (this.isAlwaysExperienceDropper() || this.lastHurtByPlayerTime > 0 && this.shouldDropExperience() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT))) {
                return this.getExperienceReward(worldserver, entity);
            }
        }
        return 0;
    }

    protected void dropExperience(@Nullable Entity entity) {
        if (!(this instanceof EntityEnderDragon)) {
            EntityExperienceOrb.award((WorldServer)this.level(), this.position(), this.expToDrop);
            this.expToDrop = 0;
        }
    }

    protected void dropCustomDeathLoot(WorldServer worldserver, DamageSource damagesource, boolean flag) {
    }

    public ResourceKey<LootTable> getLootTable() {
        return this.getType().getDefaultLootTable();
    }

    public long getLootTableSeed() {
        return 0L;
    }

    protected float getKnockback(Entity entity, DamageSource damagesource) {
        float f2 = (float)this.getAttributeValue(GenericAttributes.ATTACK_KNOCKBACK);
        net.minecraft.world.level.World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return EnchantmentManager.modifyKnockback(worldserver, this.getWeaponItem(), entity, damagesource, f2);
        }
        return f2;
    }

    protected void dropFromLootTable(DamageSource damagesource, boolean flag) {
        ResourceKey<LootTable> resourcekey = this.getLootTable();
        LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(resourcekey);
        LootParams.a lootparams_a = new LootParams.a((WorldServer)this.level()).withParameter(LootContextParameters.THIS_ENTITY, this).withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.DAMAGE_SOURCE, damagesource).withOptionalParameter(LootContextParameters.ATTACKING_ENTITY, damagesource.getEntity()).withOptionalParameter(LootContextParameters.DIRECT_ATTACKING_ENTITY, damagesource.getDirectEntity());
        if (flag && this.lastHurtByPlayer != null) {
            lootparams_a = lootparams_a.withParameter(LootContextParameters.LAST_DAMAGE_PLAYER, this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
        }
        LootParams lootparams = lootparams_a.create(LootContextParameterSets.ENTITY);
        loottable.getRandomItems(lootparams, this.getLootTableSeed(), this::spawnAtLocation);
    }

    public void knockback(double d0, double d1, double d2) {
        this.knockback(d0, d1, d2, null, EntityKnockbackEvent.KnockbackCause.UNKNOWN);
    }

    public void knockback(double d0, double d1, double d2, Entity attacker, EntityKnockbackEvent.KnockbackCause cause) {
        d0 *= 1.0 - this.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE);
        Vec3D vec3d = this.getDeltaMovement();
        while (d1 * d1 + d2 * d2 < (double)1.0E-5f) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d2 = (Math.random() - Math.random()) * 0.01;
        }
        Vec3D vec3d1 = new Vec3D(d1, 0.0, d2).normalize().scale(d0);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, cause, d0, vec3d1, vec3d.x / 2.0 - vec3d1.x, this.onGround() ? Math.min(0.4, vec3d.y / 2.0 + d0) : vec3d.y, vec3d.z / 2.0 - vec3d1.z);
        if (event.isCancelled()) {
            return;
        }
        this.hasImpulse = true;
        this.setDeltaMovement(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ());
    }

    public void indicateDamage(double d0, double d1) {
    }

    @Nullable
    protected SoundEffect getHurtSound(DamageSource damagesource) {
        return SoundEffects.GENERIC_HURT;
    }

    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.GENERIC_DEATH;
    }

    private SoundEffect getFallDamageSound(int i2) {
        return i2 > 4 ? this.getFallSounds().big() : this.getFallSounds().small();
    }

    public void skipDropExperience() {
        this.skipDropExperience = true;
    }

    public boolean wasExperienceConsumed() {
        return this.skipDropExperience;
    }

    public float getHurtDir() {
        return 0.0f;
    }

    protected AxisAlignedBB getHitbox() {
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        Entity entity = this.getVehicle();
        if (entity != null) {
            Vec3D vec3d = entity.getPassengerRidingPosition(this);
            return axisalignedbb.setMinY(Math.max(vec3d.y, axisalignedbb.minY));
        }
        return axisalignedbb;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> activeLocationDependentEnchantments() {
        return this.activeLocationDependentEnchantments;
    }

    public a getFallSounds() {
        return new a(SoundEffects.GENERIC_SMALL_FALL, SoundEffects.GENERIC_BIG_FALL);
    }

    protected SoundEffect getDrinkingSound(ItemStack itemstack) {
        return itemstack.getDrinkingSound();
    }

    public SoundEffect getEatingSound(ItemStack itemstack) {
        return itemstack.getEatingSound();
    }

    public SoundEffect getHurtSound0(DamageSource damagesource) {
        return this.getHurtSound(damagesource);
    }

    public SoundEffect getDeathSound0() {
        return this.getDeathSound();
    }

    public SoundEffect getFallDamageSound0(int fallHeight) {
        return this.getFallDamageSound(fallHeight);
    }

    public SoundEffect getDrinkingSound0(ItemStack itemstack) {
        return this.getDrinkingSound(itemstack);
    }

    public SoundEffect getEatingSound0(ItemStack itemstack) {
        return this.getEatingSound(itemstack);
    }

    public Optional<BlockPosition> getLastClimbablePos() {
        return this.lastClimbablePos;
    }

    public boolean onClimbable() {
        if (this.isSpectator()) {
            return false;
        }
        BlockPosition blockposition = this.blockPosition();
        IBlockData iblockdata = this.getInBlockState();
        if (iblockdata.is(TagsBlock.CLIMBABLE)) {
            this.lastClimbablePos = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.getBlock() instanceof BlockTrapdoor && this.trapdoorUsableAsLadder(blockposition, iblockdata)) {
            this.lastClimbablePos = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean trapdoorUsableAsLadder(BlockPosition blockposition, IBlockData iblockdata) {
        if (!iblockdata.getValue(BlockTrapdoor.OPEN).booleanValue()) {
            return false;
        }
        IBlockData iblockdata1 = this.level().getBlockState(blockposition.below());
        return iblockdata1.is(Blocks.LADDER) && iblockdata1.getValue(BlockLadder.FACING) == iblockdata.getValue(BlockTrapdoor.FACING);
    }

    @Override
    public boolean isAlive() {
        return !this.isRemoved() && this.getHealth() > 0.0f;
    }

    @Override
    public int getMaxFallDistance() {
        return this.getComfortableFallDistance(0.0f);
    }

    protected final int getComfortableFallDistance(float f2) {
        return MathHelper.floor(f2 + 3.0f);
    }

    @Override
    public boolean causeFallDamage(float f2, float f1, DamageSource damagesource) {
        boolean flag = super.causeFallDamage(f2, f1, damagesource);
        int i2 = this.calculateFallDamage(f2, f1);
        if (i2 > 0) {
            if (!this.hurt(damagesource, i2)) {
                return true;
            }
            this.playSound(this.getFallDamageSound(i2), 1.0f, 1.0f);
            this.playBlockFallSound();
            return true;
        }
        return flag;
    }

    protected int calculateFallDamage(float f2, float f1) {
        if (this.getType().is(TagsEntity.FALL_DAMAGE_IMMUNE)) {
            return 0;
        }
        float f22 = (float)this.getAttributeValue(GenericAttributes.SAFE_FALL_DISTANCE);
        float f3 = f2 - f22;
        return MathHelper.ceil((double)(f3 * f1) * this.getAttributeValue(GenericAttributes.FALL_DAMAGE_MULTIPLIER));
    }

    protected void playBlockFallSound() {
        if (!this.isSilent()) {
            int i2 = MathHelper.floor(this.getX());
            int j2 = MathHelper.floor(this.getY() - (double)0.2f);
            int k2 = MathHelper.floor(this.getZ());
            IBlockData iblockdata = this.level().getBlockState(new BlockPosition(i2, j2, k2));
            if (!iblockdata.isAir()) {
                SoundEffectType soundeffecttype = iblockdata.getSoundType();
                this.playSound(soundeffecttype.getFallSound(), soundeffecttype.getVolume() * 0.5f, soundeffecttype.getPitch() * 0.75f);
            }
        }
    }

    @Override
    public void animateHurt(float f2) {
        this.hurtTime = this.hurtDuration = 10;
    }

    public int getArmorValue() {
        return MathHelper.floor(this.getAttributeValue(GenericAttributes.ARMOR));
    }

    protected void hurtArmor(DamageSource damagesource, float f2) {
    }

    protected void hurtHelmet(DamageSource damagesource, float f2) {
    }

    protected void hurtCurrentlyUsedShield(float f2) {
    }

    protected void doHurtEquipment(DamageSource damagesource, float f2, EnumItemSlot ... aenumitemslot) {
        if (f2 > 0.0f) {
            int i2 = (int)Math.max(1.0f, f2 / 4.0f);
            EnumItemSlot[] aenumitemslot1 = aenumitemslot;
            int j2 = aenumitemslot.length;
            for (int k2 = 0; k2 < j2; ++k2) {
                EnumItemSlot enumitemslot = aenumitemslot1[k2];
                ItemStack itemstack = this.getItemBySlot(enumitemslot);
                if (!(itemstack.getItem() instanceof ItemArmor) || !itemstack.canBeHurtBy(damagesource)) continue;
                itemstack.hurtAndBreak(i2, this, enumitemslot);
            }
        }
    }

    protected float getDamageAfterArmorAbsorb(DamageSource damagesource, float f2) {
        if (!damagesource.is(DamageTypeTags.BYPASSES_ARMOR)) {
            f2 = CombatMath.getDamageAfterAbsorb(this, f2, damagesource, this.getArmorValue(), (float)this.getAttributeValue(GenericAttributes.ARMOR_TOUGHNESS));
        }
        return f2;
    }

    protected float getDamageAfterMagicAbsorb(DamageSource damagesource, float f2) {
        float f4;
        if (damagesource.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return f2;
        }
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        if (damagesource.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return f2;
        }
        net.minecraft.world.level.World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f4 = EnchantmentManager.getDamageProtection(worldserver, this, damagesource);
        } else {
            f4 = 0.0f;
        }
        if (f4 > 0.0f) {
            f2 = CombatMath.getDamageAfterMagicAbsorb(f2, f4);
        }
        return f2;
    }

    private EntityDamageEvent handleEntityDamage(final DamageSource damagesource, float f2) {
        float originalDamage = f2;
        Function<Double, Double> freezing = new Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.is(DamageTypeTags.IS_FREEZING) && EntityLiving.this.getType().is(TagsEntity.FREEZE_HURTS_EXTRA_TYPES)) {
                    return -(f2 - f2 * 5.0);
                }
                return -0.0;
            }
        };
        float freezingModifier = ((Double)freezing.apply((Object)f2)).floatValue();
        Function<Double, Double> hardHat = new Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.is(DamageTypeTags.DAMAGES_HELMET) && !EntityLiving.this.getItemBySlot(EnumItemSlot.HEAD).isEmpty()) {
                    return -(f2 - f2 * 0.75);
                }
                return -0.0;
            }
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(f2 += freezingModifier))).floatValue();
        Function<Double, Double> blocking = new Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(EntityLiving.this.isDamageSourceBlocked(damagesource) ? f2 : 0.0);
            }
        };
        float blockingModifier = ((Double)blocking.apply((Object)(f2 += hardHatModifier))).floatValue();
        Function<Double, Double> armor = new Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.getDamageAfterArmorAbsorb(damagesource, f2.floatValue()));
            }
        };
        float armorModifier = ((Double)armor.apply((Object)(f2 += blockingModifier))).floatValue();
        Function<Double, Double> resistance = new Function<Double, Double>(){

            public Double apply(Double f2) {
                if (!damagesource.is(DamageTypeTags.BYPASSES_EFFECTS) && EntityLiving.this.hasEffect(MobEffects.DAMAGE_RESISTANCE) && !damagesource.is(DamageTypeTags.BYPASSES_RESISTANCE)) {
                    int i2 = (EntityLiving.this.getEffect(MobEffects.DAMAGE_RESISTANCE).getAmplifier() + 1) * 5;
                    int j2 = 25 - i2;
                    float f1 = f2.floatValue() * (float)j2;
                    return -(f2 - (double)(f1 / 25.0f));
                }
                return -0.0;
            }
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(f2 += armorModifier))).floatValue();
        Function<Double, Double> magic = new Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.getDamageAfterMagicAbsorb(damagesource, f2.floatValue()));
            }
        };
        float magicModifier = ((Double)magic.apply((Object)(f2 += resistanceModifier))).floatValue();
        Function<Double, Double> absorption = new Function<Double, Double>(){

            public Double apply(Double f2) {
                return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.getAbsorptionAmount(), 0.0), 0.0);
            }
        };
        float absorptionModifier = ((Double)absorption.apply((Object)(f2 += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption);
    }

    protected boolean actuallyHurt(DamageSource damagesource, float f2, EntityDamageEvent event) {
        if (!this.isInvulnerableTo(damagesource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damagesource.getEntity() instanceof EntityHuman) {
                ((EntityHuman)damagesource.getEntity()).resetAttackStrengthTicker();
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).awardStat(StatisticList.DAMAGE_RESISTED, Math.round(f3 * 10.0f));
                } else if (damagesource.getEntity() instanceof EntityPlayer) {
                    ((EntityPlayer)damagesource.getEntity()).awardStat(StatisticList.DAMAGE_DEALT_RESISTED, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.is(DamageTypeTags.DAMAGES_HELMET) && !this.getItemBySlot(EnumItemSlot.HEAD).isEmpty()) {
                this.hurtHelmet(damagesource, f2);
            }
            if (!damagesource.is(DamageTypeTags.BYPASSES_ARMOR)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.hurtArmor(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.hurtCurrentlyUsedShield((float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
                Entity entity2 = damagesource.getDirectEntity();
                if (entity2 instanceof EntityLiving) {
                    this.blockUsingShield((EntityLiving)entity2);
                }
            }
            boolean human = this instanceof EntityHuman;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.setAbsorptionAmount(Math.max(this.getAbsorptionAmount() - absorptionModifier, 0.0f));
            float f22 = absorptionModifier;
            if (f22 > 0.0f && f22 < 3.4028235E37f && this instanceof EntityHuman) {
                ((EntityHuman)this).awardStat(StatisticList.DAMAGE_ABSORBED, Math.round(f22 * 10.0f));
            }
            if (f22 > 0.0f && f22 < 3.4028235E37f && (entity = damagesource.getEntity()) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.awardStat(StatisticList.DAMAGE_DEALT_ABSORBED, Math.round(f22 * 10.0f));
            }
            if (f2 > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damagesource.getFoodExhaustion(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f2 < 3.4028235E37f) {
                        ((EntityHuman)this).awardStat(StatisticList.DAMAGE_TAKEN, Math.round(f2 * 10.0f));
                    }
                }
                this.getCombatTracker().recordDamage(damagesource, f2);
                this.setHealth(this.getHealth() - f2);
                if (!human) {
                    this.setAbsorptionAmount(this.getAbsorptionAmount() - f2);
                }
                this.gameEvent(GameEvent.ENTITY_DAMAGE);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.ENTITY_HURT_PLAYER.trigger((EntityPlayer)this, damagesource, f2, originalDamage, true);
                    f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f22 > 0.0f && f22 < 3.4028235E37f) {
                        ((EntityPlayer)this).awardStat(StatisticList.DAMAGE_BLOCKED_BY_SHIELD, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.getEntity() instanceof EntityPlayer) {
                    CriterionTriggers.PLAYER_HURT_ENTITY.trigger((EntityPlayer)damagesource.getEntity(), this, damagesource, f2, originalDamage, true);
                }
                return true;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public CombatTracker getCombatTracker() {
        return this.combatTracker;
    }

    @Nullable
    public EntityLiving getKillCredit() {
        return this.lastHurtByPlayer != null ? this.lastHurtByPlayer : (this.lastHurtByMob != null ? this.lastHurtByMob : null);
    }

    public final float getMaxHealth() {
        return (float)this.getAttributeValue(GenericAttributes.MAX_HEALTH);
    }

    public final float getMaxAbsorption() {
        return (float)this.getAttributeValue(GenericAttributes.MAX_ABSORPTION);
    }

    public final int getArrowCount() {
        return this.entityData.get(DATA_ARROW_COUNT_ID);
    }

    public final void setArrowCount(int i2) {
        this.setArrowCount(i2, false);
    }

    public final void setArrowCount(int i2, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.getArrowCount(), i2, flag);
        if (event.isCancelled()) {
            return;
        }
        this.entityData.set(DATA_ARROW_COUNT_ID, event.getNewAmount());
    }

    public final int getStingerCount() {
        return this.entityData.get(DATA_STINGER_COUNT_ID);
    }

    public final void setStingerCount(int i2) {
        this.entityData.set(DATA_STINGER_COUNT_ID, i2);
    }

    private int getCurrentSwingDuration() {
        return MobEffectUtil.hasDigSpeed(this) ? 6 - (1 + MobEffectUtil.getDigSpeedAmplification(this)) : (this.hasEffect(MobEffects.DIG_SLOWDOWN) ? 6 + (1 + this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) * 2 : 6);
    }

    public void swing(EnumHand enumhand) {
        this.swing(enumhand, false);
    }

    public void swing(EnumHand enumhand, boolean flag) {
        if (!this.swinging || this.swingTime >= this.getCurrentSwingDuration() / 2 || this.swingTime < 0) {
            this.swingTime = -1;
            this.swinging = true;
            this.swingingArm = enumhand;
            if (this.level() instanceof WorldServer) {
                PacketPlayOutAnimation packetplayoutanimation = new PacketPlayOutAnimation(this, enumhand == EnumHand.MAIN_HAND ? 0 : 3);
                ChunkProviderServer chunkproviderserver = ((WorldServer)this.level()).getChunkSource();
                if (flag) {
                    chunkproviderserver.broadcastAndSend(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.broadcast(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void handleDamageEvent(DamageSource damagesource) {
        this.walkAnimation.setSpeed(1.5f);
        this.invulnerableTime = 20;
        this.hurtTime = this.hurtDuration = 10;
        SoundEffect soundeffect = this.getHurtSound(damagesource);
        if (soundeffect != null) {
            this.playSound(soundeffect, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        this.hurt(this.damageSources().generic(), 0.0f);
        this.lastDamageSource = damagesource;
        this.lastDamageStamp = this.level().getGameTime();
    }

    @Override
    public void handleEntityEvent(byte b0) {
        switch (b0) {
            case 3: {
                SoundEffect soundeffect = this.getDeathSound();
                if (soundeffect != null) {
                    this.playSound(soundeffect, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.setHealth(0.0f);
                this.die(this.damageSources().generic());
                break;
            }
            case 29: {
                this.playSound(SoundEffects.SHIELD_BLOCK, 1.0f, 0.8f + this.level().random.nextFloat() * 0.4f);
                break;
            }
            case 30: {
                this.playSound(SoundEffects.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
                break;
            }
            case 46: {
                boolean flag = true;
                for (int i2 = 0; i2 < 128; ++i2) {
                    double d0 = (double)i2 / 127.0;
                    float f2 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float f22 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    double d1 = MathHelper.lerp(d0, this.xo, this.getX()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    double d2 = MathHelper.lerp(d0, this.yo, this.getY()) + this.random.nextDouble() * (double)this.getBbHeight();
                    double d3 = MathHelper.lerp(d0, this.zo, this.getZ()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    this.level().addParticle(Particles.PORTAL, d1, d2, d3, f2, f1, f22);
                }
                return;
            }
            case 47: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.MAINHAND));
                break;
            }
            case 48: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.OFFHAND));
                break;
            }
            case 49: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.HEAD));
                break;
            }
            case 50: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.CHEST));
                break;
            }
            case 51: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.LEGS));
                break;
            }
            case 52: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.FEET));
                break;
            }
            case 54: {
                BlockHoney.showJumpParticles(this);
                break;
            }
            case 55: {
                this.swapHandItems();
                break;
            }
            case 60: {
                this.makePoofParticles();
                break;
            }
            case 65: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.BODY));
                break;
            }
            default: {
                super.handleEntityEvent(b0);
            }
        }
    }

    private void makePoofParticles() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(Particles.POOF, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    private void swapHandItems() {
        ItemStack itemstack = this.getItemBySlot(EnumItemSlot.OFFHAND);
        this.setItemSlot(EnumItemSlot.OFFHAND, this.getItemBySlot(EnumItemSlot.MAINHAND));
        this.setItemSlot(EnumItemSlot.MAINHAND, itemstack);
    }

    @Override
    protected void onBelowWorld() {
        this.hurt(this.damageSources().fellOutOfWorld(), 4.0f);
    }

    protected void updateSwingTime() {
        int i2 = this.getCurrentSwingDuration();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= i2) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / (float)i2;
    }

    @Nullable
    public AttributeModifiable getAttribute(Holder<AttributeBase> holder) {
        return this.getAttributes().getInstance(holder);
    }

    public double getAttributeValue(Holder<AttributeBase> holder) {
        return this.getAttributes().getValue(holder);
    }

    public double getAttributeBaseValue(Holder<AttributeBase> holder) {
        return this.getAttributes().getBaseValue(holder);
    }

    public AttributeMapBase getAttributes() {
        return this.attributes;
    }

    public ItemStack getMainHandItem() {
        return this.getItemBySlot(EnumItemSlot.MAINHAND);
    }

    public ItemStack getOffhandItem() {
        return this.getItemBySlot(EnumItemSlot.OFFHAND);
    }

    @Override
    @Nonnull
    public ItemStack getWeaponItem() {
        return this.getMainHandItem();
    }

    public boolean isHolding(net.minecraft.world.item.Item item) {
        return this.isHolding((ItemStack itemstack) -> itemstack.is(item));
    }

    public boolean isHolding(Predicate<ItemStack> predicate) {
        return predicate.test(this.getMainHandItem()) || predicate.test(this.getOffhandItem());
    }

    public ItemStack getItemInHand(EnumHand enumhand) {
        if (enumhand == EnumHand.MAIN_HAND) {
            return this.getItemBySlot(EnumItemSlot.MAINHAND);
        }
        if (enumhand == EnumHand.OFF_HAND) {
            return this.getItemBySlot(EnumItemSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
    }

    public void setItemInHand(EnumHand enumhand, ItemStack itemstack) {
        if (enumhand == EnumHand.MAIN_HAND) {
            this.setItemSlot(EnumItemSlot.MAINHAND, itemstack);
        } else {
            if (enumhand != EnumHand.OFF_HAND) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
            }
            this.setItemSlot(EnumItemSlot.OFFHAND, itemstack);
        }
    }

    public boolean hasItemInSlot(EnumItemSlot enumitemslot) {
        return !this.getItemBySlot(enumitemslot).isEmpty();
    }

    public boolean canUseSlot(EnumItemSlot enumitemslot) {
        return false;
    }

    public abstract Iterable<ItemStack> getArmorSlots();

    public abstract ItemStack getItemBySlot(EnumItemSlot var1);

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.setItemSlot(enumitemslot, itemstack);
    }

    public abstract void setItemSlot(EnumItemSlot var1, ItemStack var2);

    public Iterable<ItemStack> getHandSlots() {
        return List.of();
    }

    public Iterable<ItemStack> getArmorAndBodyArmorSlots() {
        return this.getArmorSlots();
    }

    public Iterable<ItemStack> getAllSlots() {
        return Iterables.concat(this.getHandSlots(), this.getArmorAndBodyArmorSlots());
    }

    protected void verifyEquippedItem(ItemStack itemstack) {
        itemstack.getItem().verifyComponentsAfterLoad(itemstack);
    }

    public float getArmorCoverPercentage() {
        Iterable<ItemStack> iterable = this.getArmorSlots();
        int i2 = 0;
        int j2 = 0;
        for (ItemStack itemstack : iterable) {
            if (!itemstack.isEmpty()) {
                ++j2;
            }
            ++i2;
        }
        return i2 > 0 ? (float)j2 / (float)i2 : 0.0f;
    }

    @Override
    public void setSprinting(boolean flag) {
        super.setSprinting(flag);
        AttributeModifiable attributemodifiable = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
        attributemodifiable.removeModifier(SPEED_MODIFIER_SPRINTING.id());
        if (flag) {
            attributemodifiable.addTransientModifier(SPEED_MODIFIER_SPRINTING);
        }
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    @Override
    public void push(Entity entity) {
        if (!this.isSleeping()) {
            super.push(entity);
        }
    }

    private void dismountVehicle(Entity entity) {
        Vec3D vec3d;
        if (this.isRemoved()) {
            vec3d = this.position();
        } else if (!entity.isRemoved() && !this.level().getBlockState(entity.blockPosition()).is(TagsBlock.PORTALS)) {
            vec3d = entity.getDismountLocationForPassenger(this);
        } else {
            double d0 = Math.max(this.getY(), entity.getY());
            vec3d = new Vec3D(this.getX(), d0, this.getZ());
        }
        this.dismountTo(vec3d.x, vec3d.y, vec3d.z);
    }

    @Override
    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    protected float getJumpPower() {
        return this.getJumpPower(1.0f);
    }

    protected float getJumpPower(float f2) {
        return (float)this.getAttributeValue(GenericAttributes.JUMP_STRENGTH) * f2 * this.getBlockJumpFactor() + this.getJumpBoostPower();
    }

    public float getJumpBoostPower() {
        return this.hasEffect(MobEffects.JUMP) ? 0.1f * ((float)this.getEffect(MobEffects.JUMP).getAmplifier() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void jumpFromGround() {
        float f2 = this.getJumpPower();
        if (f2 > 1.0E-5f) {
            Vec3D vec3d = this.getDeltaMovement();
            this.setDeltaMovement(vec3d.x, f2, vec3d.z);
            if (this.isSprinting()) {
                float f1 = this.getYRot() * ((float)Math.PI / 180);
                this.addDeltaMovement(new Vec3D((double)(-MathHelper.sin(f1)) * 0.2, 0.0, (double)MathHelper.cos(f1) * 0.2));
            }
            this.hasImpulse = true;
        }
    }

    protected void goDownInWater() {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04f, 0.0));
    }

    protected void jumpInLiquid(TagKey<FluidType> tagkey) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.04f, 0.0));
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }

    public boolean canStandOnFluid(Fluid fluid) {
        return false;
    }

    @Override
    protected double getDefaultGravity() {
        return this.getAttributeValue(GenericAttributes.GRAVITY);
    }

    public void travel(Vec3D vec3d) {
        if (this.isControlledByLocalInstance()) {
            boolean flag;
            double d0 = this.getGravity();
            boolean bl = flag = this.getDeltaMovement().y <= 0.0;
            if (flag && this.hasEffect(MobEffects.SLOW_FALLING)) {
                d0 = Math.min(d0, 0.01);
            }
            Fluid fluid = this.level().getFluidState(this.blockPosition());
            if (this.isInWater() && this.isAffectedByFluids() && !this.canStandOnFluid(fluid)) {
                double d1 = this.getY();
                float f2 = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
                float f1 = 0.02f;
                float f22 = (float)this.getAttributeValue(GenericAttributes.WATER_MOVEMENT_EFFICIENCY);
                if (!this.onGround()) {
                    f22 *= 0.5f;
                }
                if (f22 > 0.0f) {
                    f2 += (0.54600006f - f2) * f22;
                    f1 += (this.getSpeed() - f1) * f22;
                }
                if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                    f2 = 0.96f;
                }
                this.moveRelative(f1, vec3d);
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                Vec3D vec3d1 = this.getDeltaMovement();
                if (this.horizontalCollision && this.onClimbable()) {
                    vec3d1 = new Vec3D(vec3d1.x, 0.2, vec3d1.z);
                }
                this.setDeltaMovement(vec3d1.multiply(f2, 0.8f, f2));
                Vec3D vec3d2 = this.getFluidFallingAdjustedMovement(d0, flag, this.getDeltaMovement());
                this.setDeltaMovement(vec3d2);
                if (this.horizontalCollision && this.isFree(vec3d2.x, vec3d2.y + (double)0.6f - this.getY() + d1, vec3d2.z)) {
                    this.setDeltaMovement(vec3d2.x, 0.3f, vec3d2.z);
                }
            } else if (this.isInLava() && this.isAffectedByFluids() && !this.canStandOnFluid(fluid)) {
                Vec3D vec3d3;
                double d1 = this.getY();
                this.moveRelative(0.02f, vec3d);
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                if (this.getFluidHeight(TagsFluid.LAVA) <= this.getFluidJumpThreshold()) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.8f, 0.5));
                    vec3d3 = this.getFluidFallingAdjustedMovement(d0, flag, this.getDeltaMovement());
                    this.setDeltaMovement(vec3d3);
                } else {
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
                }
                if (d0 != 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -d0 / 4.0, 0.0));
                }
                vec3d3 = this.getDeltaMovement();
                if (this.horizontalCollision && this.isFree(vec3d3.x, vec3d3.y + (double)0.6f - this.getY() + d1, vec3d3.z)) {
                    this.setDeltaMovement(vec3d3.x, 0.3f, vec3d3.z);
                }
            } else if (this.isFallFlying()) {
                double d7;
                float f3;
                double d6;
                this.checkSlowFallDistance();
                Vec3D vec3d4 = this.getDeltaMovement();
                Vec3D vec3d5 = this.getLookAngle();
                float f4 = this.getXRot() * ((float)Math.PI / 180);
                double d2 = Math.sqrt(vec3d5.x * vec3d5.x + vec3d5.z * vec3d5.z);
                double d3 = vec3d4.horizontalDistance();
                double d4 = vec3d5.length();
                double d5 = Math.cos(f4);
                d5 = d5 * d5 * Math.min(1.0, d4 / 0.4);
                vec3d4 = this.getDeltaMovement().add(0.0, d0 * (-1.0 + d5 * 0.75), 0.0);
                if (vec3d4.y < 0.0 && d2 > 0.0) {
                    d6 = vec3d4.y * -0.1 * d5;
                    vec3d4 = vec3d4.add(vec3d5.x * d6 / d2, d6, vec3d5.z * d6 / d2);
                }
                if (f4 < 0.0f && d2 > 0.0) {
                    d6 = d3 * (double)(-MathHelper.sin(f4)) * 0.04;
                    vec3d4 = vec3d4.add(-vec3d5.x * d6 / d2, d6 * 3.2, -vec3d5.z * d6 / d2);
                }
                if (d2 > 0.0) {
                    vec3d4 = vec3d4.add((vec3d5.x / d2 * d3 - vec3d4.x) * 0.1, 0.0, (vec3d5.z / d2 * d3 - vec3d4.z) * 0.1);
                }
                this.setDeltaMovement(vec3d4.multiply(0.99f, 0.98f, 0.99f));
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                if (this.horizontalCollision && !this.level().isClientSide && (f3 = (float)((d7 = d3 - (d6 = this.getDeltaMovement().horizontalDistance())) * 10.0 - 3.0)) > 0.0f) {
                    this.playSound(this.getFallDamageSound((int)f3), 1.0f, 1.0f);
                    this.hurt(this.damageSources().flyIntoWall(), f3);
                }
                if (this.onGround() && !this.level().isClientSide && this.getSharedFlag(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.setSharedFlag(7, false);
                }
            } else {
                BlockPosition blockposition = this.getBlockPosBelowThatAffectsMyMovement();
                float f4 = this.level().getBlockState(blockposition).getBlock().getFriction();
                float f5 = this.onGround() ? f4 * 0.91f : 0.91f;
                Vec3D vec3d6 = this.handleRelativeFrictionAndCalculateMovement(vec3d, f4);
                double d8 = vec3d6.y;
                d8 = this.hasEffect(MobEffects.LEVITATION) ? (d8 += (0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) - vec3d6.y) * 0.2) : (this.level().isClientSide && !this.level().hasChunkAt(blockposition) ? (this.getY() > (double)this.level().getMinBuildHeight() ? -0.1 : 0.0) : (d8 -= d0));
                if (this.shouldDiscardFriction()) {
                    this.setDeltaMovement(vec3d6.x, d8, vec3d6.z);
                } else {
                    this.setDeltaMovement(vec3d6.x * (double)f5, this instanceof EntityBird ? d8 * (double)f5 : d8 * (double)0.98f, vec3d6.z * (double)f5);
                }
            }
        }
        this.calculateEntityAnimation(this instanceof EntityBird);
    }

    private void travelRidden(EntityHuman entityhuman, Vec3D vec3d) {
        Vec3D vec3d1 = this.getRiddenInput(entityhuman, vec3d);
        this.tickRidden(entityhuman, vec3d1);
        if (this.isControlledByLocalInstance()) {
            this.setSpeed(this.getRiddenSpeed(entityhuman));
            this.travel(vec3d1);
        } else {
            this.calculateEntityAnimation(false);
            this.setDeltaMovement(Vec3D.ZERO);
            this.tryCheckInsideBlocks();
        }
    }

    protected void tickRidden(EntityHuman entityhuman, Vec3D vec3d) {
    }

    protected Vec3D getRiddenInput(EntityHuman entityhuman, Vec3D vec3d) {
        return vec3d;
    }

    protected float getRiddenSpeed(EntityHuman entityhuman) {
        return this.getSpeed();
    }

    public void calculateEntityAnimation(boolean flag) {
        float f2 = (float)MathHelper.length(this.getX() - this.xo, flag ? this.getY() - this.yo : 0.0, this.getZ() - this.zo);
        this.updateWalkAnimation(f2);
    }

    protected void updateWalkAnimation(float f2) {
        float f1 = Math.min(f2 * 4.0f, 1.0f);
        this.walkAnimation.update(f1, 0.4f);
    }

    public Vec3D handleRelativeFrictionAndCalculateMovement(Vec3D vec3d, float f2) {
        this.moveRelative(this.getFrictionInfluencedSpeed(f2), vec3d);
        this.setDeltaMovement(this.handleOnClimbable(this.getDeltaMovement()));
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        Vec3D vec3d1 = this.getDeltaMovement();
        if ((this.horizontalCollision || this.jumping) && (this.onClimbable() || this.getInBlockState().is(Blocks.POWDER_SNOW) && PowderSnowBlock.canEntityWalkOnPowderSnow(this))) {
            vec3d1 = new Vec3D(vec3d1.x, 0.2, vec3d1.z);
        }
        return vec3d1;
    }

    public Vec3D getFluidFallingAdjustedMovement(double d0, boolean flag, Vec3D vec3d) {
        if (d0 != 0.0 && !this.isSprinting()) {
            double d1 = flag && Math.abs(vec3d.y - 0.005) >= 0.003 && Math.abs(vec3d.y - d0 / 16.0) < 0.003 ? -0.003 : vec3d.y - d0 / 16.0;
            return new Vec3D(vec3d.x, d1, vec3d.z);
        }
        return vec3d;
    }

    private Vec3D handleOnClimbable(Vec3D vec3d) {
        if (this.onClimbable()) {
            this.resetFallDistance();
            float f2 = 0.15f;
            double d0 = MathHelper.clamp(vec3d.x, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.clamp(vec3d.z, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(vec3d.y, (double)-0.15f);
            if (d2 < 0.0 && !this.getInBlockState().is(Blocks.SCAFFOLDING) && this.isSuppressingSlidingDownLadder() && this instanceof EntityHuman) {
                d2 = 0.0;
            }
            vec3d = new Vec3D(d0, d2, d1);
        }
        return vec3d;
    }

    private float getFrictionInfluencedSpeed(float f2) {
        return this.onGround() ? this.getSpeed() * (0.21600002f / (f2 * f2 * f2)) : this.getFlyingSpeed();
    }

    protected float getFlyingSpeed() {
        return this.getControllingPassenger() instanceof EntityHuman ? this.getSpeed() * 0.1f : 0.02f;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float f2) {
        this.speed = f2;
    }

    public boolean doHurtTarget(Entity entity) {
        this.setLastHurtMob(entity);
        return false;
    }

    @Override
    public void tick() {
        float f4;
        SpigotTimings.timerEntityBaseTick.startTiming();
        super.tick();
        this.updatingUsingItem();
        this.updateSwimAmount();
        if (!this.level().isClientSide) {
            int j2;
            int i2 = this.getArrowCount();
            if (i2 > 0) {
                if (this.removeArrowTime <= 0) {
                    this.removeArrowTime = 20 * (30 - i2);
                }
                --this.removeArrowTime;
                if (this.removeArrowTime <= 0) {
                    this.setArrowCount(i2 - 1);
                }
            }
            if ((j2 = this.getStingerCount()) > 0) {
                if (this.removeStingerTime <= 0) {
                    this.removeStingerTime = 20 * (30 - j2);
                }
                --this.removeStingerTime;
                if (this.removeStingerTime <= 0) {
                    this.setStingerCount(j2 - 1);
                }
            }
            this.detectEquipmentUpdatesPublic();
            if (this.tickCount % 20 == 0) {
                this.getCombatTracker().recheckStatus();
            }
            if (this.isSleeping() && !this.checkBedExists()) {
                this.stopSleeping();
            }
        }
        if (!this.isRemoved()) {
            SpigotTimings.timerEntityBaseTick.stopTiming();
            this.aiStep();
            SpigotTimings.timerEntityTickRest.startTiming();
        }
        double d0 = this.getX() - this.xo;
        double d1 = this.getZ() - this.zo;
        float f2 = (float)(d0 * d0 + d1 * d1);
        float f1 = this.yBodyRot;
        float f22 = 0.0f;
        this.oRun = this.run;
        float f3 = 0.0f;
        if (f2 > 0.0025000002f) {
            f3 = 1.0f;
            f22 = (float)Math.sqrt(f2) * 3.0f;
            f4 = (float)MathHelper.atan2(d1, d0) * 57.295776f - 90.0f;
            float f5 = MathHelper.abs(MathHelper.wrapDegrees(this.getYRot()) - f4);
            f1 = 95.0f < f5 && f5 < 265.0f ? f4 - 180.0f : f4;
        }
        if (this.attackAnim > 0.0f) {
            f1 = this.getYRot();
        }
        if (!this.onGround()) {
            f3 = 0.0f;
        }
        this.run += (f3 - this.run) * 0.3f;
        this.level().getProfiler().push("headTurn");
        f22 = this.tickHeadTurn(f1, f22);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("rangeChecks");
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO < -180.0f) {
            this.yBodyRotO -= 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO >= 180.0f) {
            this.yBodyRotO += 360.0f;
        }
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO < -180.0f) {
            this.yHeadRotO -= 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO >= 180.0f) {
            this.yHeadRotO += 360.0f;
        }
        this.level().getProfiler().pop();
        this.animStep += f22;
        this.fallFlyTicks = this.isFallFlying() ? ++this.fallFlyTicks : 0;
        if (this.isSleeping()) {
            this.setXRot(0.0f);
        }
        this.refreshDirtyAttributes();
        f4 = this.getScale();
        if (f4 != this.appliedScale) {
            this.appliedScale = f4;
            this.refreshDimensions();
        }
        SpigotTimings.timerEntityTickRest.stopTiming();
    }

    public void detectEquipmentUpdatesPublic() {
        Map<EnumItemSlot, ItemStack> map = this.collectEquipmentChanges();
        if (map != null) {
            this.handleHandSwap(map);
            if (!map.isEmpty()) {
                this.handleEquipmentChanges(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> collectEquipmentChanges() {
        Map map = null;
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            ItemStack itemstack1 = switch (enumitemslot.getType()) {
                case EnumItemSlot.Function.HAND -> this.getLastHandItem(enumitemslot);
                case EnumItemSlot.Function.HUMANOID_ARMOR -> this.getLastArmorItem(enumitemslot);
                case EnumItemSlot.Function.ANIMAL_ARMOR -> this.lastBodyItemStack;
                default -> throw new MatchException(null, null);
            };
            ItemStack itemstack2 = this.getItemBySlot(enumitemslot);
            if (!this.equipmentHasChanged(itemstack1, itemstack2)) continue;
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
            }
            map.put(enumitemslot, itemstack2);
            AttributeMapBase attributemapbase = this.getAttributes();
            if (itemstack1.isEmpty()) continue;
            itemstack1.forEachModifier(enumitemslot, (holder, attributemodifier) -> {
                AttributeModifiable attributemodifiable = attributemapbase.getInstance((Holder<AttributeBase>)holder);
                if (attributemodifiable != null) {
                    attributemodifiable.removeModifier((AttributeModifier)attributemodifier);
                }
                EnchantmentManager.stopLocationBasedEffects(itemstack1, this, enumitemslot);
            });
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EnumItemSlot enumitemslot1 = (EnumItemSlot)entry.getKey();
                ItemStack itemstack3 = (ItemStack)entry.getValue();
                if (itemstack3.isEmpty()) continue;
                itemstack3.forEachModifier(enumitemslot1, (holder, attributemodifier) -> {
                    net.minecraft.world.level.World world;
                    AttributeModifiable attributemodifiable = this.attributes.getInstance((Holder<AttributeBase>)holder);
                    if (attributemodifiable != null) {
                        attributemodifiable.removeModifier(attributemodifier.id());
                        attributemodifiable.addTransientModifier((AttributeModifier)attributemodifier);
                    }
                    if ((world = this.level()) instanceof WorldServer) {
                        WorldServer worldserver = (WorldServer)world;
                        EnchantmentManager.runLocationChangedEffects(worldserver, itemstack3, this, enumitemslot1);
                    }
                });
            }
        }
        return map;
    }

    public boolean equipmentHasChanged(ItemStack itemstack, ItemStack itemstack1) {
        return !ItemStack.matches(itemstack1, itemstack);
    }

    private void handleHandSwap(Map<EnumItemSlot, ItemStack> map) {
        ItemStack itemstack = map.get(EnumItemSlot.MAINHAND);
        ItemStack itemstack1 = map.get(EnumItemSlot.OFFHAND);
        if (itemstack != null && itemstack1 != null && ItemStack.matches(itemstack, this.getLastHandItem(EnumItemSlot.OFFHAND)) && ItemStack.matches(itemstack1, this.getLastHandItem(EnumItemSlot.MAINHAND))) {
            ((WorldServer)this.level()).getChunkSource().broadcast(this, new PacketPlayOutEntityStatus(this, 55));
            map.remove(EnumItemSlot.MAINHAND);
            map.remove(EnumItemSlot.OFFHAND);
            this.setLastHandItem(EnumItemSlot.MAINHAND, itemstack.copy());
            this.setLastHandItem(EnumItemSlot.OFFHAND, itemstack1.copy());
        }
    }

    private void handleEquipmentChanges(Map<EnumItemSlot, ItemStack> map) {
        ArrayList list = Lists.newArrayListWithCapacity((int)map.size());
        map.forEach((enumitemslot, itemstack) -> {
            ItemStack itemstack1 = itemstack.copy();
            list.add(Pair.of((Object)enumitemslot, (Object)itemstack1));
            switch (enumitemslot.getType()) {
                case HAND: {
                    this.setLastHandItem((EnumItemSlot)enumitemslot, itemstack1);
                    break;
                }
                case HUMANOID_ARMOR: {
                    this.setLastArmorItem((EnumItemSlot)enumitemslot, itemstack1);
                    break;
                }
                case ANIMAL_ARMOR: {
                    this.lastBodyItemStack = itemstack1;
                }
            }
        });
        ((WorldServer)this.level()).getChunkSource().broadcast(this, new PacketPlayOutEntityEquipment(this.getId(), list));
    }

    private ItemStack getLastArmorItem(EnumItemSlot enumitemslot) {
        return this.lastArmorItemStacks.get(enumitemslot.getIndex());
    }

    private void setLastArmorItem(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.lastArmorItemStacks.set(enumitemslot.getIndex(), itemstack);
    }

    private ItemStack getLastHandItem(EnumItemSlot enumitemslot) {
        return this.lastHandItemStacks.get(enumitemslot.getIndex());
    }

    private void setLastHandItem(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.lastHandItemStacks.set(enumitemslot.getIndex(), itemstack);
    }

    protected float tickHeadTurn(float f2, float f1) {
        boolean flag;
        float f22 = MathHelper.wrapDegrees(f2 - this.yBodyRot);
        this.yBodyRot += f22 * 0.3f;
        float f3 = MathHelper.wrapDegrees(this.getYRot() - this.yBodyRot);
        float f4 = this.getMaxHeadRotationRelativeToBody();
        if (Math.abs(f3) > f4) {
            this.yBodyRot += f3 - (float)MathHelper.sign(f3) * f4;
        }
        boolean bl = flag = f3 < -90.0f || f3 >= 90.0f;
        if (flag) {
            f1 *= -1.0f;
        }
        return f1;
    }

    protected float getMaxHeadRotationRelativeToBody() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void aiStep() {
        if (this.noJumpDelay > 0) {
            --this.noJumpDelay;
        }
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        } else if (!this.isEffectiveAi()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
        if (this.lerpHeadSteps > 0) {
            this.lerpHeadRotationStep(this.lerpHeadSteps, this.lerpYHeadRot);
            --this.lerpHeadSteps;
        }
        vec3d = this.getDeltaMovement();
        d0 = vec3d.x;
        d1 = vec3d.y;
        d2 = vec3d.z;
        if (Math.abs(vec3d.x) < 0.003) {
            d0 = 0.0;
        }
        if (Math.abs(vec3d.y) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec3d.z) < 0.003) {
            d2 = 0.0;
        }
        this.setDeltaMovement(d0, d1, d2);
        this.level().getProfiler().push("ai");
        SpigotTimings.timerEntityAI.startTiming();
        if (this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        } else if (this.isEffectiveAi()) {
            this.level().getProfiler().push("newAi");
            this.serverAiStep();
            this.level().getProfiler().pop();
        }
        SpigotTimings.timerEntityAI.stopTiming();
        this.level().getProfiler().pop();
        this.level().getProfiler().push("jump");
        if (this.jumping && this.isAffectedByFluids()) {
            d3 = this.isInLava() != false ? this.getFluidHeight(TagsFluid.LAVA) : this.getFluidHeight(TagsFluid.WATER);
            flag = this.isInWater() != false && d3 > 0.0;
            d4 = this.getFluidJumpThreshold();
            if (flag && (!this.onGround() || d3 > d4)) {
                this.jumpInLiquid(TagsFluid.WATER);
            } else if (this.isInLava() && (!this.onGround() || d3 > d4)) {
                this.jumpInLiquid(TagsFluid.LAVA);
            } else if ((this.onGround() || flag && d3 <= d4) && this.noJumpDelay == 0) {
                this.jumpFromGround();
                this.noJumpDelay = 10;
            }
        } else {
            this.noJumpDelay = 0;
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("travel");
        this.xxa *= 0.98f;
        this.zza *= 0.98f;
        this.updateFallFlying();
        axisalignedbb = this.getBoundingBox();
        vec3d1 = new Vec3D(this.xxa, this.yya, this.zza);
        if (this.hasEffect(MobEffects.SLOW_FALLING) || this.hasEffect(MobEffects.LEVITATION)) {
            this.resetFallDistance();
        }
        SpigotTimings.timerEntityAIMove.startTiming();
        entityliving = this.getControllingPassenger();
        if (!(entityliving instanceof EntityHuman)) ** GOTO lbl-1000
        entityhuman = (EntityHuman)entityliving;
        if (this.isAlive()) {
            this.travelRidden(entityhuman, vec3d1);
        } else lbl-1000:
        // 2 sources

        {
            this.travel(vec3d1);
        }
        SpigotTimings.timerEntityAIMove.stopTiming();
        this.level().getProfiler().pop();
        this.level().getProfiler().push("freezing");
        if (!this.level().isClientSide && !this.isDeadOrDying()) {
            i = this.getTicksFrozen();
            if (this.isInPowderSnow && this.canFreeze()) {
                this.setTicksFrozen(Math.min(this.getTicksRequiredToFreeze(), i + 1));
            } else {
                this.setTicksFrozen(Math.max(0, i - 2));
            }
        }
        this.removeFrost();
        this.tryAddFrost();
        if (!this.level().isClientSide && this.tickCount % 40 == 0 && this.isFullyFrozen() && this.canFreeze()) {
            this.hurt(this.damageSources().freeze(), 1.0f);
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("push");
        if (this.autoSpinAttackTicks > 0) {
            --this.autoSpinAttackTicks;
            this.checkAutoSpinAttack(axisalignedbb, this.getBoundingBox());
        }
        SpigotTimings.timerEntityAICollision.startTiming();
        this.pushEntities();
        SpigotTimings.timerEntityAICollision.stopTiming();
        this.level().getProfiler().pop();
        if (!this.level().isClientSide && this.isSensitiveToWater() && this.isInWaterRainOrBubble()) {
            this.hurt(this.damageSources().drown(), 1.0f);
        }
    }

    public boolean isSensitiveToWater() {
        return false;
    }

    private void updateFallFlying() {
        boolean flag = this.getSharedFlag(7);
        if (flag && !this.onGround() && !this.isPassenger() && !this.hasEffect(MobEffects.LEVITATION)) {
            ItemStack itemstack = this.getItemBySlot(EnumItemSlot.CHEST);
            if (itemstack.is(Items.ELYTRA) && ItemElytra.isFlyEnabled(itemstack)) {
                flag = true;
                int i2 = this.fallFlyTicks + 1;
                if (!this.level().isClientSide && i2 % 10 == 0) {
                    int j2 = i2 / 10;
                    if (j2 % 2 == 0) {
                        itemstack.hurtAndBreak(1, this, EnumItemSlot.CHEST);
                    }
                    this.gameEvent(GameEvent.ELYTRA_GLIDE);
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!this.level().isClientSide && flag != this.getSharedFlag(7) && !CraftEventFactory.callToggleGlideEvent(this, flag).isCancelled()) {
            this.setSharedFlag(7, flag);
        }
    }

    protected void serverAiStep() {
    }

    protected void pushEntities() {
        if (this.level().isClientSide()) {
            this.level().getEntities(EntityTypeTest.forClass(EntityHuman.class), this.getBoundingBox(), IEntitySelector.pushableBy(this)).forEach(this::doPush);
        } else {
            List<Entity> list = this.level().getEntities(this, this.getBoundingBox(), IEntitySelector.pushableBy(this));
            if (!list.isEmpty()) {
                int i2 = this.level().getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
                if (i2 > 0 && list.size() > i2 - 1 && this.random.nextInt(4) == 0) {
                    int j2 = 0;
                    for (Entity entity : list) {
                        if (entity.isPassenger()) continue;
                        ++j2;
                    }
                    if (j2 > i2 - 1) {
                        this.hurt(this.damageSources().cramming(), 6.0f);
                    }
                }
                for (Entity entity1 : list) {
                    this.doPush(entity1);
                }
            }
        }
    }

    protected void checkAutoSpinAttack(AxisAlignedBB axisalignedbb, AxisAlignedBB axisalignedbb1) {
        AxisAlignedBB axisalignedbb2 = axisalignedbb.minmax(axisalignedbb1);
        List<Entity> list = this.level().getEntities(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityLiving)) continue;
                this.doAutoAttackOnTouch((EntityLiving)entity);
                this.autoSpinAttackTicks = 0;
                this.setDeltaMovement(this.getDeltaMovement().scale(-0.2));
                break;
            }
        } else if (this.horizontalCollision) {
            this.autoSpinAttackTicks = 0;
        }
        if (!this.level().isClientSide && this.autoSpinAttackTicks <= 0) {
            this.setLivingEntityFlag(4, false);
            this.autoSpinAttackDmg = 0.0f;
            this.autoSpinAttackItemStack = null;
        }
    }

    protected void doPush(Entity entity) {
        entity.push(this);
    }

    protected void doAutoAttackOnTouch(EntityLiving entityliving) {
    }

    public boolean isAutoSpinAttack() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 4) != 0;
    }

    @Override
    public void stopRiding() {
        Entity entity = this.getVehicle();
        super.stopRiding();
        if (entity != null && entity != this.getVehicle() && !this.level().isClientSide) {
            this.dismountVehicle(entity);
        }
    }

    @Override
    public void rideTick() {
        super.rideTick();
        this.oRun = this.run;
        this.run = 0.0f;
        this.resetFallDistance();
    }

    @Override
    public void lerpTo(double d0, double d1, double d2, float f2, float f1, int i2) {
        this.lerpX = d0;
        this.lerpY = d1;
        this.lerpZ = d2;
        this.lerpYRot = f2;
        this.lerpXRot = f1;
        this.lerpSteps = i2;
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    @Override
    public void lerpHeadTo(float f2, int i2) {
        this.lerpYHeadRot = f2;
        this.lerpHeadSteps = i2;
    }

    public void setJumping(boolean flag) {
        this.jumping = flag;
    }

    public void onItemPickup(EntityItem entityitem) {
        Entity entity = entityitem.getOwner();
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.THROWN_ITEM_PICKED_UP_BY_ENTITY.trigger((EntityPlayer)entity, entityitem.getItem(), this);
        }
    }

    public void take(Entity entity, int i2) {
        if (!entity.isRemoved() && !this.level().isClientSide && (entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityExperienceOrb)) {
            ((WorldServer)this.level()).getChunkSource().broadcast(entity, new PacketPlayOutCollect(entity.getId(), this.getId(), i2));
        }
    }

    public boolean hasLineOfSight(Entity entity) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.getX(), this.getEyeY(), this.getZ());
        Vec3D vec3d1 = new Vec3D(entity.getX(), entity.getEyeY(), entity.getZ());
        return vec3d1.distanceTo(vec3d) > 128.0 ? false : this.level().clip(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, this)).getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    @Override
    public float getViewYRot(float f2) {
        return f2 == 1.0f ? this.yHeadRot : MathHelper.lerp(f2, this.yHeadRotO, this.yHeadRot);
    }

    public float getAttackAnim(float f2) {
        float f1 = this.attackAnim - this.oAttackAnim;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.oAttackAnim + f1 * f2;
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved() && this.collides;
    }

    @Override
    public boolean isPushable() {
        return this.isAlive() && !this.isSpectator() && !this.onClimbable() && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.isPushable() && this.collides != this.collidableExemptions.contains(entity.getUUID());
    }

    @Override
    public float getYHeadRot() {
        return this.yHeadRot;
    }

    @Override
    public void setYHeadRot(float f2) {
        this.yHeadRot = f2;
    }

    @Override
    public void setYBodyRot(float f2) {
        this.yBodyRot = f2;
    }

    @Override
    public Vec3D getRelativePortalPosition(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return EntityLiving.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(enumdirection_enumaxis, blockutil_rectangle));
    }

    public static Vec3D resetForwardDirectionOfRelativePortalPosition(Vec3D vec3d) {
        return new Vec3D(vec3d.x, vec3d.y, 0.0);
    }

    public float getAbsorptionAmount() {
        return this.absorptionAmount;
    }

    public final void setAbsorptionAmount(float f2) {
        this.internalSetAbsorptionAmount(MathHelper.clamp(f2, 0.0f, this.getMaxAbsorption()));
    }

    protected void internalSetAbsorptionAmount(float f2) {
        this.absorptionAmount = f2;
    }

    public void onEnterCombat() {
    }

    public void onLeaveCombat() {
    }

    protected void updateEffectVisibility() {
        this.effectsDirty = true;
    }

    public abstract EnumMainHand getMainArm();

    public boolean isUsingItem() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 1) > 0;
    }

    public EnumHand getUsedItemHand() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 2) > 0 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
    }

    private void updatingUsingItem() {
        if (this.isUsingItem()) {
            if (ItemStack.isSameItem(this.getItemInHand(this.getUsedItemHand()), this.useItem)) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                this.updateUsingItem(this.useItem);
            } else {
                this.stopUsingItem();
            }
        }
    }

    protected void updateUsingItem(ItemStack itemstack) {
        itemstack.onUseTick(this.level(), this, this.getUseItemRemainingTicks());
        if (this.shouldTriggerItemUseEffects()) {
            this.triggerItemUseEffects(itemstack, 5);
        }
        if (--this.useItemRemaining == 0 && !this.level().isClientSide && !itemstack.useOnRelease()) {
            this.completeUsingItem();
        }
    }

    private boolean shouldTriggerItemUseEffects() {
        int j2;
        int i2 = this.useItem.getUseDuration(this) - this.getUseItemRemainingTicks();
        boolean flag = i2 > (j2 = (int)((float)this.useItem.getUseDuration(this) * 0.21875f));
        return flag && this.getUseItemRemainingTicks() % 4 == 0;
    }

    private void updateSwimAmount() {
        this.swimAmountO = this.swimAmount;
        this.swimAmount = this.isVisuallySwimming() ? Math.min(1.0f, this.swimAmount + 0.09f) : Math.max(0.0f, this.swimAmount - 0.09f);
    }

    public void setLivingEntityFlag(int i2, boolean flag) {
        int j2 = this.entityData.get(DATA_LIVING_ENTITY_FLAGS).byteValue();
        j2 = flag ? (j2 |= i2) : (j2 &= ~i2);
        this.entityData.set(DATA_LIVING_ENTITY_FLAGS, (byte)j2);
    }

    public void startUsingItem(EnumHand enumhand) {
        ItemStack itemstack = this.getItemInHand(enumhand);
        if (!itemstack.isEmpty() && !this.isUsingItem()) {
            this.useItem = itemstack;
            this.useItemRemaining = itemstack.getUseDuration(this);
            if (!this.level().isClientSide) {
                this.setLivingEntityFlag(1, true);
                this.setLivingEntityFlag(2, enumhand == EnumHand.OFF_HAND);
                this.gameEvent(GameEvent.ITEM_INTERACT_START);
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        super.onSyncedDataUpdated(datawatcherobject);
        if (SLEEPING_POS_ID.equals(datawatcherobject)) {
            if (this.level().isClientSide) {
                this.getSleepingPos().ifPresent(this::setPosToBed);
            }
        } else if (DATA_LIVING_ENTITY_FLAGS.equals(datawatcherobject) && this.level().isClientSide) {
            if (this.isUsingItem() && this.useItem.isEmpty()) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                if (!this.useItem.isEmpty()) {
                    this.useItemRemaining = this.useItem.getUseDuration(this);
                }
            } else if (!this.isUsingItem() && !this.useItem.isEmpty()) {
                this.useItem = ItemStack.EMPTY;
                this.useItemRemaining = 0;
            }
        }
    }

    @Override
    public void lookAt(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.lookAt(argumentanchor_anchor, vec3d);
        this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yBodyRot = this.yHeadRot;
    }

    @Override
    public float getPreciseBodyRotation(float f2) {
        return MathHelper.lerp(f2, this.yBodyRotO, this.yBodyRot);
    }

    protected void triggerItemUseEffects(ItemStack itemstack, int i2) {
        if (!itemstack.isEmpty() && this.isUsingItem()) {
            if (itemstack.getUseAnimation() == EnumAnimation.DRINK) {
                this.playSound(this.getDrinkingSound(itemstack), 0.5f, this.level().random.nextFloat() * 0.1f + 0.9f);
            }
            if (itemstack.getUseAnimation() == EnumAnimation.EAT) {
                this.spawnItemParticles(itemstack, i2);
                this.playSound(this.getEatingSound(itemstack), 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    private void spawnItemParticles(ItemStack itemstack, int i2) {
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3d = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vec3d = vec3d.yRot(-this.getYRot() * ((float)Math.PI / 180));
            double d0 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
            Vec3D vec3d1 = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.yRot(-this.getYRot() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.add(this.getX(), this.getEyeY(), this.getZ());
            this.level().addParticle(new ParticleParamItem(Particles.ITEM, itemstack), vec3d1.x, vec3d1.y, vec3d1.z, vec3d.x, vec3d.y + 0.05, vec3d.z);
        }
    }

    protected void completeUsingItem() {
        if (!this.level().isClientSide || this.isUsingItem()) {
            EnumHand enumhand = this.getUsedItemHand();
            if (!this.useItem.equals(this.getItemInHand(enumhand))) {
                this.releaseUsingItem();
            } else if (!this.useItem.isEmpty() && this.isUsingItem()) {
                ItemStack itemstack;
                this.triggerItemUseEffects(this.useItem, 16);
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer) {
                    EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.useItem);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    PlayerItemConsumeEvent event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        net.minecraft.world.item.Item item = this.useItem.getItem();
                        if (item instanceof ItemSuspiciousStew) {
                            ItemSuspiciousStew itemSuspiciousStew = (ItemSuspiciousStew)item;
                            itemSuspiciousStew.cancelUsingItem(entityPlayer, this.useItem);
                        }
                        entityPlayer.getBukkitEntity().updateInventory();
                        entityPlayer.getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.useItem.finishUsingItem(this.level(), this) : CraftItemStack.asNMSCopy(event.getItem()).finishUsingItem(this.level(), this);
                } else {
                    itemstack = this.useItem.finishUsingItem(this.level(), this);
                }
                if (itemstack != this.useItem) {
                    this.setItemInHand(enumhand, itemstack);
                }
                this.stopUsingItem();
            }
        }
    }

    public ItemStack getUseItem() {
        return this.useItem;
    }

    public int getUseItemRemainingTicks() {
        return this.useItemRemaining;
    }

    public int getTicksUsingItem() {
        return this.isUsingItem() ? this.useItem.getUseDuration(this) - this.getUseItemRemainingTicks() : 0;
    }

    public void releaseUsingItem() {
        if (!this.useItem.isEmpty()) {
            this.useItem.releaseUsing(this.level(), this, this.getUseItemRemainingTicks());
            if (this.useItem.useOnRelease()) {
                this.updatingUsingItem();
            }
        }
        this.stopUsingItem();
    }

    public void stopUsingItem() {
        if (!this.level().isClientSide) {
            boolean flag = this.isUsingItem();
            this.setLivingEntityFlag(1, false);
            if (flag) {
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
        }
        this.useItem = ItemStack.EMPTY;
        this.useItemRemaining = 0;
    }

    public boolean isBlocking() {
        if (this.isUsingItem() && !this.useItem.isEmpty()) {
            net.minecraft.world.item.Item item = this.useItem.getItem();
            return item.getUseAnimation(this.useItem) != EnumAnimation.BLOCK ? false : item.getUseDuration(this.useItem, this) - this.useItemRemaining >= 5;
        }
        return false;
    }

    public boolean isSuppressingSlidingDownLadder() {
        return this.isShiftKeyDown();
    }

    public boolean isFallFlying() {
        return this.getSharedFlag(7);
    }

    @Override
    public boolean isVisuallySwimming() {
        return super.isVisuallySwimming() || !this.isFallFlying() && this.hasPose(EntityPose.FALL_FLYING);
    }

    public int getFallFlyingTicks() {
        return this.fallFlyTicks;
    }

    public boolean randomTeleport(double d0, double d1, double d2, boolean flag) {
        return this.randomTeleport(d0, d1, d2, flag, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = this.getZ();
        double d6 = d1;
        boolean flag1 = false;
        BlockPosition blockposition = BlockPosition.containing(d0, d1, d2);
        net.minecraft.world.level.World world = this.level();
        if (world.hasChunkAt(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.getY() > world.getMinBuildHeight()) {
                BlockPosition blockposition1 = blockposition.below();
                IBlockData iblockdata = world.getBlockState(blockposition1);
                if (iblockdata.blocksMotion()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.setPos(d0, d6, d2);
                if (world.noCollision(this) && !world.containsAnyLiquid(this.getBoundingBox())) {
                    flag1 = true;
                }
                this.setPos(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.level().getWorld(), d3, d4, d5), new Location((World)this.level().getWorld(), d0, d6, d2));
                        this.level().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled()) return Optional.empty();
                        Location to = teleport.getTo();
                        this.teleportTo(to.getX(), to.getY(), to.getZ());
                    } else if (!((EntityPlayer)this).connection.teleport(d0, d6, d2, this.getYRot(), this.getXRot(), Collections.emptySet(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.broadcastEntityEvent(this, (byte)46);
        }
        if (!(this instanceof EntityCreature)) return Optional.of(true);
        EntityCreature entitycreature = (EntityCreature)this;
        entitycreature.getNavigation().stop();
        return Optional.of(true);
    }

    public boolean isAffectedByPotions() {
        return !this.isDeadOrDying();
    }

    public boolean attackable() {
        return true;
    }

    public void setRecordPlayingNearby(BlockPosition blockposition, boolean flag) {
    }

    public boolean canTakeItem(ItemStack itemstack) {
        return false;
    }

    @Override
    public final EntitySize getDimensions(EntityPose entitypose) {
        return entitypose == EntityPose.SLEEPING ? SLEEPING_DIMENSIONS : this.getDefaultDimensions(entitypose).scale(this.getScale());
    }

    protected EntitySize getDefaultDimensions(EntityPose entitypose) {
        return this.getType().getDimensions().scale(this.getAgeScale());
    }

    public ImmutableList<EntityPose> getDismountPoses() {
        return ImmutableList.of((Object)((Object)EntityPose.STANDING));
    }

    public AxisAlignedBB getLocalBoundsForPose(EntityPose entitypose) {
        EntitySize entitysize = this.getDimensions(entitypose);
        return new AxisAlignedBB(-entitysize.width() / 2.0f, 0.0, -entitysize.width() / 2.0f, entitysize.width() / 2.0f, entitysize.height(), entitysize.width() / 2.0f);
    }

    protected boolean wouldNotSuffocateAtTargetPose(EntityPose entitypose) {
        AxisAlignedBB axisalignedbb = this.getDimensions(entitypose).makeBoundingBox(this.position());
        return this.level().noBlockCollision(this, axisalignedbb);
    }

    @Override
    public boolean canUsePortal(boolean flag) {
        return super.canUsePortal(flag) && !this.isSleeping();
    }

    public Optional<BlockPosition> getSleepingPos() {
        return this.entityData.get(SLEEPING_POS_ID);
    }

    public void setSleepingPos(BlockPosition blockposition) {
        this.entityData.set(SLEEPING_POS_ID, Optional.of(blockposition));
    }

    public void clearSleepingPos() {
        this.entityData.set(SLEEPING_POS_ID, Optional.empty());
    }

    public boolean isSleeping() {
        return this.getSleepingPos().isPresent();
    }

    public void startSleeping(BlockPosition blockposition) {
        IBlockData iblockdata;
        if (this.isPassenger()) {
            this.stopRiding();
        }
        if ((iblockdata = this.level().getBlockState(blockposition)).getBlock() instanceof BlockBed) {
            this.level().setBlock(blockposition, (IBlockData)iblockdata.setValue(BlockBed.OCCUPIED, true), 3);
        }
        this.setPose(EntityPose.SLEEPING);
        this.setPosToBed(blockposition);
        this.setSleepingPos(blockposition);
        this.setDeltaMovement(Vec3D.ZERO);
        this.hasImpulse = true;
    }

    private void setPosToBed(BlockPosition blockposition) {
        this.setPos((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.6875, (double)blockposition.getZ() + 0.5);
    }

    private boolean checkBedExists() {
        return this.getSleepingPos().map(blockposition -> this.level().getBlockState((BlockPosition)blockposition).getBlock() instanceof BlockBed).orElse(false);
    }

    public void stopSleeping() {
        Optional<BlockPosition> optional = this.getSleepingPos();
        net.minecraft.world.level.World world = this.level();
        Objects.requireNonNull(world);
        optional.filter(world::hasChunkAt).ifPresent(blockposition -> {
            IBlockData iblockdata = this.level().getBlockState((BlockPosition)blockposition);
            if (iblockdata.getBlock() instanceof BlockBed) {
                EnumDirection enumdirection = iblockdata.getValue(BlockBed.FACING);
                this.level().setBlock((BlockPosition)blockposition, (IBlockData)iblockdata.setValue(BlockBed.OCCUPIED, false), 3);
                Vec3D vec3d = BlockBed.findStandUpPosition(this.getType(), this.level(), blockposition, enumdirection, this.getYRot()).orElseGet(() -> {
                    BlockPosition blockposition1 = blockposition.above();
                    return new Vec3D((double)blockposition1.getX() + 0.5, (double)blockposition1.getY() + 0.1, (double)blockposition1.getZ() + 0.5);
                });
                Vec3D vec3d1 = Vec3D.atBottomCenterOf(blockposition).subtract(vec3d).normalize();
                float f2 = (float)MathHelper.wrapDegrees(MathHelper.atan2(vec3d1.z, vec3d1.x) * 57.2957763671875 - 90.0);
                this.setPos(vec3d.x, vec3d.y, vec3d.z);
                this.setYRot(f2);
                this.setXRot(0.0f);
            }
        });
        Vec3D vec3d = this.position();
        this.setPose(EntityPose.STANDING);
        this.setPos(vec3d.x, vec3d.y, vec3d.z);
        this.clearSleepingPos();
    }

    @Nullable
    public EnumDirection getBedOrientation() {
        BlockPosition blockposition = this.getSleepingPos().orElse(null);
        return blockposition != null ? BlockBed.getBedOrientation(this.level(), blockposition) : null;
    }

    @Override
    public boolean isInWall() {
        return !this.isSleeping() && super.isInWall();
    }

    public ItemStack getProjectile(ItemStack itemstack) {
        return ItemStack.EMPTY;
    }

    public final ItemStack eat(net.minecraft.world.level.World world, ItemStack itemstack) {
        FoodInfo foodinfo = itemstack.get(DataComponents.FOOD);
        return foodinfo != null ? this.eat(world, itemstack, foodinfo) : itemstack;
    }

    public ItemStack eat(net.minecraft.world.level.World world, ItemStack itemstack, FoodInfo foodinfo) {
        world.playSound((EntityHuman)null, this.getX(), this.getY(), this.getZ(), this.getEatingSound(itemstack), SoundCategory.NEUTRAL, 1.0f, 1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.4f);
        this.addEatEffect(foodinfo);
        itemstack.consume(1, this);
        this.gameEvent(GameEvent.EAT);
        return itemstack;
    }

    private void addEatEffect(FoodInfo foodinfo) {
        if (!this.level().isClientSide()) {
            List<FoodInfo.b> list = foodinfo.effects();
            for (FoodInfo.b foodinfo_b : list) {
                if (!(this.random.nextFloat() < foodinfo_b.probability())) continue;
                this.addEffect(foodinfo_b.effect(), EntityPotionEffectEvent.Cause.FOOD);
            }
        }
    }

    private static byte entityEventForEquipmentBreak(EnumItemSlot enumitemslot) {
        return switch (enumitemslot) {
            case EnumItemSlot.MAINHAND -> 47;
            case EnumItemSlot.OFFHAND -> 48;
            case EnumItemSlot.HEAD -> 49;
            case EnumItemSlot.CHEST -> 50;
            case EnumItemSlot.FEET -> 52;
            case EnumItemSlot.LEGS -> 51;
            case EnumItemSlot.BODY -> 65;
            default -> throw new MatchException(null, null);
        };
    }

    public void onEquippedItemBroken(net.minecraft.world.item.Item item, EnumItemSlot enumitemslot) {
        this.level().broadcastEntityEvent(this, EntityLiving.entityEventForEquipmentBreak(enumitemslot));
    }

    public static EnumItemSlot getSlotForHand(EnumHand enumhand) {
        return enumhand == EnumHand.MAIN_HAND ? EnumItemSlot.MAINHAND : EnumItemSlot.OFFHAND;
    }

    @Override
    public AxisAlignedBB getBoundingBoxForCulling() {
        if (this.getItemBySlot(EnumItemSlot.HEAD).is(Items.DRAGON_HEAD)) {
            float f2 = 0.5f;
            return this.getBoundingBox().inflate(0.5, 0.5, 0.5);
        }
        return super.getBoundingBoxForCulling();
    }

    public EnumItemSlot getEquipmentSlotForItem(ItemStack itemstack) {
        EnumItemSlot enumitemslot;
        Equipable equipable = Equipable.get(itemstack);
        if (equipable != null && this.canUseSlot(enumitemslot = equipable.getEquipmentSlot())) {
            return enumitemslot;
        }
        return EnumItemSlot.MAINHAND;
    }

    private static SlotAccess createEquipmentSlotAccess(EntityLiving entityliving, EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.HEAD && enumitemslot != EnumItemSlot.MAINHAND && enumitemslot != EnumItemSlot.OFFHAND ? SlotAccess.forEquipmentSlot(entityliving, enumitemslot, itemstack -> itemstack.isEmpty() || entityliving.getEquipmentSlotForItem((ItemStack)itemstack) == enumitemslot) : SlotAccess.forEquipmentSlot(entityliving, enumitemslot);
    }

    @Nullable
    private static EnumItemSlot getEquipmentSlot(int i2) {
        return i2 == 100 + EnumItemSlot.HEAD.getIndex() ? EnumItemSlot.HEAD : (i2 == 100 + EnumItemSlot.CHEST.getIndex() ? EnumItemSlot.CHEST : (i2 == 100 + EnumItemSlot.LEGS.getIndex() ? EnumItemSlot.LEGS : (i2 == 100 + EnumItemSlot.FEET.getIndex() ? EnumItemSlot.FEET : (i2 == 98 ? EnumItemSlot.MAINHAND : (i2 == 99 ? EnumItemSlot.OFFHAND : (i2 == 105 ? EnumItemSlot.BODY : null))))));
    }

    @Override
    public SlotAccess getSlot(int i2) {
        EnumItemSlot enumitemslot = EntityLiving.getEquipmentSlot(i2);
        return enumitemslot != null ? EntityLiving.createEquipmentSlotAccess(this, enumitemslot) : super.getSlot(i2);
    }

    @Override
    public boolean canFreeze() {
        if (this.isSpectator()) {
            return false;
        }
        boolean flag = !this.getItemBySlot(EnumItemSlot.HEAD).is(TagsItem.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EnumItemSlot.CHEST).is(TagsItem.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EnumItemSlot.LEGS).is(TagsItem.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EnumItemSlot.FEET).is(TagsItem.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EnumItemSlot.BODY).is(TagsItem.FREEZE_IMMUNE_WEARABLES);
        return flag && super.canFreeze();
    }

    @Override
    public boolean isCurrentlyGlowing() {
        return !this.level().isClientSide() && this.hasEffect(MobEffects.GLOWING) || super.isCurrentlyGlowing();
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return this.yBodyRot;
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        double d0 = packetplayoutspawnentity.getX();
        double d1 = packetplayoutspawnentity.getY();
        double d2 = packetplayoutspawnentity.getZ();
        float f2 = packetplayoutspawnentity.getYRot();
        float f1 = packetplayoutspawnentity.getXRot();
        this.syncPacketPositionCodec(d0, d1, d2);
        this.yBodyRot = packetplayoutspawnentity.getYHeadRot();
        this.yHeadRot = packetplayoutspawnentity.getYHeadRot();
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.setId(packetplayoutspawnentity.getId());
        this.setUUID(packetplayoutspawnentity.getUUID());
        this.absMoveTo(d0, d1, d2, f2, f1);
        this.setDeltaMovement(packetplayoutspawnentity.getXa(), packetplayoutspawnentity.getYa(), packetplayoutspawnentity.getZa());
    }

    public boolean canDisableShield() {
        return this.getWeaponItem().getItem() instanceof ItemAxe;
    }

    @Override
    public float maxUpStep() {
        float f2 = (float)this.getAttributeValue(GenericAttributes.STEP_HEIGHT);
        return this.getControllingPassenger() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    @Override
    public Vec3D getPassengerRidingPosition(Entity entity) {
        return this.position().add(this.getPassengerAttachmentPoint(entity, this.getDimensions(this.getPose()), this.getScale() * this.getAgeScale()));
    }

    protected void lerpHeadRotationStep(int i2, double d0) {
        this.yHeadRot = (float)MathHelper.rotLerp(1.0 / (double)i2, (double)this.yHeadRot, d0);
    }

    @Override
    public void igniteForTicks(int i2) {
        super.igniteForTicks(MathHelper.ceil((double)i2 * this.getAttributeValue(GenericAttributes.BURNING_TIME)));
    }

    public boolean hasInfiniteMaterials() {
        return false;
    }

    @Override
    public boolean isInvulnerableTo(DamageSource damagesource) {
        WorldServer worldserver;
        net.minecraft.world.level.World world;
        if (!(super.isInvulnerableTo(damagesource) || (world = this.level()) instanceof WorldServer && EnchantmentManager.isImmuneToDamage(worldserver = (WorldServer)world, this, damagesource))) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static class ProcessableEffect {
        private Holder<MobEffectList> type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffectList> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect small, SoundEffect big) {
    }
}

