/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTeleportEvent;

public abstract class EntityTameableAnimal
extends EntityAnimal
implements OwnableEntity {
    public static final int TELEPORT_WHEN_DISTANCE_IS_SQ = 144;
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 1;
    protected static final DataWatcherObject<Byte> DATA_FLAGS_ID = DataWatcher.defineId(EntityTameableAnimal.class, DataWatcherRegistry.BYTE);
    protected static final DataWatcherObject<Optional<UUID>> DATA_OWNERUUID_ID = DataWatcher.defineId(EntityTameableAnimal.class, DataWatcherRegistry.OPTIONAL_UUID);
    private boolean orderedToSit;

    protected EntityTameableAnimal(EntityTypes<? extends EntityTameableAnimal> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_FLAGS_ID, (byte)0);
        datawatcher_a.define(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        if (this.getOwnerUUID() != null) {
            nbttagcompound.putUUID("Owner", this.getOwnerUUID());
        }
        nbttagcompound.putBoolean("Sitting", this.orderedToSit);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        UUID uuid;
        super.readAdditionalSaveData(nbttagcompound);
        if (nbttagcompound.hasUUID("Owner")) {
            uuid = nbttagcompound.getUUID("Owner");
        } else {
            String s2 = nbttagcompound.getString("Owner");
            uuid = NameReferencingFileConverter.convertMobOwnerIfNecessary(this.getServer(), s2);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true, false);
            }
            catch (Throwable throwable) {
                this.setTame(false, true);
            }
        }
        this.orderedToSit = nbttagcompound.getBoolean("Sitting");
        this.setInSittingPose(this.orderedToSit);
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    @Override
    public boolean handleLeashAtDistance(Entity entity, float f2) {
        if (this.isInSittingPose()) {
            if (f2 > 10.0f) {
                this.dropLeash(true, true);
            }
            return false;
        }
        return super.handleLeashAtDistance(entity, f2);
    }

    protected void spawnTamingParticles(boolean flag) {
        ParticleType particletype = Particles.HEART;
        if (!flag) {
            particletype = Particles.SMOKE;
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            ((World)this.level()).addParticle(particletype, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 7) {
            this.spawnTamingParticles(true);
        } else if (b0 == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(b0);
        }
    }

    public boolean isTame() {
        return (this.entityData.get(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean flag, boolean flag1) {
        byte b0 = this.entityData.get(DATA_FLAGS_ID);
        if (flag) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(b0 | 4));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(b0 & 0xFFFFFFFB));
        }
        if (flag1) {
            this.applyTamingSideEffects();
        }
    }

    protected void applyTamingSideEffects() {
    }

    public boolean isInSittingPose() {
        return (this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setInSittingPose(boolean flag) {
        byte b0 = this.entityData.get(DATA_FLAGS_ID);
        if (flag) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(b0 | 1));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return this.entityData.get(DATA_OWNERUUID_ID).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    public void tame(EntityHuman entityhuman) {
        this.setTame(true, true);
        this.setOwnerUUID(entityhuman.getUUID());
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityhuman;
            CriterionTriggers.TAME_ANIMAL.trigger(entityplayer, this);
        }
    }

    @Override
    public boolean canAttack(EntityLiving entityliving) {
        return this.isOwnedBy(entityliving) ? false : super.canAttack(entityliving);
    }

    public boolean isOwnedBy(EntityLiving entityliving) {
        return entityliving == this.getOwner();
    }

    public boolean wantsToAttack(EntityLiving entityliving, EntityLiving entityliving1) {
        return true;
    }

    @Override
    public ScoreboardTeam getTeam() {
        EntityLiving entityliving;
        if (this.isTame() && (entityliving = this.getOwner()) != null) {
            return entityliving.getTeam();
        }
        return super.getTeam();
    }

    @Override
    public boolean isAlliedTo(Entity entity) {
        if (this.isTame()) {
            EntityLiving entityliving = this.getOwner();
            if (entity == entityliving) {
                return true;
            }
            if (entityliving != null) {
                return entityliving.isAlliedTo(entity);
            }
        }
        return super.isAlliedTo(entity);
    }

    @Override
    public void die(DamageSource damagesource) {
        if (!((World)this.level()).isClientSide && ((World)this.level()).getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && this.getOwner() instanceof EntityPlayer) {
            this.getOwner().sendSystemMessage(this.getCombatTracker().getDeathMessage());
        }
        super.die(damagesource);
    }

    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public void setOrderedToSit(boolean flag) {
        this.orderedToSit = flag;
    }

    public void tryToTeleportToOwner() {
        EntityLiving entityliving = this.getOwner();
        if (entityliving != null) {
            this.teleportToAroundBlockPos(entityliving.blockPosition());
        }
    }

    public boolean shouldTryTeleportToOwner() {
        EntityLiving entityliving = this.getOwner();
        return entityliving != null && this.distanceToSqr(this.getOwner()) >= 144.0;
    }

    private void teleportToAroundBlockPos(BlockPosition blockposition) {
        for (int i2 = 0; i2 < 10; ++i2) {
            int j2 = this.random.nextIntBetweenInclusive(-3, 3);
            int k2 = this.random.nextIntBetweenInclusive(-3, 3);
            if (Math.abs(j2) < 2 && Math.abs(k2) < 2) continue;
            int l2 = this.random.nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(blockposition.getX() + j2, blockposition.getY() + l2, blockposition.getZ() + k2)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int i2, int j2, int k2) {
        if (!this.canTeleportTo(new BlockPosition(i2, j2, k2))) {
            return false;
        }
        EntityTeleportEvent event = CraftEventFactory.callEntityTeleportEvent(this, (double)i2 + 0.5, j2, (double)k2 + 0.5);
        if (event.isCancelled()) {
            return false;
        }
        Location to = event.getTo();
        this.moveTo(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPosition blockposition) {
        PathType pathtype = PathfinderNormal.getPathTypeStatic(this, blockposition);
        if (pathtype != PathType.WALKABLE) {
            return false;
        }
        IBlockData iblockdata = ((World)this.level()).getBlockState(blockposition.below());
        if (!this.canFlyToOwner() && iblockdata.getBlock() instanceof BlockLeaves) {
            return false;
        }
        BlockPosition blockposition1 = blockposition.subtract(this.blockPosition());
        return this.level().noCollision(this, this.getBoundingBox().move(blockposition1));
    }

    public final boolean unableToMoveToOwner() {
        return this.isOrderedToSit() || this.isPassenger() || this.mayBeLeashed() || this.getOwner() != null && this.getOwner().isSpectator();
    }

    protected boolean canFlyToOwner() {
        return false;
    }

    public class a
    extends PathfinderGoalPanic {
        public a(double d0, TagKey tagkey) {
            super((EntityCreature)EntityTameableAnimal.this, d0, tagkey);
        }

        public a(double d0) {
            super(EntityTameableAnimal.this, d0);
        }

        @Override
        public void tick() {
            if (!EntityTameableAnimal.this.unableToMoveToOwner() && EntityTameableAnimal.this.shouldTryTeleportToOwner()) {
                EntityTameableAnimal.this.tryToTeleportToOwner();
            }
            super.tick();
        }
    }
}

