/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityTargetEvent;

public interface IEntityAngerable {
    public static final String TAG_ANGER_TIME = "AngerTime";
    public static final String TAG_ANGRY_AT = "AngryAt";

    public int getRemainingPersistentAngerTime();

    public void setRemainingPersistentAngerTime(int var1);

    @Nullable
    public UUID getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable UUID var1);

    public void startPersistentAngerTimer();

    default public void addPersistentAngerSaveData(NBTTagCompound nbttagcompound) {
        nbttagcompound.putInt(TAG_ANGER_TIME, this.getRemainingPersistentAngerTime());
        if (this.getPersistentAngerTarget() != null) {
            nbttagcompound.putUUID(TAG_ANGRY_AT, this.getPersistentAngerTarget());
        }
    }

    default public void readPersistentAngerSaveData(World world, NBTTagCompound nbttagcompound) {
        this.setRemainingPersistentAngerTime(nbttagcompound.getInt(TAG_ANGER_TIME));
        if (world instanceof WorldServer) {
            if (!nbttagcompound.hasUUID(TAG_ANGRY_AT)) {
                this.setPersistentAngerTarget(null);
            } else {
                UUID uuid = nbttagcompound.getUUID(TAG_ANGRY_AT);
                this.setPersistentAngerTarget(uuid);
                Entity entity = ((WorldServer)world).getEntity(uuid);
                if (entity != null) {
                    if (entity instanceof EntityInsentient) {
                        EntityInsentient entityinsentient = (EntityInsentient)entity;
                        this.setTarget(entityinsentient, EntityTargetEvent.TargetReason.UNKNOWN, false);
                        this.setLastHurtByMob(entityinsentient);
                    }
                    if (entity instanceof EntityHuman) {
                        EntityHuman entityhuman = (EntityHuman)entity;
                        this.setTarget(entityhuman, EntityTargetEvent.TargetReason.UNKNOWN, false);
                        this.setLastHurtByPlayer(entityhuman);
                    }
                }
            }
        }
    }

    default public void updatePersistentAnger(WorldServer worldserver, boolean flag) {
        EntityLiving entityliving = this.getTarget();
        UUID uuid = this.getPersistentAngerTarget();
        if ((entityliving == null || entityliving.isDeadOrDying()) && uuid != null && worldserver.getEntity(uuid) instanceof EntityInsentient) {
            this.stopBeingAngry();
        } else {
            if (entityliving != null && !Objects.equals(uuid, entityliving.getUUID())) {
                this.setPersistentAngerTarget(entityliving.getUUID());
                this.startPersistentAngerTimer();
            }
            if (!(this.getRemainingPersistentAngerTime() <= 0 || entityliving != null && entityliving.getType() == EntityTypes.PLAYER && flag)) {
                this.setRemainingPersistentAngerTime(this.getRemainingPersistentAngerTime() - 1);
                if (this.getRemainingPersistentAngerTime() == 0) {
                    this.stopBeingAngry();
                }
            }
        }
    }

    default public boolean isAngryAt(EntityLiving entityliving) {
        return !this.canAttack(entityliving) ? false : (entityliving.getType() == EntityTypes.PLAYER && this.isAngryAtAllPlayers(entityliving.level()) ? true : entityliving.getUUID().equals(this.getPersistentAngerTarget()));
    }

    default public boolean isAngryAtAllPlayers(World world) {
        return world.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER) && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        return this.getRemainingPersistentAngerTime() > 0;
    }

    default public void playerDied(EntityHuman entityhuman) {
        if (entityhuman.level().getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS) && entityhuman.getUUID().equals(this.getPersistentAngerTarget())) {
            this.stopBeingAngry();
        }
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
        this.setRemainingPersistentAngerTime(0);
    }

    @Nullable
    public EntityLiving getLastHurtByMob();

    public void setLastHurtByMob(@Nullable EntityLiving var1);

    public void setLastHurtByPlayer(@Nullable EntityHuman var1);

    public void setTarget(@Nullable EntityLiving var1);

    public boolean setTarget(@Nullable EntityLiving var1, EntityTargetEvent.TargetReason var2, boolean var3);

    public boolean canAttack(EntityLiving var1);

    @Nullable
    public EntityLiving getTarget();
}

