/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.slf4j.Logger;

public class Interaction
extends Entity
implements Attackable,
Targeting {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DataWatcherObject<Float> DATA_WIDTH_ID = DataWatcher.defineId(Interaction.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Float> DATA_HEIGHT_ID = DataWatcher.defineId(Interaction.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Boolean> DATA_RESPONSE_ID = DataWatcher.defineId(Interaction.class, DataWatcherRegistry.BOOLEAN);
    private static final String TAG_WIDTH = "width";
    private static final String TAG_HEIGHT = "height";
    private static final String TAG_ATTACK = "attack";
    private static final String TAG_INTERACTION = "interaction";
    private static final String TAG_RESPONSE = "response";
    @Nullable
    public PlayerAction attack;
    @Nullable
    public PlayerAction interaction;

    public Interaction(EntityTypes<?> entitytypes, World world) {
        super(entitytypes, world);
        this.noPhysics = true;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        datawatcher_a.define(DATA_WIDTH_ID, Float.valueOf(1.0f));
        datawatcher_a.define(DATA_HEIGHT_ID, Float.valueOf(1.0f));
        datawatcher_a.define(DATA_RESPONSE_ID, false);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        Logger logger;
        DataResult dataresult;
        if (nbttagcompound.contains(TAG_WIDTH, 99)) {
            this.setWidth(nbttagcompound.getFloat(TAG_WIDTH));
        }
        if (nbttagcompound.contains(TAG_HEIGHT, 99)) {
            this.setHeight(nbttagcompound.getFloat(TAG_HEIGHT));
        }
        if (nbttagcompound.contains(TAG_ATTACK)) {
            dataresult = PlayerAction.CODEC.decode((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.get(TAG_ATTACK));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(SystemUtils.prefix("Interaction entity", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(pair -> {
                this.attack = (PlayerAction)pair.getFirst();
            });
        } else {
            this.attack = null;
        }
        if (nbttagcompound.contains(TAG_INTERACTION)) {
            dataresult = PlayerAction.CODEC.decode((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.get(TAG_INTERACTION));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(SystemUtils.prefix("Interaction entity", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(pair -> {
                this.interaction = (PlayerAction)pair.getFirst();
            });
        } else {
            this.interaction = null;
        }
        this.setResponse(nbttagcompound.getBoolean(TAG_RESPONSE));
        this.setBoundingBox(this.makeBoundingBox());
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        nbttagcompound.putFloat(TAG_WIDTH, this.getWidth());
        nbttagcompound.putFloat(TAG_HEIGHT, this.getHeight());
        if (this.attack != null) {
            PlayerAction.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.attack).ifSuccess(nbtbase -> nbttagcompound.put(TAG_ATTACK, (NBTBase)nbtbase));
        }
        if (this.interaction != null) {
            PlayerAction.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.interaction).ifSuccess(nbtbase -> nbttagcompound.put(TAG_INTERACTION, (NBTBase)nbtbase));
        }
        nbttagcompound.putBoolean(TAG_RESPONSE, this.getResponse());
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> datawatcherobject) {
        super.onSyncedDataUpdated(datawatcherobject);
        if (DATA_HEIGHT_ID.equals(datawatcherobject) || DATA_WIDTH_ID.equals(datawatcherobject)) {
            this.setBoundingBox(this.makeBoundingBox());
        }
    }

    @Override
    public boolean canBeHitByProjectile() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public EnumPistonReaction getPistonPushReaction() {
        return EnumPistonReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity entity) {
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            DamageSource source = entityhuman.damageSources().playerAttack(entityhuman);
            EntityDamageEvent event = CraftEventFactory.callNonLivingEntityDamageEvent(this, source, 1.0, false);
            if (event.isCancelled()) {
                return true;
            }
            this.attack = new PlayerAction(entityhuman.getUUID(), this.level().getGameTime());
            if (entityhuman instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityhuman;
                CriterionTriggers.PLAYER_HURT_ENTITY.trigger(entityplayer, this, source, (float)event.getFinalDamage(), 1.0f, false);
            }
            return !this.getResponse();
        }
        return false;
    }

    @Override
    public EnumInteractionResult interact(EntityHuman entityhuman, EnumHand enumhand) {
        if (this.level().isClientSide) {
            return this.getResponse() ? EnumInteractionResult.SUCCESS : EnumInteractionResult.CONSUME;
        }
        this.interaction = new PlayerAction(entityhuman.getUUID(), this.level().getGameTime());
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nullable
    public EntityLiving getLastAttacker() {
        return this.attack != null ? this.level().getPlayerByUUID(this.attack.player()) : null;
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        return this.interaction != null ? this.level().getPlayerByUUID(this.interaction.player()) : null;
    }

    public void setWidth(float f2) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf(f2));
    }

    public float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    public void setHeight(float f2) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf(f2));
    }

    public float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    public void setResponse(boolean flag) {
        this.entityData.set(DATA_RESPONSE_ID, flag);
    }

    public boolean getResponse() {
        return this.entityData.get(DATA_RESPONSE_ID);
    }

    private EntitySize getDimensions() {
        return EntitySize.scalable(this.getWidth(), this.getHeight());
    }

    @Override
    public EntitySize getDimensions(EntityPose entitypose) {
        return this.getDimensions();
    }

    @Override
    protected AxisAlignedBB makeBoundingBox() {
        return this.getDimensions().makeBoundingBox(this.position());
    }

    public record PlayerAction(UUID player, long timestamp) {
        public static final Codec<PlayerAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("player").forGetter(PlayerAction::player), (App)Codec.LONG.fieldOf("timestamp").forGetter(PlayerAction::timestamp)).apply((Applicative)instance, PlayerAction::new));
    }
}

