/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityUnleashEvent;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 10.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;

    @Nullable
    public a getLeashData();

    public void setLeashData(@Nullable a var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedToIt() {
        return this.canBeLeashed() && !this.isLeashed();
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int i2) {
        this.setLeashData(new a(i2));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    @Nullable
    default public a readLeashData(NBTTagCompound nbttagcompound) {
        Either either;
        if (nbttagcompound.contains(LEASH_TAG, 10)) {
            return new a((Either<UUID, BlockPosition>)Either.left((Object)nbttagcompound.getCompound(LEASH_TAG).getUUID("UUID")));
        }
        if (nbttagcompound.contains(LEASH_TAG, 11) && (either = (Either)GameProfileSerializer.readBlockPos(nbttagcompound, LEASH_TAG).map(Either::right).orElse(null)) != null) {
            return new a((Either<UUID, BlockPosition>)either);
        }
        return null;
    }

    default public void writeLeashData(NBTTagCompound nbttagcompound, @Nullable a leashable_a) {
        if (leashable_a != null) {
            Either either = leashable_a.delayedLeashInfo;
            Entity entity = leashable_a.leashHolder;
            if (entity != null && entity.pluginRemoved) {
                return;
            }
            if (entity instanceof EntityLeash) {
                EntityLeash entityleash = (EntityLeash)entity;
                either = Either.right((Object)entityleash.getPos());
            } else if (leashable_a.leashHolder != null) {
                either = Either.left((Object)leashable_a.leashHolder.getUUID());
            }
            if (either != null) {
                nbttagcompound.put(LEASH_TAG, (NBTBase)either.map(uuid -> {
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    nbttagcompound1.putUUID("UUID", (UUID)uuid);
                    return nbttagcompound1;
                }, GameProfileSerializer::writeBlockPos));
            }
        }
    }

    private static <E extends Entity> void restoreLeashFromSave(E e0, a leashable_a) {
        World world;
        if (leashable_a.delayedLeashInfo != null && (world = e0.level()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional optional = leashable_a.delayedLeashInfo.left();
            Optional optional1 = leashable_a.delayedLeashInfo.right();
            if (optional.isPresent()) {
                Entity entity = worldserver.getEntity((UUID)optional.get());
                if (entity != null) {
                    Leashable.setLeashedTo(e0, entity, true);
                    return;
                }
            } else if (optional1.isPresent()) {
                Leashable.setLeashedTo(e0, EntityLeash.getOrCreateKnot(worldserver, (BlockPosition)optional1.get()), true);
                return;
            }
            if (e0.tickCount > 100) {
                e0.forceDrops = true;
                e0.spawnAtLocation(Items.LEAD);
                e0.forceDrops = false;
                ((Leashable)((Object)e0)).setLeashData(null);
            }
        }
    }

    default public void dropLeash(boolean flag, boolean flag1) {
        Leashable.dropLeash((Entity)((Object)this), flag, flag1);
    }

    private static <E extends Entity> void dropLeash(E e0, boolean flag, boolean flag1) {
        a leashable_a = ((Leashable)((Object)e0)).getLeashData();
        if (leashable_a != null && leashable_a.leashHolder != null) {
            World world;
            ((Leashable)((Object)e0)).setLeashData(null);
            if (!e0.level().isClientSide && flag1) {
                e0.forceDrops = true;
                e0.spawnAtLocation(Items.LEAD);
                e0.forceDrops = false;
            }
            if (flag && (world = e0.level()) instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                worldserver.getChunkSource().broadcast(e0, new PacketPlayOutAttachEntity(e0, null));
            }
        }
    }

    public static <E extends Entity> void tickLeash(E e0) {
        a leashable_a = ((Leashable)((Object)e0)).getLeashData();
        if (leashable_a != null && leashable_a.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave(e0, leashable_a);
        }
        if (leashable_a != null && leashable_a.leashHolder != null) {
            Entity entity;
            if (!e0.isAlive() || !leashable_a.leashHolder.isAlive()) {
                e0.level().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)e0.getBukkitEntity(), !e0.isAlive() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE));
                Leashable.dropLeash(e0, true, !e0.pluginRemoved);
            }
            if ((entity = ((Leashable)((Object)e0)).getLeashHolder()) != null && entity.level() == e0.level()) {
                float f2 = e0.distanceTo(entity);
                if (!((Leashable)((Object)e0)).handleLeashAtDistance(entity, f2)) {
                    return;
                }
                if ((double)f2 > 10.0) {
                    ((Leashable)((Object)e0)).leashTooFarBehaviour();
                } else if ((double)f2 > 6.0) {
                    ((Leashable)((Object)e0)).elasticRangeLeashBehaviour(entity, f2);
                    e0.checkSlowFallDistance();
                } else {
                    ((Leashable)((Object)e0)).closeRangeLeashBehaviour(entity);
                }
            }
        }
    }

    default public boolean handleLeashAtDistance(Entity entity, float f2) {
        return true;
    }

    default public void leashTooFarBehaviour() {
        Leashable leashable = this;
        if (leashable instanceof Entity) {
            Entity entity = (Entity)((Object)leashable);
            entity.level().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE));
        }
        this.dropLeash(true, true);
    }

    default public void closeRangeLeashBehaviour(Entity entity) {
    }

    default public void elasticRangeLeashBehaviour(Entity entity, float f2) {
        Leashable.legacyElasticRangeLeashBehaviour((Entity)((Object)this), entity, f2);
    }

    private static <E extends Entity> void legacyElasticRangeLeashBehaviour(E e0, Entity entity, float f2) {
        double d0 = (entity.getX() - e0.getX()) / (double)f2;
        double d1 = (entity.getY() - e0.getY()) / (double)f2;
        double d2 = (entity.getZ() - e0.getZ()) / (double)f2;
        e0.setDeltaMovement(e0.getDeltaMovement().add(Math.copySign(d0 * d0 * 0.4, d0), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
    }

    default public void setLeashedTo(Entity entity, boolean flag) {
        Leashable.setLeashedTo((Entity)((Object)this), entity, flag);
    }

    private static <E extends Entity> void setLeashedTo(E e0, Entity entity, boolean flag) {
        World world;
        a leashable_a = ((Leashable)((Object)e0)).getLeashData();
        if (leashable_a == null) {
            leashable_a = new a(entity);
            ((Leashable)((Object)e0)).setLeashData(leashable_a);
        } else {
            leashable_a.setLeashHolder(entity);
        }
        if (flag && (world = e0.level()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.getChunkSource().broadcast(e0, new PacketPlayOutAttachEntity(e0, entity));
        }
        if (e0.isPassenger()) {
            e0.stopRiding();
        }
    }

    @Nullable
    default public Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity getLeashHolder(E e0) {
        Entity entity;
        a leashable_a = ((Leashable)((Object)e0)).getLeashData();
        if (leashable_a == null) {
            return null;
        }
        if (leashable_a.delayedLeashHolderId != 0 && e0.level().isClientSide && (entity = e0.level().getEntity(leashable_a.delayedLeashHolderId)) instanceof Entity) {
            leashable_a.setLeashHolder(entity);
        }
        return leashable_a.leashHolder;
    }

    public static final class a {
        int delayedLeashHolderId;
        @Nullable
        public Entity leashHolder;
        @Nullable
        public Either<UUID, BlockPosition> delayedLeashInfo;

        a(Either<UUID, BlockPosition> either) {
            this.delayedLeashInfo = either;
        }

        a(Entity entity) {
            this.leashHolder = entity;
        }

        a(int i2) {
            this.delayedLeashHolderId = i2;
        }

        public void setLeashHolder(Entity entity) {
            this.leashHolder = entity;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }
}

