/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.Vec3D;

public class OminousItemSpawner
extends Entity {
    private static final int SPAWN_ITEM_DELAY_MIN = 60;
    private static final int SPAWN_ITEM_DELAY_MAX = 120;
    private static final String TAG_SPAWN_ITEM_AFTER_TICKS = "spawn_item_after_ticks";
    private static final String TAG_ITEM = "item";
    private static final DataWatcherObject<ItemStack> DATA_ITEM = DataWatcher.defineId(OminousItemSpawner.class, DataWatcherRegistry.ITEM_STACK);
    public static final int TICKS_BEFORE_ABOUT_TO_SPAWN_SOUND = 36;
    public long spawnItemAfterTicks;

    public OminousItemSpawner(EntityTypes<? extends OminousItemSpawner> var0, World var1) {
        super(var0, var1);
        this.noPhysics = true;
    }

    public static OminousItemSpawner create(World var0, ItemStack var1) {
        OminousItemSpawner var2 = new OminousItemSpawner((EntityTypes<? extends OminousItemSpawner>)EntityTypes.OMINOUS_ITEM_SPAWNER, var0);
        var2.spawnItemAfterTicks = var0.random.nextIntBetweenInclusive(60, 120);
        var2.setItem(var1);
        return var2;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.tickClient();
            return;
        }
        this.tickServer();
    }

    private void tickServer() {
        if ((long)this.tickCount == this.spawnItemAfterTicks - 36L) {
            this.level().playSound(null, this.blockPosition(), SoundEffects.TRIAL_SPAWNER_ABOUT_TO_SPAWN_ITEM, SoundCategory.NEUTRAL);
        }
        if ((long)this.tickCount >= this.spawnItemAfterTicks) {
            this.spawnItem();
            this.kill();
        }
    }

    private void tickClient() {
        if (this.level().getGameTime() % 5L == 0L) {
            this.addParticles();
        }
    }

    private void spawnItem() {
        Entity var2;
        World var0 = this.level();
        ItemStack var12 = this.getItem();
        if (var12.isEmpty()) {
            return;
        }
        Item item = var12.getItem();
        if (item instanceof ProjectileItem) {
            ProjectileItem var3 = (ProjectileItem)((Object)item);
            EnumDirection var4 = EnumDirection.DOWN;
            IProjectile var5 = var3.asProjectile(var0, this.position(), var12, var4);
            var5.setOwner(this);
            ProjectileItem.a var6 = var3.createDispenseConfig();
            var3.shoot(var5, var4.getStepX(), var4.getStepY(), var4.getStepZ(), var6.power(), var6.uncertainty());
            var6.overrideDispenseEvent().ifPresent(var1 -> var0.levelEvent(var1, this.blockPosition(), 0));
            var2 = var5;
        } else {
            var2 = new EntityItem(var0, this.getX(), this.getY(), this.getZ(), var12);
        }
        var0.addFreshEntity(var2);
        var0.levelEvent(3021, this.blockPosition(), 1);
        var0.gameEvent(var2, GameEvent.ENTITY_PLACE, this.position());
        this.setItem(ItemStack.EMPTY);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_ITEM, ItemStack.EMPTY);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        ItemStack var1 = var0.contains(TAG_ITEM, 10) ? ItemStack.parse(this.registryAccess(), var0.getCompound(TAG_ITEM)).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        this.setItem(var1);
        this.spawnItemAfterTicks = var0.getLong(TAG_SPAWN_ITEM_AFTER_TICKS);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        if (!this.getItem().isEmpty()) {
            var0.put(TAG_ITEM, this.getItem().save(this.registryAccess()).copy());
        }
        var0.putLong(TAG_SPAWN_ITEM_AFTER_TICKS, this.spawnItemAfterTicks);
    }

    @Override
    protected boolean canAddPassenger(Entity var0) {
        return false;
    }

    @Override
    protected boolean couldAcceptPassenger() {
        return false;
    }

    @Override
    protected void addPassenger(Entity var0) {
        throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
    }

    @Override
    public EnumPistonReaction getPistonPushReaction() {
        return EnumPistonReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public void addParticles() {
        Vec3D var0 = this.position();
        int var1 = this.random.nextIntBetweenInclusive(1, 3);
        for (int var2 = 0; var2 < var1; ++var2) {
            double var3 = 0.4;
            Vec3D var5 = new Vec3D(this.getX() + 0.4 * (this.random.nextGaussian() - this.random.nextGaussian()), this.getY() + 0.4 * (this.random.nextGaussian() - this.random.nextGaussian()), this.getZ() + 0.4 * (this.random.nextGaussian() - this.random.nextGaussian()));
            Vec3D var6 = var0.vectorTo(var5);
            this.level().addParticle(Particles.OMINOUS_SPAWNING, var0.x(), var0.y(), var0.z(), var6.x(), var6.y(), var6.z());
        }
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    public void setItem(ItemStack var0) {
        this.getEntityData().set(DATA_ITEM, var0);
    }
}

