/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BehaviorAttackTargetForget {
    private static final int TIMEOUT_TO_GET_WITHIN_ATTACK_RANGE = 200;

    public static <E extends EntityInsentient> BehaviorControl<E> create(BiConsumer<E, EntityLiving> biconsumer) {
        return BehaviorAttackTargetForget.create(entityliving -> false, biconsumer, true);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> create(Predicate<EntityLiving> predicate) {
        return BehaviorAttackTargetForget.create(predicate, (entityinsentient, entityliving) -> {}, true);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> create() {
        return BehaviorAttackTargetForget.create(entityliving -> false, (entityinsentient, entityliving) -> {}, true);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> create(Predicate<EntityLiving> predicate, BiConsumer<E, EntityLiving> biconsumer, boolean flag) {
        return BehaviorBuilder.create((BehaviorBuilder.b<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.present(MemoryModuleType.ATTACK_TARGET), behaviorbuilder_b.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1) -> (worldserver, entityinsentient, i2) -> {
            EntityLiving entityliving = (EntityLiving)behaviorbuilder_b.get(memoryaccessor);
            if (!(!entityinsentient.canAttack(entityliving) || flag && BehaviorAttackTargetForget.isTiredOfTryingToReachTarget(entityinsentient, behaviorbuilder_b.tryGet(memoryaccessor1)) || !entityliving.isAlive() || entityliving.level() != entityinsentient.level() || predicate.test(entityliving))) {
                return true;
            }
            EntityLiving old = entityinsentient.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityinsentient, null, old != null && !old.isAlive() ? EntityTargetEvent.TargetReason.TARGET_DIED : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            if (event.isCancelled()) {
                return false;
            }
            if (event.getTarget() != null) {
                entityinsentient.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, ((CraftLivingEntity)event.getTarget()).getHandle());
                return true;
            }
            biconsumer.accept(entityinsentient, entityliving);
            memoryaccessor.erase();
            return true;
        }));
    }

    private static boolean isTiredOfTryingToReachTarget(EntityLiving entityliving, Optional<Long> optional) {
        return optional.isPresent() && entityliving.level().getGameTime() - optional.get() > 200L;
    }
}

