/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BehaviorAttackTargetSet {
    public static <E extends EntityInsentient> BehaviorControl<E> create(Function<E, Optional<? extends EntityLiving>> function) {
        return BehaviorAttackTargetSet.create(entityinsentient -> true, function);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> create(Predicate<E> predicate, Function<E, Optional<? extends EntityLiving>> function) {
        return BehaviorBuilder.create((BehaviorBuilder.b<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.absent(MemoryModuleType.ATTACK_TARGET), behaviorbuilder_b.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1) -> (worldserver, entityinsentient, i2) -> {
            if (!predicate.test(entityinsentient)) {
                return false;
            }
            Optional optional = (Optional)function.apply(entityinsentient);
            if (optional.isEmpty()) {
                return false;
            }
            EntityLiving entityliving = (EntityLiving)optional.get();
            if (!entityinsentient.canAttack(entityliving)) {
                return false;
            }
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityinsentient, entityliving, entityliving instanceof EntityPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled()) {
                return false;
            }
            if (event.getTarget() == null) {
                memoryaccessor.erase();
                return true;
            }
            entityliving = ((CraftLivingEntity)event.getTarget()).getHandle();
            memoryaccessor.set(entityliving);
            memoryaccessor1.erase();
            return true;
        }));
    }
}

