/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.VillagerCareerChangeEvent;

public class BehaviorCareer {
    public static BehaviorControl<EntityVillager> create() {
        return BehaviorBuilder.create(behaviorbuilder_b -> behaviorbuilder_b.group(behaviorbuilder_b.present(MemoryModuleType.POTENTIAL_JOB_SITE), behaviorbuilder_b.registered(MemoryModuleType.JOB_SITE)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1) -> (worldserver, entityvillager, i2) -> {
            GlobalPos globalpos = (GlobalPos)behaviorbuilder_b.get(memoryaccessor);
            if (!globalpos.pos().closerToCenterThan(entityvillager.position(), 2.0) && !entityvillager.assignProfessionWhenSpawned()) {
                return false;
            }
            memoryaccessor.erase();
            memoryaccessor1.set(globalpos);
            worldserver.broadcastEntityEvent(entityvillager, (byte)14);
            if (entityvillager.getVillagerData().getProfession() != VillagerProfession.NONE) {
                return true;
            }
            MinecraftServer minecraftserver = worldserver.getServer();
            Optional.ofNullable(minecraftserver.getLevel(globalpos.dimension())).flatMap(worldserver1 -> worldserver1.getPoiManager().getType(globalpos.pos())).flatMap(holder -> BuiltInRegistries.VILLAGER_PROFESSION.stream().filter(villagerprofession -> villagerprofession.heldJobSite().test((Holder<VillagePlaceType>)holder)).findFirst()).ifPresent(villagerprofession -> {
                VillagerCareerChangeEvent event = CraftEventFactory.callVillagerCareerChangeEvent(entityvillager, CraftVillager.CraftProfession.minecraftToBukkit(villagerprofession), VillagerCareerChangeEvent.ChangeReason.EMPLOYED);
                if (event.isCancelled()) {
                    return;
                }
                entityvillager.setVillagerData(entityvillager.getVillagerData().setProfession(CraftVillager.CraftProfession.bukkitToMinecraft(event.getProfession())));
                entityvillager.refreshBrain(worldserver);
            });
            return true;
        }));
    }
}

