/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockSoil;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BehaviorFarm
extends Behavior<EntityVillager> {
    private static final int HARVEST_DURATION = 200;
    public static final float SPEED_MODIFIER = 0.5f;
    @Nullable
    private BlockPosition aboveFarmlandPos;
    private long nextOkStartTime;
    private int timeWorkedSoFar;
    private final List<BlockPosition> validFarmlandAroundVillager = Lists.newArrayList();

    public BehaviorFarm() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.SECONDARY_JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer worldserver, EntityVillager entityvillager) {
        if (!worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (entityvillager.getVillagerData().getProfession() != VillagerProfession.FARMER) {
            return false;
        }
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = entityvillager.blockPosition().mutable();
        this.validFarmlandAroundVillager.clear();
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j2 = -1; j2 <= 1; ++j2) {
                for (int k2 = -1; k2 <= 1; ++k2) {
                    blockposition_mutableblockposition.set(entityvillager.getX() + (double)i2, entityvillager.getY() + (double)j2, entityvillager.getZ() + (double)k2);
                    if (!this.validPos(blockposition_mutableblockposition, worldserver)) continue;
                    this.validFarmlandAroundVillager.add(new BlockPosition(blockposition_mutableblockposition));
                }
            }
        }
        this.aboveFarmlandPos = this.getValidFarmland(worldserver);
        return this.aboveFarmlandPos != null;
    }

    @Nullable
    private BlockPosition getValidFarmland(WorldServer worldserver) {
        return this.validFarmlandAroundVillager.isEmpty() ? null : this.validFarmlandAroundVillager.get(worldserver.getRandom().nextInt(this.validFarmlandAroundVillager.size()));
    }

    private boolean validPos(BlockPosition blockposition, WorldServer worldserver) {
        IBlockData iblockdata = worldserver.getBlockState(blockposition);
        Block block = iblockdata.getBlock();
        Block block1 = worldserver.getBlockState(blockposition.below()).getBlock();
        return block instanceof BlockCrops && ((BlockCrops)block).isMaxAge(iblockdata) || iblockdata.isAir() && block1 instanceof BlockSoil;
    }

    @Override
    protected void start(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        if (i2 > this.nextOkStartTime && this.aboveFarmlandPos != null) {
            entityvillager.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorTarget(this.aboveFarmlandPos));
            entityvillager.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(new BehaviorTarget(this.aboveFarmlandPos), 0.5f, 1));
        }
    }

    @Override
    protected void stop(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        entityvillager.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        entityvillager.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.timeWorkedSoFar = 0;
        this.nextOkStartTime = i2 + 40L;
    }

    @Override
    protected void tick(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        if (this.aboveFarmlandPos == null || this.aboveFarmlandPos.closerToCenterThan(entityvillager.position(), 1.0)) {
            if (this.aboveFarmlandPos != null && i2 > this.nextOkStartTime) {
                IBlockData iblockdata = worldserver.getBlockState(this.aboveFarmlandPos);
                Block block = iblockdata.getBlock();
                Block block1 = worldserver.getBlockState(this.aboveFarmlandPos.below()).getBlock();
                if (block instanceof BlockCrops && ((BlockCrops)block).isMaxAge(iblockdata) && CraftEventFactory.callEntityChangeBlockEvent(entityvillager, this.aboveFarmlandPos, Blocks.AIR.defaultBlockState())) {
                    worldserver.destroyBlock(this.aboveFarmlandPos, true, entityvillager);
                }
                if (iblockdata.isAir() && block1 instanceof BlockSoil && entityvillager.hasFarmSeeds()) {
                    InventorySubcontainer inventorysubcontainer = entityvillager.getInventory();
                    for (int j2 = 0; j2 < inventorysubcontainer.getContainerSize(); ++j2) {
                        ItemBlock itemblock;
                        IBlockData iblockdata1;
                        Item item;
                        ItemStack itemstack = inventorysubcontainer.getItem(j2);
                        boolean flag = false;
                        if (!itemstack.isEmpty() && itemstack.is(TagsItem.VILLAGER_PLANTABLE_SEEDS) && (item = itemstack.getItem()) instanceof ItemBlock && CraftEventFactory.callEntityChangeBlockEvent(entityvillager, this.aboveFarmlandPos, iblockdata1 = (itemblock = (ItemBlock)item).getBlock().defaultBlockState())) {
                            worldserver.setBlockAndUpdate(this.aboveFarmlandPos, iblockdata1);
                            worldserver.gameEvent(GameEvent.BLOCK_PLACE, this.aboveFarmlandPos, GameEvent.a.of(entityvillager, iblockdata1));
                            flag = true;
                        }
                        if (!flag) continue;
                        worldserver.playSound((EntityHuman)null, (double)this.aboveFarmlandPos.getX(), (double)this.aboveFarmlandPos.getY(), (double)this.aboveFarmlandPos.getZ(), SoundEffects.CROP_PLANTED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        itemstack.shrink(1);
                        if (!itemstack.isEmpty()) break;
                        inventorysubcontainer.setItem(j2, ItemStack.EMPTY);
                        break;
                    }
                }
                if (block instanceof BlockCrops && !((BlockCrops)block).isMaxAge(iblockdata)) {
                    this.validFarmlandAroundVillager.remove(this.aboveFarmlandPos);
                    this.aboveFarmlandPos = this.getValidFarmland(worldserver);
                    if (this.aboveFarmlandPos != null) {
                        this.nextOkStartTime = i2 + 20L;
                        entityvillager.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(new BehaviorTarget(this.aboveFarmlandPos), 0.5f, 1));
                        entityvillager.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorTarget(this.aboveFarmlandPos));
                    }
                }
            }
            ++this.timeWorkedSoFar;
        }
    }

    @Override
    protected boolean canStillUse(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        return this.timeWorkedSoFar < 200;
    }
}

