/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Predicate;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.EntityItem;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;

public class BehaviorFindAdmirableItem {
    public static BehaviorControl<EntityLiving> create(float f2, boolean flag, int i2) {
        return BehaviorFindAdmirableItem.create(entityliving -> true, f2, flag, i2);
    }

    public static <E extends EntityLiving> BehaviorControl<E> create(Predicate<E> predicate, float f2, boolean flag, int i2) {
        return BehaviorBuilder.create(behaviorbuilder_b -> {
            BehaviorBuilder behaviorbuilder = flag ? behaviorbuilder_b.registered(MemoryModuleType.WALK_TARGET) : behaviorbuilder_b.absent(MemoryModuleType.WALK_TARGET);
            return behaviorbuilder_b.group(behaviorbuilder_b.registered(MemoryModuleType.LOOK_TARGET), behaviorbuilder, behaviorbuilder_b.present(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM), behaviorbuilder_b.registered(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1, memoryaccessor2, memoryaccessor3) -> (worldserver, entityliving, j2) -> {
                EntityItem entityitem = (EntityItem)behaviorbuilder_b.get(memoryaccessor2);
                if (behaviorbuilder_b.tryGet(memoryaccessor3).isEmpty() && predicate.test(entityliving) && entityitem.closerThan(entityliving, i2) && entityliving.level().getWorldBorder().isWithinBounds(entityitem.blockPosition())) {
                    if (entityliving instanceof Allay) {
                        EntityTargetEvent event = CraftEventFactory.callEntityTargetEvent(entityliving, entityitem, EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
                        if (event.isCancelled()) {
                            return false;
                        }
                        if (!(event.getTarget() instanceof EntityItem)) {
                            memoryaccessor2.erase();
                        }
                        entityitem = (EntityItem)((CraftEntity)event.getTarget()).getHandle();
                    }
                    MemoryTarget memorytarget = new MemoryTarget(new BehaviorPositionEntity(entityitem, false), f2, 0);
                    memoryaccessor.set(new BehaviorPositionEntity(entityitem, true));
                    memoryaccessor1.set(memorytarget);
                    return true;
                }
                return false;
            });
        });
    }
}

