/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Function;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BehaviorFollowAdult {
    public static OneShot<EntityAgeable> create(UniformInt uniformint, float f2) {
        return BehaviorFollowAdult.create(uniformint, entityliving -> Float.valueOf(f2));
    }

    public static OneShot<EntityAgeable> create(UniformInt uniformint, Function<EntityLiving, Float> function) {
        return BehaviorBuilder.create(behaviorbuilder_b -> behaviorbuilder_b.group(behaviorbuilder_b.present(MemoryModuleType.NEAREST_VISIBLE_ADULT), behaviorbuilder_b.registered(MemoryModuleType.LOOK_TARGET), behaviorbuilder_b.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1, memoryaccessor2) -> (worldserver, entityageable, i2) -> {
            if (!entityageable.isBaby()) {
                return false;
            }
            EntityLiving entityageable1 = (EntityAgeable)behaviorbuilder_b.get(memoryaccessor);
            if (entityageable.closerThan(entityageable1, uniformint.getMaxValue() + 1) && !entityageable.closerThan(entityageable1, uniformint.getMinValue())) {
                EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityageable, entityageable1, EntityTargetEvent.TargetReason.FOLLOW_LEADER);
                if (event.isCancelled()) {
                    return false;
                }
                if (event.getTarget() == null) {
                    memoryaccessor.erase();
                    return true;
                }
                entityageable1 = ((CraftLivingEntity)event.getTarget()).getHandle();
                MemoryTarget memorytarget = new MemoryTarget(new BehaviorPositionEntity(entityageable1, false), ((Float)function.apply(entityageable)).floatValue(), uniformint.getMinValue() - 1);
                memoryaccessor1.set(new BehaviorPositionEntity(entityageable1, true));
                memoryaccessor2.set(memorytarget);
                return true;
            }
            return false;
        }));
    }
}

