/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.level.pathfinder.PathEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class BehaviorMakeLove
extends Behavior<EntityVillager> {
    private long birthTimestamp;

    public BehaviorMakeLove() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.BREED_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 350, 350);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer worldserver, EntityVillager entityvillager) {
        return this.isBreedingPossible(entityvillager);
    }

    @Override
    protected boolean canStillUse(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        return i2 <= this.birthTimestamp && this.isBreedingPossible(entityvillager);
    }

    @Override
    protected void start(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        EntityAgeable entityageable = entityvillager.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
        BehaviorUtil.lockGazeAndWalkToEachOther(entityvillager, entityageable, 0.5f, 2);
        worldserver.broadcastEntityEvent(entityageable, (byte)18);
        worldserver.broadcastEntityEvent(entityvillager, (byte)18);
        int j2 = 275 + entityvillager.getRandom().nextInt(50);
        this.birthTimestamp = i2 + (long)j2;
    }

    @Override
    protected void tick(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        EntityVillager entityvillager1 = (EntityVillager)entityvillager.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
        if (entityvillager.distanceToSqr(entityvillager1) <= 5.0) {
            BehaviorUtil.lockGazeAndWalkToEachOther(entityvillager, entityvillager1, 0.5f, 2);
            if (i2 >= this.birthTimestamp) {
                entityvillager.eatAndDigestFood();
                entityvillager1.eatAndDigestFood();
                this.tryToGiveBirth(worldserver, entityvillager, entityvillager1);
            } else if (entityvillager.getRandom().nextInt(35) == 0) {
                worldserver.broadcastEntityEvent(entityvillager1, (byte)12);
                worldserver.broadcastEntityEvent(entityvillager, (byte)12);
            }
        }
    }

    private void tryToGiveBirth(WorldServer worldserver, EntityVillager entityvillager, EntityVillager entityvillager1) {
        Optional<BlockPosition> optional = this.takeVacantBed(worldserver, entityvillager);
        if (optional.isEmpty()) {
            worldserver.broadcastEntityEvent(entityvillager1, (byte)13);
            worldserver.broadcastEntityEvent(entityvillager, (byte)13);
        } else {
            Optional<EntityVillager> optional1 = this.breed(worldserver, entityvillager, entityvillager1);
            if (optional1.isPresent()) {
                this.giveBedToChild(worldserver, optional1.get(), optional.get());
            } else {
                worldserver.getPoiManager().release(optional.get());
                PacketDebug.sendPoiTicketCountPacket(worldserver, optional.get());
            }
        }
    }

    @Override
    protected void stop(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        entityvillager.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
    }

    private boolean isBreedingPossible(EntityVillager entityvillager) {
        BehaviorController<EntityVillager> behaviorcontroller = entityvillager.getBrain();
        Optional<EntityAgeable> optional = behaviorcontroller.getMemory(MemoryModuleType.BREED_TARGET).filter(entityageable -> entityageable.getType() == EntityTypes.VILLAGER);
        return optional.isEmpty() ? false : BehaviorUtil.targetIsValid(behaviorcontroller, MemoryModuleType.BREED_TARGET, EntityTypes.VILLAGER) && entityvillager.canBreed() && optional.get().canBreed();
    }

    private Optional<BlockPosition> takeVacantBed(WorldServer worldserver, EntityVillager entityvillager) {
        return worldserver.getPoiManager().take(holder -> holder.is(PoiTypes.HOME), (holder, blockposition) -> this.canReach(entityvillager, (BlockPosition)blockposition, (Holder<VillagePlaceType>)holder), entityvillager.blockPosition(), 48);
    }

    private boolean canReach(EntityVillager entityvillager, BlockPosition blockposition, Holder<VillagePlaceType> holder) {
        PathEntity pathentity = entityvillager.getNavigation().createPath(blockposition, holder.value().validRange());
        return pathentity != null && pathentity.canReach();
    }

    private Optional<EntityVillager> breed(WorldServer worldserver, EntityVillager entityvillager, EntityVillager entityvillager1) {
        EntityVillager entityvillager2 = entityvillager.getBreedOffspring(worldserver, entityvillager1);
        if (entityvillager2 == null) {
            return Optional.empty();
        }
        entityvillager2.setAge(-24000);
        entityvillager2.moveTo(entityvillager.getX(), entityvillager.getY(), entityvillager.getZ(), 0.0f, 0.0f);
        if (CraftEventFactory.callEntityBreedEvent(entityvillager2, entityvillager, entityvillager1, null, null, 0).isCancelled()) {
            return Optional.empty();
        }
        entityvillager.setAge(6000);
        entityvillager1.setAge(6000);
        worldserver.addFreshEntityWithPassengers(entityvillager2, CreatureSpawnEvent.SpawnReason.BREEDING);
        worldserver.broadcastEntityEvent(entityvillager2, (byte)12);
        return Optional.of(entityvillager2);
    }

    private void giveBedToChild(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockposition) {
        GlobalPos globalpos = GlobalPos.of(worldserver.dimension(), blockposition);
        entityvillager.getBrain().setMemory(MemoryModuleType.HOME, globalpos);
    }
}

