/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class BehaviorUtil {
    private BehaviorUtil() {
    }

    public static void lockGazeAndWalkToEachOther(EntityLiving entityliving, EntityLiving entityliving1, float f2, int i2) {
        BehaviorUtil.lookAtEachOther(entityliving, entityliving1);
        BehaviorUtil.setWalkAndLookTargetMemoriesToEachOther(entityliving, entityliving1, f2, i2);
    }

    public static boolean entityIsVisible(BehaviorController<?> behaviorcontroller, EntityLiving entityliving) {
        Optional<NearestVisibleLivingEntities> optional = behaviorcontroller.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        return optional.isPresent() && optional.get().contains(entityliving);
    }

    public static boolean targetIsValid(BehaviorController<?> behaviorcontroller, MemoryModuleType<? extends EntityLiving> memorymoduletype, EntityTypes<?> entitytypes) {
        return BehaviorUtil.targetIsValid(behaviorcontroller, memorymoduletype, (EntityLiving entityliving) -> entityliving.getType() == entitytypes);
    }

    private static boolean targetIsValid(BehaviorController<?> behaviorcontroller, MemoryModuleType<? extends EntityLiving> memorymoduletype, Predicate<EntityLiving> predicate) {
        return behaviorcontroller.getMemory(memorymoduletype).filter(predicate).filter(EntityLiving::isAlive).filter(entityliving -> BehaviorUtil.entityIsVisible(behaviorcontroller, entityliving)).isPresent();
    }

    private static void lookAtEachOther(EntityLiving entityliving, EntityLiving entityliving1) {
        BehaviorUtil.lookAtEntity(entityliving, entityliving1);
        BehaviorUtil.lookAtEntity(entityliving1, entityliving);
    }

    public static void lookAtEntity(EntityLiving entityliving, EntityLiving entityliving1) {
        entityliving.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(entityliving1, true));
    }

    private static void setWalkAndLookTargetMemoriesToEachOther(EntityLiving entityliving, EntityLiving entityliving1, float f2, int i2) {
        BehaviorUtil.setWalkAndLookTargetMemories(entityliving, entityliving1, f2, i2);
        BehaviorUtil.setWalkAndLookTargetMemories(entityliving1, entityliving, f2, i2);
    }

    public static void setWalkAndLookTargetMemories(EntityLiving entityliving, Entity entity, float f2, int i2) {
        BehaviorUtil.setWalkAndLookTargetMemories(entityliving, new BehaviorPositionEntity(entity, true), f2, i2);
    }

    public static void setWalkAndLookTargetMemories(EntityLiving entityliving, BlockPosition blockposition, float f2, int i2) {
        BehaviorUtil.setWalkAndLookTargetMemories(entityliving, new BehaviorTarget(blockposition), f2, i2);
    }

    public static void setWalkAndLookTargetMemories(EntityLiving entityliving, BehaviorPosition behaviorposition, float f2, int i2) {
        MemoryTarget memorytarget = new MemoryTarget(behaviorposition, f2, i2);
        entityliving.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, behaviorposition);
        entityliving.getBrain().setMemory(MemoryModuleType.WALK_TARGET, memorytarget);
    }

    public static void throwItem(EntityLiving entityliving, ItemStack itemstack, Vec3D vec3d) {
        Vec3D vec3d1 = new Vec3D(0.3f, 0.3f, 0.3f);
        BehaviorUtil.throwItem(entityliving, itemstack, vec3d, vec3d1, 0.3f);
    }

    public static void throwItem(EntityLiving entityliving, ItemStack itemstack, Vec3D vec3d, Vec3D vec3d1, float f2) {
        if (itemstack.isEmpty()) {
            return;
        }
        double d0 = entityliving.getEyeY() - (double)f2;
        EntityItem entityitem = new EntityItem(entityliving.level(), entityliving.getX(), d0, entityliving.getZ(), itemstack);
        entityitem.setThrower(entityliving);
        Vec3D vec3d2 = vec3d.subtract(entityliving.position());
        vec3d2 = vec3d2.normalize().multiply(vec3d1.x, vec3d1.y, vec3d1.z);
        entityitem.setDeltaMovement(vec3d2);
        entityitem.setDefaultPickUpDelay();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)entityliving.getBukkitEntity(), (org.bukkit.entity.Item)entityitem.getBukkitEntity());
        entityitem.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        entityliving.level().addFreshEntity(entityitem);
    }

    public static SectionPosition findSectionClosestToVillage(WorldServer worldserver, SectionPosition sectionposition, int i2) {
        int j2 = worldserver.sectionsToVillage(sectionposition);
        Stream<SectionPosition> stream = SectionPosition.cube(sectionposition, i2).filter(sectionposition1 -> worldserver.sectionsToVillage((SectionPosition)sectionposition1) < j2);
        Objects.requireNonNull(worldserver);
        return stream.min(Comparator.comparingInt(worldserver::sectionsToVillage)).orElse(sectionposition);
    }

    public static boolean isWithinAttackRange(EntityInsentient entityinsentient, EntityLiving entityliving, int i2) {
        ItemProjectileWeapon itemprojectileweapon;
        Item item = entityinsentient.getMainHandItem().getItem();
        if (item instanceof ItemProjectileWeapon && entityinsentient.canFireProjectileWeapon(itemprojectileweapon = (ItemProjectileWeapon)item)) {
            int j2 = itemprojectileweapon.getDefaultProjectileRange() - i2;
            return entityinsentient.closerThan(entityliving, j2);
        }
        return entityinsentient.isWithinMeleeAttackRange(entityliving);
    }

    public static boolean isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(EntityLiving entityliving, EntityLiving entityliving1, double d0) {
        Optional<EntityLiving> optional = entityliving.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        if (optional.isEmpty()) {
            return false;
        }
        double d1 = entityliving.distanceToSqr(optional.get().position());
        double d2 = entityliving.distanceToSqr(entityliving1.position());
        return d2 > d1 + d0 * d0;
    }

    public static boolean canSee(EntityLiving entityliving, EntityLiving entityliving1) {
        BehaviorController<NearestVisibleLivingEntities> behaviorcontroller = entityliving.getBrain();
        return !behaviorcontroller.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES) ? false : behaviorcontroller.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get().contains(entityliving1);
    }

    public static EntityLiving getNearestTarget(EntityLiving entityliving, Optional<EntityLiving> optional, EntityLiving entityliving1) {
        return optional.isEmpty() ? entityliving1 : BehaviorUtil.getTargetNearestMe(entityliving, optional.get(), entityliving1);
    }

    public static EntityLiving getTargetNearestMe(EntityLiving entityliving, EntityLiving entityliving1, EntityLiving entityliving2) {
        Vec3D vec3d = entityliving1.position();
        Vec3D vec3d1 = entityliving2.position();
        return entityliving.distanceToSqr(vec3d) < entityliving.distanceToSqr(vec3d1) ? entityliving1 : entityliving2;
    }

    public static Optional<EntityLiving> getLivingEntityFromUUIDMemory(EntityLiving entityliving, MemoryModuleType<UUID> memorymoduletype) {
        Optional<UUID> optional = entityliving.getBrain().getMemory(memorymoduletype);
        return optional.map(uuid -> ((WorldServer)entityliving.level()).getEntity((UUID)uuid)).map(entity -> {
            EntityLiving entityliving2;
            EntityLiving entityliving1 = entity instanceof EntityLiving ? (entityliving2 = (EntityLiving)entity) : null;
            return entityliving1;
        });
    }

    @Nullable
    public static Vec3D getRandomSwimmablePos(EntityCreature entitycreature, int i2, int j2) {
        Vec3D vec3d = DefaultRandomPos.getPos(entitycreature, i2, j2);
        int k2 = 0;
        while (vec3d != null && !entitycreature.level().getBlockState(BlockPosition.containing(vec3d)).isPathfindable(PathMode.WATER) && k2++ < 10) {
            vec3d = DefaultRandomPos.getPos(entitycreature, i2, j2);
        }
        return vec3d;
    }

    public static boolean isBreeding(EntityLiving entityliving) {
        return entityliving.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET);
    }
}

