/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class PrepareRamNearestTarget<E extends EntityCreature>
extends Behavior<E> {
    public static final int TIME_OUT_DURATION = 160;
    private final ToIntFunction<E> getCooldownOnFail;
    private final int minRamDistance;
    private final int maxRamDistance;
    private final float walkSpeed;
    private final PathfinderTargetCondition ramTargeting;
    private final int ramPrepareTime;
    private final Function<E, SoundEffect> getPrepareRamSound;
    private Optional<Long> reachedRamPositionTimestamp = Optional.empty();
    private Optional<a> ramCandidate = Optional.empty();

    public PrepareRamNearestTarget(ToIntFunction<E> tointfunction, int i2, int j2, float f2, PathfinderTargetCondition pathfindertargetcondition, int k2, Function<E, SoundEffect> function) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.RAM_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 160);
        this.getCooldownOnFail = tointfunction;
        this.minRamDistance = i2;
        this.maxRamDistance = j2;
        this.walkSpeed = f2;
        this.ramTargeting = pathfindertargetcondition;
        this.ramPrepareTime = k2;
        this.getPrepareRamSound = function;
    }

    @Override
    protected void start(WorldServer worldserver, EntityCreature entitycreature, long i2) {
        BehaviorController<?> behaviorcontroller = entitycreature.getBrain();
        behaviorcontroller.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(nearestvisiblelivingentities -> nearestvisiblelivingentities.findClosest(entityliving -> this.ramTargeting.test(entitycreature, (EntityLiving)entityliving))).ifPresent(entityliving -> {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entitycreature, entityliving, entityliving instanceof EntityPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled() || event.getTarget() == null) {
                return;
            }
            entityliving = ((CraftLivingEntity)event.getTarget()).getHandle();
            this.chooseRamPosition(entitycreature, (EntityLiving)entityliving);
        });
    }

    @Override
    protected void stop(WorldServer worldserver, E e0, long i2) {
        BehaviorController<Vec3D> behaviorcontroller = ((EntityLiving)e0).getBrain();
        if (!behaviorcontroller.hasMemoryValue(MemoryModuleType.RAM_TARGET)) {
            worldserver.broadcastEntityEvent((Entity)e0, (byte)59);
            behaviorcontroller.setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, this.getCooldownOnFail.applyAsInt(e0));
        }
    }

    @Override
    protected boolean canStillUse(WorldServer worldserver, EntityCreature entitycreature, long i2) {
        return this.ramCandidate.isPresent() && this.ramCandidate.get().getTarget().isAlive();
    }

    @Override
    protected void tick(WorldServer worldserver, E e0, long i2) {
        if (!this.ramCandidate.isEmpty()) {
            boolean flag;
            ((EntityLiving)e0).getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(this.ramCandidate.get().getStartPosition(), this.walkSpeed, 0));
            ((EntityLiving)e0).getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(this.ramCandidate.get().getTarget(), true));
            boolean bl = flag = !this.ramCandidate.get().getTarget().blockPosition().equals(this.ramCandidate.get().getTargetPosition());
            if (flag) {
                worldserver.broadcastEntityEvent((Entity)e0, (byte)59);
                ((EntityInsentient)e0).getNavigation().stop();
                this.chooseRamPosition((EntityCreature)e0, this.ramCandidate.get().target);
            } else {
                BlockPosition blockposition = ((Entity)e0).blockPosition();
                if (blockposition.equals(this.ramCandidate.get().getStartPosition())) {
                    worldserver.broadcastEntityEvent((Entity)e0, (byte)58);
                    if (this.reachedRamPositionTimestamp.isEmpty()) {
                        this.reachedRamPositionTimestamp = Optional.of(i2);
                    }
                    if (i2 - this.reachedRamPositionTimestamp.get() >= (long)this.ramPrepareTime) {
                        ((EntityLiving)e0).getBrain().setMemory(MemoryModuleType.RAM_TARGET, this.getEdgeOfBlock(blockposition, this.ramCandidate.get().getTargetPosition()));
                        worldserver.playSound((EntityHuman)null, (Entity)e0, this.getPrepareRamSound.apply(e0), SoundCategory.NEUTRAL, 1.0f, ((EntityLiving)e0).getVoicePitch());
                        this.ramCandidate = Optional.empty();
                    }
                }
            }
        }
    }

    private Vec3D getEdgeOfBlock(BlockPosition blockposition, BlockPosition blockposition1) {
        double d0 = 0.5;
        double d1 = 0.5 * (double)MathHelper.sign(blockposition1.getX() - blockposition.getX());
        double d2 = 0.5 * (double)MathHelper.sign(blockposition1.getZ() - blockposition.getZ());
        return Vec3D.atBottomCenterOf(blockposition1).add(d1, 0.0, d2);
    }

    private Optional<BlockPosition> calculateRammingStartPosition(EntityCreature entitycreature, EntityLiving entityliving) {
        BlockPosition blockposition = entityliving.blockPosition();
        if (!this.isWalkableBlock(entitycreature, blockposition)) {
            return Optional.empty();
        }
        ArrayList list = Lists.newArrayList();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.mutable();
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            blockposition_mutableblockposition.set(blockposition);
            for (int i2 = 0; i2 < this.maxRamDistance; ++i2) {
                if (this.isWalkableBlock(entitycreature, blockposition_mutableblockposition.move(enumdirection))) {
                    continue;
                }
                blockposition_mutableblockposition.move(enumdirection.getOpposite());
                break;
            }
            if (blockposition_mutableblockposition.distManhattan(blockposition) < this.minRamDistance) continue;
            list.add(blockposition_mutableblockposition.immutable());
        }
        NavigationAbstract navigationabstract = entitycreature.getNavigation();
        Stream stream = list.stream();
        BlockPosition blockposition1 = entitycreature.blockPosition();
        Objects.requireNonNull(blockposition1);
        return stream.sorted(Comparator.comparingDouble(blockposition1::distSqr)).filter(blockposition2 -> {
            PathEntity pathentity = navigationabstract.createPath((BlockPosition)blockposition2, 0);
            return pathentity != null && pathentity.canReach();
        }).findFirst();
    }

    private boolean isWalkableBlock(EntityCreature entitycreature, BlockPosition blockposition) {
        return entitycreature.getNavigation().isStableDestination(blockposition) && entitycreature.getPathfindingMalus(PathfinderNormal.getPathTypeStatic(entitycreature, blockposition)) == 0.0f;
    }

    private void chooseRamPosition(EntityCreature entitycreature, EntityLiving entityliving) {
        this.reachedRamPositionTimestamp = Optional.empty();
        this.ramCandidate = this.calculateRammingStartPosition(entitycreature, entityliving).map(blockposition -> new a((BlockPosition)blockposition, entityliving.blockPosition(), entityliving));
    }

    public static class a {
        private final BlockPosition startPosition;
        private final BlockPosition targetPosition;
        final EntityLiving target;

        public a(BlockPosition blockposition, BlockPosition blockposition1, EntityLiving entityliving) {
            this.startPosition = blockposition;
            this.targetPosition = blockposition1;
            this.target = entityliving;
        }

        public BlockPosition getStartPosition() {
            return this.startPosition;
        }

        public BlockPosition getTargetPosition() {
            return this.targetPosition;
        }

        public EntityLiving getTarget() {
            return this.target;
        }
    }
}

