/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class TryLaySpawnOnWaterNearLand {
    public static BehaviorControl<EntityLiving> create(Block block) {
        return BehaviorBuilder.create((BehaviorBuilder.b<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.absent(MemoryModuleType.ATTACK_TARGET), behaviorbuilder_b.present(MemoryModuleType.WALK_TARGET), behaviorbuilder_b.present(MemoryModuleType.IS_PREGNANT)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1, memoryaccessor2) -> (worldserver, entityliving, i2) -> {
            if (!entityliving.isInWater() && entityliving.onGround()) {
                BlockPosition blockposition = entityliving.blockPosition().below();
                for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                    BlockPosition blockposition2;
                    BlockPosition blockposition1 = blockposition.relative(enumdirection);
                    if (!worldserver.getBlockState(blockposition1).getCollisionShape(worldserver, blockposition1).getFaceShape(EnumDirection.UP).isEmpty() || !worldserver.getFluidState(blockposition1).is(FluidTypes.WATER) || !worldserver.getBlockState(blockposition2 = blockposition1.above()).isAir()) continue;
                    IBlockData iblockdata = block.defaultBlockState();
                    if (!CraftEventFactory.callEntityChangeBlockEvent(entityliving, blockposition2, iblockdata)) {
                        memoryaccessor2.erase();
                        return true;
                    }
                    worldserver.setBlock(blockposition2, iblockdata, 3);
                    worldserver.gameEvent(GameEvent.BLOCK_PLACE, blockposition2, GameEvent.a.of(entityliving, iblockdata));
                    worldserver.playSound((EntityHuman)null, entityliving, SoundEffects.FROG_LAY_SPAWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    memoryaccessor2.erase();
                    return true;
                }
                return true;
            }
            return false;
        }));
    }
}

