/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;
import org.bukkit.event.entity.EntityRemoveEvent;

public class Digging<E extends Warden>
extends Behavior<E> {
    public Digging(int i2) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), i2);
    }

    @Override
    protected boolean canStillUse(WorldServer worldserver, E e0, long i2) {
        return ((Entity)e0).getRemovalReason() == null;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer worldserver, E e0) {
        return ((Entity)e0).onGround() || ((Entity)e0).isInWater() || ((Entity)e0).isInLava();
    }

    @Override
    protected void start(WorldServer worldserver, E e0, long i2) {
        if (((Entity)e0).onGround()) {
            ((Entity)e0).setPose(EntityPose.DIGGING);
            ((Entity)e0).playSound(SoundEffects.WARDEN_DIG, 5.0f, 1.0f);
        } else {
            ((Entity)e0).playSound(SoundEffects.WARDEN_AGITATED, 5.0f, 1.0f);
            this.stop(worldserver, e0, i2);
        }
    }

    @Override
    protected void stop(WorldServer worldserver, E e0, long i2) {
        if (((Entity)e0).getRemovalReason() == null) {
            ((EntityLiving)e0).remove(Entity.RemovalReason.DISCARDED, EntityRemoveEvent.Cause.DESPAWN);
        }
    }
}

