/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;

public class PathfinderGoalLookAtPlayer
extends PathfinderGoal {
    public static final float DEFAULT_PROBABILITY = 0.02f;
    protected final EntityInsentient mob;
    @Nullable
    protected Entity lookAt;
    protected final float lookDistance;
    private int lookTime;
    protected final float probability;
    private final boolean onlyHorizontal;
    protected final Class<? extends EntityLiving> lookAtType;
    protected final PathfinderTargetCondition lookAtContext;

    public PathfinderGoalLookAtPlayer(EntityInsentient var0, Class<? extends EntityLiving> var1, float var2) {
        this(var0, var1, var2, 0.02f);
    }

    public PathfinderGoalLookAtPlayer(EntityInsentient var0, Class<? extends EntityLiving> var1, float var2, float var3) {
        this(var0, var1, var2, var3, false);
    }

    public PathfinderGoalLookAtPlayer(EntityInsentient var0, Class<? extends EntityLiving> var12, float var2, float var3, boolean var4) {
        this.mob = var0;
        this.lookAtType = var12;
        this.lookDistance = var2;
        this.probability = var3;
        this.onlyHorizontal = var4;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.LOOK));
        this.lookAtContext = var12 == EntityHuman.class ? PathfinderTargetCondition.forNonCombat().range(var2).selector(var1 -> IEntitySelector.notRiding(var0).test((Entity)var1)) : PathfinderTargetCondition.forNonCombat().range(var2);
    }

    @Override
    public boolean canUse() {
        if (this.mob.getRandom().nextFloat() >= this.probability) {
            return false;
        }
        if (this.mob.getTarget() != null) {
            this.lookAt = this.mob.getTarget();
        }
        this.lookAt = this.lookAtType == EntityHuman.class ? this.mob.level().getNearestPlayer(this.lookAtContext, this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ()) : this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(this.lookAtType, this.mob.getBoundingBox().inflate(this.lookDistance, 3.0, this.lookDistance), var0 -> true), this.lookAtContext, this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
        return this.lookAt != null;
    }

    @Override
    public boolean canContinueToUse() {
        if (!this.lookAt.isAlive()) {
            return false;
        }
        if (this.mob.distanceToSqr(this.lookAt) > (double)(this.lookDistance * this.lookDistance)) {
            return false;
        }
        return this.lookTime > 0;
    }

    @Override
    public void start() {
        this.lookTime = this.adjustedTickDelay(40 + this.mob.getRandom().nextInt(40));
    }

    @Override
    public void stop() {
        this.lookAt = null;
    }

    @Override
    public void tick() {
        if (!this.lookAt.isAlive()) {
            return;
        }
        double var0 = this.onlyHorizontal ? this.mob.getEyeY() : this.lookAt.getEyeY();
        this.mob.getLookControl().setLookAt(this.lookAt.getX(), var0, this.lookAt.getZ());
        --this.lookTime;
    }
}

