/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;

public class PathfinderGoalWrapped
extends PathfinderGoal {
    private final PathfinderGoal goal;
    private final int priority;
    private boolean isRunning;

    public PathfinderGoalWrapped(int var0, PathfinderGoal var1) {
        this.priority = var0;
        this.goal = var1;
    }

    public boolean canBeReplacedBy(PathfinderGoalWrapped var0) {
        return this.isInterruptable() && var0.getPriority() < this.getPriority();
    }

    @Override
    public boolean canUse() {
        return this.goal.canUse();
    }

    @Override
    public boolean canContinueToUse() {
        return this.goal.canContinueToUse();
    }

    @Override
    public boolean isInterruptable() {
        return this.goal.isInterruptable();
    }

    @Override
    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.goal.start();
    }

    @Override
    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        this.goal.stop();
    }

    @Override
    public boolean requiresUpdateEveryTick() {
        return this.goal.requiresUpdateEveryTick();
    }

    @Override
    protected int adjustedTickDelay(int var0) {
        return this.goal.adjustedTickDelay(var0);
    }

    @Override
    public void tick() {
        this.goal.tick();
    }

    @Override
    public void setFlags(EnumSet<PathfinderGoal.Type> var0) {
        this.goal.setFlags(var0);
    }

    @Override
    public EnumSet<PathfinderGoal.Type> getFlags() {
        return this.goal.getFlags();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getPriority() {
        return this.priority;
    }

    public PathfinderGoal getGoal() {
        return this.goal;
    }

    public boolean equals(@Nullable Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        return this.goal.equals(((PathfinderGoalWrapped)var0).goal);
    }

    public int hashCode() {
        return this.goal.hashCode();
    }
}

