/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.event.entity.EntityTargetEvent;

public class PathfinderGoalDefendVillage
extends PathfinderGoalTarget {
    private final EntityIronGolem golem;
    @Nullable
    private EntityLiving potentialTarget;
    private final PathfinderTargetCondition attackTargeting = PathfinderTargetCondition.forCombat().range(64.0);

    public PathfinderGoalDefendVillage(EntityIronGolem entityirongolem) {
        super(entityirongolem, false, true);
        this.golem = entityirongolem;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.TARGET));
    }

    @Override
    public boolean canUse() {
        AxisAlignedBB axisalignedbb = this.golem.getBoundingBox().inflate(10.0, 8.0, 10.0);
        List<EntityVillager> list = this.golem.level().getNearbyEntities(EntityVillager.class, this.attackTargeting, this.golem, axisalignedbb);
        List<EntityHuman> list1 = this.golem.level().getNearbyPlayers(this.attackTargeting, this.golem, axisalignedbb);
        for (EntityLiving entityLiving : list) {
            EntityVillager entityvillager = (EntityVillager)entityLiving;
            for (EntityHuman entityhuman : list1) {
                int i2 = entityvillager.getPlayerReputation(entityhuman);
                if (i2 > -100) continue;
                this.potentialTarget = entityhuman;
            }
        }
        if (this.potentialTarget == null) {
            return false;
        }
        return !(this.potentialTarget instanceof EntityHuman) || !this.potentialTarget.isSpectator() && !((EntityHuman)this.potentialTarget).isCreative();
    }

    @Override
    public void start() {
        this.golem.setTarget(this.potentialTarget, EntityTargetEvent.TargetReason.DEFEND_VILLAGE, true);
        super.start();
    }
}

