/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.event.entity.EntityTargetEvent;

public class PathfinderGoalHurtByTarget
extends PathfinderGoalTarget {
    private static final PathfinderTargetCondition HURT_BY_TARGETING = PathfinderTargetCondition.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
    private static final int ALERT_RANGE_Y = 10;
    private boolean alertSameType;
    private int timestamp;
    private final Class<?>[] toIgnoreDamage;
    @Nullable
    private Class<?>[] toIgnoreAlert;

    public PathfinderGoalHurtByTarget(EntityCreature entitycreature, Class<?> ... aclass) {
        super(entitycreature, true);
        this.toIgnoreDamage = aclass;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.TARGET));
    }

    @Override
    public boolean canUse() {
        int i2 = this.mob.getLastHurtByMobTimestamp();
        EntityLiving entityliving = this.mob.getLastHurtByMob();
        if (i2 != this.timestamp && entityliving != null) {
            if (entityliving.getType() == EntityTypes.PLAYER && this.mob.level().getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                return false;
            }
            for (Class<?> oclass : this.toIgnoreDamage) {
                if (!oclass.isAssignableFrom(entityliving.getClass())) continue;
                return false;
            }
            return this.canAttack(entityliving, HURT_BY_TARGETING);
        }
        return false;
    }

    public PathfinderGoalHurtByTarget setAlertOthers(Class<?> ... aclass) {
        this.alertSameType = true;
        this.toIgnoreAlert = aclass;
        return this;
    }

    @Override
    public void start() {
        this.mob.setTarget(this.mob.getLastHurtByMob(), EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
        this.targetMob = this.mob.getTarget();
        this.timestamp = this.mob.getLastHurtByMobTimestamp();
        this.unseenMemoryTicks = 300;
        if (this.alertSameType) {
            this.alertOthers();
        }
        super.start();
    }

    protected void alertOthers() {
        double d0 = this.getFollowDistance();
        AxisAlignedBB axisalignedbb = AxisAlignedBB.unitCubeFromLowerCorner(this.mob.position()).inflate(d0, 10.0, d0);
        List<Entity> list = this.mob.level().getEntitiesOfClass(this.mob.getClass(), axisalignedbb, IEntitySelector.NO_SPECTATORS);
        for (EntityInsentient entityInsentient : list) {
            if (this.mob == entityInsentient || entityInsentient.getTarget() != null || this.mob instanceof EntityTameableAnimal && ((EntityTameableAnimal)this.mob).getOwner() != ((EntityTameableAnimal)entityInsentient).getOwner() || entityInsentient.isAlliedTo(this.mob.getLastHurtByMob())) continue;
            if (this.toIgnoreAlert != null) {
                boolean flag = false;
                for (Class<?> oclass : this.toIgnoreAlert) {
                    if (entityInsentient.getClass() != oclass) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
            }
            this.alertOther(entityInsentient, this.mob.getLastHurtByMob());
        }
    }

    protected void alertOther(EntityInsentient entityinsentient, EntityLiving entityliving) {
        entityinsentient.setTarget(entityliving, EntityTargetEvent.TargetReason.TARGET_ATTACKED_NEARBY_ENTITY, true);
    }
}

