/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderWater;
import net.minecraft.world.phys.Vec3D;

public class NavigationGuardian
extends NavigationAbstract {
    private boolean allowBreaching;

    public NavigationGuardian(EntityInsentient var0, World var1) {
        super(var0, var1);
    }

    @Override
    protected Pathfinder createPathFinder(int var0) {
        this.allowBreaching = this.mob.getType() == EntityTypes.DOLPHIN;
        this.nodeEvaluator = new PathfinderWater(this.allowBreaching);
        return new Pathfinder(this.nodeEvaluator, var0);
    }

    @Override
    protected boolean canUpdatePath() {
        return this.allowBreaching || this.mob.isInLiquid();
    }

    @Override
    protected Vec3D getTempMobPos() {
        return new Vec3D(this.mob.getX(), this.mob.getY(0.5), this.mob.getZ());
    }

    @Override
    protected double getGroundY(Vec3D var0) {
        return var0.y;
    }

    @Override
    protected boolean canMoveDirectly(Vec3D var0, Vec3D var1) {
        return NavigationGuardian.isClearForMovementBetween(this.mob, var0, var1, false);
    }

    @Override
    public boolean isStableDestination(BlockPosition var0) {
        return !this.level.getBlockState(var0).isSolidRender(this.level, var0);
    }

    @Override
    public void setCanFloat(boolean var0) {
    }
}

